/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaBracesMatcher
implements BracesMatcher,
BracesMatcherFactory {
    private static final char[] PAIRS = new char[]{'(', ')', '[', ']', '{', '}'};
    private static final JavaTokenId[] PAIR_TOKEN_IDS = new JavaTokenId[]{JavaTokenId.LPAREN, JavaTokenId.RPAREN, JavaTokenId.LBRACKET, JavaTokenId.RBRACKET, JavaTokenId.LBRACE, JavaTokenId.RBRACE};
    private final MatcherContext context;
    private int originOffset;
    private char originChar;
    private char matchingChar;
    private boolean backward;
    private List<TokenSequence<?>> sequences;

    public JavaBracesMatcher() {
        this(null);
    }

    private JavaBracesMatcher(MatcherContext matcherContext) {
        this.context = matcherContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws BadLocationException, InterruptedException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            int[] nArray = BracesMatcherSupport.findChar((Document)this.context.getDocument(), (int)this.context.getSearchOffset(), (int)this.context.getLimitOffset(), (char[])PAIRS);
            if (nArray != null) {
                Object object;
                this.originOffset = nArray[0];
                this.originChar = PAIRS[nArray[1]];
                this.matchingChar = PAIRS[nArray[1] + nArray[2]];
                this.backward = nArray[2] < 0;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.context.getDocument());
                this.sequences = JavaBracesMatcher.getEmbeddedTokenSequences(tokenHierarchy, this.originOffset, this.backward, JavaTokenId.language());
                if (!this.sequences.isEmpty()) {
                    object = this.sequences.get(this.sequences.size() - 1);
                    object.move(this.originOffset);
                    if (object.moveNext() && (object.token().id() == JavaTokenId.BLOCK_COMMENT || object.token().id() == JavaTokenId.LINE_COMMENT)) {
                        int[] nArray2 = null;
                        return nArray2;
                    }
                }
                object = new int[]{this.originOffset, this.originOffset + 1};
                return object;
            }
            int[] nArray3 = null;
            return nArray3;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            TokenSequence<?> tokenSequence;
            if (!this.sequences.isEmpty()) {
                tokenSequence = this.sequences.get(this.sequences.size() - 1);
                tokenSequence.move(this.originOffset);
                if (tokenSequence.moveNext() && tokenSequence.token().id() == JavaTokenId.STRING_LITERAL) {
                    int n = BracesMatcherSupport.matchChar((Document)this.context.getDocument(), (int)(this.backward ? this.originOffset : this.originOffset + 1), (int)(this.backward ? tokenSequence.offset() : tokenSequence.offset() + tokenSequence.token().length()), (char)this.originChar, (char)this.matchingChar);
                    if (n != -1) {
                        int[] nArray = new int[]{n, n + 1};
                        return nArray;
                    }
                    int[] nArray = null;
                    return nArray;
                }
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.context.getDocument());
                List list = this.backward ? tokenHierarchy.tokenSequenceList(tokenSequence.languagePath(), 0, this.originOffset) : tokenHierarchy.tokenSequenceList(tokenSequence.languagePath(), this.originOffset + 1, this.context.getDocument().getLength());
                JavaTokenId javaTokenId = this.getTokenId(this.originChar);
                JavaTokenId javaTokenId2 = this.getTokenId(this.matchingChar);
                int n = 0;
                TokenSequenceIterator tokenSequenceIterator = new TokenSequenceIterator(list, this.backward);
                while (tokenSequenceIterator.hasMore()) {
                    TokenSequence<?> tokenSequence2 = tokenSequenceIterator.getSequence();
                    if (javaTokenId == tokenSequence2.token().id()) {
                        ++n;
                        continue;
                    }
                    if (javaTokenId2 != tokenSequence2.token().id()) continue;
                    if (n == 0) {
                        int[] nArray = new int[]{tokenSequence2.offset(), tokenSequence2.offset() + tokenSequence2.token().length()};
                        return nArray;
                    }
                    --n;
                }
            }
            tokenSequence = null;
            return tokenSequence;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private JavaTokenId getTokenId(char c) {
        for (int i = 0; i < PAIRS.length; ++i) {
            if (PAIRS[i] != c) continue;
            return PAIR_TOKEN_IDS[i];
        }
        return null;
    }

    public static List<TokenSequence<?>> getEmbeddedTokenSequences(TokenHierarchy<?> tokenHierarchy, int n, boolean bl, Language<?> language) {
        TokenSequence tokenSequence;
        List list = tokenHierarchy.embeddedTokenSequences(n, bl);
        for (int i = list.size() - 1; i >= 0 && (tokenSequence = (TokenSequence)list.get(i)).language() != language; --i) {
            list.remove(i);
        }
        return list;
    }

    public BracesMatcher createMatcher(MatcherContext matcherContext) {
        return new JavaBracesMatcher(matcherContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TokenSequenceIterator {
        private final List<TokenSequence<?>> list;
        private final boolean backward;
        private int index;

        public TokenSequenceIterator(List<TokenSequence<?>> list, boolean bl) {
            this.list = list;
            this.backward = bl;
            this.index = -1;
        }

        public boolean hasMore() {
            return this.backward ? this.hasPrevious() : this.hasNext();
        }

        public TokenSequence<?> getSequence() {
            assert (this.index >= 0 && this.index < this.list.size()) : "No sequence available, call hasMore() first.";
            return this.list.get(this.index);
        }

        private boolean hasPrevious() {
            boolean bl = false;
            if (this.index == -1) {
                this.index = this.list.size() - 1;
                bl = true;
            }
            while (this.index >= 0) {
                TokenSequence<?> tokenSequence = this.list.get(this.index);
                if (bl) {
                    tokenSequence.moveEnd();
                }
                if (tokenSequence.movePrevious()) {
                    return true;
                }
                bl = true;
                --this.index;
            }
            return false;
        }

        private boolean hasNext() {
            boolean bl = false;
            if (this.index == -1) {
                this.index = 0;
                bl = true;
            }
            while (this.index < this.list.size()) {
                TokenSequence<?> tokenSequence = this.list.get(this.index);
                if (bl) {
                    tokenSequence.moveStart();
                }
                if (tokenSequence.moveNext()) {
                    return true;
                }
                bl = true;
                ++this.index;
            }
            return false;
        }
    }
}

