/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen.ui;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.editor.codegen.ui.CheckRenderer;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

public class CheckTreeView
extends BeanTreeView {
    private NodeTreeModel nodeTreeModel;

    public CheckTreeView() {
        this.setFocusable(false);
        CheckListener checkListener = new CheckListener();
        this.tree.addMouseListener(checkListener);
        this.tree.addKeyListener(checkListener);
        CheckRenderer checkRenderer = new CheckRenderer();
        this.tree.setCellRenderer(checkRenderer);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(false);
        InputMap inputMap = this.tree.getInputMap(0);
        if (null != inputMap) {
            inputMap.remove(KeyStroke.getKeyStroke(10, 0));
        }
        this.setBorder(UIManager.getBorder("ScrollPane.border"));
    }

    protected NodeTreeModel createModel() {
        this.nodeTreeModel = super.createModel();
        return this.nodeTreeModel;
    }

    public void expandRow(int n) {
        this.tree.expandRow(n);
    }

    public boolean getScrollsOnExpand() {
        return this.tree.getScrollsOnExpand();
    }

    public void setScrollsOnExpand(boolean bl) {
        this.tree.setScrollsOnExpand(bl);
    }

    protected void showPath(TreePath treePath) {
        this.tree.expandPath(treePath);
        this.showPathWithoutExpansion(treePath);
    }

    protected void showSelection(TreePath[] treePathArray) {
        this.tree.getSelectionModel().setSelectionPaths(treePathArray);
        if (treePathArray.length == 1) {
            this.showPathWithoutExpansion(treePathArray[0]);
        }
    }

    private void showPathWithoutExpansion(TreePath treePath) {
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (rectangle != null && this.getWidth() > 0 && this.getHeight() > 0) {
            this.tree.scrollRectToVisible(rectangle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CheckListener
    implements MouseListener,
    KeyListener {
        CheckListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                TreePath treePath = CheckTreeView.this.tree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                this.toggle(treePath);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Serializable serializable;
            TreePath treePath;
            if (keyEvent.getKeyCode() == 32 && keyEvent.getSource() instanceof JTree && this.toggle(treePath = (serializable = (JTree)keyEvent.getSource()).getSelectionPath())) {
                keyEvent.consume();
            }
            if (keyEvent.getKeyCode() == 10 && !(keyEvent.getSource() instanceof JTree)) {
                serializable = CheckTreeView.this.tree.getSelectionPath();
                this.toggle((TreePath)serializable);
                keyEvent.consume();
            }
        }

        private boolean toggle(TreePath treePath) {
            if (treePath == null) {
                return false;
            }
            Node node = Visualizer.findNode((Object)treePath.getLastPathComponent());
            if (node == null) {
                return false;
            }
            ElementNode.Description description = (ElementNode.Description)node.getLookup().lookup(ElementNode.Description.class);
            if (description != null) {
                if (description.isSelectable()) {
                    description.setSelected(!description.isSelected());
                    return true;
                }
                boolean bl = !description.isSelected();
                description.setSelected(bl);
                this.toggleChildren(description.getSubs(), bl);
            }
            return false;
        }

        private void toggleChildren(List<ElementNode.Description> list, boolean bl) {
            if (null == list) {
                return;
            }
            for (ElementNode.Description description : list) {
                description.setSelected(bl);
                this.toggleChildren(description.getSubs(), bl);
            }
        }
    }
}

