/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static final Logger LOG = Logger.getLogger(Utilities.class.getName());
    @Deprecated
    private static final boolean DEBUG = false;
    private static final Map<Class, List<Tree.Kind>> class2Kind = new HashMap<Class, List<Tree.Kind>>();
    private static final Set<String> keywords;

    private static Token<JavaTokenId> findTokenWithText(CompilationInfo compilationInfo, String string, int n, int n2) {
        TokenHierarchy tokenHierarchy = compilationInfo.getTokenHierarchy();
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JavaTokenId.language()).subSequence(n, n2);
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (!string.equals(((Object)token.text()).toString())) continue;
            return token;
        }
        return null;
    }

    private static Tree normalizeLastLeftTree(Tree tree) {
        while (tree != null && tree.getKind() == Tree.Kind.ARRAY_TYPE) {
            tree = ((ArrayTypeTree)tree).getType();
        }
        return tree;
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo compilationInfo, Tree tree, Tree tree2, List<? extends Tree> list, String string, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions) {
        int n;
        int n2 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
        int n3 = n = (tree2 = Utilities.normalizeLastLeftTree(tree2)) != null ? (int)sourcePositions.getEndPosition(compilationUnitTree, tree2) : n2;
        if (n == -1 && (n = n2) == -1) {
            return null;
        }
        int n4 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
        for (Tree tree3 : list) {
            int n5;
            if (tree3 == null || (n5 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree3)) == -1 || n5 >= n4) continue;
            n4 = n5;
        }
        if (n4 == -1) {
            return null;
        }
        if (n > n4) {
            n = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
        }
        return Utilities.findTokenWithText(compilationInfo, string, n, n4);
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo compilationInfo, MemberSelectTree memberSelectTree, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions) {
        int n = (int)sourcePositions.getStartPosition(compilationUnitTree, memberSelectTree);
        int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, memberSelectTree);
        if (n == -1 || n2 == -1) {
            return null;
        }
        String string = memberSelectTree.getIdentifier().toString();
        TokenHierarchy tokenHierarchy = compilationInfo.getTokenHierarchy();
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JavaTokenId.language());
        if (tokenSequence.move(n2) == Integer.MAX_VALUE) {
            return null;
        }
        tokenSequence.moveNext();
        while (tokenSequence.offset() >= n) {
            Token token = tokenSequence.token();
            if (string.equals(((Object)token.text()).toString())) {
                return token;
            }
            if (tokenSequence.movePrevious()) continue;
            break;
        }
        return null;
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo compilationInfo, IdentifierTree identifierTree, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions) {
        int n = (int)sourcePositions.getStartPosition(compilationUnitTree, identifierTree);
        int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, identifierTree);
        if (n == -1 || n2 == -1) {
            return null;
        }
        TokenHierarchy tokenHierarchy = compilationInfo.getTokenHierarchy();
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JavaTokenId.language());
        if (tokenSequence.move(n) == Integer.MAX_VALUE) {
            return null;
        }
        tokenSequence.moveNext();
        if (tokenSequence.offset() >= n) {
            Token token = tokenSequence.token();
            return token;
        }
        return null;
    }

    private static Token<JavaTokenId> findIdentifierSpanImpl(CompilationInfo compilationInfo, TreePath treePath) {
        if (compilationInfo.getTreeUtilities().isSynthetic(treePath)) {
            return null;
        }
        Tree tree = treePath.getLeaf();
        if (class2Kind.get(MethodTree.class).contains((Object)tree.getKind())) {
            MethodTree methodTree = (MethodTree)tree;
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            arrayList.addAll(methodTree.getParameters());
            arrayList.addAll(methodTree.getThrows());
            arrayList.add(methodTree.getBody());
            Name name = methodTree.getName();
            if (methodTree.getReturnType() == null) {
                name = ((ClassTree)treePath.getParentPath().getLeaf()).getSimpleName();
            }
            return Utilities.findIdentifierSpanImpl(compilationInfo, tree, methodTree.getReturnType(), arrayList, name.toString(), compilationInfo.getCompilationUnit(), compilationInfo.getTrees().getSourcePositions());
        }
        if (class2Kind.get(VariableTree.class).contains((Object)tree.getKind())) {
            VariableTree variableTree = (VariableTree)tree;
            return Utilities.findIdentifierSpanImpl(compilationInfo, tree, variableTree.getType(), Collections.singletonList(variableTree.getInitializer()), variableTree.getName().toString(), compilationInfo.getCompilationUnit(), compilationInfo.getTrees().getSourcePositions());
        }
        if (class2Kind.get(MemberSelectTree.class).contains((Object)tree.getKind())) {
            return Utilities.findIdentifierSpanImpl(compilationInfo, (MemberSelectTree)tree, compilationInfo.getCompilationUnit(), compilationInfo.getTrees().getSourcePositions());
        }
        if (class2Kind.get(ClassTree.class).contains((Object)tree.getKind())) {
            String string = ((ClassTree)tree).getSimpleName().toString();
            if (string.length() == 0) {
                return null;
            }
            SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
            CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
            int n = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
            int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
            if (n == -1 || n2 == -1) {
                return null;
            }
            return Utilities.findTokenWithText(compilationInfo, string, n, n2);
        }
        if (class2Kind.get(IdentifierTree.class).contains((Object)tree.getKind())) {
            return Utilities.findIdentifierSpanImpl(compilationInfo, (IdentifierTree)tree, compilationInfo.getCompilationUnit(), compilationInfo.getTrees().getSourcePositions());
        }
        if (class2Kind.get(ParameterizedTypeTree.class).contains((Object)tree.getKind())) {
            return Utilities.findIdentifierSpanImpl(compilationInfo, new TreePath(treePath, ((ParameterizedTypeTree)tree).getType()));
        }
        throw new IllegalArgumentException("Only MethodDecl, VariableDecl, MemberSelectTree, IdentifierTree and ClassDecl are accepted by this method. Got: " + (Object)((Object)tree.getKind()));
    }

    public static int[] findIdentifierSpan(final TreePath treePath, final CompilationInfo compilationInfo, final Document document) {
        final int[] nArray = new int[]{-1, -1};
        document.render(new Runnable(){

            public void run() {
                Token<JavaTokenId> token = Utilities.findIdentifierSpan(compilationInfo, document, treePath);
                if (token != null) {
                    nArray[0] = token.offset(null);
                    nArray[1] = token.offset(null) + token.length();
                }
            }
        });
        return nArray;
    }

    public static Token<JavaTokenId> findIdentifierSpan(final CompilationInfo compilationInfo, Document document, final TreePath treePath) {
        final Token[] tokenArray = new Token[1];
        document.render(new Runnable(){

            public void run() {
                tokenArray[0] = Utilities.findIdentifierSpanImpl(compilationInfo, treePath);
            }
        });
        return tokenArray[0];
    }

    private static int findBodyStartImpl(Tree tree, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Document document) {
        int n = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
        int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
        if (n == -1 || n2 == -1) {
            return -1;
        }
        if (n > document.getLength() || n2 > document.getLength()) {
            return -1;
        }
        try {
            String string = document.getText(n, n2 - n);
            int n3 = string.indexOf(123);
            if (n3 == -1) {
                return -1;
            }
            return n + n3;
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.INFO, null, badLocationException);
            return -1;
        }
    }

    public static int findBodyStart(final Tree tree, final CompilationUnitTree compilationUnitTree, final SourcePositions sourcePositions, final Document document) {
        Tree.Kind kind = tree.getKind();
        if (kind != Tree.Kind.CLASS && kind != Tree.Kind.METHOD) {
            throw new IllegalArgumentException("Unsupported kind: " + (Object)((Object)kind));
        }
        final int[] nArray = new int[1];
        document.render(new Runnable(){

            public void run() {
                nArray[0] = Utilities.findBodyStartImpl(tree, compilationUnitTree, sourcePositions, document);
            }
        });
        return nArray[0];
    }

    private static int findLastBracketImpl(MethodTree methodTree, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Document document) {
        int n = (int)sourcePositions.getStartPosition(compilationUnitTree, methodTree);
        int n2 = (int)sourcePositions.getEndPosition(compilationUnitTree, methodTree);
        if (n == -1 || n2 == -1) {
            return -1;
        }
        if (n > document.getLength() || n2 > document.getLength()) {
            return -1;
        }
        try {
            String string = document.getText(n2 - 1, 1);
            if (string.charAt(0) == '}') {
                return n2 - 1;
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.INFO, null, badLocationException);
        }
        return -1;
    }

    public static int findLastBracket(final MethodTree methodTree, final CompilationUnitTree compilationUnitTree, final SourcePositions sourcePositions, final Document document) {
        final int[] nArray = new int[1];
        document.render(new Runnable(){

            public void run() {
                nArray[0] = Utilities.findLastBracketImpl(methodTree, compilationUnitTree, sourcePositions, document);
            }
        });
        return nArray[0];
    }

    private static Token<JavaTokenId> createHighlightImpl(CompilationInfo compilationInfo, Document document, TreePath treePath) {
        Tree tree = treePath.getLeaf();
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        if (tree instanceof MethodTree || tree instanceof VariableTree || tree instanceof ClassTree || tree instanceof MemberSelectTree) {
            return Utilities.findIdentifierSpan(compilationInfo, document, treePath);
        }
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree);
        TokenHierarchy tokenHierarchy = compilationInfo.getTokenHierarchy();
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JavaTokenId.language());
        if (tokenSequence.move(n) == Integer.MAX_VALUE) {
            return null;
        }
        tokenSequence.moveNext();
        if (tokenSequence.offset() == n && tokenSequence.token().id() == JavaTokenId.IDENTIFIER) {
            return tokenSequence.token();
        }
        return null;
    }

    public static Token<JavaTokenId> getToken(final CompilationInfo compilationInfo, final Document document, final TreePath treePath) {
        final Token[] tokenArray = new Token[1];
        document.render(new Runnable(){

            public void run() {
                tokenArray[0] = Utilities.createHighlightImpl(compilationInfo, document, treePath);
            }
        });
        return tokenArray[0];
    }

    public static boolean isKeyword(Tree tree) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            return keywords.contains(((IdentifierTree)tree).getName().toString());
        }
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            return keywords.contains(((MemberSelectTree)tree).getIdentifier().toString());
        }
        return false;
    }

    public static boolean isPrivateElement(Element element) {
        if (element.getKind() == ElementKind.PARAMETER) {
            return true;
        }
        if (element.getKind() == ElementKind.LOCAL_VARIABLE) {
            return true;
        }
        if (element.getKind() == ElementKind.EXCEPTION_PARAMETER) {
            return true;
        }
        return element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    static {
        for (Tree.Kind kind : Tree.Kind.values()) {
            Class<? extends Tree> clazz = kind.asInterface();
            List<Tree.Kind> list = class2Kind.get(clazz);
            if (list == null) {
                list = new ArrayList<Tree.Kind>();
                class2Kind.put(clazz, list);
            }
            list.add(kind);
        }
        keywords = new HashSet<String>();
        keywords.add("true");
        keywords.add("false");
        keywords.add("null");
        keywords.add("this");
        keywords.add("super");
        keywords.add("class");
    }
}

