/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.highlight.InterrupterImpl;
import org.netbeans.modules.cnd.highlight.error.CppUpToDateStatusProvider;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;

public class HighlightProvider {
    private Hook hook;
    public static final boolean TRACE_ANNOTATIONS = Boolean.getBoolean("cnd.highlight.trace.annotations");
    private static final HighlightProvider instance = new HighlightProvider();

    public synchronized void setHook(Hook hook) {
        this.hook = hook;
    }

    public static HighlightProvider getInstance() {
        return instance;
    }

    private HighlightProvider() {
    }

    void update(CsmFile csmFile, Document document, DataObject dataObject, CsmReferenceRepository.Interrupter interrupter) {
        assert (document != null || csmFile == null);
        if (document instanceof BaseDocument) {
            this.addAnnotations((BaseDocument)document, csmFile, dataObject, interrupter);
            Hook hook = this.hook;
            if (hook != null) {
                hook.highlightingDone(((Object)csmFile.getAbsolutePath()).toString());
            }
        }
    }

    void clear(Document document) {
        assert (document != null);
        if (document instanceof BaseDocument) {
            this.removeAnnotations(document);
            CppUpToDateStatusProvider.get((BaseDocument)document).setUpToDate(UpToDateStatus.UP_TO_DATE_OK);
        }
    }

    private static Severity getSeverity(CsmErrorInfo csmErrorInfo) {
        switch (csmErrorInfo.getSeverity()) {
            case ERROR: {
                return Severity.ERROR;
            }
            case WARNING: {
                return Severity.WARNING;
            }
        }
        throw new IllegalArgumentException("Unexpected severity: " + csmErrorInfo.getSeverity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAnnotations(final BaseDocument baseDocument, CsmFile csmFile, final DataObject dataObject, final CsmReferenceRepository.Interrupter interrupter) {
        block5: {
            CppUpToDateStatusProvider.get(baseDocument).setUpToDate(UpToDateStatus.UP_TO_DATE_PROCESSING);
            final ArrayList arrayList = new ArrayList();
            if (TRACE_ANNOTATIONS) {
                System.err.printf("\nSetting annotations for %s\n", csmFile);
            }
            CsmErrorProvider.Response response = new CsmErrorProvider.Response(){
                private int lastSize;
                {
                    this.lastSize = arrayList.size();
                }

                public void addError(CsmErrorInfo csmErrorInfo) {
                    PositionBounds positionBounds = HighlightProvider.createPositionBounds(dataObject, csmErrorInfo.getStartOffset(), csmErrorInfo.getEndOffset());
                    ErrorDescription errorDescription = null;
                    if (positionBounds != null) {
                        try {
                            errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)HighlightProvider.getSeverity(csmErrorInfo), (String)csmErrorInfo.getMessage(), (Document)baseDocument, (Position)positionBounds.getBegin().getPosition(), (Position)positionBounds.getEnd().getPosition());
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        arrayList.add(errorDescription);
                        if (TRACE_ANNOTATIONS) {
                            System.err.printf("\tadded to a bag %s\n", errorDescription.toString());
                        }
                    } else if (TRACE_ANNOTATIONS) {
                        System.err.printf("\tCan't create PositionBounds for %s\n", csmErrorInfo);
                    }
                }

                public void done() {
                    if (arrayList.size() > this.lastSize) {
                        this.lastSize = arrayList.size();
                        if (TRACE_ANNOTATIONS) {
                            System.err.printf("Showing %d errors\n", arrayList.size());
                        }
                        HintsController.setErrors((Document)baseDocument, (String)HighlightProvider.class.getName(), (Collection)arrayList);
                    }
                }
            };
            this.removeAnnotations((Document)baseDocument);
            DocumentListener documentListener = null;
            if (baseDocument != null && interrupter instanceof InterrupterImpl) {
                documentListener = new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        ((InterrupterImpl)interrupter).cancel();
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        ((InterrupterImpl)interrupter).cancel();
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                    }
                };
                baseDocument.addDocumentListener(documentListener);
            }
            try {
                CsmErrorProvider.getDefault().getErrors((CsmErrorProvider.Request)new RequestImpl(csmFile, (Document)baseDocument, interrupter), response);
                if (documentListener == null) break block5;
            }
            catch (Throwable throwable) {
                if (documentListener != null) {
                    baseDocument.removeDocumentListener(documentListener);
                }
                throw throwable;
            }
            baseDocument.removeDocumentListener(documentListener);
        }
        CppUpToDateStatusProvider.get(baseDocument).setUpToDate(UpToDateStatus.UP_TO_DATE_OK);
    }

    private static PositionBounds createPositionBounds(DataObject dataObject, int n, int n2) {
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport((DataObject)dataObject);
        if (cloneableEditorSupport != null) {
            PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
            PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Backward);
            return new PositionBounds(positionRef, positionRef2);
        }
        return null;
    }

    private void removeAnnotations(Document document) {
        HintsController.setErrors((Document)document, (String)HighlightProvider.class.getName(), Collections.emptyList());
    }

    static class RequestImpl
    implements CsmErrorProvider.Request {
        private final CsmFile file;
        private CsmReferenceRepository.Interrupter interrupter;
        private final Document document;

        public RequestImpl(CsmFile csmFile, Document document, CsmReferenceRepository.Interrupter interrupter) {
            this.file = csmFile;
            this.interrupter = interrupter;
            this.document = document;
        }

        public CsmFile getFile() {
            return this.file;
        }

        public boolean isCancelled() {
            return this.interrupter.cancelled();
        }

        public Document getDocument() {
            return this.document;
        }
    }

    public static interface Hook {
        public void highlightingDone(String var1);
    }
}

