/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error.includes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorIncludesModel
implements ListModel {
    private List<String> names = new ArrayList<String>();
    private List<List<CsmOffsetable>> includeList = new ArrayList<List<CsmOffsetable>>();
    private int errorFiles;
    private int errorIncludes;

    public ErrorIncludesModel(List<CsmInclude> list, List<CsmErrorDirective> list2) {
        ArrayList<CsmErrorDirective> arrayList;
        String string;
        this.errorIncludes = list.size();
        TreeMap<String, ArrayList<CsmErrorDirective>> treeMap = new TreeMap<String, ArrayList<CsmErrorDirective>>();
        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
        for (CsmInclude object : list) {
            hashSet.add(object.getContainingFile());
            string = object.isSystem() ? "<" + object.getIncludeName() + ">" : "\"" + object.getIncludeName() + "\"";
            arrayList = (List)treeMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                treeMap.put(string, arrayList);
            }
            arrayList.add((CsmErrorDirective)object);
        }
        for (CsmErrorDirective csmErrorDirective : list2) {
            hashSet.add(csmErrorDirective.getContainingFile());
            string = ((Object)csmErrorDirective.getText()).toString();
            arrayList = (ArrayList<CsmErrorDirective>)treeMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<CsmErrorDirective>();
                treeMap.put(string, arrayList);
            }
            arrayList.add(csmErrorDirective);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            this.names.add((String)entry.getKey());
            this.includeList.add((List<CsmOffsetable>)entry.getValue());
        }
        this.errorFiles = hashSet.size();
    }

    public int getFailedIncludesSize() {
        return this.errorIncludes;
    }

    public int getFailedFilesSize() {
        return this.errorFiles;
    }

    @Override
    public int getSize() {
        return this.names.size();
    }

    public Object getElementAt(int n) {
        return this.names.get(n);
    }

    public List<CsmOffsetable> getElementList(int n) {
        return this.includeList.get(n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
    }
}

