/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.highlight.InterrupterImpl;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.netbeans.modules.cnd.model.tasks.CaretAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MarkOccurrencesHighlighter
extends HighlighterBase {
    private static AttributeSet defaultColors;
    public static final Color ES_COLOR;
    private boolean valid = true;

    public static OffsetsBag getHighlightsBag(Document document) {
        if (document == null) {
            return null;
        }
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(MarkOccurrencesHighlighter.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document, false);
            document.putProperty(MarkOccurrencesHighlighter.class, offsetsBag);
            final OffsetsBag offsetsBag2 = offsetsBag;
            DocumentListener documentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    offsetsBag2.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset(), false);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    offsetsBag2.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset(), false);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }
            };
            document.addDocumentListener(documentListener);
        }
        return offsetsBag;
    }

    private void clean() {
        BaseDocument baseDocument = this.getDocument();
        if (baseDocument != null) {
            MarkOccurrencesHighlighter.getHighlightsBag((Document)baseDocument).clear();
            OccurrencesMarkProvider.get((Document)baseDocument).setOccurrences(Collections.<Mark>emptySet());
        }
    }

    public MarkOccurrencesHighlighter(Document document) {
        super(document);
        this.init(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
        InterrupterImpl interrupterImpl = new InterrupterImpl();
        try {
            this.addCancelListener(interrupterImpl);
            this.runImpl(phase, interrupterImpl);
        }
        finally {
            this.removeCancelListener(interrupterImpl);
        }
    }

    public void runImpl(CsmFileTaskFactory.PhaseRunner.Phase phase, CsmReferenceRepository.Interrupter interrupter) {
        if (!SemanticHighlightingOptions.instance().getEnableMarkOccurrences()) {
            this.clean();
            this.valid = false;
            return;
        }
        if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP) {
            this.clean();
        } else {
            Collection<CsmReference> collection;
            Object object;
            BaseDocument baseDocument = this.getDocument();
            if (baseDocument == null) {
                this.clean();
                return;
            }
            CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)false);
            FileObject fileObject = CsmUtilities.getFileObject((Document)baseDocument);
            if (csmFile == null || fileObject == null) {
                this.clean();
                return;
            }
            int n = CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)fileObject);
            Document document = (Document)baseDocument.getProperty(Document.class);
            if (document != null) {
                Object object2;
                boolean bl = true;
                object = baseDocument.getProperty((Object)"use-own-caret-position");
                if (object != null) {
                    bl = (Boolean)object;
                }
                if (!bl && (object2 = CsmUtilities.getFileObject((Document)document)) != null) {
                    n = MarkOccurrencesHighlighter.getDocumentOffset((Document)baseDocument, MarkOccurrencesHighlighter.getFileOffset(document, CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)object2)));
                }
            }
            if (baseDocument.getProperty((Object)"macro-expansion-view-document") == null) {
                HighlightsSequence highlightsSequence = MarkOccurrencesHighlighter.getHighlightsBag((Document)baseDocument).getHighlights(0, baseDocument.getLength() - 1);
                while (highlightsSequence.moveNext()) {
                    if (n < highlightsSequence.getStartOffset() || n > highlightsSequence.getEndOffset()) continue;
                    return;
                }
            }
            if ((collection = MarkOccurrencesHighlighter.getOccurrences((AbstractDocument)baseDocument, csmFile, n, interrupter)).isEmpty()) {
                if (!SemanticHighlightingOptions.instance().getKeepMarks()) {
                    this.clean();
                }
            } else {
                object = new OffsetsBag((Document)baseDocument);
                object.clear();
                for (CsmReference csmReference : collection) {
                    int n2;
                    int n3;
                    int[][] nArray = CsmMacroExpansion.getUsages((Document)baseDocument, (int)csmReference.getStartOffset());
                    if (nArray != null) {
                        for (n3 = 0; n3 < nArray.length; ++n3) {
                            n2 = nArray[n3][0];
                            int n4 = nArray[n3][1];
                            if (n2 >= baseDocument.getLength() || n4 <= 0) continue;
                            object.addHighlight(n2 > 0 ? n2 : 0, n4 < baseDocument.getLength() ? n4 : baseDocument.getLength(), defaultColors);
                        }
                        continue;
                    }
                    n3 = MarkOccurrencesHighlighter.getDocumentOffset((Document)baseDocument, csmReference.getStartOffset());
                    n2 = MarkOccurrencesHighlighter.getDocumentOffset((Document)baseDocument, csmReference.getEndOffset());
                    if (n3 >= baseDocument.getLength() || n2 <= 0) continue;
                    object.addHighlight(n3 > 0 ? n3 : 0, n2 < baseDocument.getLength() ? n2 : baseDocument.getLength(), defaultColors);
                }
                MarkOccurrencesHighlighter.getHighlightsBag((Document)baseDocument).setHighlights((OffsetsBag)object);
                OccurrencesMarkProvider.get((Document)baseDocument).setOccurrences(OccurrencesMarkProvider.createMarks((Document)baseDocument, collection, ES_COLOR, NbBundle.getMessage(MarkOccurrencesHighlighter.class, (String)"LBL_ES_TOOLTIP")));
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isHighPriority() {
        return true;
    }

    static Collection<CsmReference> getOccurrences(AbstractDocument abstractDocument, CsmFile csmFile, int n, CsmReferenceRepository.Interrupter interrupter) {
        CsmReference csmReference;
        n = MarkOccurrencesHighlighter.getFileOffset(abstractDocument, n);
        Collection<Object> collection = Collections.emptyList();
        if (MarkOccurrencesHighlighter.isPreprocessorConditionalBlock(abstractDocument, n)) {
            return MarkOccurrencesHighlighter.getPreprocReferences(abstractDocument, csmFile, n, interrupter);
        }
        if (csmFile != null && csmFile.isParsed() && (csmReference = CsmReferenceResolver.getDefault().findReference(csmFile, n)) != null && csmReference.getReferencedObject() != null) {
            collection = CsmReferenceRepository.getDefault().getReferences(csmReference.getReferencedObject(), csmFile, CsmReferenceKind.ALL, interrupter);
        }
        return collection;
    }

    private static int getFileOffset(Document document, int n) {
        return CsmMacroExpansion.getOffsetInOriginalText((Document)document, (int)n);
    }

    private static int getDocumentOffset(Document document, int n) {
        return CsmMacroExpansion.getOffsetInExpandedText((Document)document, (int)n);
    }

    @Override
    protected void updateFontColors(FontColorProvider fontColorProvider) {
        defaultColors = fontColorProvider.getColor(FontColorProvider.Entity.MARK_OCCURENCES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPreprocessorConditionalBlock(AbstractDocument abstractDocument, int n) {
        if (abstractDocument == null) {
            return false;
        }
        abstractDocument.readLock();
        try {
            int[] nArray;
            TokenSequence<CppTokenId> tokenSequence = MarkOccurrencesHighlighter.cppTokenSequence(abstractDocument, n, false);
            if (tokenSequence != null && tokenSequence.language() == CppTokenId.languagePreproc() && MarkOccurrencesHighlighter.isIn(nArray = MarkOccurrencesHighlighter.getPreprocConditionalOffsets(tokenSequence), n)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            abstractDocument.readUnlock();
        }
        return false;
    }

    private static int[] getPreprocConditionalOffsets(TokenSequence<CppTokenId> tokenSequence) {
        tokenSequence.moveStart();
        tokenSequence.moveNext();
        int n = tokenSequence.offset();
        block4: while (tokenSequence.moveNext()) {
            switch ((CppTokenId)tokenSequence.token().id()) {
                case PREPROCESSOR_START: 
                case WHITESPACE: 
                case BLOCK_COMMENT: 
                case ESCAPED_LINE: 
                case ESCAPED_WHITESPACE: {
                    continue block4;
                }
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: 
                case PREPROCESSOR_ELIF: 
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ENDIF: {
                    int n2 = tokenSequence.offset() + tokenSequence.token().length();
                    return new int[]{n, n2};
                }
            }
            return null;
        }
        return null;
    }

    private static TokenSequence<CppTokenId> cppTokenSequence(Document document, int n, boolean bl) {
        return CndLexerUtilities.getCppTokenSequence((Document)document, (int)n, (boolean)true, (boolean)bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<CsmReference> getPreprocReferences(AbstractDocument abstractDocument, CsmFile csmFile, int n, CsmReferenceRepository.Interrupter interrupter) {
        TokenSequence<CppTokenId> tokenSequence = MarkOccurrencesHighlighter.cppTokenSequence(abstractDocument, n, false);
        if (tokenSequence == null || tokenSequence.language() != CppTokenId.languagePreproc()) {
            return Collections.emptyList();
        }
        abstractDocument.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)abstractDocument);
            List list = tokenHierarchy.tokenSequenceList(tokenSequence.languagePath(), 0, abstractDocument.getLength());
            ConditionalBlock conditionalBlock = new ConditionalBlock(null);
            ConditionalBlock conditionalBlock2 = new ConditionalBlock(conditionalBlock);
            ConditionalBlock conditionalBlock3 = null;
            for (TokenSequence tokenSequence2 : list) {
                Object object;
                if (interrupter != null && interrupter.cancelled()) {
                    object = Collections.emptyList();
                    return object;
                }
                object = tokenSequence2;
                int[] nArray = MarkOccurrencesHighlighter.getPreprocConditionalOffsets((TokenSequence<CppTokenId>)object);
                if (nArray == null) continue;
                switch ((CppTokenId)object.token().id()) {
                    case PREPROCESSOR_IF: 
                    case PREPROCESSOR_IFDEF: 
                    case PREPROCESSOR_IFNDEF: {
                        conditionalBlock2 = conditionalBlock2.startNestedBlock(nArray);
                        break;
                    }
                    case PREPROCESSOR_ELIF: 
                    case PREPROCESSOR_ELSE: 
                    case PREPROCESSOR_ENDIF: {
                        conditionalBlock2.addDirective(nArray);
                        break;
                    }
                    default: {
                        assert (false) : "unexpected token " + tokenSequence2.token();
                        break;
                    }
                }
                if (conditionalBlock3 == null && MarkOccurrencesHighlighter.isIn(nArray, n)) {
                    conditionalBlock3 = conditionalBlock2;
                }
                if (object.token().id() != CppTokenId.PREPROCESSOR_ENDIF || (conditionalBlock2 = conditionalBlock2.getParent()) != null) continue;
                Collection<CsmReference> collection = MarkOccurrencesHighlighter.toRefs(conditionalBlock3);
                return collection;
            }
            Collection<CsmReference> collection = MarkOccurrencesHighlighter.toRefs(conditionalBlock3);
            return collection;
        }
        finally {
            abstractDocument.readUnlock();
        }
    }

    private static boolean isIn(int[] nArray, int n) {
        return nArray != null && nArray[0] <= n && n <= nArray[1];
    }

    private static Collection<CsmReference> toRefs(ConditionalBlock conditionalBlock) {
        if (conditionalBlock == null || conditionalBlock.getDirectives().isEmpty()) {
            return Collections.emptyList();
        }
        List<int[]> list = conditionalBlock.getDirectives();
        ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>(list.size());
        for (int[] nArray : list) {
            arrayList.add(new PreprocRef(nArray[0], nArray[1]));
        }
        return arrayList;
    }

    static {
        ES_COLOR = new Color(175, 172, 102);
    }

    private static final class PreprocRef
    implements CsmReference {
        private final int start;
        private final int end;

        public PreprocRef(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public CsmReferenceKind getKind() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public CsmObject getReferencedObject() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public CsmObject getOwner() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public CsmFile getContainingFile() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public int getStartOffset() {
            return this.start;
        }

        public int getEndOffset() {
            return this.end;
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConditionalBlock {
        private final List<int[]> directivePositions = new ArrayList<int[]>(4);
        private final List<ConditionalBlock> nested = new ArrayList<ConditionalBlock>(4);
        private final ConditionalBlock parent;

        public ConditionalBlock(ConditionalBlock conditionalBlock) {
            this.parent = conditionalBlock;
        }

        public void addDirective(int[] nArray) {
            this.directivePositions.add(nArray);
        }

        public ConditionalBlock startNestedBlock(int[] nArray) {
            ConditionalBlock conditionalBlock = new ConditionalBlock(this);
            conditionalBlock.addDirective(nArray);
            this.nested.add(conditionalBlock);
            return conditionalBlock;
        }

        public ConditionalBlock getParent() {
            return this.parent;
        }

        public List<int[]> getDirectives() {
            return Collections.unmodifiableList(this.directivePositions);
        }
    }
}

