/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.java.AutoImport;
import org.netbeans.modules.editor.java.JavaCompletionProvider;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaCompletionItem
implements CompletionItem {
    protected static int SMART_TYPE = 1000;
    private static final String GENERATE_TEXT = NbBundle.getMessage(JavaCompletionItem.class, (String)"generate_Lbl");
    private static final Logger LOGGER = Logger.getLogger(JavaCompletionItem.class.getName());
    public static final String COLOR_END = "</font>";
    public static final String STRIKE = "<s>";
    public static final String STRIKE_END = "</s>";
    public static final String BOLD = "<b>";
    public static final String BOLD_END = "</b>";
    protected int substitutionOffset;
    private static final int PUBLIC_LEVEL = 3;
    private static final int PROTECTED_LEVEL = 2;
    private static final int PACKAGE_LEVEL = 1;
    private static final int PRIVATE_LEVEL = 0;

    public static final JavaCompletionItem createKeywordItem(String string, String string2, int n, boolean bl) {
        return new KeywordItem(string, 0, string2, n, bl);
    }

    public static final JavaCompletionItem createPackageItem(String string, int n, boolean bl) {
        return new PackageItem(string, n, bl);
    }

    public static final JavaCompletionItem createTypeItem(TypeElement typeElement, DeclaredType declaredType, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        switch (typeElement.getKind()) {
            case CLASS: {
                return new ClassItem(typeElement, declaredType, 0, n, bl, bl2, bl3, bl4);
            }
            case INTERFACE: {
                return new InterfaceItem(typeElement, declaredType, 0, n, bl, bl2, bl3, bl4);
            }
            case ENUM: {
                return new EnumItem(typeElement, declaredType, 0, n, bl, bl2, bl3, bl4);
            }
            case ANNOTATION_TYPE: {
                return new AnnotationTypeItem(typeElement, declaredType, 0, n, bl, bl2, bl3, bl4);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)typeElement.getKind()));
    }

    public static final JavaCompletionItem createArrayItem(ArrayType arrayType, int n, Elements elements) {
        int n2 = 0;
        TypeMirror typeMirror = arrayType;
        while (typeMirror.getKind() == TypeKind.ARRAY) {
            typeMirror = typeMirror.getComponentType();
            ++n2;
        }
        if (typeMirror.getKind().isPrimitive()) {
            return new KeywordItem(((Object)typeMirror).toString(), n2, null, n, true);
        }
        if (typeMirror.getKind() == TypeKind.DECLARED || typeMirror.getKind() == TypeKind.ERROR) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            switch (typeElement.getKind()) {
                case CLASS: {
                    return new ClassItem(typeElement, declaredType, n2, n, true, elements.isDeprecated(typeElement), false, true);
                }
                case INTERFACE: {
                    return new InterfaceItem(typeElement, declaredType, n2, n, true, elements.isDeprecated(typeElement), false, true);
                }
                case ENUM: {
                    return new EnumItem(typeElement, declaredType, n2, n, true, elements.isDeprecated(typeElement), false, true);
                }
                case ANNOTATION_TYPE: {
                    return new AnnotationTypeItem(typeElement, declaredType, n2, n, true, elements.isDeprecated(typeElement), false, true);
                }
            }
        }
        throw new IllegalArgumentException("array element kind=" + (Object)((Object)typeMirror.getKind()));
    }

    public static final JavaCompletionItem createTypeParameterItem(TypeParameterElement typeParameterElement, int n) {
        return new TypeParameterItem(typeParameterElement, n);
    }

    public static final JavaCompletionItem createVariableItem(VariableElement variableElement, TypeMirror typeMirror, int n, boolean bl, boolean bl2, boolean bl3) {
        switch (variableElement.getKind()) {
            case LOCAL_VARIABLE: 
            case PARAMETER: 
            case EXCEPTION_PARAMETER: {
                return new VariableItem(typeMirror, variableElement.getSimpleName().toString(), n, bl3);
            }
            case ENUM_CONSTANT: 
            case FIELD: {
                return new FieldItem(variableElement, typeMirror, n, bl, bl2, bl3);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)variableElement.getKind()));
    }

    public static final JavaCompletionItem createVariableItem(String string, int n, boolean bl) {
        return new VariableItem(null, string, n, bl);
    }

    public static final JavaCompletionItem createExecutableItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        switch (executableElement.getKind()) {
            case METHOD: {
                return new MethodItem(executableElement, executableType, n, bl, bl2, bl3, bl4);
            }
            case CONSTRUCTOR: {
                return new ConstructorItem(executableElement, executableType, n, bl2, bl4, null);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)executableElement.getKind()));
    }

    public static final JavaCompletionItem createThisOrSuperConstructorItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl, String string) {
        if (executableElement.getKind() == ElementKind.CONSTRUCTOR) {
            return new ConstructorItem(executableElement, executableType, n, bl, false, string);
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)executableElement.getKind()));
    }

    public static final JavaCompletionItem createOverrideMethodItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl) {
        switch (executableElement.getKind()) {
            case METHOD: {
                return new OverrideMethodItem(executableElement, executableType, n, bl);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)executableElement.getKind()));
    }

    public static final JavaCompletionItem createGetterSetterMethodItem(VariableElement variableElement, TypeMirror typeMirror, int n, boolean bl) {
        switch (variableElement.getKind()) {
            case ENUM_CONSTANT: 
            case FIELD: {
                return new GetterSetterMethodItem(variableElement, typeMirror, n, bl);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)variableElement.getKind()));
    }

    public static final JavaCompletionItem createDefaultConstructorItem(TypeElement typeElement, int n, boolean bl) {
        return new DefaultConstructorItem(typeElement, n, bl);
    }

    public static final JavaCompletionItem createParametersItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl, int n2, String string) {
        return new ParametersItem(executableElement, executableType, n, bl, n2, string);
    }

    public static final JavaCompletionItem createAnnotationItem(TypeElement typeElement, DeclaredType declaredType, int n, boolean bl) {
        return new AnnotationItem(typeElement, declaredType, n, bl, true);
    }

    public static final JavaCompletionItem createAttributeItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl) {
        return new AttributeItem(executableElement, executableType, n, bl);
    }

    public static final JavaCompletionItem createStaticMemberItem(DeclaredType declaredType, Element element, TypeMirror typeMirror, int n, boolean bl) {
        switch (element.getKind()) {
            case ENUM_CONSTANT: 
            case FIELD: 
            case METHOD: {
                return new StaticMemberItem(declaredType, element, typeMirror, n, bl);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)element.getKind()));
    }

    public static final JavaCompletionItem createInitializeAllConstructorItem(Iterable<? extends VariableElement> iterable, TypeElement typeElement, int n) {
        return new InitializeAllConstructorItem(iterable, typeElement, n);
    }

    protected JavaCompletionItem(int n) {
        this.substitutionOffset = n;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, null);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400 && Utilities.getJavaCompletionSelectors().indexOf(keyEvent.getKeyChar()) >= 0) {
            Completion.get().hideDocumentation();
            if (Utilities.getJavaCompletionAutoPopupTriggers().indexOf(keyEvent.getKeyChar()) < 0) {
                Completion.get().hideCompletion();
            }
            JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, Character.toString(keyEvent.getKeyChar()));
            keyEvent.consume();
        }
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            try {
                int n = jTextComponent.getSelectionEnd();
                if (n > this.substitutionOffset) {
                    String string = jTextComponent.getDocument().getText(this.substitutionOffset, n - this.substitutionOffset);
                    if (!((Object)this.getInsertPrefix()).toString().startsWith(string)) {
                        return false;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.defaultAction(jTextComponent);
        return true;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    protected ImageIcon getIcon() {
        return null;
    }

    protected String getLeftHtmlText() {
        return null;
    }

    protected String getRightHtmlText() {
        return null;
    }

    protected void substituteText(final JTextComponent jTextComponent, final int n, int n2, String string) {
        int n3;
        final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        CharSequence charSequence = this.getInsertPrefix();
        if (charSequence == null) {
            return;
        }
        final StringBuilder stringBuilder = new StringBuilder(charSequence);
        int n4 = n3 = string != null && string.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(jTextComponent) : -2;
        if (n3 > -2) {
            String string2 = string = string.length() > 1 ? string.substring(0, string.length() - 1) : null;
        }
        if (string != null && !string.equals("\n")) {
            TokenSequence tokenSequence;
            char c;
            int n5;
            for (n5 = 0; n5 < string.length() && (c = string.charAt(n5)) <= ' '; ++n5) {
                stringBuilder.append(c);
            }
            if (n5 > 0) {
                string = string.substring(n5);
            }
            if ((tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)baseDocument), (int)(n + n2))) == null || !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                stringBuilder.append(string);
                string = null;
            }
            boolean bl = false;
            while (string != null && string.length() > 0) {
                String string3 = ((Object)tokenSequence.token().text()).toString();
                if (string3.startsWith(string)) {
                    n2 = tokenSequence.offset() - n + string.length();
                    stringBuilder.append(string);
                    string = null;
                    continue;
                }
                if (string.startsWith(string3)) {
                    tokenSequence.moveNext();
                    n2 = tokenSequence.offset() - n;
                    stringBuilder.append(string.substring(0, string3.length()));
                    string = string.substring(string3.length());
                    bl = true;
                    continue;
                }
                if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                    if (tokenSequence.moveNext()) continue;
                    stringBuilder.append(string);
                    string = null;
                    continue;
                }
                if (!bl) {
                    stringBuilder.append(string);
                }
                string = null;
            }
        }
        final int n5 = n2;
        baseDocument.runAtomic(new Runnable(){

            public void run() {
                try {
                    String string = baseDocument.getText(n, n5);
                    if (string.contentEquals(stringBuilder)) {
                        if (n3 > -1) {
                            baseDocument.insertString(n3, ";", null);
                        } else {
                            jTextComponent.setCaretPosition(n + n5);
                        }
                        return;
                    }
                    Position position = baseDocument.createPosition(n);
                    Position position2 = n3 > -1 ? baseDocument.createPosition(n3) : null;
                    baseDocument.remove(n, n5);
                    baseDocument.insertString(position.getOffset(), stringBuilder.toString(), null);
                    if (position2 != null) {
                        baseDocument.insertString(position2.getOffset(), ";", null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    private static int getProtectionLevel(Set<Modifier> set) {
        if (set.contains((Object)Modifier.PUBLIC)) {
            return 3;
        }
        if (set.contains((Object)Modifier.PROTECTED)) {
            return 2;
        }
        if (set.contains((Object)Modifier.PRIVATE)) {
            return 0;
        }
        return 1;
    }

    private static String escape(String string) {
        if (string != null) {
            try {
                return XMLUtil.toAttributeValue((String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private static int findPositionForSemicolon(JTextComponent jTextComponent) {
        final int[] nArray = new int[]{-2};
        final int n = jTextComponent.getSelectionEnd();
        try {
            Source source = Source.create((Document)jTextComponent.getDocument());
            ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    TreePath treePath;
                    CompilationController compilationController = CompilationController.get((Parser.Result)resultIterator.getParserResult(n));
                    compilationController.toPhase(JavaSource.Phase.PARSED);
                    int n3 = compilationController.getSnapshot().getEmbeddedOffset(n);
                    Tree tree = null;
                    block5: for (treePath = compilationController.getTreeUtilities().pathFor(n3); tree == null && treePath != null; treePath = treePath.getParentPath()) {
                        switch (treePath.getLeaf().getKind()) {
                            case EXPRESSION_STATEMENT: 
                            case IMPORT: {
                                tree = treePath.getLeaf();
                                continue block5;
                            }
                            case RETURN: {
                                tree = ((ReturnTree)treePath.getLeaf()).getExpression();
                                continue block5;
                            }
                            case THROW: {
                                tree = ((ThrowTree)treePath.getLeaf()).getExpression();
                            }
                        }
                    }
                    if (tree != null) {
                        SourcePositions sourcePositions = compilationController.getTrees().getSourcePositions();
                        int n2 = (int)sourcePositions.getEndPosition(treePath.getCompilationUnit(), tree);
                        TokenSequence tokenSequence = JavaCompletionItem.findLastNonWhitespaceToken(compilationController, n3, n2);
                        if (tokenSequence != null) {
                            nArray[0] = tokenSequence.token().id() == JavaTokenId.SEMICOLON ? -1 : tokenSequence.offset() + tokenSequence.token().length();
                        }
                    } else {
                        TokenSequence tokenSequence = compilationController.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                        tokenSequence.move(n3);
                        if (tokenSequence.moveNext() && tokenSequence.token().id() == JavaTokenId.SEMICOLON) {
                            nArray[0] = -1;
                        }
                    }
                }
            });
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return nArray[0];
    }

    private static TokenSequence<JavaTokenId> findLastNonWhitespaceToken(CompilationController compilationController, int n, int n2) {
        TokenSequence tokenSequence = compilationController.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(n2);
        block3: while (tokenSequence.movePrevious()) {
            int n3 = tokenSequence.offset();
            if (n3 < n) {
                return null;
            }
            switch ((JavaTokenId)tokenSequence.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    continue block3;
                }
            }
            return tokenSequence;
        }
        return null;
    }

    static class ParamDesc {
        private String fullTypeName;
        private String typeName;
        private String name;

        public ParamDesc(String string, String string2, String string3) {
            this.fullTypeName = string;
            this.typeName = string2;
            this.name = string3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InitializeAllConstructorItem
    extends JavaCompletionItem {
        private static final String CONSTRUCTOR_PUBLIC = "org/netbeans/modules/java/editor/resources/new_constructor_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#b200b2>";
        private static ImageIcon icon;
        private List<ElementHandle<VariableElement>> fieldHandles = new ArrayList<ElementHandle<VariableElement>>();
        private ElementHandle<TypeElement> parentHandle;
        private String simpleName;
        private List<ParamDesc> params;
        private String sortText;
        private String leftText;

        private InitializeAllConstructorItem(Iterable<? extends VariableElement> iterable, TypeElement typeElement, int n) {
            super(n);
            this.parentHandle = ElementHandle.create((Element)typeElement);
            this.params = new ArrayList<ParamDesc>();
            for (VariableElement variableElement : iterable) {
                this.fieldHandles.add((ElementHandle<VariableElement>)ElementHandle.create((Element)variableElement));
                this.params.add(new ParamDesc(null, ((Object)Utilities.getTypeName(variableElement.asType(), false)).toString(), variableElement.getSimpleName().toString()));
            }
            this.simpleName = typeElement.getSimpleName().toString();
        }

        public int getSortPriority() {
            return 400;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                int n = 0;
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(paramDesc.typeName);
                    if (iterator.hasNext()) {
                        stringBuilder.append(',');
                    }
                    ++n;
                }
                stringBuilder.append(')');
                this.sortText = this.simpleName + "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString();
            }
            return this.sortText;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(CONSTRUCTOR_COLOR);
                stringBuilder.append(this.simpleName);
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                stringBuilder.append('(');
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(JavaCompletionItem.escape(paramDesc.typeName));
                    stringBuilder.append(' ');
                    stringBuilder.append(PARAMETER_NAME_COLOR);
                    stringBuilder.append(paramDesc.name);
                    stringBuilder.append(JavaCompletionItem.COLOR_END);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(") - ");
                stringBuilder.append(GENERATE_TEXT);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)CONSTRUCTOR_PUBLIC, (boolean)false);
            }
            return icon;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        @Override
        protected void substituteText(JTextComponent jTextComponent, final int n, final int n2, String string) {
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            if (n2 > 0) {
                baseDocument.runAtomic(new Runnable(){

                    public void run() {
                        try {
                            baseDocument.remove(n, n2);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
            try {
                ModificationResult modificationResult = ModificationResult.runModificationTask(Collections.singletonList(Source.create((Document)baseDocument)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        WorkingCopy workingCopy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        int n3 = workingCopy.getSnapshot().getEmbeddedOffset(n);
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n3);
                        if (treePath.getLeaf().getKind() == Tree.Kind.CLASS) {
                            Object object22;
                            TypeElement typeElement = (TypeElement)InitializeAllConstructorItem.this.parentHandle.resolve((CompilationInfo)workingCopy);
                            ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
                            for (Object object22 : InitializeAllConstructorItem.this.fieldHandles) {
                                arrayList.add((VariableElement)object22.resolve((CompilationInfo)workingCopy));
                            }
                            int n2 = 0;
                            for (Tree tree2 : ((ClassTree)treePath.getLeaf()).getMembers()) {
                                if (workingCopy.getTrees().getSourcePositions().getStartPosition(treePath.getCompilationUnit(), tree2) >= (long)n3) break;
                                ++n2;
                            }
                            object22 = workingCopy.getTreeMaker();
                            ClassTree classTree = (ClassTree)treePath.getLeaf();
                            GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
                            ClassTree classTree2 = object22.insertClassMember(classTree, n2, (Tree)generatorUtilities.createConstructor(typeElement, arrayList, null));
                            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                        }
                    }
                });
                GeneratorUtils.guardedCommit(jTextComponent, modificationResult);
            }
            catch (Exception exception) {
                LOGGER.log(Level.FINE, null, exception);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("public ");
            stringBuilder.append(this.simpleName);
            stringBuilder.append('(');
            Iterator<ParamDesc> iterator = this.params.iterator();
            while (iterator.hasNext()) {
                ParamDesc paramDesc = iterator.next();
                stringBuilder.append(paramDesc.typeName);
                stringBuilder.append(' ');
                stringBuilder.append(paramDesc.name);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(") - ");
            stringBuilder.append(GENERATE_TEXT);
            return stringBuilder.toString();
        }

        @Override
        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }
    }

    static class StaticMemberItem
    extends JavaCompletionItem {
        private static final String FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png";
        private static final String FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png";
        private static final String FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png";
        private static final String FIELD_COLOR = "<font color=#0000b2>";
        private static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
        private static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
        private static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
        private static final String METHOD_COLOR = "<font color=#7c0000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#b200b2>";
        private static ImageIcon[][] icon = new ImageIcon[2][3];
        private TypeMirrorHandle<DeclaredType> typeHandle;
        private ElementHandle<Element> memberElementHandle;
        private boolean isDeprecated;
        private String typeName;
        private String memberName;
        private String memberTypeName;
        private Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private String sortText;
        private String leftText;
        private String rightText;

        private StaticMemberItem(DeclaredType declaredType, Element element, TypeMirror typeMirror, int n, boolean bl) {
            super(n);
            this.typeHandle = TypeMirrorHandle.create((TypeMirror)declaredType);
            this.memberElementHandle = ElementHandle.create((Element)element);
            this.isDeprecated = bl;
            this.typeName = ((Object)Utilities.getTypeName(declaredType, false)).toString();
            this.memberName = element.getSimpleName().toString();
            this.memberTypeName = ((Object)Utilities.getTypeName(element.getKind().isField() ? typeMirror : ((ExecutableType)typeMirror).getReturnType(), false)).toString();
            this.modifiers = element.getModifiers();
            if (!element.getKind().isField()) {
                this.params = new ArrayList<ParamDesc>();
                Iterator<? extends VariableElement> iterator = ((ExecutableElement)element).getParameters().iterator();
                Iterator<? extends TypeMirror> iterator2 = ((ExecutableType)typeMirror).getParameterTypes().iterator();
                while (iterator.hasNext() && iterator2.hasNext()) {
                    TypeMirror typeMirror2 = iterator2.next();
                    this.params.add(new ParamDesc(((Object)typeMirror2).toString(), ((Object)Utilities.getTypeName(typeMirror2, false, ((ExecutableElement)element).isVarArgs() && !iterator2.hasNext())).toString(), iterator.next().getSimpleName().toString()));
                }
            }
        }

        public int getSortPriority() {
            return (this.params == null ? 700 : 750) - SMART_TYPE;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                if (this.params == null) {
                    this.sortText = this.memberName + "#" + this.typeName;
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append('(');
                    int n = 0;
                    Iterator<ParamDesc> iterator = this.params.iterator();
                    while (iterator.hasNext()) {
                        ParamDesc paramDesc = iterator.next();
                        stringBuilder.append(paramDesc.typeName);
                        if (iterator.hasNext()) {
                            stringBuilder.append(',');
                        }
                        ++n;
                    }
                    stringBuilder.append(')');
                    this.sortText = this.memberName + "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString() + "#" + this.typeName;
                }
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.typeName + "." + this.memberName;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.memberElementHandle);
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.memberElementHandle.getKind().isField() ? FIELD_COLOR : METHOD_COLOR);
                stringBuilder.append(JavaCompletionItem.escape(this.typeName));
                stringBuilder.append('.');
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.memberName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                if (this.params != null) {
                    stringBuilder.append('(');
                    Iterator<ParamDesc> iterator = this.params.iterator();
                    while (iterator.hasNext()) {
                        ParamDesc paramDesc = iterator.next();
                        stringBuilder.append(JavaCompletionItem.escape(paramDesc.typeName));
                        stringBuilder.append(' ');
                        stringBuilder.append(PARAMETER_NAME_COLOR);
                        stringBuilder.append(paramDesc.name);
                        stringBuilder.append(JavaCompletionItem.COLOR_END);
                        if (!iterator.hasNext()) continue;
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(')');
                }
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.memberTypeName);
            }
            return this.rightText;
        }

        protected ImageIcon getIcon() {
            int n = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean bl = this.memberElementHandle.getKind().isField();
            ImageIcon imageIcon = icon[bl ? 0 : 1][n - 1];
            if (imageIcon != null) {
                return imageIcon;
            }
            String string = null;
            if (bl) {
                switch (n) {
                    case 1: {
                        string = FIELD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = FIELD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = FIELD_ST_PUBLIC;
                    }
                }
            } else {
                switch (n) {
                    case 1: {
                        string = METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = METHOD_ST_PUBLIC;
                    }
                }
            }
            if (string == null) {
                return null;
            }
            ImageIcon imageIcon2 = ImageUtilities.loadImageIcon((String)string, (boolean)false);
            StaticMemberItem.icon[bl ? 0 : 1][n - 1] = imageIcon2;
            return imageIcon2;
        }

        protected void substituteText(final JTextComponent jTextComponent, final int n, int n2, String string) {
            int n3;
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            final StringBuilder stringBuilder = new StringBuilder();
            int n4 = n3 = string != null && string.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(jTextComponent) : -2;
            if (n3 > -2) {
                String string2 = string = string.length() > 1 ? string.substring(0, string.length() - 1) : null;
            }
            if (string != null && !string.equals("\n")) {
                TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)baseDocument), (int)(n + n2));
                if (tokenSequence == null || !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    stringBuilder.append(string);
                    string = null;
                }
                boolean bl = false;
                while (string != null && string.length() > 0) {
                    String string3 = ((Object)tokenSequence.token().text()).toString();
                    if (string3.startsWith(string)) {
                        n2 = tokenSequence.offset() - n + string.length();
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (string.startsWith(string3)) {
                        tokenSequence.moveNext();
                        n2 = tokenSequence.offset() - n;
                        stringBuilder.append(string.substring(0, string3.length()));
                        string = string.substring(string3.length());
                        bl = true;
                        continue;
                    }
                    if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                        if (tokenSequence.moveNext()) continue;
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (!bl) {
                        stringBuilder.append(string);
                    }
                    string = null;
                }
            }
            final int n5 = n2;
            Source source = Source.create((Document)baseDocument);
            try {
                ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Object object;
                        CompilationController compilationController = CompilationController.get((Parser.Result)resultIterator.getParserResult(n));
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        DeclaredType declaredType = (DeclaredType)StaticMemberItem.this.typeHandle.resolve((CompilationInfo)compilationController);
                        StringBuilder stringBuilder2 = new StringBuilder();
                        int n2 = 1;
                        stringBuilder2.append("${PAR#");
                        stringBuilder2.append(n2++);
                        stringBuilder2.append(" type=\"");
                        stringBuilder2.append(((TypeElement)declaredType.asElement()).getQualifiedName());
                        stringBuilder2.append("\" default=\"");
                        stringBuilder2.append(((TypeElement)declaredType.asElement()).getSimpleName());
                        stringBuilder2.append("\" editable=false}");
                        Iterator<? extends TypeMirror> iterator = declaredType.getTypeArguments().iterator();
                        if (iterator.hasNext()) {
                            stringBuilder2.append('<');
                            while (iterator.hasNext()) {
                                TypeMirror typeMirror = iterator.next();
                                stringBuilder2.append("${PAR#");
                                stringBuilder2.append(n2++);
                                if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                                    stringBuilder2.append(" type=\"");
                                    typeMirror = ((TypeVariable)typeMirror).getUpperBound();
                                    stringBuilder2.append(Utilities.getTypeName(typeMirror, true));
                                    stringBuilder2.append("\" default=\"");
                                    stringBuilder2.append(Utilities.getTypeName(typeMirror, false));
                                    stringBuilder2.append("\"}");
                                } else if (typeMirror.getKind() == TypeKind.WILDCARD) {
                                    stringBuilder2.append(" type=\"");
                                    object = ((WildcardType)typeMirror).getExtendsBound();
                                    if (object == null) {
                                        object = ((WildcardType)typeMirror).getSuperBound();
                                    }
                                    stringBuilder2.append(object != null ? Utilities.getTypeName((TypeMirror)object, true) : "Object");
                                    stringBuilder2.append("\" default=\"");
                                    stringBuilder2.append(object != null ? Utilities.getTypeName((TypeMirror)object, false) : "Object");
                                    stringBuilder2.append("\"}");
                                } else if (typeMirror.getKind() == TypeKind.ERROR) {
                                    stringBuilder2.append(" default=\"");
                                    stringBuilder2.append(((ErrorType)typeMirror).asElement().getSimpleName());
                                    stringBuilder2.append("\"}");
                                } else {
                                    stringBuilder2.append(" type=\"");
                                    stringBuilder2.append(Utilities.getTypeName(typeMirror, true));
                                    stringBuilder2.append("\" default=\"");
                                    stringBuilder2.append(Utilities.getTypeName(typeMirror, false));
                                    stringBuilder2.append("\" editable=false}");
                                }
                                if (!iterator.hasNext()) continue;
                                stringBuilder2.append(", ");
                            }
                            stringBuilder2.append('>');
                        }
                        stringBuilder2.append('.');
                        stringBuilder2.append(StaticMemberItem.this.memberName);
                        if (StaticMemberItem.this.params != null) {
                            boolean bl = Utilities.guessMethodArguments();
                            stringBuilder2.append("(");
                            object = StaticMemberItem.this.params.iterator();
                            while (object.hasNext()) {
                                ParamDesc paramDesc = (ParamDesc)object.next();
                                stringBuilder2.append("${");
                                stringBuilder2.append(paramDesc.name);
                                if (bl) {
                                    stringBuilder2.append(" named instanceof=");
                                    stringBuilder2.append(paramDesc.fullTypeName);
                                }
                                stringBuilder2.append("}");
                                if (!object.hasNext()) continue;
                                stringBuilder2.append(", ");
                            }
                            stringBuilder2.append(")");
                        }
                        stringBuilder2.append((CharSequence)stringBuilder);
                        baseDocument.runAtomic(new Runnable(){

                            public void run() {
                                try {
                                    Position position;
                                    Position position2 = position = n3 > -1 ? baseDocument.createPosition(n3) : null;
                                    if (n5 > 0) {
                                        baseDocument.remove(n, n5);
                                    }
                                    if (position != null) {
                                        baseDocument.insertString(position.getOffset(), ";", null);
                                    }
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        });
                        CodeTemplateManager codeTemplateManager = CodeTemplateManager.get((Document)baseDocument);
                        if (codeTemplateManager != null) {
                            codeTemplateManager.createTemporary(stringBuilder2.toString()).insert(jTextComponent);
                        }
                    }
                });
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : this.modifiers) {
                stringBuilder.append(object.toString());
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.memberTypeName);
            stringBuilder.append(' ');
            stringBuilder.append(this.typeName);
            stringBuilder.append('.');
            stringBuilder.append(this.memberName);
            if (this.params != null) {
                stringBuilder.append('(');
                Iterator<Object> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    object = (ParamDesc)iterator.next();
                    stringBuilder.append(((ParamDesc)object).typeName);
                    stringBuilder.append(' ');
                    stringBuilder.append(((ParamDesc)object).name);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        }
    }

    static class AttributeItem
    extends JavaCompletionItem {
        private static final String ATTRIBUTE = "org/netbeans/modules/java/editor/resources/attribute_16.png";
        private static final String ATTRIBUTE_COLOR = "<font color=#404040>";
        private static ImageIcon icon;
        private ElementHandle<ExecutableElement> elementHandle;
        private boolean isDeprecated;
        private String simpleName;
        private String typeName;
        private String defaultValue;
        private String leftText;
        private String rightText;

        private AttributeItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl) {
            super(n);
            this.elementHandle = ElementHandle.create((Element)executableElement);
            this.isDeprecated = bl;
            this.simpleName = executableElement.getSimpleName().toString();
            this.typeName = ((Object)Utilities.getTypeName(executableType.getReturnType(), false)).toString();
            AnnotationValue annotationValue = executableElement.getDefaultValue();
            this.defaultValue = annotationValue != null ? ((Object)annotationValue).toString() : null;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.simpleName;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName + "=";
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)ATTRIBUTE, (boolean)false);
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(ATTRIBUTE_COLOR);
                if (this.defaultValue == null) {
                    stringBuilder.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                if (this.defaultValue == null) {
                    stringBuilder.append(JavaCompletionItem.BOLD_END);
                } else {
                    stringBuilder.append(" = ");
                    stringBuilder.append(this.defaultValue);
                }
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        public String toString() {
            return this.simpleName;
        }
    }

    static class AnnotationItem
    extends AnnotationTypeItem {
        private AnnotationItem(TypeElement typeElement, DeclaredType declaredType, int n, boolean bl, boolean bl2) {
            super(typeElement, declaredType, 0, n, true, bl, false, bl2);
        }

        public CharSequence getInsertPrefix() {
            return "@" + super.getInsertPrefix();
        }

        protected void substituteText(JTextComponent jTextComponent, final int n, int n2, String string) {
            int n3;
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            final StringBuilder stringBuilder = new StringBuilder();
            int n4 = n3 = string != null && string.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(jTextComponent) : -2;
            if (n3 > -2) {
                String string2 = string = string.length() > 1 ? string.substring(0, string.length() - 1) : null;
            }
            if (string != null && !string.equals("\n")) {
                TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)baseDocument), (int)(n + n2));
                if (tokenSequence == null || !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    stringBuilder.append(string);
                    string = null;
                }
                boolean bl = false;
                while (string != null && string.length() > 0) {
                    String string3 = ((Object)tokenSequence.token().text()).toString();
                    if (string3.startsWith(string)) {
                        n2 = tokenSequence.offset() - n + string.length();
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (string.startsWith(string3)) {
                        tokenSequence.moveNext();
                        n2 = tokenSequence.offset() - n;
                        stringBuilder.append(string.substring(0, string3.length()));
                        string = string.substring(string3.length());
                        bl = true;
                        continue;
                    }
                    if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                        if (tokenSequence.moveNext()) continue;
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (!bl) {
                        stringBuilder.append(string);
                    }
                    string = null;
                }
            }
            final int n5 = n2;
            Source source = Source.create((Document)baseDocument);
            try {
                ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        final CompilationController compilationController = CompilationController.get((Parser.Result)resultIterator.getParserResult(n));
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        final int n2 = compilationController.getSnapshot().getEmbeddedOffset(n);
                        final DeclaredType declaredType = (DeclaredType)AnnotationItem.this.typeHandle.resolve((CompilationInfo)compilationController);
                        baseDocument.runAtomic(new Runnable(){

                            public void run() {
                                try {
                                    Position position = n3 > -1 ? baseDocument.createPosition(n3) : null;
                                    TreePath treePath = compilationController.getTreeUtilities().pathFor(n2);
                                    stringBuilder.insert(0, "@" + AutoImport.resolveImport((CompilationInfo)compilationController, treePath, declaredType));
                                    String string = baseDocument.getText(n, n5);
                                    if (string.contentEquals(stringBuilder)) {
                                        return;
                                    }
                                    baseDocument.remove(n, n5);
                                    baseDocument.insertString(n, stringBuilder.toString(), null);
                                    if (position != null) {
                                        baseDocument.insertString(position.getOffset(), ";", null);
                                    }
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                });
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    static class ParametersItem
    extends JavaCompletionItem {
        private static final String PARAMETERS_COLOR = "<font color=#808080>";
        private static final String ACTIVE_PARAMETER_COLOR = "<font color=#000000>";
        protected ElementHandle<ExecutableElement> elementHandle;
        private boolean isDeprecated;
        private int activeParamsIndex;
        private String simpleName;
        private ArrayList<ParamDesc> params;
        private String typeName;
        private String sortText;
        private String leftText;
        private String rightText;

        private ParametersItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl, int n2, String string) {
            super(n);
            TypeMirror typeMirror;
            this.elementHandle = ElementHandle.create((Element)executableElement);
            this.isDeprecated = bl;
            this.activeParamsIndex = n2;
            this.simpleName = string != null ? string : (executableElement.getKind() == ElementKind.CONSTRUCTOR ? executableElement.getEnclosingElement().getSimpleName().toString() : executableElement.getSimpleName().toString());
            this.params = new ArrayList();
            Iterator<? extends VariableElement> iterator = executableElement.getParameters().iterator();
            Iterator<? extends TypeMirror> iterator2 = executableType.getParameterTypes().iterator();
            while (iterator.hasNext() && iterator2.hasNext() && (typeMirror = iterator2.next()) != null) {
                this.params.add(new ParamDesc(((Object)typeMirror).toString(), ((Object)Utilities.getTypeName(typeMirror, false, executableElement.isVarArgs() && !iterator2.hasNext())).toString(), iterator.next().getSimpleName().toString()));
            }
            typeMirror = executableType.getReturnType();
            this.typeName = ((Object)Utilities.getTypeName(typeMirror, false)).toString();
        }

        public int getSortPriority() {
            return 100 - SMART_TYPE;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                int n = 0;
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(paramDesc.typeName);
                    if (iterator.hasNext()) {
                        stringBuilder.append(',');
                    }
                    ++n;
                }
                stringBuilder.append(')');
                this.sortText = "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return "";
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(PARAMETERS_COLOR);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                stringBuilder.append('(');
                for (int i = 0; i < this.params.size(); ++i) {
                    ParamDesc paramDesc = this.params.get(i);
                    if (i == this.activeParamsIndex) {
                        stringBuilder.append(JavaCompletionItem.COLOR_END).append(ACTIVE_PARAMETER_COLOR).append(JavaCompletionItem.BOLD);
                    }
                    stringBuilder.append(JavaCompletionItem.escape(paramDesc.typeName));
                    stringBuilder.append(' ');
                    stringBuilder.append(paramDesc.name);
                    if (i < this.params.size() - 1) {
                        stringBuilder.append(", ");
                        continue;
                    }
                    stringBuilder.append(JavaCompletionItem.BOLD_END).append(JavaCompletionItem.COLOR_END).append(PARAMETERS_COLOR);
                }
                stringBuilder.append(')');
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                return stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = PARAMETERS_COLOR + JavaCompletionItem.escape(this.typeName) + JavaCompletionItem.COLOR_END;
            }
            return this.rightText;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }

        protected void substituteText(JTextComponent jTextComponent, final int n, int n2, String string) {
            String string2 = ")";
            if (string != null && !string2.startsWith(string)) {
                string2 = string2 + string;
            }
            if (this.params.isEmpty()) {
                super.substituteText(jTextComponent, n, n2, string2);
            } else {
                TokenSequence tokenSequence;
                int n3;
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                String string3 = "";
                int n4 = n3 = string2.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(jTextComponent) : -2;
                if (n3 > -2) {
                    String string4 = string2 = string2.length() > 1 ? string2.substring(0, string2.length() - 1) : null;
                }
                if ((tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)baseDocument), (int)(n + n2))) == null || !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    string3 = string3 + string2;
                    string2 = null;
                }
                boolean bl = false;
                while (string2 != null && string2.length() > 0) {
                    String string5 = ((Object)tokenSequence.token().text()).toString();
                    if (string5.startsWith(string2)) {
                        n2 = tokenSequence.offset() - n + string2.length();
                        string3 = string3 + string2;
                        string2 = null;
                        continue;
                    }
                    if (string2.startsWith(string5)) {
                        tokenSequence.moveNext();
                        n2 = tokenSequence.offset() - n;
                        string3 = string3 + string2.substring(0, string5.length());
                        string2 = string2.substring(string5.length());
                        bl = true;
                        continue;
                    }
                    if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                        if (tokenSequence.moveNext()) continue;
                        string3 = string3 + string2;
                        string2 = null;
                        continue;
                    }
                    if (!bl) {
                        string3 = string3 + string2;
                    }
                    string2 = null;
                }
                final int n5 = n2;
                baseDocument.runAtomic(new Runnable(){

                    public void run() {
                        try {
                            Position position;
                            Position position2 = position = n3 > -1 ? baseDocument.createPosition(n3) : null;
                            if (n5 > 0) {
                                baseDocument.remove(n, n5);
                            }
                            if (position != null) {
                                baseDocument.insertString(position.getOffset(), ";", null);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
                CodeTemplateManager codeTemplateManager = CodeTemplateManager.get((Document)baseDocument);
                if (codeTemplateManager != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl2 = Utilities.guessMethodArguments();
                    for (int i = this.activeParamsIndex; i < this.params.size(); ++i) {
                        ParamDesc paramDesc = this.params.get(i);
                        stringBuilder.append("${");
                        stringBuilder.append(paramDesc.name);
                        if (bl2) {
                            stringBuilder.append(" named instanceof=");
                            stringBuilder.append(paramDesc.fullTypeName);
                        }
                        stringBuilder.append("}");
                        if (i >= this.params.size() - 1) continue;
                        stringBuilder.append(", ");
                    }
                    if (string3.length() > 0) {
                        stringBuilder.append(string3);
                    }
                    codeTemplateManager.createTemporary(stringBuilder.toString()).insert(jTextComponent);
                    Completion.get().showToolTip();
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.typeName);
            stringBuilder.append(' ');
            stringBuilder.append(this.simpleName);
            stringBuilder.append('(');
            Iterator<ParamDesc> iterator = this.params.iterator();
            while (iterator.hasNext()) {
                ParamDesc paramDesc = iterator.next();
                stringBuilder.append(paramDesc.typeName);
                stringBuilder.append(' ');
                stringBuilder.append(paramDesc.name);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(") - parameters");
            return stringBuilder.toString();
        }
    }

    static class DefaultConstructorItem
    extends JavaCompletionItem {
        private static final String CONSTRUCTOR = "org/netbeans/modules/java/editor/resources/new_constructor_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static ImageIcon icon;
        private boolean smartType;
        private String simpleName;
        private boolean isAbstract;
        private String sortText;
        private String leftText;

        private DefaultConstructorItem(TypeElement typeElement, int n, boolean bl) {
            super(n);
            this.smartType = bl;
            this.simpleName = typeElement.getSimpleName().toString();
            this.isAbstract = typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public int getSortPriority() {
            return this.smartType ? 650 - SMART_TYPE : 650;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                this.sortText = this.simpleName + "#0#";
            }
            return this.sortText;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = CONSTRUCTOR_COLOR + this.simpleName + "()" + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)CONSTRUCTOR, (boolean)false);
            }
            return icon;
        }

        protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
            Object object;
            String string2;
            String string3;
            BaseDocument baseDocument;
            TokenSequence tokenSequence;
            int n3;
            int[] nArray = new int[]{n + n2};
            n2 = 0;
            int n4 = n3 = string != null && string.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(jTextComponent) : -2;
            if (n3 > -2) {
                String string4 = string = string.length() > 1 ? string.substring(0, string.length() - 1) : null;
            }
            if ((tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)(baseDocument = (BaseDocument)jTextComponent.getDocument())), (int)nArray[0])) == null || !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == JavaTokenId.THIS || tokenSequence.token().id() == JavaTokenId.SUPER) {
                    this.isAbstract = false;
                    if (string == null) {
                        string = ";";
                    }
                }
                tokenSequence.moveNext();
            }
            String string5 = string3 = this.isAbstract ? "() {}" : "()";
            if (string != null && !string3.startsWith(string)) {
                string3 = string3 + string;
            }
            String string6 = string2 = CodeStyle.getDefault((Document)baseDocument).spaceBeforeMethodCallParen() ? " " : "";
            if (tokenSequence == null) {
                string2 = string2 + string3;
                string3 = null;
            }
            boolean bl = false;
            while (string3 != null && string3.length() > 0) {
                object = ((Object)tokenSequence.token().text()).toString();
                if (((String)object).startsWith(string3)) {
                    n2 = tokenSequence.offset() - nArray[0] + string3.length();
                    string2 = string2 + string3;
                    string3 = null;
                    continue;
                }
                if (string3.startsWith((String)object)) {
                    tokenSequence.moveNext();
                    n2 = tokenSequence.offset() - nArray[0];
                    string2 = string2 + string3.substring(0, ((String)object).length());
                    string3 = string3.substring(((String)object).length());
                    bl = true;
                    continue;
                }
                if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                    if (tokenSequence.moveNext()) continue;
                    string2 = string2 + string3;
                    string3 = null;
                    continue;
                }
                if (!bl) {
                    string2 = string2 + string3;
                }
                string3 = null;
            }
            object = new Position[1];
            String string7 = string2;
            String string8 = string;
            int n5 = n2;
            baseDocument.runAtomic(new Runnable((Position[])object, baseDocument, nArray, n3, n5, string7, string8, jTextComponent){
                final /* synthetic */ Position[] val$position;
                final /* synthetic */ BaseDocument val$doc;
                final /* synthetic */ int[] val$offset2;
                final /* synthetic */ int val$semiPos;
                final /* synthetic */ int val$length;
                final /* synthetic */ String val$text2;
                final /* synthetic */ String val$toAdd2;
                final /* synthetic */ JTextComponent val$c;
                {
                    this.val$position = positionArray;
                    this.val$doc = baseDocument;
                    this.val$offset2 = nArray;
                    this.val$semiPos = n;
                    this.val$length = n2;
                    this.val$text2 = string;
                    this.val$toAdd2 = string2;
                    this.val$c = jTextComponent;
                }

                public void run() {
                    try {
                        this.val$position[0] = this.val$doc.createPosition(this.val$offset2[0]);
                        Position position = this.val$semiPos > -1 ? this.val$doc.createPosition(this.val$semiPos) : null;
                        this.val$doc.remove(this.val$offset2[0], this.val$length);
                        this.val$offset2[0] = this.val$position[0].getOffset();
                        this.val$doc.insertString(this.val$offset2[0], this.val$text2, null);
                        this.val$position[0] = this.val$doc.createPosition(this.val$offset2[0]);
                        if (position != null) {
                            this.val$doc.insertString(position.getOffset(), ";", null);
                        } else if (!DefaultConstructorItem.this.isAbstract && "(".equals(this.val$toAdd2)) {
                            this.val$c.setCaretPosition(this.val$c.getCaretPosition() - 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            if (this.isAbstract && string2.trim().length() > 3) {
                try {
                    if (object[0] != null) {
                        nArray[0] = object[0].getOffset();
                    }
                    final int n6 = nArray[0] + string2.indexOf(123) + 1;
                    ModificationResult modificationResult = ModificationResult.runModificationTask(Collections.singletonList(Source.create((Document)baseDocument)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            WorkingCopy workingCopy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                            int n = workingCopy.getSnapshot().getEmbeddedOffset(n6);
                            TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                            while (treePath.getLeaf() != treePath.getCompilationUnit()) {
                                Tree tree = treePath.getLeaf();
                                Tree tree2 = treePath.getParentPath().getLeaf();
                                if (tree2.getKind() == Tree.Kind.NEW_CLASS && tree.getKind() == Tree.Kind.CLASS) {
                                    GeneratorUtils.generateAllAbstractMethodImplementations(workingCopy, treePath);
                                    break;
                                }
                                treePath = treePath.getParentPath();
                            }
                        }
                    });
                    GeneratorUtils.guardedCommit(jTextComponent, modificationResult);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.FINE, null, exception);
                }
            }
        }

        public String toString() {
            return this.simpleName + "()";
        }
    }

    static class ConstructorItem
    extends JavaCompletionItem {
        private static final String CONSTRUCTOR_PUBLIC = "org/netbeans/modules/editor/resources/completion/constructor_16.png";
        private static final String CONSTRUCTOR_PROTECTED = "org/netbeans/modules/editor/resources/completion/constructor_protected_16.png";
        private static final String CONSTRUCTOR_PACKAGE = "org/netbeans/modules/editor/resources/completion/constructor_package_private_16.png";
        private static final String CONSTRUCTOR_PRIVATE = "org/netbeans/modules/editor/resources/completion/constructor_private_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon[] icon = new ImageIcon[4];
        private ElementHandle<ExecutableElement> elementHandle;
        private boolean isDeprecated;
        private boolean smartType;
        private String simpleName;
        protected Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private boolean isAbstract;
        private boolean insertName;
        private String sortText;
        private String leftText;

        private ConstructorItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl, boolean bl2, String string) {
            super(n);
            TypeMirror typeMirror;
            this.elementHandle = ElementHandle.create((Element)executableElement);
            this.isDeprecated = bl;
            this.smartType = bl2;
            this.simpleName = string != null ? string : executableElement.getEnclosingElement().getSimpleName().toString();
            this.insertName = string != null;
            this.modifiers = executableElement.getModifiers();
            this.params = new ArrayList<ParamDesc>();
            Iterator<? extends VariableElement> iterator = executableElement.getParameters().iterator();
            Iterator<? extends TypeMirror> iterator2 = executableType.getParameterTypes().iterator();
            while (iterator.hasNext() && iterator2.hasNext() && (typeMirror = iterator2.next()) != null) {
                this.params.add(new ParamDesc(((Object)typeMirror).toString(), ((Object)Utilities.getTypeName(typeMirror, false, executableElement.isVarArgs() && !iterator2.hasNext())).toString(), iterator.next().getSimpleName().toString()));
            }
            this.isAbstract = !this.insertName && executableElement.getEnclosingElement().getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        public int getSortPriority() {
            return this.insertName ? 550 : (this.smartType ? 650 - SMART_TYPE : 650);
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                int n = 0;
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(paramDesc.typeName);
                    if (iterator.hasNext()) {
                        stringBuilder.append(',');
                    }
                    ++n;
                }
                stringBuilder.append(')');
                this.sortText = this.simpleName + "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(CONSTRUCTOR_COLOR);
                stringBuilder.append(JavaCompletionItem.BOLD);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                stringBuilder.append(JavaCompletionItem.BOLD_END);
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                stringBuilder.append('(');
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(JavaCompletionItem.escape(paramDesc.typeName));
                    stringBuilder.append(' ');
                    stringBuilder.append(PARAMETER_NAME_COLOR);
                    stringBuilder.append(paramDesc.name);
                    stringBuilder.append(JavaCompletionItem.COLOR_END);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(')');
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected ImageIcon getIcon() {
            ImageIcon imageIcon;
            int n = JavaCompletionItem.getProtectionLevel(this.modifiers);
            ImageIcon imageIcon2 = icon[n];
            if (imageIcon2 != null) {
                return imageIcon2;
            }
            String string = CONSTRUCTOR_PUBLIC;
            switch (n) {
                case 0: {
                    string = CONSTRUCTOR_PRIVATE;
                    break;
                }
                case 1: {
                    string = CONSTRUCTOR_PACKAGE;
                    break;
                }
                case 2: {
                    string = CONSTRUCTOR_PROTECTED;
                    break;
                }
                case 3: {
                    string = CONSTRUCTOR_PUBLIC;
                }
            }
            ConstructorItem.icon[n] = imageIcon = ImageUtilities.loadImageIcon((String)string, (boolean)false);
            return imageIcon;
        }

        protected void substituteText(final JTextComponent jTextComponent, int n, int n2, String string) {
            CodeTemplateManager codeTemplateManager;
            Object object;
            String string2;
            String string3;
            String string4;
            BaseDocument baseDocument;
            TokenSequence tokenSequence;
            int n3;
            if (!this.insertName) {
                n += n2;
                n2 = 0;
            }
            int n4 = n3 = string != null && string.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(jTextComponent) : -2;
            if (n3 > -2) {
                String string5 = string = string.length() > 1 ? string.substring(0, string.length() - 1) : null;
            }
            if ((tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)(baseDocument = (BaseDocument)jTextComponent.getDocument())), (int)n)) == null || !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == JavaTokenId.THIS || tokenSequence.token().id() == JavaTokenId.SUPER) {
                    this.isAbstract = false;
                    if (string == null) {
                        string = ";";
                    }
                }
                tokenSequence.moveNext();
            }
            String string6 = string4 = this.isAbstract ? "() {}" : "()";
            if (string != null && !string4.startsWith(string)) {
                string4 = string4 + string;
            } else {
                string = null;
            }
            String string7 = string3 = CodeStyle.getDefault((Document)baseDocument).spaceBeforeMethodCallParen() ? " " : "";
            if (tokenSequence == null) {
                string3 = string3 + string4;
                string4 = null;
            }
            boolean bl = false;
            while (string4 != null && string4.length() > 0) {
                string2 = ((Object)tokenSequence.token().text()).toString();
                if (string2.startsWith(string4)) {
                    n2 = tokenSequence.offset() - n + string4.length();
                    string3 = string3 + string4;
                    string4 = null;
                    continue;
                }
                if (string4.startsWith(string2)) {
                    tokenSequence.moveNext();
                    n2 = tokenSequence.offset() - n;
                    string3 = string3 + string4.substring(0, string2.length());
                    string4 = string4.substring(string2.length());
                    bl = true;
                    continue;
                }
                if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                    if (tokenSequence.moveNext()) continue;
                    string3 = string3 + string4;
                    string4 = null;
                    continue;
                }
                if (!bl) {
                    string3 = string3 + string4;
                }
                string4 = null;
            }
            string2 = string3;
            final int n5 = n2;
            final int n6 = n;
            final String string8 = string;
            final Position[] positionArray = new Position[1];
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        Position position = n3 > -1 ? baseDocument.createPosition(n3) : null;
                        baseDocument.remove(n6, n5);
                        if (ConstructorItem.this.insertName) {
                            baseDocument.insertString(n6, ConstructorItem.this.simpleName + string2, null);
                            positionArray[0] = baseDocument.createPosition(n6 + ConstructorItem.this.simpleName.length() + string2.indexOf(40));
                        } else {
                            baseDocument.insertString(n6, string2, null);
                            positionArray[0] = baseDocument.createPosition(n6 + string2.indexOf(40));
                        }
                        if (position != null) {
                            baseDocument.insertString(position.getOffset(), ";", null);
                        } else if (!ConstructorItem.this.isAbstract && ConstructorItem.this.params.isEmpty() && "(".equals(string8)) {
                            jTextComponent.setCaretPosition(jTextComponent.getCaretPosition() - 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            if (this.isAbstract && string3.length() > 3) {
                try {
                    final int n7 = n + string3.indexOf(123) + 1;
                    object = ModificationResult.runModificationTask(Collections.singletonList(Source.create((Document)baseDocument)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            WorkingCopy workingCopy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                            int n = workingCopy.getSnapshot().getEmbeddedOffset(n7);
                            TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                            while (treePath.getLeaf() != treePath.getCompilationUnit()) {
                                Tree tree = treePath.getLeaf();
                                Tree tree2 = treePath.getParentPath().getLeaf();
                                if (tree2.getKind() == Tree.Kind.NEW_CLASS && tree.getKind() == Tree.Kind.CLASS) {
                                    GeneratorUtils.generateAllAbstractMethodImplementations(workingCopy, treePath);
                                    break;
                                }
                                treePath = treePath.getParentPath();
                            }
                        }
                    });
                    GeneratorUtils.guardedCommit(jTextComponent, (ModificationResult)object);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.FINE, null, exception);
                }
            }
            if (!this.params.isEmpty() && string3.trim().length() > 1 && (codeTemplateManager = CodeTemplateManager.get((Document)baseDocument)) != null) {
                if (positionArray[0] != null) {
                    n = positionArray[0].getOffset();
                }
                if (string == null) {
                    string = "";
                }
                if (string3.startsWith("()" + string)) {
                    jTextComponent.select(n, n + string.length() + 2);
                } else if (string3.startsWith("()")) {
                    jTextComponent.select(n, n + 2);
                } else {
                    jTextComponent.setCaretPosition(n);
                }
                object = new StringBuilder();
                boolean bl2 = Utilities.guessMethodArguments();
                ((StringBuilder)object).append("(");
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    ((StringBuilder)object).append("${");
                    ((StringBuilder)object).append(paramDesc.name);
                    if (bl2) {
                        ((StringBuilder)object).append(" named instanceof=");
                        ((StringBuilder)object).append(paramDesc.fullTypeName);
                    }
                    ((StringBuilder)object).append("}");
                    if (!iterator.hasNext()) continue;
                    ((StringBuilder)object).append(", ");
                }
                ((StringBuilder)object).append(")");
                ((StringBuilder)object).append(string);
                codeTemplateManager.createTemporary(((StringBuilder)object).toString()).insert(jTextComponent);
                Completion.get().showToolTip();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : this.modifiers) {
                stringBuilder.append(object.toString());
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.simpleName);
            stringBuilder.append('(');
            Iterator<Object> iterator = this.params.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = (ParamDesc)iterator.next();
                stringBuilder.append(((ParamDesc)object).typeName);
                stringBuilder.append(' ');
                stringBuilder.append(((ParamDesc)object).name);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    static class GetterSetterMethodItem
    extends JavaCompletionItem {
        private static final String METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png";
        private static final String GETTER_BADGE_PATH = "org/netbeans/modules/java/editor/resources/getter_badge.png";
        private static final String SETTER_BADGE_PATH = "org/netbeans/modules/java/editor/resources/setter_badge.png";
        private static final String METHOD_COLOR = "<font color=#000000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon superIcon;
        private static ImageIcon[] merged_icons;
        protected ElementHandle<VariableElement> elementHandle;
        private boolean setter;
        private String simpleName;
        private String name;
        private String typeName;
        private String sortText;
        private String leftText;
        private String rightText;

        private GetterSetterMethodItem(VariableElement variableElement, TypeMirror typeMirror, int n, boolean bl) {
            super(n);
            this.elementHandle = ElementHandle.create((Element)variableElement);
            this.setter = bl;
            this.simpleName = variableElement.getSimpleName().toString();
            this.name = bl ? "set" + GeneratorUtils.getCapitalizedName(this.simpleName) : (variableElement.asType().getKind() == TypeKind.BOOLEAN ? "is" : "get") + GeneratorUtils.getCapitalizedName(this.simpleName);
            this.typeName = ((Object)Utilities.getTypeName(typeMirror, false)).toString();
        }

        public int getSortPriority() {
            return 500;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                if (this.setter) {
                    stringBuilder.append(this.typeName);
                }
                stringBuilder.append(')');
                this.sortText = this.name + "#" + (this.setter ? "01" : "00") + "#" + stringBuilder.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.name;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(METHOD_COLOR);
                stringBuilder.append(JavaCompletionItem.BOLD);
                stringBuilder.append(this.name);
                stringBuilder.append(JavaCompletionItem.BOLD_END);
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                stringBuilder.append('(');
                if (this.setter) {
                    stringBuilder.append(JavaCompletionItem.escape(this.typeName));
                    stringBuilder.append(' ');
                    stringBuilder.append(PARAMETER_NAME_COLOR);
                    stringBuilder.append(this.simpleName);
                    stringBuilder.append(JavaCompletionItem.COLOR_END);
                }
                stringBuilder.append(") - ");
                stringBuilder.append(GENERATE_TEXT);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = this.setter ? "void" : JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        protected ImageIcon getIcon() {
            if (merged_icons[this.setter ? 1 : 0] == null) {
                if (superIcon == null) {
                    superIcon = ImageUtilities.loadImageIcon((String)METHOD_PUBLIC, (boolean)false);
                }
                if (this.setter) {
                    ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)SETTER_BADGE_PATH, (boolean)false);
                    GetterSetterMethodItem.merged_icons[1] = new ImageIcon(ImageUtilities.mergeImages((Image)superIcon.getImage(), (Image)imageIcon.getImage(), (int)8, (int)8));
                } else {
                    ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)GETTER_BADGE_PATH, (boolean)false);
                    GetterSetterMethodItem.merged_icons[0] = new ImageIcon(ImageUtilities.mergeImages((Image)superIcon.getImage(), (Image)imageIcon.getImage(), (int)8, (int)8));
                }
            }
            return merged_icons[this.setter ? 1 : 0];
        }

        protected void substituteText(JTextComponent jTextComponent, final int n, final int n2, String string) {
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            if (n2 > 0) {
                baseDocument.runAtomic(new Runnable(){

                    public void run() {
                        try {
                            baseDocument.remove(n, n2);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
            try {
                ModificationResult modificationResult = ModificationResult.runModificationTask(Collections.singletonList(Source.create((Document)baseDocument)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        WorkingCopy workingCopy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        VariableElement variableElement = (VariableElement)GetterSetterMethodItem.this.elementHandle.resolve((CompilationInfo)workingCopy);
                        if (variableElement == null) {
                            return;
                        }
                        int n3 = workingCopy.getSnapshot().getEmbeddedOffset(n);
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n3);
                        if (treePath.getLeaf().getKind() == Tree.Kind.CLASS) {
                            Tree tree;
                            if (Utilities.inAnonymousOrLocalClass(treePath)) {
                                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                            }
                            int n2 = 0;
                            Object object = ((ClassTree)treePath.getLeaf()).getMembers().iterator();
                            while (object.hasNext()) {
                                tree = object.next();
                                if (workingCopy.getTrees().getSourcePositions().getStartPosition(treePath.getCompilationUnit(), tree) >= (long)n3) break;
                                ++n2;
                            }
                            if ((object = (TypeElement)workingCopy.getTrees().getElement(treePath)) != null) {
                                tree = GeneratorUtilities.get((WorkingCopy)workingCopy);
                                MethodTree methodTree = GetterSetterMethodItem.this.setter ? tree.createSetter((TypeElement)object, variableElement) : tree.createGetter((TypeElement)object, variableElement);
                                ClassTree classTree = workingCopy.getTreeMaker().insertClassMember((ClassTree)treePath.getLeaf(), n2, (Tree)methodTree);
                                workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree);
                            }
                        }
                    }
                });
                GeneratorUtils.guardedCommit(jTextComponent, modificationResult);
            }
            catch (Exception exception) {
                LOGGER.log(Level.FINE, null, exception);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("public ");
            stringBuilder.append(this.setter ? "void" : this.typeName);
            stringBuilder.append(' ');
            stringBuilder.append(this.name);
            stringBuilder.append('(');
            if (this.setter) {
                stringBuilder.append(this.typeName);
                stringBuilder.append(' ');
                stringBuilder.append(this.simpleName);
            }
            stringBuilder.append(") - ");
            stringBuilder.append(GENERATE_TEXT);
            return stringBuilder.toString();
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }

        static {
            merged_icons = new ImageIcon[2];
        }
    }

    static class OverrideMethodItem
    extends MethodItem {
        private static final String IMPL_BADGE_PATH = "org/netbeans/modules/java/editor/resources/implement_badge.png";
        private static final String OVRD_BADGE_PATH = "org/netbeans/modules/java/editor/resources/override_badge.png";
        private static final String OVERRIDE_TEXT = NbBundle.getMessage(JavaCompletionItem.class, (String)"override_Lbl");
        private static final String IMPLEMENT_TEXT = NbBundle.getMessage(JavaCompletionItem.class, (String)"implement_Lbl");
        private static ImageIcon implementBadge = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/editor/resources/implement_badge.png", (boolean)false);
        private static ImageIcon overrideBadge = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/editor/resources/override_badge.png", (boolean)false);
        private static ImageIcon[][] merged_icon = new ImageIcon[2][4];
        private boolean implement;
        private String leftText;

        private OverrideMethodItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl) {
            super(executableElement, executableType, n, false, false, false, false);
            this.implement = bl;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = super.getLeftHtmlText() + " - ";
                this.leftText = this.leftText + (this.implement ? IMPLEMENT_TEXT : OVERRIDE_TEXT);
            }
            return this.leftText;
        }

        protected ImageIcon getIcon() {
            int n;
            ImageIcon imageIcon = merged_icon[this.implement ? 0 : 1][n = JavaCompletionItem.getProtectionLevel(this.modifiers)];
            if (imageIcon != null) {
                return imageIcon;
            }
            ImageIcon imageIcon2 = super.getIcon();
            imageIcon = new ImageIcon(ImageUtilities.mergeImages((Image)imageIcon2.getImage(), (Image)(this.implement ? implementBadge.getImage() : overrideBadge.getImage()), (int)8, (int)8));
            OverrideMethodItem.merged_icon[this.implement ? 0 : 1][n] = imageIcon;
            return imageIcon;
        }

        protected void substituteText(JTextComponent jTextComponent, final int n, final int n2, String string) {
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            if (n2 > 0) {
                baseDocument.runAtomic(new Runnable(){

                    public void run() {
                        try {
                            baseDocument.remove(n, n2);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
            try {
                ModificationResult modificationResult = ModificationResult.runModificationTask(Collections.singletonList(Source.create((Document)baseDocument)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        WorkingCopy workingCopy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ExecutableElement executableElement = (ExecutableElement)OverrideMethodItem.this.elementHandle.resolve((CompilationInfo)workingCopy);
                        if (executableElement == null) {
                            return;
                        }
                        int n3 = workingCopy.getSnapshot().getEmbeddedOffset(n);
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n3);
                        if (treePath.getLeaf().getKind() == Tree.Kind.CLASS) {
                            if (Utilities.inAnonymousOrLocalClass(treePath)) {
                                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                            }
                            int n2 = 0;
                            for (Tree tree : ((ClassTree)treePath.getLeaf()).getMembers()) {
                                if (workingCopy.getTrees().getSourcePositions().getStartPosition(treePath.getCompilationUnit(), tree) >= (long)n3) break;
                                ++n2;
                            }
                            if (OverrideMethodItem.this.implement) {
                                GeneratorUtils.generateAbstractMethodImplementation(workingCopy, treePath, executableElement, n2);
                            } else {
                                GeneratorUtils.generateMethodOverride(workingCopy, treePath, executableElement, n2);
                            }
                        }
                    }
                });
                GeneratorUtils.guardedCommit(jTextComponent, modificationResult);
            }
            catch (Exception exception) {
                LOGGER.log(Level.FINE, null, exception);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.toString());
            stringBuilder.append(" - ");
            stringBuilder.append(this.implement ? IMPLEMENT_TEXT : OVERRIDE_TEXT);
            return stringBuilder.toString();
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }
    }

    static class MethodItem
    extends JavaCompletionItem {
        private static final String METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png";
        private static final String METHOD_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_protected_16.png";
        private static final String METHOD_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_package_private_16.png";
        private static final String METHOD_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_private_16.png";
        private static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
        private static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
        private static final String METHOD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_static_private_16.png";
        private static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
        private static final String METHOD_COLOR = "<font color=#000000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon[][] icon = new ImageIcon[2][4];
        protected ElementHandle<ExecutableElement> elementHandle;
        private boolean isInherited;
        private boolean isDeprecated;
        private boolean inImport;
        private boolean smartType;
        private String simpleName;
        protected Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private String typeName;
        private boolean isPrimitive;
        private String sortText;
        private String leftText;
        private String rightText;

        private MethodItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(n);
            TypeMirror typeMirror;
            this.elementHandle = ElementHandle.create((Element)executableElement);
            this.isInherited = bl;
            this.isDeprecated = bl2;
            this.inImport = bl3;
            this.smartType = bl4;
            this.simpleName = executableElement.getSimpleName().toString();
            this.modifiers = executableElement.getModifiers();
            this.params = new ArrayList<ParamDesc>();
            Iterator<? extends VariableElement> iterator = executableElement.getParameters().iterator();
            Iterator<? extends TypeMirror> iterator2 = executableType.getParameterTypes().iterator();
            while (iterator.hasNext() && iterator2.hasNext() && (typeMirror = iterator2.next()) != null) {
                this.params.add(new ParamDesc(((Object)typeMirror).toString(), ((Object)Utilities.getTypeName(typeMirror, false, executableElement.isVarArgs() && !iterator2.hasNext())).toString(), iterator.next().getSimpleName().toString()));
            }
            typeMirror = executableType.getReturnType();
            this.typeName = ((Object)Utilities.getTypeName(typeMirror, false)).toString();
            this.isPrimitive = typeMirror.getKind().isPrimitive() || typeMirror.getKind() == TypeKind.VOID;
        }

        public int getSortPriority() {
            return this.smartType ? 500 - SMART_TYPE : 500;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                int n = 0;
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(paramDesc.typeName);
                    if (iterator.hasNext()) {
                        stringBuilder.append(',');
                    }
                    ++n;
                }
                stringBuilder.append(')');
                this.sortText = this.simpleName + "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(METHOD_COLOR);
                if (!this.isInherited) {
                    stringBuilder.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                if (!this.isInherited) {
                    stringBuilder.append(JavaCompletionItem.BOLD_END);
                }
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                stringBuilder.append('(');
                Iterator<ParamDesc> iterator = this.params.iterator();
                while (iterator.hasNext()) {
                    ParamDesc paramDesc = iterator.next();
                    stringBuilder.append(JavaCompletionItem.escape(paramDesc.typeName));
                    stringBuilder.append(' ');
                    stringBuilder.append(PARAMETER_NAME_COLOR);
                    stringBuilder.append(paramDesc.name);
                    stringBuilder.append(JavaCompletionItem.COLOR_END);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected ImageIcon getIcon() {
            int n = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean bl = this.modifiers.contains((Object)Modifier.STATIC);
            ImageIcon imageIcon = icon[bl ? 1 : 0][n];
            if (imageIcon != null) {
                return imageIcon;
            }
            String string = METHOD_PUBLIC;
            if (bl) {
                switch (n) {
                    case 0: {
                        string = METHOD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = METHOD_ST_PUBLIC;
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        string = METHOD_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = METHOD_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = METHOD_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = METHOD_PUBLIC;
                    }
                }
            }
            ImageIcon imageIcon2 = ImageUtilities.loadImageIcon((String)string, (boolean)false);
            MethodItem.icon[bl ? 1 : 0][n] = imageIcon2;
            return imageIcon2;
        }

        protected void substituteText(final JTextComponent jTextComponent, final int n, int n2, String object) {
            Source source;
            Object object2;
            if (object == null && this.isPrimitive) {
                try {
                    object2 = new String[1];
                    source = Source.create((Document)jTextComponent.getDocument());
                    ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask((String[])object2){
                        final /* synthetic */ String[] val$ret;
                        {
                            this.val$ret = stringArray;
                        }

                        public void run(ResultIterator resultIterator) throws Exception {
                            CompilationController compilationController = CompilationController.get((Parser.Result)resultIterator.getParserResult(n));
                            compilationController.toPhase(JavaSource.Phase.PARSED);
                            int n2 = compilationController.getSnapshot().getEmbeddedOffset(jTextComponent.getSelectionEnd());
                            TreePath treePath = compilationController.getTreeUtilities().pathFor(n2);
                            Tree tree = treePath.getLeaf();
                            if ((tree.getKind() == Tree.Kind.IDENTIFIER || tree.getKind() == Tree.Kind.PRIMITIVE_TYPE) && (treePath = treePath.getParentPath()).getLeaf().getKind() == Tree.Kind.VARIABLE && ((VariableTree)treePath.getLeaf()).getType() == tree) {
                                this.val$ret[0] = ";";
                            }
                            if (treePath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT || treePath.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION && ((MethodInvocationTree)treePath.getLeaf()).getMethodSelect() == tree) {
                                treePath = treePath.getParentPath();
                            }
                            if (treePath.getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT || treePath.getLeaf().getKind() == Tree.Kind.BLOCK) {
                                this.val$ret[0] = ";";
                            }
                        }
                    });
                    object = object2[0];
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (this.inImport || this.params.isEmpty()) {
                Object object3 = this.inImport ? ";" : (object2 = CodeStyle.getDefault((Document)jTextComponent.getDocument()).spaceBeforeMethodCallParen() ? " ()" : "()");
                if (object != null && !((String)object2).startsWith((String)object)) {
                    object2 = (String)object2 + (String)object;
                }
                super.substituteText(jTextComponent, n, n2, (String)object2);
                if ("(".equals(object)) {
                    jTextComponent.setCaretPosition(jTextComponent.getCaretPosition() - 1);
                }
            } else {
                TokenSequence tokenSequence;
                int n3;
                object2 = "()";
                if (object != null && !((String)object2).startsWith((String)object)) {
                    object2 = (String)object2 + (String)object;
                }
                source = (BaseDocument)jTextComponent.getDocument();
                String string = "";
                int n4 = n3 = ((String)object2).endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(jTextComponent) : -2;
                if (n3 > -2) {
                    Object object4 = object2 = ((String)object2).length() > 1 ? ((String)object2).substring(0, ((String)object2).length() - 1) : null;
                }
                if ((tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)source), (int)(n + n2))) == null || !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    string = string + (String)object2;
                    object2 = null;
                }
                boolean bl = false;
                while (object2 != null && ((String)object2).length() > 0) {
                    String string2 = ((Object)tokenSequence.token().text()).toString();
                    if (string2.startsWith((String)object2)) {
                        n2 = tokenSequence.offset() - n + ((String)object2).length();
                        string = string + (String)object2;
                        object2 = null;
                        continue;
                    }
                    if (((String)object2).startsWith(string2)) {
                        tokenSequence.moveNext();
                        n2 = tokenSequence.offset() - n;
                        string = string + ((String)object2).substring(0, string2.length());
                        object2 = ((String)object2).substring(string2.length());
                        bl = true;
                        continue;
                    }
                    if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                        if (tokenSequence.moveNext()) continue;
                        string = string + (String)object2;
                        object2 = null;
                        continue;
                    }
                    if (!bl) {
                        string = string + (String)object2;
                    }
                    object2 = null;
                }
                int n5 = n2;
                source.runAtomic(new Runnable((BaseDocument)source, n5, n){
                    final /* synthetic */ BaseDocument val$doc;
                    final /* synthetic */ int val$length;
                    final /* synthetic */ int val$offset;
                    {
                        this.val$doc = baseDocument;
                        this.val$length = n2;
                        this.val$offset = n32;
                    }

                    public void run() {
                        try {
                            Position position;
                            Position position2 = position = n3 > -1 ? this.val$doc.createPosition(n3) : null;
                            if (this.val$length > 0) {
                                this.val$doc.remove(this.val$offset, this.val$length);
                            }
                            this.val$doc.insertString(this.val$offset, ((Object)MethodItem.this.getInsertPrefix()).toString(), null);
                            if (position != null) {
                                this.val$doc.insertString(position.getOffset(), ";", null);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
                CodeTemplateManager codeTemplateManager = CodeTemplateManager.get((Document)source);
                if (codeTemplateManager != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl2 = Utilities.guessMethodArguments();
                    if (CodeStyle.getDefault((Document)source).spaceBeforeMethodCallParen()) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append('(');
                    if (string.length() > 1) {
                        Iterator<ParamDesc> iterator = this.params.iterator();
                        while (iterator.hasNext()) {
                            ParamDesc paramDesc = iterator.next();
                            stringBuilder.append("${");
                            stringBuilder.append(paramDesc.name);
                            if (bl2) {
                                stringBuilder.append(" named instanceof=");
                                stringBuilder.append(paramDesc.fullTypeName);
                            }
                            stringBuilder.append('}');
                            if (!iterator.hasNext()) continue;
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(')');
                        if (string.length() > 2) {
                            stringBuilder.append(string.substring(2));
                        }
                    }
                    codeTemplateManager.createTemporary(stringBuilder.toString()).insert(jTextComponent);
                    Completion.get().showToolTip();
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : this.modifiers) {
                stringBuilder.append(object.toString());
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.typeName);
            stringBuilder.append(' ');
            stringBuilder.append(this.simpleName);
            stringBuilder.append('(');
            Iterator<Object> iterator = this.params.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = (ParamDesc)iterator.next();
                stringBuilder.append(((ParamDesc)object).typeName);
                stringBuilder.append(' ');
                stringBuilder.append(((ParamDesc)object).name);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    static class FieldItem
    extends JavaCompletionItem {
        private static final String FIELD_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_16.png";
        private static final String FIELD_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_protected_16.png";
        private static final String FIELD_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_package_private_16.png";
        private static final String FIELD_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_private_16.png";
        private static final String FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png";
        private static final String FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png";
        private static final String FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png";
        private static final String FIELD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_static_private_16.png";
        private static final String FIELD_COLOR = "<font color=#008618>";
        private static ImageIcon[][] icon = new ImageIcon[2][4];
        private ElementHandle<VariableElement> elementHandle;
        private boolean isInherited;
        private boolean isDeprecated;
        private boolean smartType;
        private String simpleName;
        private Set<Modifier> modifiers;
        private String typeName;
        private String leftText;
        private String rightText;

        private FieldItem(VariableElement variableElement, TypeMirror typeMirror, int n, boolean bl, boolean bl2, boolean bl3) {
            super(n);
            this.elementHandle = ElementHandle.create((Element)variableElement);
            this.isInherited = bl;
            this.isDeprecated = bl2;
            this.smartType = bl3;
            this.simpleName = variableElement.getSimpleName().toString();
            this.modifiers = variableElement.getModifiers();
            this.typeName = ((Object)Utilities.getTypeName(typeMirror, false)).toString();
        }

        public int getSortPriority() {
            return this.smartType ? 300 - SMART_TYPE : 300;
        }

        public CharSequence getSortText() {
            return this.simpleName;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(FIELD_COLOR);
                if (!this.isInherited) {
                    stringBuilder.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(this.simpleName);
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                if (!this.isInherited) {
                    stringBuilder.append(JavaCompletionItem.BOLD_END);
                }
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        protected ImageIcon getIcon() {
            int n = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean bl = this.modifiers.contains((Object)Modifier.STATIC);
            ImageIcon imageIcon = icon[bl ? 1 : 0][n];
            if (imageIcon != null) {
                return imageIcon;
            }
            String string = FIELD_PUBLIC;
            if (bl) {
                switch (n) {
                    case 0: {
                        string = FIELD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = FIELD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = FIELD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = FIELD_ST_PUBLIC;
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        string = FIELD_PRIVATE;
                        break;
                    }
                    case 1: {
                        string = FIELD_PACKAGE;
                        break;
                    }
                    case 2: {
                        string = FIELD_PROTECTED;
                        break;
                    }
                    case 3: {
                        string = FIELD_PUBLIC;
                    }
                }
            }
            ImageIcon imageIcon2 = ImageUtilities.loadImageIcon((String)string, (boolean)false);
            FieldItem.icon[bl ? 1 : 0][n] = imageIcon2;
            return imageIcon2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Modifier modifier : this.modifiers) {
                stringBuilder.append(modifier.toString());
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.typeName);
            stringBuilder.append(' ');
            stringBuilder.append(this.simpleName);
            return stringBuilder.toString();
        }
    }

    static class VariableItem
    extends JavaCompletionItem {
        private static final String LOCAL_VARIABLE = "org/netbeans/modules/editor/resources/completion/localVariable.gif";
        private static final String PARAMETER_COLOR = "<font color=#00007c>";
        private static ImageIcon icon;
        private String varName;
        private boolean smartType;
        private String typeName;
        private String leftText;
        private String rightText;

        private VariableItem(TypeMirror typeMirror, String string, int n, boolean bl) {
            super(n);
            this.varName = string;
            this.smartType = bl;
            this.typeName = typeMirror != null ? ((Object)Utilities.getTypeName(typeMirror, false)).toString() : null;
        }

        public int getSortPriority() {
            return this.smartType ? 200 - SMART_TYPE : 200;
        }

        public CharSequence getSortText() {
            return this.varName;
        }

        public CharSequence getInsertPrefix() {
            return this.varName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = "<font color=#00007c><b>" + this.varName + JavaCompletionItem.BOLD_END + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)LOCAL_VARIABLE, (boolean)false);
            }
            return icon;
        }

        public String toString() {
            return (this.typeName != null ? this.typeName + " " : "") + this.varName;
        }
    }

    static class TypeParameterItem
    extends JavaCompletionItem {
        private static final String TYPE_PARAMETER_COLOR = "<font color=#000000>";
        private String simpleName;
        private String leftText;

        private TypeParameterItem(TypeParameterElement typeParameterElement, int n) {
            super(n);
            this.simpleName = typeParameterElement.getSimpleName().toString();
        }

        public int getSortPriority() {
            return 700;
        }

        public CharSequence getSortText() {
            return this.simpleName;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = TYPE_PARAMETER_COLOR + this.simpleName + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        public String toString() {
            return this.simpleName;
        }
    }

    static class AnnotationTypeItem
    extends ClassItem {
        private static final String ANNOTATION = "org/netbeans/modules/editor/resources/completion/annotation_type.png";
        private static ImageIcon icon;

        private AnnotationTypeItem(TypeElement typeElement, DeclaredType declaredType, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(typeElement, declaredType, n, n2, bl, bl2, bl3, bl4);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)ANNOTATION, (boolean)false);
            }
            return icon;
        }
    }

    static class EnumItem
    extends ClassItem {
        private static final String ENUM = "org/netbeans/modules/editor/resources/completion/enum.png";
        private static ImageIcon icon;

        private EnumItem(TypeElement typeElement, DeclaredType declaredType, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(typeElement, declaredType, n, n2, bl, bl2, bl3, bl4);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)ENUM, (boolean)false);
            }
            return icon;
        }
    }

    static class InterfaceItem
    extends ClassItem {
        private static final String INTERFACE = "org/netbeans/modules/editor/resources/completion/interface.png";
        private static final String INTERFACE_COLOR = "<font color=#404040>";
        private static ImageIcon icon;

        private InterfaceItem(TypeElement typeElement, DeclaredType declaredType, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(typeElement, declaredType, n, n2, bl, bl2, bl3, bl4);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)INTERFACE, (boolean)false);
            }
            return icon;
        }

        protected String getColor() {
            return INTERFACE_COLOR;
        }
    }

    static class ClassItem
    extends JavaCompletionItem {
        private static final String CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png";
        private static final String CLASS_COLOR = "<font color=#560000>";
        private static final String PKG_COLOR = "<font color=#808080>";
        private static ImageIcon icon;
        protected TypeMirrorHandle<DeclaredType> typeHandle;
        private int dim;
        private boolean isDeprecated;
        private boolean insideNew;
        private boolean smartType;
        private String simpleName;
        private String typeName;
        private String enclName;
        private CharSequence sortText;
        private String leftText;

        private ClassItem(TypeElement typeElement, DeclaredType declaredType, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(n2);
            this.typeHandle = TypeMirrorHandle.create((TypeMirror)declaredType);
            this.dim = n;
            this.isDeprecated = bl2;
            this.insideNew = bl3;
            this.smartType = bl4;
            this.simpleName = typeElement.getSimpleName().toString();
            this.typeName = ((Object)Utilities.getTypeName(declaredType, false)).toString();
            if (bl) {
                this.enclName = ((Object)Utilities.getElementName(typeElement.getEnclosingElement(), true)).toString();
                this.sortText = this.simpleName + Utilities.getImportanceLevel(this.enclName) + "#" + this.enclName;
            } else {
                this.enclName = null;
                this.sortText = this.simpleName;
            }
        }

        public int getSortPriority() {
            return this.smartType ? 800 - SMART_TYPE : 800;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }

        public CompletionTask createDocumentationTask() {
            return this.typeHandle.getKind() == TypeKind.DECLARED ? JavaCompletionProvider.createDocTask(ElementHandle.from(this.typeHandle)) : null;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)CLASS, (boolean)false);
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.getColor());
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE);
                }
                stringBuilder.append(JavaCompletionItem.escape(this.typeName));
                for (int i = 0; i < this.dim; ++i) {
                    stringBuilder.append("[]");
                }
                if (this.isDeprecated) {
                    stringBuilder.append(JavaCompletionItem.STRIKE_END);
                }
                if (this.enclName != null && this.enclName.length() > 0) {
                    stringBuilder.append(JavaCompletionItem.COLOR_END);
                    stringBuilder.append(PKG_COLOR);
                    stringBuilder.append(" (");
                    stringBuilder.append(this.enclName);
                    stringBuilder.append(")");
                }
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getColor() {
            return CLASS_COLOR;
        }

        protected void substituteText(final JTextComponent jTextComponent, final int n, int n2, String string) {
            int n3;
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            final StringBuilder stringBuilder = new StringBuilder();
            int n4 = n3 = string != null && string.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(jTextComponent) : -2;
            if (n3 > -2) {
                String string2 = string = string.length() > 1 ? string.substring(0, string.length() - 1) : null;
            }
            if (string != null && !string.equals("\n")) {
                TokenSequence tokenSequence = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)baseDocument), (int)(n + n2));
                if (tokenSequence == null || !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    stringBuilder.append(string);
                    string = null;
                }
                boolean bl = false;
                while (string != null && string.length() > 0) {
                    String string3 = ((Object)tokenSequence.token().text()).toString();
                    if (string3.startsWith(string)) {
                        n2 = tokenSequence.offset() - n + string.length();
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (string.startsWith(string3)) {
                        tokenSequence.moveNext();
                        n2 = tokenSequence.offset() - n;
                        stringBuilder.append(string.substring(0, string3.length()));
                        string = string.substring(string3.length());
                        bl = true;
                        continue;
                    }
                    if (tokenSequence.token().id() == JavaTokenId.WHITESPACE && ((Object)tokenSequence.token().text()).toString().indexOf(10) < 0) {
                        if (tokenSequence.moveNext()) continue;
                        stringBuilder.append(string);
                        string = null;
                        continue;
                    }
                    if (!bl) {
                        stringBuilder.append(string);
                    }
                    string = null;
                }
            }
            final int n5 = n2;
            Source source = Source.create((Document)baseDocument);
            try {
                ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Trees trees;
                        final CompilationController compilationController = CompilationController.get((Parser.Result)resultIterator.getParserResult(n));
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        final int n4 = compilationController.getSnapshot().getEmbeddedOffset(n);
                        DeclaredType declaredType = (DeclaredType)ClassItem.this.typeHandle.resolve((CompilationInfo)compilationController);
                        final TypeElement typeElement = declaredType != null ? (TypeElement)declaredType.asElement() : null;
                        boolean bl = false;
                        StringBuilder stringBuilder2 = new StringBuilder();
                        if (typeElement != null) {
                            int n2 = 1;
                            stringBuilder2.append("${PAR");
                            stringBuilder2.append(n2++);
                            if ((declaredType == null || declaredType.getKind() != TypeKind.ERROR) && EnumSet.range(ElementKind.PACKAGE, ElementKind.INTERFACE).contains((Object)typeElement.getEnclosingElement().getKind())) {
                                stringBuilder2.append(" type=\"");
                                stringBuilder2.append(typeElement.getQualifiedName());
                                stringBuilder2.append("\" default=\"");
                                stringBuilder2.append(typeElement.getSimpleName());
                            } else {
                                stringBuilder2.append(" default=\"");
                                stringBuilder2.append(typeElement.getQualifiedName());
                            }
                            stringBuilder2.append("\" editable=false}");
                            Trees trees2 = trees = declaredType != null ? declaredType.getTypeArguments().iterator() : null;
                            if (trees != null && trees.hasNext()) {
                                stringBuilder2.append('<');
                                while (trees.hasNext()) {
                                    TypeMirror typeMirror;
                                    TypeMirror typeMirror2 = (TypeMirror)trees.next();
                                    stringBuilder2.append("${PAR");
                                    stringBuilder2.append(n2++);
                                    if (typeMirror2.getKind() == TypeKind.TYPEVAR) {
                                        typeMirror = (TypeVariable)typeMirror2;
                                        if (typeElement == typeMirror.asElement().getEnclosingElement()) {
                                            stringBuilder2.append(" type=\"");
                                            typeMirror2 = typeMirror.getUpperBound();
                                            stringBuilder2.append(Utilities.getTypeName(typeMirror2, true));
                                            stringBuilder2.append("\" default=\"");
                                            stringBuilder2.append(Utilities.getTypeName(typeMirror2, false));
                                        } else {
                                            stringBuilder2.append(" editable=false default=\"");
                                            stringBuilder2.append(Utilities.getTypeName(typeMirror2, true));
                                            bl = true;
                                        }
                                        stringBuilder2.append("\"}");
                                    } else if (typeMirror2.getKind() == TypeKind.WILDCARD) {
                                        stringBuilder2.append(" type=\"");
                                        typeMirror = ((WildcardType)typeMirror2).getExtendsBound();
                                        if (typeMirror == null) {
                                            typeMirror = ((WildcardType)typeMirror2).getSuperBound();
                                        }
                                        stringBuilder2.append(typeMirror != null ? Utilities.getTypeName(typeMirror, true) : "Object");
                                        stringBuilder2.append("\" default=\"");
                                        stringBuilder2.append(typeMirror != null ? Utilities.getTypeName(typeMirror, false) : "Object");
                                        stringBuilder2.append("\"}");
                                        bl = true;
                                    } else if (typeMirror2.getKind() == TypeKind.ERROR) {
                                        stringBuilder2.append(" default=\"");
                                        stringBuilder2.append(((ErrorType)typeMirror2).asElement().getSimpleName());
                                        stringBuilder2.append("\"}");
                                        bl = true;
                                    } else {
                                        stringBuilder2.append(" type=\"");
                                        stringBuilder2.append(Utilities.getTypeName(typeMirror2, true));
                                        stringBuilder2.append("\" default=\"");
                                        stringBuilder2.append(Utilities.getTypeName(typeMirror2, false));
                                        stringBuilder2.append("\" editable=false}");
                                        bl = true;
                                    }
                                    if (!trees.hasNext()) continue;
                                    stringBuilder2.append(", ");
                                }
                                stringBuilder2.append('>');
                            }
                            for (int i = 0; i < ClassItem.this.dim; ++i) {
                                stringBuilder2.append("[${PAR");
                                stringBuilder2.append(n2++);
                                stringBuilder2.append(" instanceof=\"int\" default=\"\"}]");
                                bl = true;
                            }
                        }
                        if (bl) {
                            CodeTemplateManager codeTemplateManager;
                            if (ClassItem.this.insideNew) {
                                stringBuilder2.append("${cursor completionInvoke}");
                            }
                            if (n5 > 0) {
                                baseDocument.runAtomic(new Runnable(){

                                    public void run() {
                                        try {
                                            baseDocument.remove(n, n5);
                                        }
                                        catch (BadLocationException badLocationException) {
                                            // empty catch block
                                        }
                                    }
                                });
                            }
                            if ((codeTemplateManager = CodeTemplateManager.get((Document)baseDocument)) != null) {
                                codeTemplateManager.createTemporary(stringBuilder2.append((CharSequence)stringBuilder).toString()).insert(jTextComponent);
                            }
                        } else {
                            baseDocument.runAtomic(new Runnable(){

                                public void run() {
                                    try {
                                        String string;
                                        CharSequence charSequence;
                                        Position position = n3 > -1 && !ClassItem.this.insideNew ? baseDocument.createPosition(n3) : null;
                                        TreePath treePath = compilationController.getTreeUtilities().pathFor(n4);
                                        CharSequence charSequence2 = ClassItem.this.enclName == null ? (typeElement != null ? typeElement.getSimpleName() : ClassItem.this.simpleName) : (charSequence = AutoImport.resolveImport((CompilationInfo)compilationController, treePath, compilationController.getTypes().getDeclaredType(typeElement, new TypeMirror[0])));
                                        if (!ClassItem.this.insideNew) {
                                            charSequence = stringBuilder.insert(0, charSequence);
                                        }
                                        if ((string = baseDocument.getText(n, n5)).contentEquals(charSequence)) {
                                            return;
                                        }
                                        baseDocument.remove(n, n5);
                                        baseDocument.insertString(n, ((Object)charSequence).toString(), null);
                                        if (position != null) {
                                            baseDocument.insertString(position.getOffset(), ";", null);
                                        }
                                    }
                                    catch (BadLocationException badLocationException) {
                                        // empty catch block
                                    }
                                }
                            });
                            if (ClassItem.this.insideNew && declaredType != null && declaredType.getKind() == TypeKind.DECLARED) {
                                ExecutableElement executableElement = null;
                                trees = compilationController.getTrees();
                                Scope scope = compilationController.getTreeUtilities().scopeFor(n4);
                                int n32 = 0;
                                for (ExecutableElement object : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
                                    if (trees.isAccessible(scope, object, declaredType)) {
                                        if (executableElement != null) {
                                            n32 = 2;
                                            break;
                                        }
                                        executableElement = object;
                                    }
                                    n32 = 1;
                                }
                                if (n32 != 1 || executableElement != null) {
                                    final JavaCompletionItem javaCompletionItem = n32 == 0 ? JavaCompletionItem.createDefaultConstructorItem(typeElement, n, true) : (n32 == 2 || Utilities.hasAccessibleInnerClassConstructor(typeElement, scope, trees) ? null : JavaCompletionItem.createExecutableItem(executableElement, (ExecutableType)compilationController.getTypes().asMemberOf(declaredType, executableElement), n, false, false, false, true));
                                    try {
                                        final Position badLocationException = baseDocument.createPosition(n);
                                        SwingUtilities.invokeLater(new Runnable(){

                                            public void run() {
                                                if (javaCompletionItem != null) {
                                                    javaCompletionItem.substituteText(jTextComponent, badLocationException.getOffset(), jTextComponent.getSelectionEnd() - badLocationException.getOffset(), stringBuilder.toString());
                                                } else {
                                                    SwingUtilities.invokeLater(new Runnable(){

                                                        public void run() {
                                                            Completion.get().showCompletion();
                                                        }
                                                    });
                                                }
                                            }
                                        });
                                    }
                                    catch (BadLocationException badLocationException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                });
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public String toString() {
            return this.simpleName;
        }
    }

    static class PackageItem
    extends JavaCompletionItem {
        private static final String PACKAGE = "org/netbeans/modules/java/editor/resources/package.gif";
        private static final String PACKAGE_COLOR = "<font color=#005600>";
        private static ImageIcon icon;
        private boolean inPackageStatement;
        private String simpleName;
        private String sortText;
        private String leftText;

        private PackageItem(String string, int n, boolean bl) {
            super(n);
            this.inPackageStatement = bl;
            int n2 = string.lastIndexOf(46);
            this.simpleName = n2 < 0 ? string : string.substring(n2 + 1);
            this.sortText = this.simpleName + "#" + string;
        }

        public int getSortPriority() {
            return 900;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)PACKAGE, (boolean)false);
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(PACKAGE_COLOR);
                stringBuilder.append(this.simpleName);
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
            super.substituteText(jTextComponent, n, n2, this.inPackageStatement || string != null ? string : ".");
        }

        public String toString() {
            return this.simpleName;
        }
    }

    static class KeywordItem
    extends JavaCompletionItem {
        private static final String JAVA_KEYWORD = "org/netbeans/modules/java/editor/resources/javakw_16.png";
        private static final String KEYWORD_COLOR = "<font color=#000099>";
        private static ImageIcon icon;
        private String kwd;
        private int dim;
        private String postfix;
        private boolean smartType;
        private String leftText;

        private KeywordItem(String string, int n, String string2, int n2, boolean bl) {
            super(n2);
            this.kwd = string;
            this.dim = n;
            this.postfix = string2;
            this.smartType = bl;
        }

        public int getSortPriority() {
            return this.smartType ? 600 - SMART_TYPE : 600;
        }

        public CharSequence getSortText() {
            return this.kwd;
        }

        public CharSequence getInsertPrefix() {
            return this.kwd;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = ImageUtilities.loadImageIcon((String)JAVA_KEYWORD, (boolean)false);
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(KEYWORD_COLOR);
                stringBuilder.append(JavaCompletionItem.BOLD);
                stringBuilder.append(this.kwd);
                for (int i = 0; i < this.dim; ++i) {
                    stringBuilder.append("[]");
                }
                stringBuilder.append(JavaCompletionItem.BOLD_END);
                stringBuilder.append(JavaCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected void substituteText(JTextComponent jTextComponent, final int n, int n2, String string) {
            int n3;
            int n4;
            StringBuilder stringBuilder;
            int n5;
            if (this.dim == 0) {
                super.substituteText(jTextComponent, n, n2, string != null ? string : this.postfix);
                return;
            }
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            StringBuilder stringBuilder2 = new StringBuilder();
            int n6 = n5 = string != null && string.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(jTextComponent) : -2;
            if (n5 > -2) {
                String string2 = string = string.length() > 1 ? string.substring(0, string.length() - 1) : null;
            }
            if (string != null && !string.equals("\n")) {
                stringBuilder = SourceUtils.getJavaTokenSequence((TokenHierarchy)TokenHierarchy.get((Document)baseDocument), (int)(n + n2));
                if (stringBuilder == null || !stringBuilder.moveNext() && !stringBuilder.movePrevious()) {
                    stringBuilder2.append(string);
                    string = null;
                }
                n4 = 0;
                while (string != null && string.length() > 0) {
                    String string3 = ((Object)stringBuilder.token().text()).toString();
                    if (string3.startsWith(string)) {
                        n2 = stringBuilder.offset() - n + string.length();
                        stringBuilder2.append(string);
                        string = null;
                        continue;
                    }
                    if (string.startsWith(string3)) {
                        stringBuilder.moveNext();
                        n2 = stringBuilder.offset() - n;
                        stringBuilder2.append(string.substring(0, string3.length()));
                        string = string.substring(string3.length());
                        n4 = 1;
                        continue;
                    }
                    if (stringBuilder.token().id() == JavaTokenId.WHITESPACE && ((Object)stringBuilder.token().text()).toString().indexOf(10) < 0) {
                        if (stringBuilder.moveNext()) continue;
                        stringBuilder2.append(string);
                        string = null;
                        continue;
                    }
                    if (n4 == 0) {
                        stringBuilder2.append(string);
                    }
                    string = null;
                }
            }
            stringBuilder = new StringBuilder();
            n4 = 1;
            stringBuilder.append(this.kwd);
            for (n3 = 0; n3 < this.dim; ++n3) {
                stringBuilder.append("[${PAR");
                stringBuilder.append(n4++);
                stringBuilder.append(" instanceof=\"int\" default=\"\"}]");
            }
            n3 = n2;
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    try {
                        Position position;
                        Position position2 = position = n5 > -1 ? baseDocument.createPosition(n5) : null;
                        if (n3 > 0) {
                            baseDocument.remove(n, n3);
                        }
                        if (position != null) {
                            baseDocument.insertString(position.getOffset(), ";", null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            CodeTemplateManager codeTemplateManager = CodeTemplateManager.get((Document)baseDocument);
            if (codeTemplateManager != null) {
                codeTemplateManager.createTemporary(stringBuilder.append((CharSequence)stringBuilder2).toString()).insert(jTextComponent);
            }
        }

        public String toString() {
            return this.kwd;
        }
    }
}

