/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportClassPanel
extends JPanel {
    private JavaSource javaSource;
    private DefaultListModel model;
    private final int position;
    public JLabel ctrlLabel;
    public JLabel jLabel1;
    public JList jList1;
    public JPanel jPanel1;
    public JScrollPane jScrollPane1;

    public ImportClassPanel(List<TypeElement> list, List<TypeElement> list2, Font font, JavaSource javaSource, int n) {
        this.javaSource = javaSource;
        this.position = n;
        this.createModel(list, list2);
        this.initComponents();
        this.setBackground(this.jList1.getBackground());
        if (this.model.size() > 0) {
            int n2;
            this.jList1.setModel(this.model);
            this.setFocusable(false);
            this.setNextFocusableComponent(this.jList1);
            this.jScrollPane1.setBackground(this.jList1.getBackground());
            this.setBackground(this.jList1.getBackground());
            if (font != null) {
                this.jList1.setFont(font);
            }
            if ((n2 = this.jList1.getModel().getSize()) > 0) {
                this.jList1.setSelectedIndex(0);
            }
            this.jList1.setVisibleRowCount(n2 > 8 ? 8 : n2);
            this.jList1.setCellRenderer(new Renderer(this.jList1));
            this.jList1.grabFocus();
        } else {
            this.remove(this.jScrollPane1);
            JLabel jLabel = new JLabel("<No Classes Found>");
            if (font != null) {
                jLabel.setFont(font);
            }
            jLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
            jLabel.setEnabled(false);
            jLabel.setBackground(this.jList1.getBackground());
            this.add(jLabel);
        }
        this.setA11Y();
    }

    private void setA11Y() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportClassPanel.class, (String)"ImportClassPanel_ACN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportClassPanel.class, (String)"ImportClassPanel_ACSD"));
        this.jList1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportClassPanel.class, (String)"ImportClassPanel_JList1_ACN"));
        this.jList1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportClassPanel.class, (String)"ImportClassPanel_JList1_ACSD"));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.ctrlLabel = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(64, 64, 64)));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
        this.jList1.setSelectionMode(0);
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                ImportClassPanel.this.listMouseReleased(mouseEvent);
            }
        });
        this.jList1.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                ImportClassPanel.this.listKeyReleased(keyEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jLabel1.setLabelFor(this.jList1);
        this.jLabel1.setText("Type to import:");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jLabel1.setOpaque(true);
        this.add((Component)this.jLabel1, "First");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanel1.setLayout(new BorderLayout());
        this.ctrlLabel.setText(NbBundle.getMessage(ImportClassPanel.class, (String)"LBL_PackageImport"));
        this.jPanel1.add((Component)this.ctrlLabel, "Center");
        this.add((Component)this.jPanel1, "Last");
    }

    private void listMouseReleased(MouseEvent mouseEvent) {
        this.importClass(this.getSelected(), (mouseEvent.getModifiers() & 8) > 0, (mouseEvent.getModifiers() & 1) > 0);
    }

    private void listKeyReleased(KeyEvent keyEvent) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        if (keyStroke.getKeyCode() == 10 || keyStroke.getKeyCode() == 32) {
            this.importClass(this.getSelected(), (keyEvent.getModifiers() & 8) > 0, (keyEvent.getModifiers() & 1) > 0);
        }
    }

    public String getSelected() {
        TypeDescription typeDescription = (TypeDescription)this.jList1.getSelectedValue();
        return typeDescription == null ? null : typeDescription.qualifiedName;
    }

    private void createModel(List<TypeElement> list, List<TypeElement> list2) {
        ArrayList<TypeDescription> arrayList = new ArrayList<TypeDescription>(list.size());
        for (TypeElement iterator : list) {
            arrayList.add(new TypeDescription(iterator, false));
        }
        ArrayList arrayList2 = new ArrayList(list.size());
        for (TypeElement typeElement : list2) {
            arrayList.add(new TypeDescription(typeElement, true));
        }
        Collections.sort(arrayList);
        this.model = new DefaultListModel();
        for (TypeDescription typeDescription : arrayList) {
            this.model.addElement(typeDescription);
        }
    }

    private void importClass(String string, final boolean bl, final boolean bl2) {
        String string2;
        int n;
        PopupUtil.hidePopup();
        if (bl && !bl2 && (n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n) + ".*";
        }
        if ((string2 = string) != null) {
            Task<WorkingCopy> task = new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                    ArrayList<ImportTree> arrayList = new ArrayList<ImportTree>(compilationUnitTree.getImports());
                    if (bl2 && this.replaceSimpleName(string2, workingCopy)) {
                        return;
                    }
                    if (this.isImported(string2, arrayList)) {
                        Utilities.setStatusText((JTextComponent)EditorRegistry.lastFocusedComponent(), (String)NbBundle.getMessage(ImportClassPanel.class, (String)(bl ? "MSG_PackageAlreadyImported" : "MSG_ClassAlreadyImported"), (Object)string2), (int)700);
                        return;
                    }
                    ImportTree importTree = treeMaker.Import((Tree)treeMaker.Identifier((CharSequence)string2), false);
                    Object object = arrayList.listIterator();
                    while (object.hasNext()) {
                        ImportTree importTree2 = (ImportTree)object.next();
                        if (!importTree2.isStatic() && importTree2.getQualifiedIdentifier().toString().compareTo(string2) <= 0) continue;
                        object.set(importTree);
                        object.add(importTree2);
                        break;
                    }
                    object = arrayList.contains(importTree) ? treeMaker.CompilationUnit(compilationUnitTree.getPackageName(), arrayList, compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile()) : treeMaker.addCompUnitImport(compilationUnitTree, importTree);
                    workingCopy.rewrite((Tree)compilationUnitTree, (Tree)object);
                }

                private boolean replaceSimpleName(String string, WorkingCopy workingCopy) {
                    TreeUtilities treeUtilities = workingCopy.getTreeUtilities();
                    TreePath treePath = treeUtilities.pathFor(ImportClassPanel.this.position);
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    if (treePath.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
                        workingCopy.rewrite(treePath.getLeaf(), (Tree)treeMaker.Identifier((CharSequence)string));
                        return true;
                    }
                    return false;
                }

                private boolean isImported(String string, List<ImportTree> list) {
                    for (ImportTree importTree : list) {
                        if (!string.equals(importTree.getQualifiedIdentifier().toString())) continue;
                        return true;
                    }
                    return false;
                }
            };
            try {
                this.javaSource.runModificationTask((Task)task).commit();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeDescription
    implements Comparable<TypeDescription> {
        private boolean isDenied;
        private final ElementKind kind;
        private final String qualifiedName;

        public TypeDescription(TypeElement typeElement, boolean bl) {
            this.isDenied = bl;
            this.kind = typeElement.getKind();
            this.qualifiedName = typeElement.getQualifiedName().toString();
        }

        @Override
        public int compareTo(TypeDescription typeDescription) {
            if (this.isDenied && !typeDescription.isDenied) {
                return 1;
            }
            if (!this.isDenied && typeDescription.isDenied) {
                return -1;
            }
            return this.qualifiedName.compareTo(typeDescription.qualifiedName);
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private static int DARKER_COLOR_COMPONENT;
        private static int LIGHTER_COLOR_COMPONENT;
        private Color denidedColor = new Color(128, 128, 128);
        private Color fgColor;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;

        public Renderer(JList jList) {
            this.setFont(jList.getFont());
            this.fgColor = jList.getForeground();
            this.bgColor = jList.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = jList.getSelectionBackground();
            this.fgSelectionColor = jList.getSelectionForeground();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setForeground(this.fgSelectionColor);
                this.setBackground(this.bgSelectionColor);
            } else {
                this.setForeground(this.fgColor);
                this.setBackground(n % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (object instanceof TypeDescription) {
                TypeDescription typeDescription = (TypeDescription)object;
                this.setText(typeDescription.qualifiedName);
                if (typeDescription.isDenied) {
                    this.setForeground(this.denidedColor);
                }
                this.setIcon(ElementIcons.getElementIcon((ElementKind)typeDescription.kind, null));
            } else {
                this.setText(object.toString());
            }
            return this;
        }

        static {
            LIGHTER_COLOR_COMPONENT = DARKER_COLOR_COMPONENT = 5;
        }
    }
}

