/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.javadoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.source.tree.CompilationUnitTree;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.editor.javadoc.JavadocCompletionUtils;
import org.netbeans.modules.parsing.api.Snapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocPositions {
    public static final String UNCLOSED_INLINE_TAG = "@UnclosedInlineTag";
    public static final String NONAME_BLOCK_TAG = "@NonameTag";
    private Map<Tag, int[]> positions;
    private List<TagEntry> sortedTags;
    private int blockSectionStart;
    private Env env;
    static boolean isTestMode = false;
    String tokenSequenceDump;

    public static final DocPositions get(CompilationInfo compilationInfo, Doc doc, TokenSequence<JavadocTokenId> tokenSequence) {
        return DocPositionsManager.get(compilationInfo).get(doc, tokenSequence);
    }

    private DocPositions(Doc doc, TokenSequence<JavadocTokenId> tokenSequence, Snapshot snapshot) {
        this.env = new Env(tokenSequence, snapshot, doc);
    }

    public int[] getTagSpan(Tag tag) {
        this.resolve();
        return this.positions.get(tag);
    }

    public Tag getTag(int n) {
        this.resolve();
        for (TagEntry tagEntry : this.sortedTags) {
            if (n < tagEntry.span[0] || n >= tagEntry.span[1]) continue;
            return tagEntry.tag();
        }
        return null;
    }

    public int getBlockSectionStart() {
        this.resolve();
        return this.blockSectionStart;
    }

    List<? extends Tag> getTags() {
        this.resolve();
        ArrayList<Tag> arrayList = new ArrayList<Tag>(this.sortedTags.size());
        for (TagEntry tagEntry : this.sortedTags) {
            arrayList.add(tagEntry.tag());
        }
        return arrayList;
    }

    private void resolve() {
        if (this.positions != null) {
            return;
        }
        this.positions = new WeakHashMap<Tag, int[]>();
        this.sortedTags = new ArrayList<TagEntry>();
        try {
            this.env.prepare();
            if (this.env.javadoc == null || this.env.jdts.isEmpty()) {
                return;
            }
            TokenSequence tokenSequence = this.env.jdts;
            Token token = null;
            Token token2 = null;
            tokenSequence.moveStart();
            boolean bl = true;
            while (tokenSequence.moveNext()) {
                token2 = token;
                token = tokenSequence.token();
                if (token.id() == JavadocTokenId.TAG) {
                    if (token2 == null || bl) {
                        bl = false;
                        this.addBlockTag((Token<JavadocTokenId>)token, tokenSequence.offset());
                        continue;
                    }
                    if (token2.id() != JavadocTokenId.OTHER_TEXT) continue;
                    if (JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)token2)) {
                        this.closeBlockTag(tokenSequence.offset());
                        this.addBlockTag((Token<JavadocTokenId>)token, tokenSequence.offset());
                        continue;
                    }
                    if (!JavadocCompletionUtils.isInlineTagStart((Token<JavadocTokenId>)token2)) continue;
                    this.addInlineTag();
                    token = tokenSequence.token();
                    continue;
                }
                if (bl && token.id() == JavadocTokenId.OTHER_TEXT && JavadocCompletionUtils.isFirstWhiteSpaceAtFirstLine((Token<JavadocTokenId>)token)) continue;
                bl = false;
            }
            if (token != null) {
                this.closeBlockTag(tokenSequence.offset() + token.length());
            }
            Collections.sort(this.sortedTags);
            if (this.env.btags.length > 0) {
                int[] nArray = this.positions.get(this.env.btags[0]);
                this.blockSectionStart = nArray[0];
            } else {
                this.blockSectionStart = 0;
            }
        }
        catch (Throwable throwable) {
            this.tokenSequenceDump = String.valueOf(this.env.jdts);
            throw new IllegalStateException('\'' + this.env.javadoc.getRawCommentText() + "'\n" + this.toString(), throwable);
        }
        finally {
            if (isTestMode) {
                this.tokenSequenceDump = String.valueOf(this.env.jdts);
            }
            this.env = null;
        }
    }

    private void addInlineTag() {
        Object object;
        TokenSequence tokenSequence = this.env.jdts;
        Token token = tokenSequence.token();
        int n = 0;
        int n2 = tokenSequence.offset() - 1;
        int n3 = -1;
        boolean bl = false;
        CharSequence charSequence = DocPositions.findTagName((TokenSequence<JavadocTokenId>)tokenSequence, tokenSequence.index());
        block0: while (tokenSequence.moveNext()) {
            Token token2 = token;
            token = tokenSequence.token();
            if (token.id() == JavadocTokenId.TAG) {
                if (token2.id() != JavadocTokenId.OTHER_TEXT || !JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)token2)) continue;
                n3 = tokenSequence.offset();
                tokenSequence.movePrevious();
                break;
            }
            if (token.id() != JavadocTokenId.OTHER_TEXT) continue;
            object = token.text();
            for (int i = 0; i < object.length(); ++i) {
                char c = object.charAt(i);
                if (c == '}') {
                    if (n == 0) {
                        bl = true;
                        n3 = tokenSequence.offset() + i;
                        break block0;
                    }
                    --n;
                    continue;
                }
                if (c != '{') continue;
                ++n;
            }
        }
        if (bl) {
            object = this.findNextInlineAtTag();
            if (object != null && object.name().contentEquals(charSequence)) {
                this.addTag((Tag)object, new int[]{n2, n3}, false);
            }
        } else {
            n3 = n3 < n2 ? tokenSequence.offset() + token.length() : n3;
            object = new UnclosedTag(((Object)charSequence).toString(), UNCLOSED_INLINE_TAG, this.env.javadoc);
            ((UnclosedTag)object).text = this.env.snapshot.getText().subSequence(n2, n3);
            this.addTag((Tag)object, new int[]{n2, n3}, false);
        }
    }

    private Tag findNextInlineAtTag() {
        Tag tag = null;
        while (this.env.iindex < this.env.itags.length) {
            if (this.env.itags[this.env.iindex].name().startsWith("@")) {
                tag = this.env.itags[this.env.iindex++];
                break;
            }
            this.env.iindex++;
        }
        return tag;
    }

    private void addBlockTag(Token<JavadocTokenId> token, int n) {
        assert (token.id() == JavadocTokenId.TAG);
        this.env.btag = this.env.btags[this.env.bindex];
        CharSequence charSequence = DocPositions.findTagName((TokenSequence<JavadocTokenId>)this.env.jdts, this.env.jdts.index());
        if (this.env.btag.name().contentEquals(charSequence)) {
            ++this.env.bindex;
            this.env.iindex = 0;
            Env.access$602(this.env, this.env.btag.inlineTags());
        } else {
            this.env.btag = new UnclosedTag(((Object)token.text()).toString(), NONAME_BLOCK_TAG, this.env.javadoc);
        }
        this.addTag(this.env.btag, new int[]{n, -1}, true);
        this.env.bscan = true;
    }

    private static CharSequence findTagName(TokenSequence<JavadocTokenId> tokenSequence, int n) {
        tokenSequence.moveIndex(n);
        if (!tokenSequence.moveNext() || tokenSequence.token().id() != JavadocTokenId.TAG) {
            throw new IllegalArgumentException(n + ", " + tokenSequence.toString());
        }
        StringBuilder stringBuilder = new StringBuilder(tokenSequence.token().text());
        block0: while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (token.id() != JavadocTokenId.OTHER_TEXT) {
                stringBuilder.append(token.text());
                n = tokenSequence.index();
                continue;
            }
            CharSequence charSequence = token.text();
            for (int i = 0; i < charSequence.length(); ++i) {
                char c = charSequence.charAt(i);
                if (Character.isWhitespace(c)) break block0;
                stringBuilder.append(c);
            }
        }
        tokenSequence.moveIndex(n);
        tokenSequence.moveNext();
        return stringBuilder;
    }

    private void closeBlockTag(int n) {
        if (this.env.bscan) {
            int[] nArray = this.positions.get(this.env.btag);
            nArray[1] = n;
            if (NONAME_BLOCK_TAG == this.env.btag.kind()) {
                ((UnclosedTag)this.env.btag).text = this.env.snapshot.getText().subSequence(nArray[0], nArray[1]);
            }
            this.env.bscan = false;
        }
    }

    private void addTag(Tag tag, int[] nArray, boolean bl) {
        this.positions.put(tag, nArray);
        this.sortedTags.add(new TagEntry(tag, nArray, bl));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        if (this.positions != null) {
            for (TagEntry tagEntry : this.sortedTags) {
                stringBuilder.append("\n ").append(tagEntry);
            }
        } else {
            stringBuilder.append(" Not resolved yet.");
        }
        stringBuilder.append("\ntoken sequence dump: " + this.tokenSequenceDump);
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DocPositionsManager {
        private static final Map<CompilationUnitTree, DocPositionsManager> managers = new WeakHashMap<CompilationUnitTree, DocPositionsManager>();
        private final Map<Doc, DocPositions> cache = new WeakHashMap<Doc, DocPositions>();
        private final Reference<Snapshot> snapshot;

        public DocPositionsManager(Snapshot snapshot) {
            this.snapshot = new WeakReference<Snapshot>(snapshot);
        }

        public static DocPositionsManager get(CompilationInfo compilationInfo) {
            Snapshot snapshot = compilationInfo.getSnapshot();
            CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
            DocPositionsManager docPositionsManager = managers.get(compilationUnitTree);
            if (docPositionsManager == null) {
                docPositionsManager = new DocPositionsManager(snapshot);
                managers.put(compilationUnitTree, docPositionsManager);
            }
            return docPositionsManager;
        }

        public DocPositions get(Doc doc, TokenSequence<JavadocTokenId> tokenSequence) {
            DocPositions docPositions = this.cache.get(doc);
            if (docPositions == null) {
                docPositions = new DocPositions(doc, tokenSequence, this.snapshot.get());
                this.cache.put(doc, docPositions);
            }
            return docPositions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TagEntry
    implements Comparable<TagEntry> {
        final Reference<Tag> wtag;
        final UnclosedTag utag;
        final boolean isBlock;
        final int[] span;

        public TagEntry(Tag tag, int[] nArray, boolean bl) {
            this.wtag = new WeakReference<Tag>(tag);
            this.utag = (UnclosedTag)(tag instanceof UnclosedTag ? tag : null);
            this.isBlock = bl;
            assert (nArray.length == 2);
            this.span = nArray;
        }

        public Tag tag() {
            return this.wtag.get();
        }

        @Override
        public int compareTo(TagEntry tagEntry) {
            if (tagEntry == this) {
                return 0;
            }
            int n = this.span[1] - tagEntry.span[1];
            if (n == 0) {
                n = this.isBlock ? 1 : -1;
            }
            return n;
        }

        public String toString() {
            return String.format("[%1$d,%2$d], block: %3$b, %4$s", this.span[0], this.span[1], this.isBlock, this.tag());
        }
    }

    private static final class UnclosedTag
    implements Tag {
        private static final Tag[] EMPTY_TAGS = new Tag[0];
        private final String name;
        private final Reference<Doc> wjavadoc;
        private final String kind;
        private CharSequence text;

        public UnclosedTag(String string, String string2, Doc doc) {
            this.name = string;
            this.kind = string2;
            this.wjavadoc = new WeakReference<Doc>(doc);
        }

        public String name() {
            return this.name;
        }

        public Doc holder() {
            return this.wjavadoc.get();
        }

        public String kind() {
            return this.kind;
        }

        public String text() {
            return ((Object)this.text).toString();
        }

        public Tag[] inlineTags() {
            return EMPTY_TAGS;
        }

        public Tag[] firstSentenceTags() {
            return EMPTY_TAGS;
        }

        public SourcePosition position() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.name + ":" + this.kind + ":" + this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Env {
        private TokenSequence<JavadocTokenId> jdts;
        private Snapshot snapshot;
        private final WeakReference<Doc> wjavadoc;
        private Doc javadoc;
        private Tag[] btags;
        private Tag btag;
        private int bindex;
        private boolean bscan = false;
        private Tag[] itags;
        private int iindex;

        public Env(TokenSequence<JavadocTokenId> tokenSequence, Snapshot snapshot, Doc doc) {
            this.jdts = tokenSequence;
            this.snapshot = snapshot;
            this.wjavadoc = new WeakReference<Doc>(doc);
        }

        void prepare() {
            this.javadoc = (Doc)this.wjavadoc.get();
            if (this.javadoc != null) {
                this.btags = this.javadoc.tags();
                this.itags = this.javadoc.inlineTags();
            }
        }

        static /* synthetic */ Tag[] access$602(Env env, Tag[] tagArray) {
            env.itags = tagArray;
            return tagArray;
        }
    }
}

