/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CodeCompletionPanel
extends JPanel
implements DocumentListener {
    public static final String JAVA_AUTO_POPUP_ON_IDENTIFIER_PART = "javaAutoPopupOnIdentifierPart";
    public static final boolean JAVA_AUTO_POPUP_ON_IDENTIFIER_PART_DEFAULT = false;
    public static final String JAVA_AUTO_COMPLETION_TRIGGERS = "javaAutoCompletionTriggers";
    public static final String JAVA_AUTO_COMPLETION_TRIGGERS_DEFAULT = ".";
    public static final String JAVA_COMPLETION_SELECTORS = "javaCompletionSelectors";
    public static final String JAVA_COMPLETION_SELECTORS_DEFAULT = ".,;:([+-=";
    public static final String JAVADOC_AUTO_COMPLETION_TRIGGERS = "javadocAutoCompletionTriggers";
    public static final String JAVADOC_AUTO_COMPLETION_TRIGGERS_DEFAULT = ".#@";
    public static final String GUESS_METHOD_ARGUMENTS = "guessMethodArguments";
    public static final boolean GUESS_METHOD_ARGUMENTS_DEFAULT = true;
    public static final String JAVA_COMPLETION_WHITELIST = "javaCompletionWhitelist";
    public static final String JAVA_COMPLETION_WHITELIST_DEFAULT = "";
    public static final String JAVA_COMPLETION_BLACKLIST = "javaCompletionBlacklist";
    public static final String JAVA_COMPLETION_BLACKLIST_DEFAULT = "";
    public static final String JAVA_COMPLETION_EXCLUDER_METHODS = "javaCompletionExcluderMethods";
    public static final boolean JAVA_COMPLETION_EXCLUDER_METHODS_DEFAULT = false;
    private static final String JAVA_FQN_REGEX = "[$\\w._]*";
    private final Preferences preferences;
    private volatile String javaExcluderEditing;
    private JCheckBox guessMethodArguments;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField javaAutoCompletionTriggersField;
    private JLabel javaAutoCompletionTriggersLabel;
    private JCheckBox javaAutoPopupOnIdentifierPart;
    private JList javaCompletionExcludeJlist;
    private JScrollPane javaCompletionExcludeScrollPane;
    private JButton javaCompletionExcluderAddButton;
    private JDialog javaCompletionExcluderDialog2;
    private JButton javaCompletionExcluderDialogCancelButton;
    private JLabel javaCompletionExcluderDialogLabel;
    private JButton javaCompletionExcluderDialogOkButton;
    private JTextField javaCompletionExcluderDialogTextField;
    private JButton javaCompletionExcluderEditButton;
    private JLabel javaCompletionExcluderLabel;
    private JCheckBox javaCompletionExcluderMethodsCheckBox;
    private JButton javaCompletionExcluderRemoveButton;
    private JTabbedPane javaCompletionExcluderTab;
    private JList javaCompletionIncludeJlist;
    private JScrollPane javaCompletionIncludeScrollPane;
    private JPanel javaCompletionPane;
    private JTextField javaCompletionSelectorsField;
    private JLabel javaCompletionSelectorsLabel;
    private JTextField javadocAutoCompletionTriggersField;
    private JLabel javadocAutoCompletionTriggersLabel;

    public CodeCompletionPanel(Preferences preferences) {
        this.initComponents();
        this.preferences = preferences;
        this.guessMethodArguments.setSelected(this.preferences.getBoolean(GUESS_METHOD_ARGUMENTS, true));
        this.javaAutoPopupOnIdentifierPart.setSelected(this.preferences.getBoolean(JAVA_AUTO_POPUP_ON_IDENTIFIER_PART, false));
        this.javaAutoCompletionTriggersField.setText(this.preferences.get(JAVA_AUTO_COMPLETION_TRIGGERS, JAVA_AUTO_COMPLETION_TRIGGERS_DEFAULT));
        this.javaCompletionSelectorsField.setText(this.preferences.get(JAVA_COMPLETION_SELECTORS, JAVA_COMPLETION_SELECTORS_DEFAULT));
        this.javadocAutoCompletionTriggersField.setText(this.preferences.get(JAVADOC_AUTO_COMPLETION_TRIGGERS, JAVADOC_AUTO_COMPLETION_TRIGGERS_DEFAULT));
        String string = this.preferences.get(JAVA_COMPLETION_BLACKLIST, "");
        this.initExcluderList(this.javaCompletionExcludeJlist, string);
        String string2 = this.preferences.get(JAVA_COMPLETION_WHITELIST, "");
        this.initExcluderList(this.javaCompletionIncludeJlist, string2);
        this.javaCompletionExcluderMethodsCheckBox.setSelected(this.preferences.getBoolean(JAVA_COMPLETION_EXCLUDER_METHODS, false));
        this.javaCompletionExcluderDialog2.getRootPane().setDefaultButton(this.javaCompletionExcluderDialogOkButton);
        this.javaCompletionExcluderDialog2.pack();
        this.javaCompletionExcluderDialog2.setLocationRelativeTo(this);
        this.javaAutoCompletionTriggersField.getDocument().addDocumentListener(this);
        this.javaCompletionSelectorsField.getDocument().addDocumentListener(this);
        this.javadocAutoCompletionTriggersField.getDocument().addDocumentListener(this);
    }

    private void initExcluderList(JList jList, String string) {
        String[] stringArray;
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string2 : stringArray = string.split(",")) {
            if (string2.length() == 0) continue;
            defaultListModel.addElement(string2);
        }
        jList.setModel(defaultListModel);
    }

    private void openExcluderEditor() {
        assert (!this.javaCompletionExcluderDialog2.isVisible());
        this.javaCompletionExcluderDialogTextField.setText(this.javaExcluderEditing);
        this.javaCompletionExcluderDialog2.setVisible(true);
        this.javaCompletionExcluderDialogTextField.requestFocus();
    }

    public static PreferencesCustomizer.Factory getCustomizerFactory() {
        return new PreferencesCustomizer.Factory(){

            public PreferencesCustomizer create(Preferences preferences) {
                return new CodeCompletionPreferencesCustomizer(preferences);
            }
        };
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    private void initComponents() {
        this.javaCompletionExcluderDialog2 = new JDialog();
        this.javaCompletionExcluderDialogTextField = new JTextField();
        this.javaCompletionExcluderDialogOkButton = new JButton();
        this.javaCompletionExcluderDialogLabel = new JLabel();
        this.javaCompletionExcluderDialogCancelButton = new JButton();
        this.javaCompletionPane = new JPanel();
        this.guessMethodArguments = new JCheckBox();
        this.javaAutoPopupOnIdentifierPart = new JCheckBox();
        this.javaAutoCompletionTriggersLabel = new JLabel();
        this.javaAutoCompletionTriggersField = new JTextField();
        this.javaCompletionSelectorsLabel = new JLabel();
        this.javaCompletionSelectorsField = new JTextField();
        this.javadocAutoCompletionTriggersLabel = new JLabel();
        this.javadocAutoCompletionTriggersField = new JTextField();
        this.javaCompletionExcluderTab = new JTabbedPane();
        this.javaCompletionExcludeScrollPane = new JScrollPane();
        this.javaCompletionExcludeJlist = new JList();
        this.javaCompletionIncludeScrollPane = new JScrollPane();
        this.javaCompletionIncludeJlist = new JList();
        this.javaCompletionExcluderMethodsCheckBox = new JCheckBox();
        this.javaCompletionExcluderAddButton = new JButton();
        this.javaCompletionExcluderRemoveButton = new JButton();
        this.javaCompletionExcluderEditButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.javaCompletionExcluderLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.javaCompletionExcluderDialog2.setTitle(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ExcluderDialogTitle"));
        this.javaCompletionExcluderDialog2.setModal(true);
        this.javaCompletionExcluderDialogTextField.setText(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderDialogTextField.text"));
        this.javaCompletionExcluderDialogTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                CodeCompletionPanel.this.javaCompletionExcluderDialogTextFieldKeyTyped(keyEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.javaCompletionExcluderDialogOkButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderDialogOkButton.text"));
        this.javaCompletionExcluderDialogOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeCompletionPanel.this.javaCompletionExcluderDialogOkButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.javaCompletionExcluderDialogLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderDialogLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.javaCompletionExcluderDialogCancelButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderDialogCancelButton.text"));
        this.javaCompletionExcluderDialogCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeCompletionPanel.this.javaCompletionExcluderDialogCancelButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.javaCompletionExcluderDialog2.getContentPane());
        this.javaCompletionExcluderDialog2.getContentPane().setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add(1, (Component)this.javaCompletionExcluderDialogLabel, 0, 0, Short.MAX_VALUE).add(1, (Component)this.javaCompletionExcluderDialogTextField, -1, 307, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.javaCompletionExcluderDialogOkButton, -1, -1, Short.MAX_VALUE).add((Component)this.javaCompletionExcluderDialogCancelButton, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.javaCompletionExcluderDialogLabel).addPreferredGap(0, -1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.javaCompletionExcluderDialogCancelButton).addPreferredGap(0))).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.javaCompletionExcluderDialogTextField, -2, -1, -2).add((Component)this.javaCompletionExcluderDialogOkButton)).add(61, 61, 61)));
        this.javaCompletionExcluderDialogTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderDialogTextField.AccessibleContext.accessibleName"));
        this.javaCompletionExcluderDialogTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderDialogTextField.AccessibleContext.accessibleDescription"));
        this.javaCompletionExcluderDialogOkButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ACSD_OKButton"));
        this.javaCompletionExcluderDialogLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderDialogLabel.AccessibleContext.accessibleName"));
        this.javaCompletionExcluderDialogCancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ACSD_CancelButton"));
        this.javaCompletionExcluderDialog2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderDialog2.AccessibleContext.accessibleName"));
        this.javaCompletionExcluderDialog2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ACSD_PopupDialog"));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.guessMethodArguments, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"LBL_GuessMethodArgs"));
        this.guessMethodArguments.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeCompletionPanel.this.guessMethodArgumentsActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.javaAutoPopupOnIdentifierPart, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"LBL_AutoPopupOnIdentifierPartBox"));
        this.javaAutoPopupOnIdentifierPart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeCompletionPanel.this.javaAutoPopupOnIdentifierPartActionPerformed(actionEvent);
            }
        });
        this.javaAutoCompletionTriggersLabel.setLabelFor(this.javaAutoCompletionTriggersField);
        Mnemonics.setLocalizedText((JLabel)this.javaAutoCompletionTriggersLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"LBL_JavaAutoCompletionTriggers"));
        this.javaAutoCompletionTriggersField.setAlignmentX(1.0f);
        this.javaCompletionSelectorsLabel.setLabelFor(this.javaCompletionSelectorsField);
        Mnemonics.setLocalizedText((JLabel)this.javaCompletionSelectorsLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"LBL_JavaCompletionSelectors"));
        this.javadocAutoCompletionTriggersLabel.setLabelFor(this.javadocAutoCompletionTriggersField);
        Mnemonics.setLocalizedText((JLabel)this.javadocAutoCompletionTriggersLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"LBL_JavadocAutoCompletionTriggers"));
        this.javadocAutoCompletionTriggersField.setText(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javadocAutoCompletionTriggersField.text"));
        this.javaCompletionExcludeScrollPane.setViewportView(this.javaCompletionExcludeJlist);
        this.javaCompletionExcludeJlist.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcludeJlist.AccessibleContext.accessibleName"));
        this.javaCompletionExcludeJlist.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ACSD_ExcludeList"));
        this.javaCompletionExcluderTab.addTab(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcludeScrollPane.TabConstraints.tabTitle"), this.javaCompletionExcludeScrollPane);
        this.javaCompletionExcludeScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcludeScrollPane.AccessibleContext.accessibleName"));
        this.javaCompletionIncludeScrollPane.setViewportView(this.javaCompletionIncludeJlist);
        this.javaCompletionIncludeJlist.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionIncludeJlist.AccessibleContext.accessibleName"));
        this.javaCompletionExcluderTab.addTab(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionIncludeScrollPane.TabConstraints.tabTitle"), this.javaCompletionIncludeScrollPane);
        this.javaCompletionIncludeScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionIncludeScrollPane.AccessibleContext.accessibleName"));
        Mnemonics.setLocalizedText((AbstractButton)this.javaCompletionExcluderMethodsCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderMethodsCheckBox.text"));
        this.javaCompletionExcluderMethodsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeCompletionPanel.this.javaCompletionExcluderMethodsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.javaCompletionExcluderAddButton.setMnemonic('A');
        Mnemonics.setLocalizedText((AbstractButton)this.javaCompletionExcluderAddButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderAddButton.text"));
        this.javaCompletionExcluderAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeCompletionPanel.this.javaCompletionExcluderAddButtonActionPerformed(actionEvent);
            }
        });
        this.javaCompletionExcluderRemoveButton.setMnemonic('R');
        Mnemonics.setLocalizedText((AbstractButton)this.javaCompletionExcluderRemoveButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderRemoveButton.text"));
        this.javaCompletionExcluderRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeCompletionPanel.this.javaCompletionExcluderRemoveButtonActionPerformed(actionEvent);
            }
        });
        this.javaCompletionExcluderEditButton.setMnemonic('E');
        Mnemonics.setLocalizedText((AbstractButton)this.javaCompletionExcluderEditButton, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderEditButton.text"));
        this.javaCompletionExcluderEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeCompletionPanel.this.javaCompletionExcluderEditButtonActionPerformed(actionEvent);
            }
        });
        this.javaCompletionExcluderLabel.setLabelFor(this.javaCompletionExcluderTab);
        Mnemonics.setLocalizedText((JLabel)this.javaCompletionExcluderLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderLabel.text"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.javaCompletionPane);
        this.javaCompletionPane.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createParallelGroup(2, false).add(1, (Component)this.javaCompletionExcluderLabel).add(1, (Component)this.jSeparator2).add(1, (GroupLayout.Group)groupLayout2.createSequentialGroup().add(6, 6, 6).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.javaCompletionExcluderMethodsCheckBox).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.javaCompletionExcluderTab, -2, 298, -2).add(10, 10, 10).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.javaCompletionExcluderAddButton).add((Component)this.javaCompletionExcluderRemoveButton).add((Component)this.javaCompletionExcluderEditButton)))))).add((Component)this.jSeparator1, -2, 427, -2).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.javadocAutoCompletionTriggersLabel).addPreferredGap(0).add((Component)this.javadocAutoCompletionTriggersField, -2, 86, -2))).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.guessMethodArguments).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.javaAutoCompletionTriggersLabel).add(34, 34, 34).add((Component)this.javaAutoCompletionTriggersField, -2, 86, -2)).add((Component)this.javaAutoPopupOnIdentifierPart).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.javaCompletionSelectorsLabel).add(30, 30, 30).add((Component)this.javaCompletionSelectorsField, -2, 86, -2))).add(213, 213, 213))));
        groupLayout2.linkSize(new Component[]{this.javaCompletionExcluderAddButton, this.javaCompletionExcluderEditButton, this.javaCompletionExcluderRemoveButton}, 1);
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(132, 132, 132).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.javaCompletionExcluderLabel).addPreferredGap(0).add((Component)this.javaCompletionExcluderTab, -2, 124, -2).addPreferredGap(0).add((Component)this.javaCompletionExcluderMethodsCheckBox)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(35, 35, 35).add((Component)this.javaCompletionExcluderAddButton).addPreferredGap(0).add((Component)this.javaCompletionExcluderRemoveButton).addPreferredGap(0).add((Component)this.javaCompletionExcluderEditButton))).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.javadocAutoCompletionTriggersLabel).add((Component)this.javadocAutoCompletionTriggersField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.guessMethodArguments, -2, 23, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.javaAutoCompletionTriggersLabel).add((Component)this.javaAutoCompletionTriggersField, -2, -1, -2)).addPreferredGap(0).add((Component)this.javaAutoPopupOnIdentifierPart).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.javaCompletionSelectorsLabel).add((Component)this.javaCompletionSelectorsField, -2, -1, -2)).addContainerGap(255, Short.MAX_VALUE))));
        this.javadocAutoCompletionTriggersField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ACSN_JavadocTriggers"));
        this.javadocAutoCompletionTriggersField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ACSD_JavadocTrigger"));
        this.javaCompletionExcluderTab.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.javaCompletionExcluderTab.AccessibleContext.accessibleName"));
        this.javaCompletionExcluderTab.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ACSD_Table"));
        this.javaCompletionExcluderMethodsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ACSD_MethodsCB"));
        this.javaCompletionExcluderAddButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ACSD_Add"));
        this.javaCompletionExcluderRemoveButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ACSD_Remove"));
        this.javaCompletionExcluderEditButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CodeCompletionPanel.class, (String)"ACSD_Edit"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.javaCompletionPane, -1, 439, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.javaCompletionPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void javaAutoPopupOnIdentifierPartActionPerformed(ActionEvent actionEvent) {
        this.preferences.putBoolean(JAVA_AUTO_POPUP_ON_IDENTIFIER_PART, this.javaAutoPopupOnIdentifierPart.isSelected());
    }

    private void guessMethodArgumentsActionPerformed(ActionEvent actionEvent) {
        this.preferences.putBoolean(GUESS_METHOD_ARGUMENTS, this.guessMethodArguments.isSelected());
    }

    private void javaCompletionExcluderAddButtonActionPerformed(ActionEvent actionEvent) {
        this.openExcluderEditor();
    }

    private void javaCompletionExcluderRemoveButtonActionPerformed(ActionEvent actionEvent) {
        JList jList = this.getSelectedExcluderList();
        int[] nArray = jList.getSelectedIndices();
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        for (int i = nArray.length - 1; i >= 0; --i) {
            defaultListModel.remove(nArray[i]);
        }
        this.updateExcluder(jList);
    }

    private void javaCompletionExcluderEditButtonActionPerformed(ActionEvent actionEvent) {
        JList jList = this.getSelectedExcluderList();
        int n = jList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        this.javaExcluderEditing = (String)defaultListModel.getElementAt(n);
        this.openExcluderEditor();
    }

    private void javaCompletionExcluderMethodsCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.preferences.putBoolean(JAVA_COMPLETION_EXCLUDER_METHODS, this.javaCompletionExcluderMethodsCheckBox.isSelected());
    }

    private void javaCompletionExcluderDialogOkButtonActionPerformed(ActionEvent actionEvent) {
        String[] stringArray;
        JList jList = this.getSelectedExcluderList();
        String string = this.javaCompletionExcluderDialogTextField.getText();
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        int n = defaultListModel.size();
        if (this.javaExcluderEditing != null) {
            n = defaultListModel.indexOf(this.javaExcluderEditing);
            defaultListModel.remove(n);
            this.javaExcluderEditing = null;
        }
        for (String string2 : stringArray = string.split(",")) {
            if (string2.contains("*")) {
                string2 = string2.replaceAll("\\*", "");
            }
            if ((string2 = string2.trim()).length() == 0 || !string2.matches(JAVA_FQN_REGEX)) continue;
            defaultListModel.insertElementAt(string2, n);
            ++n;
        }
        this.updateExcluder(jList);
        this.javaCompletionExcluderDialog2.setVisible(false);
        this.javaCompletionExcluderDialogTextField.setText(null);
    }

    private void javaCompletionExcluderDialogCancelButtonActionPerformed(ActionEvent actionEvent) {
        this.javaCompletionExcluderDialog2.setVisible(false);
        this.javaCompletionExcluderDialogTextField.setText(null);
        this.javaExcluderEditing = null;
    }

    private void javaCompletionExcluderDialogTextFieldKeyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c != ' ' && c != ',' && c != '*' && !String.valueOf(c).matches(JAVA_FQN_REGEX) && c != '\b') {
            this.getToolkit().beep();
            keyEvent.consume();
        }
    }

    private void update(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.javaAutoCompletionTriggersField.getDocument()) {
            this.preferences.put(JAVA_AUTO_COMPLETION_TRIGGERS, this.javaAutoCompletionTriggersField.getText());
        } else if (documentEvent.getDocument() == this.javaCompletionSelectorsField.getDocument()) {
            this.preferences.put(JAVA_COMPLETION_SELECTORS, this.javaCompletionSelectorsField.getText());
        } else if (documentEvent.getDocument() == this.javadocAutoCompletionTriggersField.getDocument()) {
            this.preferences.put(JAVADOC_AUTO_COMPLETION_TRIGGERS, this.javadocAutoCompletionTriggersField.getText());
        }
    }

    private void updateExcluder(JList jList) {
        String string;
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            String string2 = (String)defaultListModel.getElementAt(i);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string2);
        }
        if (jList == this.javaCompletionExcludeJlist) {
            string = JAVA_COMPLETION_BLACKLIST;
        } else if (jList == this.javaCompletionIncludeJlist) {
            string = JAVA_COMPLETION_WHITELIST;
        } else {
            throw new RuntimeException(jList.getName());
        }
        this.preferences.put(string, stringBuilder.toString());
    }

    private JList getSelectedExcluderList() {
        Component component = this.javaCompletionExcluderTab.getSelectedComponent();
        if (component == this.javaCompletionExcludeScrollPane) {
            return this.javaCompletionExcludeJlist;
        }
        if (component == this.javaCompletionIncludeScrollPane) {
            return this.javaCompletionIncludeJlist;
        }
        throw new RuntimeException(component.getName());
    }

    private static class CodeCompletionPreferencesCustomizer
    implements PreferencesCustomizer {
        private final Preferences preferences;

        private CodeCompletionPreferencesCustomizer(Preferences preferences) {
            this.preferences = preferences;
        }

        public String getId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getDisplayName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("netbeans.optionsDialog.editor.codeCompletion.java");
        }

        public JComponent getComponent() {
            return new CodeCompletionPanel(this.preferences);
        }
    }
}

