/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.netbeans.modules.i18n.I18nAction;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.InsertI18nStringAction;
import org.netbeans.modules.i18n.wizard.I18nTestWizardAction;
import org.netbeans.modules.i18n.wizard.I18nWizardAction;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class I18nGroupAction
extends SystemAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup,
Presenter.Toolbar {
    protected static final SystemAction[] i18nActions = new SystemAction[]{SystemAction.get(I18nAction.class), SystemAction.get(InsertI18nStringAction.class), null, SystemAction.get(I18nWizardAction.class), SystemAction.get(I18nTestWizardAction.class)};

    public I18nGroupAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public String getName() {
        return I18nUtil.getBundle().getString("LBL_I18nGroupActionName");
    }

    protected String iconResource() {
        return "org/netbeans/modules/i18n/i18nAction.gif";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("internation.internation");
    }

    public JMenuItem getMenuPresenter() {
        return LazyPopup.createLazyPopup(true, this);
    }

    public JMenuItem getPopupPresenter() {
        return LazyPopup.createLazyPopup(false, this);
    }

    public Component getToolbarPresenter() {
        JToolBar jToolBar = new JToolBar(this.getName());
        for (SystemAction systemAction : i18nActions) {
            if (systemAction == null) {
                jToolBar.addSeparator();
                continue;
            }
            if (!(systemAction instanceof Presenter.Toolbar)) continue;
            jToolBar.add(((Presenter.Toolbar)systemAction).getToolbarPresenter());
        }
        return jToolBar;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAwareClass(this, lookup);
    }

    private final class ContextAwareClass
    implements Action,
    PropertyChangeListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar {
        private final I18nGroupAction delegate;
        private final Lookup context;
        private final Action[] contextActions;
        private List<PropertyChangeListener> propListeners;
        private volatile Boolean enabled = null;

        ContextAwareClass(I18nGroupAction i18nGroupAction2, Lookup lookup) {
            this.delegate = i18nGroupAction2;
            this.context = lookup;
            this.contextActions = new Action[i18nActions.length];
            i18nGroupAction2.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)((Object)i18nGroupAction2)));
            for (int i = 0; i < i18nActions.length; ++i) {
                SystemAction systemAction = i18nActions[i];
                if (systemAction == null) {
                    this.contextActions[i] = null;
                    continue;
                }
                this.contextActions[i] = systemAction instanceof ContextAwareAction ? ((ContextAwareAction)systemAction).createContextAwareInstance(this.context) : systemAction;
                this.contextActions[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.contextActions[i]));
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == this.delegate) {
                this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if ("enabled".equals(string)) {
                this.updateEnabled();
            }
        }

        private synchronized void updateEnabled() {
            assert (EventQueue.isDispatchThread());
            if (this.propListeners == null) {
                this.enabled = null;
                return;
            }
            Boolean bl = this.enabled;
            this.enabled = this.shouldBeEnabled();
            if (this.enabled != bl) {
                this.fireEnabledChanged();
            }
        }

        private void fireEnabledChanged() {
            this.firePropertyChange("enabled", null, null);
        }

        private boolean shouldBeEnabled() {
            for (SystemAction systemAction : i18nActions) {
                if (systemAction == null || !systemAction.isEnabled()) continue;
                return true;
            }
            return false;
        }

        public boolean isEnabled() {
            assert (EventQueue.isDispatchThread());
            if (this.enabled == null) {
                this.enabled = this.shouldBeEnabled();
            }
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.delegate.actionPerformed(actionEvent);
        }

        public JMenuItem getMenuPresenter() {
            return this.delegate.getMenuPresenter();
        }

        public JMenuItem getPopupPresenter() {
            return this.delegate.getPopupPresenter();
        }

        public Component getToolbarPresenter() {
            return this.delegate.getToolbarPresenter();
        }

        public Object getValue(String string) {
            return this.delegate.getValue(string);
        }

        public void putValue(String string, Object object) {
            this.delegate.putValue(string, object);
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propListeners == null) {
                this.propListeners = new ArrayList<PropertyChangeListener>(4);
            }
            this.propListeners.add(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.propListeners != null && this.propListeners.remove(propertyChangeListener) && this.propListeners.isEmpty()) {
                this.propListeners = null;
            }
        }

        private void firePropertyChange(String string, Object object, Object object2) {
            if (object2 != null && object2.equals(object)) {
                return;
            }
            if (this.propListeners != null) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
                for (PropertyChangeListener propertyChangeListener : this.propListeners) {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
            }
        }
    }

    static class LazyPopup
    extends JMenu {
        private boolean isMenu;
        private boolean created = false;

        private LazyPopup(boolean bl, SystemAction systemAction) {
            Actions.setMenuText((AbstractButton)this, (String)systemAction.getName(), (boolean)bl);
            this.isMenu = bl;
            if (bl) {
                this.createMenuItems();
            }
        }

        static JMenuItem createLazyPopup(boolean bl, SystemAction systemAction) {
            return new LazyPopup(bl, systemAction);
        }

        public JPopupMenu getPopupMenu() {
            if (!this.created) {
                this.createMenuItems();
            }
            return super.getPopupMenu();
        }

        private void createMenuItems() {
            this.created = true;
            this.removeAll();
            for (int i = 0; i < i18nActions.length; ++i) {
                SystemAction systemAction = i18nActions[i];
                if (systemAction == null) {
                    this.addSeparator();
                    continue;
                }
                if (!this.isMenu && systemAction instanceof Presenter.Popup) {
                    this.add(((Presenter.Popup)systemAction).getPopupPresenter());
                    continue;
                }
                if (!this.isMenu || !(systemAction instanceof Presenter.Menu)) continue;
                this.add(((Presenter.Menu)systemAction).getMenuPresenter());
            }
        }
    }
}

