/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NbKeymap
extends Observable
implements Keymap,
Comparator<KeyStroke> {
    String name;
    Keymap parent;
    Map<KeyStroke, Action> bindings;
    Action defaultAction;
    Map<Action, List<KeyStroke>> actions;
    private static List<KeyStroke> context = new ArrayList<KeyStroke>();
    private final Action NO_ACTION = new KeymapAction(null, null);
    private static final Logger LOG = Logger.getLogger(NbKeymap.class.getName());

    public static void resetContext() {
        context.clear();
        StatusDisplayer.getDefault().setStatusText("");
    }

    public static KeyStroke[] getContext() {
        return context.toArray(new KeyStroke[context.size()]);
    }

    public static void shiftContext(KeyStroke keyStroke) {
        context.add(keyStroke);
        StringBuilder stringBuilder = new StringBuilder();
        for (KeyStroke keyStroke2 : context) {
            stringBuilder.append(NbKeymap.getKeyText(keyStroke2)).append(' ');
        }
        StatusDisplayer.getDefault().setStatusText(stringBuilder.toString());
    }

    private static String getKeyText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if ("".equals(string)) {
            return KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return string + "+" + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public Action createMapAction(Keymap keymap, KeyStroke keyStroke) {
        return new KeymapAction(keymap, keyStroke);
    }

    public NbKeymap() {
        this("Default", null);
    }

    NbKeymap(String string, Keymap keymap) {
        this.name = string;
        this.parent = keymap;
        this.bindings = new HashMap<KeyStroke, Action>();
    }

    @Override
    public Action getDefaultAction() {
        LOG.log(Level.FINE, "getDefaultAction");
        if (this.defaultAction != null) {
            return this.defaultAction;
        }
        return this.parent != null ? this.parent.getDefaultAction() : null;
    }

    @Override
    public void setDefaultAction(Action action) {
        LOG.log(Level.FINE, "setDefaultAction {0}", NbKeymap.id(action));
        this.defaultAction = action;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Action getAction(KeyStroke keyStroke) {
        Action action;
        LOG.log(Level.FINE, "getAction {0}", keyStroke);
        KeyStroke[] keyStrokeArray = NbKeymap.getContext();
        Keymap keymap = this;
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            if (keymap == this) {
                action = this.bindings.get(keyStrokeArray[i]);
                if (action == null && this.parent != null) {
                    action = this.parent.getAction(keyStrokeArray[i]);
                }
            } else {
                action = keymap.getAction(keyStrokeArray[i]);
            }
            if (!(action instanceof KeymapAction)) {
                int n = keyStroke.getKeyCode();
                if (n != 17 && n != 18 && n != 65406 && n != 16 && n != 157) {
                    NbKeymap.resetContext();
                }
                return null;
            }
            keymap = ((KeymapAction)action).keymap;
        }
        if (keymap == this) {
            action = this.bindings.get(keyStroke);
            if (action == null && this.parent != null) {
                action = this.parent.getAction(keyStroke);
            }
            return action;
        }
        action = keymap.getAction(keyStroke);
        if (action != null) {
            if (!(action instanceof KeymapAction)) {
                NbKeymap.resetContext();
            }
            return action;
        }
        if (keyStroke.isOnKeyRelease() || keyStroke.getKeyChar() != '\u0000' && keyStroke.getKeyChar() != '\uffff') {
            return null;
        }
        switch (keyStroke.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 157: {
                return null;
            }
        }
        NbKeymap.resetContext();
        return this.NO_ACTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyStroke[] getBoundKeyStrokes() {
        LOG.log(Level.FINE, "getBoundKeyStrokes");
        int n = 0;
        KeyStroke[] keyStrokeArray = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            keyStrokeArray = new KeyStroke[this.bindings.size()];
            for (KeyStroke keyStroke : this.bindings.keySet()) {
                keyStrokeArray[n++] = keyStroke;
            }
        }
        return keyStrokeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Action[] getBoundActions() {
        LOG.log(Level.FINE, "getBoundActions");
        int n = 0;
        Action[] actionArray = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            actionArray = new Action[this.bindings.size()];
            Iterator<Action> iterator = this.bindings.values().iterator();
            while (iterator.hasNext()) {
                actionArray[n++] = iterator.next();
            }
        }
        return actionArray;
    }

    @Override
    public KeyStroke[] getKeyStrokesForAction(Action action) {
        List<KeyStroke> list;
        LOG.log(Level.FINE, "getKeyStrokesForAction {0}", NbKeymap.id(action));
        Map<Action, List<KeyStroke>> map = this.actions;
        if (map == null) {
            map = this.buildReverseMapping();
        }
        if ((list = map.get(action)) != null) {
            return list.toArray(new KeyStroke[list.size()]);
        }
        return new KeyStroke[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Action, List<KeyStroke>> buildReverseMapping() {
        this.actions = new HashMap<Action, List<KeyStroke>>();
        HashMap<Action, List<KeyStroke>> hashMap = this.actions;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            for (Map.Entry<KeyStroke, Action> entry : this.bindings.entrySet()) {
                Action action = entry.getValue();
                KeyStroke keyStroke = entry.getKey();
                List<KeyStroke> list = (List<KeyStroke>)hashMap.get(action);
                if (list == null) {
                    list = Collections.synchronizedList(new ArrayList(1));
                    hashMap.put(action, list);
                }
                list.add(keyStroke);
            }
        }
        return hashMap;
    }

    @Override
    public synchronized boolean isLocallyDefined(KeyStroke keyStroke) {
        LOG.log(Level.FINE, "isLocallyDefined {0}", keyStroke);
        return this.bindings.containsKey(keyStroke);
    }

    private void updateActionAccelerator(final Action action) {
        if (action == null) {
            return;
        }
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                KeyStroke[] keyStrokeArray = NbKeymap.this.getKeyStrokesForAction(action);
                Arrays.sort(keyStrokeArray, NbKeymap.this);
                action.putValue("AcceleratorKey", keyStrokeArray.length > 0 ? keyStrokeArray[0] : null);
            }
        });
    }

    @Override
    public int compare(KeyStroke keyStroke, KeyStroke keyStroke2) {
        return KeyEvent.getKeyText(keyStroke.getKeyCode()).length() - KeyEvent.getKeyText(keyStroke2.getKeyCode()).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        Action action2;
        LOG.log(Level.FINE, "addActionForKeyStroke {0} => {1}", new Object[]{keyStroke, NbKeymap.id(action)});
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            action2 = this.bindings.put(keyStroke, action);
            this.actions = null;
        }
        this.updateActionAccelerator(action);
        this.updateActionAccelerator(action2);
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActionForKeyStrokeMap(Map<KeyStroke, Action> map) {
        HashSet<Action> hashSet = new HashSet<Action>();
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            for (Map.Entry<KeyStroke, Action> entry : map.entrySet()) {
                KeyStroke keyStroke = entry.getKey();
                Action action = entry.getValue();
                hashSet.add(action);
                hashSet.add(this.bindings.put(keyStroke, action));
            }
            this.actions = null;
        }
        for (Action action : hashSet) {
            this.updateActionAccelerator(action);
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeKeyStrokeBinding(KeyStroke keyStroke) {
        Action action;
        LOG.log(Level.FINE, "removeKeyStrokeBinding {0}", keyStroke);
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            action = this.bindings.remove(keyStroke);
            this.actions = null;
        }
        this.updateActionAccelerator(action);
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBindings() {
        HashSet<Action> hashSet;
        LOG.log(Level.FINE, "removeBindings");
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            hashSet = new HashSet<Action>(this.bindings.values());
            this.bindings.clear();
            this.actions = null;
        }
        for (Action action : hashSet) {
            this.updateActionAccelerator(action);
        }
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public Keymap getResolveParent() {
        return this.parent;
    }

    @Override
    public void setResolveParent(Keymap keymap) {
        LOG.log(Level.FINE, "setResolveParent {0}", keymap == null ? null : keymap.getClass());
        this.parent = keymap;
        this.setChanged();
        this.notifyObservers();
    }

    public String toString() {
        return "Keymap[" + this.name + "]" + this.bindings;
    }

    private static Object id(Action action) {
        if (action instanceof SystemAction) {
            return action.getClass();
        }
        return action;
    }

    public static class KeymapAction
    extends AbstractAction {
        private Keymap keymap;
        private KeyStroke stroke;

        public KeymapAction(Keymap keymap, KeyStroke keyStroke) {
            this.keymap = keymap;
            this.stroke = keyStroke;
        }

        public Keymap getSubMap() {
            return this.keymap;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.stroke == null) {
                NbKeymap.resetContext();
            } else {
                NbKeymap.shiftContext(this.stroke);
            }
        }
    }

    public static class SubKeymap
    implements Keymap {
        Object hold;
        Keymap parent;
        Map<KeyStroke, Action> bindings;
        Action defaultAction;

        public SubKeymap(Object object) {
            this.hold = object;
            this.bindings = new HashMap<KeyStroke, Action>();
        }

        public String getName() {
            return "name";
        }

        public void setResolveParent(Keymap keymap) {
            this.parent = keymap;
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.bindings.put(keyStroke, action);
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            return new KeyStroke[0];
        }

        public void setDefaultAction(Action action) {
            this.defaultAction = action;
        }

        public Action getAction(KeyStroke keyStroke) {
            return this.bindings.get(keyStroke);
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            return this.bindings.containsKey(keyStroke);
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.bindings.remove(keyStroke);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Action[] getBoundActions() {
            SubKeymap subKeymap = this;
            synchronized (subKeymap) {
                return this.bindings.values().toArray(new Action[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeyStroke[] getBoundKeyStrokes() {
            SubKeymap subKeymap = this;
            synchronized (subKeymap) {
                return this.bindings.keySet().toArray(new KeyStroke[0]);
            }
        }

        public Action getDefaultAction() {
            return this.defaultAction;
        }

        public void removeBindings() {
            this.bindings.clear();
        }
    }
}

