/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.netbeans.core.NbKeymap;
import org.netbeans.core.startup.StartLog;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class ShortcutsFolder {
    private static final String PROFILES_FOLDER = "Keymaps";
    private static final String SHORTCUTS_FOLDER = "Shortcuts";
    private static final String CURRENT_PROFILE_ATTRIBUTE = "currentKeymap";
    private static ShortcutsFolder shortcutsFolder;
    private Listener listener = new Listener();
    private FileObject profilesFileObject;
    private FileObject shortcutsFileObject;
    private FileObject currentFolder;
    private Logger debug = Logger.getLogger(ShortcutsFolder.class.getName());
    private Collection<DataObject> dataObjects;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initShortcuts() {
        StartLog.logStart((String)"initShortcuts");
        try {
            if (shortcutsFolder != null) {
                return;
            }
            shortcutsFolder = new ShortcutsFolder();
        }
        finally {
            StartLog.logEnd((String)"initShortcuts");
        }
    }

    private ShortcutsFolder() {
        try {
            FileObject fileObject = FileUtil.getConfigRoot();
            this.profilesFileObject = fileObject.getFileObject(PROFILES_FOLDER);
            if (this.profilesFileObject == null) {
                this.profilesFileObject = fileObject.createFolder(PROFILES_FOLDER);
            }
            this.profilesFileObject.addFileChangeListener((FileChangeListener)this.listener);
            this.shortcutsFileObject = fileObject.getFileObject(SHORTCUTS_FOLDER);
            if (this.shortcutsFileObject == null) {
                this.shortcutsFileObject = fileObject.createFolder(SHORTCUTS_FOLDER);
            }
            this.shortcutsFileObject.addFileChangeListener((FileChangeListener)this.listener);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.refresh();
    }

    static void waitFinished() {
        ShortcutsFolder.shortcutsFolder.listener.task.waitFinished();
    }

    private void refresh() {
        NbKeymap nbKeymap = (NbKeymap)Lookup.getDefault().lookup(Keymap.class);
        nbKeymap.removeBindings();
        this.dataObjects = new LinkedList<DataObject>();
        this.readShortcuts(nbKeymap, this.shortcutsFileObject);
        String string = (String)this.profilesFileObject.getAttribute(CURRENT_PROFILE_ATTRIBUTE);
        if (string == null || "".equals(string)) {
            string = "NetBeans";
        }
        if (this.currentFolder != null) {
            this.currentFolder.removeFileChangeListener((FileChangeListener)this.listener);
        }
        this.currentFolder = FileUtil.getConfigFile((String)("Keymaps/" + string));
        if (this.currentFolder == null) {
            try {
                this.currentFolder = this.profilesFileObject.createFolder(string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (this.currentFolder != null) {
            this.readShortcuts(nbKeymap, this.currentFolder);
            this.currentFolder.addFileChangeListener((FileChangeListener)this.listener);
        }
    }

    private void readShortcuts(NbKeymap nbKeymap, FileObject fileObject) {
        this.debug.fine("\nreadShortcuts " + fileObject);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        Enumeration enumeration = dataFolder.children(false);
        while (enumeration.hasMoreElements()) {
            InstanceCookie instanceCookie;
            DataObject dataObject = (DataObject)enumeration.nextElement();
            if (dataObject instanceof DataFolder || (instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class)) == null) continue;
            try {
                Action action = (Action)instanceCookie.instanceCreate();
                String string = dataObject.getName();
                this.debug.fine("  " + string + " : " + action);
                KeyStroke[] keyStrokeArray = Utilities.stringToKeys((String)string);
                if (keyStrokeArray != null) {
                    ShortcutsFolder.addShortcut(nbKeymap, action, keyStrokeArray);
                } else {
                    this.debug.warning("Unrecognized shortcut name from " + dataObject.getPrimaryFile().getPath());
                }
                this.dataObjects.add(dataObject);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(ShortcutsFolder.class.getName()).log(Level.WARNING, "{0} ignored; cannot load class {1}", new Object[]{dataObject.getPrimaryFile().getPath(), instanceCookie.instanceName()});
            }
            catch (Exception exception) {
                Logger.getLogger(ShortcutsFolder.class.getName()).log(Level.WARNING, null, exception);
            }
        }
    }

    private static void addShortcut(NbKeymap nbKeymap, Action action, KeyStroke[] keyStrokeArray) {
        Keymap keymap = nbKeymap;
        int n = keyStrokeArray.length - 1;
        for (int i = 0; i < n; ++i) {
            Action action2 = keymap.getAction(keyStrokeArray[i]);
            if (action2 == null) {
                action2 = nbKeymap.createMapAction(new NbKeymap.SubKeymap(null), keyStrokeArray[i]);
                keymap.addActionForKeyStroke(keyStrokeArray[i], action2);
            }
            if (!(action2 instanceof NbKeymap.KeymapAction)) {
                return;
            }
            keymap = ((NbKeymap.KeymapAction)action2).getSubMap();
        }
        keymap.addActionForKeyStroke(keyStrokeArray[n], action);
    }

    private class Listener
    extends FileChangeAdapter
    implements Runnable {
        private RequestProcessor.Task task = new RequestProcessor("ShortcutsFolder").create((Runnable)this);

        private Listener() {
        }

        public void run() {
            ShortcutsFolder.this.refresh();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.task.schedule(500);
        }

        public void fileChanged(FileEvent fileEvent) {
            this.task.schedule(500);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.task.schedule(500);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            if (fileAttributeEvent.getName() != null && !ShortcutsFolder.CURRENT_PROFILE_ATTRIBUTE.equals(fileAttributeEvent.getName())) {
                return;
            }
            this.task.schedule(500);
        }
    }
}

