/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.dd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.openide.filesystems.FileObject;

public class PersistenceUtils {
    private PersistenceUtils() {
    }

    public static PersistenceUnit[] getPersistenceUnits(FileObject fileObject) throws IOException {
        if (fileObject == null) {
            throw new NullPointerException("The sourceFile parameter cannot be null");
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return new PersistenceUnit[0];
        }
        ArrayList<PersistenceUnit> arrayList = new ArrayList<PersistenceUnit>();
        for (PersistenceScope persistenceScope : PersistenceUtils.getPersistenceScopes(project)) {
            Persistence persistence = PersistenceMetadata.getDefault().getRoot(persistenceScope.getPersistenceXml());
            for (PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
                arrayList.add(persistenceUnit);
            }
        }
        return arrayList.toArray(new PersistenceUnit[arrayList.size()]);
    }

    public static Entity getEntity(String string, EntityMappings entityMappings) {
        if (string == null) {
            throw new NullPointerException("The javaClass parameter cannot be null");
        }
        if (entityMappings == null) {
            throw new NullPointerException("The entityMappings parameter cannot be null");
        }
        for (Entity entity : entityMappings.getEntity()) {
            if (!string.equals(entity.getClass2())) continue;
            return entity;
        }
        return null;
    }

    public static PersistenceScope[] getPersistenceScopes(Project project) {
        if (project == null) {
            throw new NullPointerException("The project parameter cannot be null");
        }
        PersistenceScopes persistenceScopes = PersistenceScopes.getPersistenceScopes((Project)project);
        if (persistenceScopes != null) {
            return persistenceScopes.getPersistenceScopes();
        }
        return new PersistenceScope[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityComparator
    implements Comparator<Entity> {
        private EntityComparator() {
        }

        @Override
        public int compare(Entity entity, Entity entity2) {
            String string = entity.getClass2();
            String string2 = entity2.getClass2();
            if (string == null) {
                return string2 == null ? 0 : -1;
            }
            return string2 == null ? 1 : string.compareTo(string2);
        }
    }
}

