/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.Catalog;
import org.netbeans.modules.j2ee.persistence.editor.completion.db.DBMetaDataProvider;
import org.openide.util.Exceptions;

public class Schema {
    private DBMetaDataProvider provider;
    private Catalog catalog;
    private String name;
    private Set tableNames;
    private ConnectionProvider cp;
    private SchemaElementImpl schemaElementImpl;
    private SchemaElement schemaElement;

    Schema(DBMetaDataProvider dBMetaDataProvider, Catalog catalog, String string) {
        this.provider = dBMetaDataProvider;
        this.catalog = catalog;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public synchronized String[] getTableNames() throws SQLException {
        if (this.tableNames == null) {
            this.tableNames = this.getTableNamesByType("TABLE");
        }
        return this.tableNames.toArray(new String[this.tableNames.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableElement getTable(String string) throws SQLException {
        TableElement tableElement;
        SchemaElement schemaElement;
        Schema schema = this;
        synchronized (schema) {
            schemaElement = this.schemaElement;
        }
        if (schemaElement == null) {
            this.cp = new ConnectionProvider(this.provider.getConnection(), this.provider.getDriverClass());
            this.cp.setSchema(this.name);
            this.schemaElementImpl = new SchemaElementImpl(this.cp);
            try {
                this.schemaElementImpl.setName(DBIdentifier.create((String)"foo"));
            }
            catch (DBException dBException) {
                Exceptions.printStackTrace((Throwable)dBException);
            }
            schemaElement = new SchemaElement((SchemaElement.Impl)this.schemaElementImpl);
            schema = this;
            synchronized (schema) {
                this.schemaElement = schemaElement;
            }
        }
        if ((tableElement = schemaElement.getTable((DBIdentifier)(schema = DBIdentifier.create((String)string)))) == null) {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string);
            LinkedList linkedList2 = new LinkedList();
            this.schemaElementImpl.initTables(this.cp, linkedList, linkedList2, false);
            tableElement = schemaElement.getTable((DBIdentifier)schema);
        }
        return tableElement;
    }

    public synchronized void refresh() {
        this.schemaElement = null;
        this.tableNames = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getTableNamesByType(String string) throws SQLException {
        TreeSet<String> treeSet = new TreeSet<String>();
        ResultSet resultSet = this.provider.getMetaData().getTables(this.catalog.getName(), this.name, "%", new String[]{string});
        try {
            while (resultSet.next()) {
                String string2 = resultSet.getString("TABLE_NAME");
                treeSet.add(string2);
            }
        }
        finally {
            resultSet.close();
        }
        return treeSet;
    }

    public String toString() {
        return "Schema[catalog=" + this.catalog + ",name='" + this.name + "']";
    }
}

