/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectedTables {
    private final PersistenceGenerator persistenceGen;
    private final Map<Table, String> table2ClassName = new HashMap<Table, String>();
    private final Map<Table, Set<Problem>> table2Problems = new TreeMap<Table, Set<Problem>>();
    private final ChangeListener tableClosureListener = new TableClosureListener();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private TableClosure tableClosure;
    private SourceGroup location;
    private String packageName;
    private FileObject targetFolder;
    private Set<Table> validatedTables = Collections.emptySet();

    public SelectedTables(PersistenceGenerator persistenceGenerator, TableClosure tableClosure, SourceGroup sourceGroup, String string) throws IOException {
        assert (persistenceGenerator != null);
        this.persistenceGen = persistenceGenerator;
        this.setTableClosureAndTargetFolder(tableClosure, sourceGroup, string);
    }

    public void setTableClosureAndTargetFolder(TableClosure tableClosure, SourceGroup sourceGroup, String string) throws IOException {
        assert (tableClosure != null);
        boolean bl = this.changeTableClosure(tableClosure);
        boolean bl2 = this.changeTargetFolder(sourceGroup, string);
        if (bl || bl2) {
            this.revalidateTables();
        }
    }

    public void setTargetFolder(SourceGroup sourceGroup, String string) throws IOException {
        if (this.changeTargetFolder(sourceGroup, string)) {
            this.revalidateTables();
        }
    }

    private boolean changeTableClosure(TableClosure tableClosure) {
        if (!tableClosure.equals(this.tableClosure)) {
            if (this.tableClosure != null) {
                this.tableClosure.removeChangeListener(this.tableClosureListener);
            }
            this.tableClosure = tableClosure;
            this.table2ClassName.clear();
            this.tableClosure.addChangeListener(this.tableClosureListener);
            return true;
        }
        return false;
    }

    private boolean changeTargetFolder(SourceGroup sourceGroup, String string) throws IOException {
        if (!Utilities.compareObjects((Object)sourceGroup, (Object)this.location) || !Utilities.compareObjects((Object)string, (Object)this.packageName)) {
            this.location = sourceGroup;
            this.packageName = string;
            this.targetFolder = sourceGroup != null && string != null ? SourceGroups.getFolderForPackage((SourceGroup)sourceGroup, (String)string, (boolean)false) : null;
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private void revalidateTables() {
        this.validatedTables = Collections.emptySet();
        this.table2Problems.clear();
        this.validateTables();
    }

    private void validateTables() {
        HashSet<Table> hashSet = new HashSet<Table>(this.tableClosure.getSelectedTables());
        hashSet.removeAll(this.validatedTables);
        HashSet<Table> hashSet2 = new HashSet<Table>(this.validatedTables);
        hashSet2.removeAll(this.tableClosure.getSelectedTables());
        for (Table table : hashSet2) {
            this.table2Problems.remove(table);
        }
        for (Table table : hashSet) {
            this.putProblems(table, this.validateClassName(this.getClassName(table)));
        }
        this.validatedTables = new HashSet<Table>(this.tableClosure.getSelectedTables());
        this.changeSupport.fireChange();
    }

    public List<Table> getTables() {
        ArrayList<Table> arrayList = new ArrayList<Table>(this.tableClosure.getSelectedTables());
        Collections.sort(arrayList);
        return arrayList;
    }

    public String getClassName(Table table) {
        assert (table != null);
        String string = this.table2ClassName.get(table);
        if (string == null) {
            string = EntityMember.makeClassName(table.getName());
            string = this.persistenceGen.generateEntityName(string);
        }
        return string;
    }

    public void setClassName(Table table, String string) {
        assert (table != null);
        assert (string != null);
        this.table2ClassName.put(table, string);
        this.putProblems(table, this.validateClassName(string));
        this.changeSupport.fireChange();
    }

    private void putProblems(Table table, Set<Problem> set) {
        if (set.isEmpty()) {
            this.table2Problems.remove(table);
        } else {
            this.table2Problems.put(table, set);
        }
    }

    private Set<Problem> validateClassName(String string) {
        EnumSet<Problem> enumSet = EnumSet.noneOf(Problem.class);
        if (!Utilities.isJavaIdentifier((String)string)) {
            enumSet.add(Problem.NO_JAVA_IDENTIFIER);
        }
        if (JavaPersistenceQLKeywords.isKeyword(string)) {
            enumSet.add(Problem.JPA_QL_IDENTIFIER);
        }
        if (this.targetFolder != null && this.targetFolder.getFileObject(string, "java") != null) {
            enumSet.add(Problem.ALREADY_EXISTS);
        }
        return enumSet;
    }

    public void ensureUniqueClassNames() {
        Set<Table> set = this.tableClosure.getSelectedTables();
        if (this.targetFolder != null) {
            for (Table table : set) {
                String string = this.getClassName(table);
                boolean bl = this.targetFolder.getFileObject(string, "java") != null;
                if (!bl) continue;
                this.setClassName(table, string + '1');
            }
        }
    }

    public String getFirstProblemDisplayName() {
        Map.Entry<Table, Set<Problem>> entry = this.getFirstProblemEntry();
        if (entry == null) {
            return null;
        }
        return this.getProblemDisplayNameForTable(entry.getKey(), entry.getValue());
    }

    private Map.Entry<Table, Set<Problem>> getFirstProblemEntry() {
        Set<Map.Entry<Table, Set<Problem>>> set = this.table2Problems.entrySet();
        if (set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    private String getProblemDisplayNameForTable(Table table, Set<Problem> set) {
        Problem problem = set.iterator().next();
        return SelectedTables.getProblemDisplayName(problem, this.getClassName(table));
    }

    String getProblemDisplayNameForTable(Table table) {
        Set<Problem> set = this.table2Problems.get(table);
        return set != null ? this.getProblemDisplayNameForTable(table, set) : null;
    }

    boolean hasProblem(Table table) {
        return this.table2Problems.containsKey(table);
    }

    Problem getFirstProblem() {
        Map.Entry<Table, Set<Problem>> entry = this.getFirstProblemEntry();
        if (entry == null) {
            return null;
        }
        Set<Problem> set = entry.getValue();
        return set.iterator().next();
    }

    private static String getProblemDisplayName(Problem problem, String string) {
        switch (problem) {
            case NO_JAVA_IDENTIFIER: {
                return NbBundle.getMessage(SelectedTables.class, (String)"ERR_NoJavaIdentifier", (Object)string);
            }
            case JPA_QL_IDENTIFIER: {
                return NbBundle.getMessage(SelectedTables.class, (String)"ERR_ReservedQLKeyword", (Object)string);
            }
            case ALREADY_EXISTS: {
                return NbBundle.getMessage(SelectedTables.class, (String)"ERR_AlreadyExists", (Object)string);
            }
        }
        assert (false) : (Object)((Object)problem) + " should be handled in getProblemDisplayName()";
        return null;
    }

    private final class TableClosureListener
    implements ChangeListener {
        private TableClosureListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SelectedTables.this.validateTables();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Problem {
        NO_JAVA_IDENTIFIER,
        JPA_QL_IDENTIFIER,
        ALREADY_EXISTS;

    }
}

