/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class ExecSupport {
    private static Logger LOGGER = Logger.getLogger(ExecSupport.class.getName());
    private OutputCopier[] copyMakers;

    public InputOutput displayProcessOutputs(final Process process, String string) throws IOException, InterruptedException {
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        try {
            inputOutput.getOut().reset();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
        }
        inputOutput.select();
        this.copyMakers = new OutputCopier[3];
        this.copyMakers[0] = new OutputCopier(new InputStreamReader(process.getInputStream()), (Writer)inputOutput.getOut(), true);
        this.copyMakers[0].start();
        this.copyMakers[1] = new OutputCopier(new InputStreamReader(process.getErrorStream()), (Writer)inputOutput.getErr(), true);
        this.copyMakers[1].start();
        this.copyMakers[2] = new OutputCopier(inputOutput.getIn(), new OutputStreamWriter(process.getOutputStream()), true);
        this.copyMakers[2].start();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    process.waitFor();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    try {
                        ExecSupport.this.copyMakers[0].interrupt();
                        ExecSupport.this.copyMakers[1].interrupt();
                        ExecSupport.this.copyMakers[2].interrupt();
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.INFO, null, exception);
                    }
                }
            }
        }.start();
        return inputOutput;
    }

    public static class OutputCopier
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;
        private boolean done = false;

        public OutputCopier(Reader reader, Writer writer, boolean bl) {
            this.os = writer;
            this.is = reader;
            this.autoflush = bl;
        }

        public void run() {
            char[] cArray = new char[256];
            try {
                int n;
                while ((n = this.read(this.is, cArray, 0, 256)) > 0) {
                    if (this.os == null) continue;
                    this.os.write(cArray, 0, n);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, null, iOException);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.FINE, null, interruptedException);
            }
        }

        public void interrupt() {
            super.interrupt();
            this.done = true;
        }

        private int read(Reader reader, char[] cArray, int n, int n2) throws InterruptedException, IOException {
            while (!reader.ready() && !this.done) {
                OutputCopier.sleep(100L);
            }
            return reader.read(cArray, n, n2);
        }
    }
}

