/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.cnd.debugger.gdb.CallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentThreadAnnotationListener
extends DebuggerManagerAdapter {
    private GdbDebugger currentDebugger;
    private final Collection<Object> stackAnnotations = new LinkedList<Object>();
    private final Set<String> annotatedAddresses = new HashSet<String>();
    private final RequestProcessor rp = new RequestProcessor("Debugger Thread Annotation Refresher");
    private RequestProcessor.Task taskRemove;
    private RequestProcessor.Task taskAnnotate;
    private List<CallStackFrame> stackToAnnotate;

    public CurrentThreadAnnotationListener() {
        this.updateCurrentDebugger();
        assert (this.currentDebugger == null || !Boolean.getBoolean("gdb.assertions.enabled"));
    }

    public String[] getProperties() {
        return new String[]{"currentEngine"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("currentEngine")) {
            this.updateCurrentDebugger();
            this.annotate(false);
        } else if (propertyChangeEvent.getPropertyName().equals("currentThread")) {
            this.annotate(false);
        } else if (propertyChangeEvent.getPropertyName().equals("currentCallStackFrame")) {
            this.annotate(false);
        } else if (propertyChangeEvent.getPropertyName().equals("state")) {
            this.annotate(false);
        } else if (propertyChangeEvent.getPropertyName().equals("dis_update")) {
            this.annotate((Boolean)propertyChangeEvent.getOldValue());
        }
    }

    private void updateCurrentDebugger() {
        GdbDebugger gdbDebugger = GdbDebugger.getGdbDebugger();
        if (this.currentDebugger == gdbDebugger) {
            return;
        }
        if (this.currentDebugger != null) {
            this.currentDebugger.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (gdbDebugger != null) {
            gdbDebugger.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.currentDebugger = gdbDebugger;
    }

    private void annotate(boolean bl) {
        if (this.currentDebugger == null) {
            return;
        }
        if (!this.currentDebugger.isStopped()) {
            this.removeAnnotations();
            return;
        }
        this.currentDebugger.showCurrentSource(bl);
        this.annotateCallStack(this.currentDebugger.getCallStack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotations() {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove == null) {
                this.taskRemove = this.rp.create(new Runnable(){

                    public void run() {
                        CurrentThreadAnnotationListener.this.clearAnnotations();
                    }
                });
            }
        }
        this.taskRemove.schedule(500);
    }

    private void clearAnnotations() {
        for (Object object : this.stackAnnotations) {
            EditorContextBridge.removeAnnotation(object);
        }
        this.stackAnnotations.clear();
        this.annotatedAddresses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotateCallStack(List<CallStackFrame> list) {
        RequestProcessor requestProcessor = this.rp;
        synchronized (requestProcessor) {
            if (this.taskRemove != null) {
                this.taskRemove.cancel();
            }
            this.stackToAnnotate = list;
            if (this.taskAnnotate == null) {
                this.taskAnnotate = this.rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ArrayList arrayList;
                        Object object = CurrentThreadAnnotationListener.this.rp;
                        synchronized (object) {
                            if (CurrentThreadAnnotationListener.this.stackToAnnotate == null) {
                                return;
                            }
                            arrayList = new ArrayList(CurrentThreadAnnotationListener.this.stackToAnnotate);
                            CurrentThreadAnnotationListener.this.stackToAnnotate = null;
                        }
                        CurrentThreadAnnotationListener.this.clearAnnotations();
                        object = "CurrentPC";
                        for (CallStackFrame callStackFrame : arrayList) {
                            if (!CurrentThreadAnnotationListener.this.annotatedAddresses.add(callStackFrame.getAddr())) continue;
                            Object object2 = EditorContextBridge.annotate(callStackFrame, (String)object);
                            if (object2 != null) {
                                CurrentThreadAnnotationListener.this.stackAnnotations.add(object2);
                            }
                            if ((object2 = EditorContextBridge.annotateDis(callStackFrame, (String)object)) != null) {
                                CurrentThreadAnnotationListener.this.stackAnnotations.add(object2);
                            }
                            object = "CallSite";
                        }
                    }
                });
            }
        }
        this.taskAnnotate.schedule(50);
    }
}

