/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.ValuePresenter;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        GdbDebugger gdbDebugger = GdbDebugger.getGdbDebugger();
        if (gdbDebugger == null) {
            return null;
        }
        Line.Part part = (Line.Part)this.getAttachedAnnotatable();
        if (part == null) {
            return null;
        }
        Line line = part.getLine();
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        this.lp = part;
        this.ec = editorCookie;
        RequestProcessor.getDefault().post((Runnable)this);
        return null;
    }

    public void run() {
        StyledDocument styledDocument;
        if (this.lp == null || this.ec == null) {
            return;
        }
        try {
            styledDocument = this.ec.openDocument();
        }
        catch (IOException iOException) {
            return;
        }
        JEditorPane jEditorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (jEditorPane == null) {
            return;
        }
        int n = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn();
        String string = ToolTipAnnotation.getIdentifier(styledDocument, jEditorPane, n);
        if (string == null) {
            return;
        }
        GdbDebugger gdbDebugger = GdbDebugger.getGdbDebugger();
        if (gdbDebugger == null) {
            return;
        }
        if (!gdbDebugger.isStopped()) {
            return;
        }
        string = GdbWatchVariable.expandMacro(gdbDebugger, string);
        String string2 = gdbDebugger.requestWhatis(string);
        String string3 = gdbDebugger.evaluate(string);
        String string4 = ValuePresenter.getValue(string2, string3);
        this.firePropertyChange("shortDescription", null, string4);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n5 = element.getStartOffset();
            int n6 = element.getEndOffset() - n5;
            string = styledDocument.getText(n5, n6);
            int n7 = n3;
            while (n7 > 0) {
                char c;
                n4 = string.charAt(n7 - 1);
                if (n7 > 1 && ((c = string.charAt(n7 - 2)) == '-' && n4 == 62 || c == ':' && n4 == 58)) {
                    n7 -= 2;
                    continue;
                }
                if (!Character.isJavaIdentifierPart((char)n4) && n4 != 46) break;
                --n7;
            }
            for (n4 = n3; n4 < n6 && Character.isJavaIdentifierPart(string.charAt(n4)); ++n4) {
            }
            if (n7 == n4) {
                return null;
            }
            String string2 = string.substring(n7, n4);
            if (CndLexerUtilities.isKeyword((String)string2)) {
                return null;
            }
            return string2;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

