/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.attach;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.debugger.gdb.actions.AttachTableColumn;
import org.netbeans.modules.cnd.debugger.gdb.attach.ProcessListReader;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessList {
    private PTYPE ptype = PTYPE.UNINITIALIZED;
    private final List<String> argsSimple = new ArrayList<String>();

    protected ProcessList() {
        if (Utilities.isWindows()) {
            File file = new File(CompilerSetManager.getCygwinBase() + "/bin", "ps.exe");
            if (file.exists()) {
                this.argsSimple.add(file.getAbsolutePath());
                this.ptype = PTYPE.WINDOWS;
            } else {
                file = new File(CompilerSetManager.getMSysBase() + "/bin", "ps.exe");
                if (file.exists()) {
                    this.argsSimple.add(file.getAbsolutePath());
                    this.ptype = PTYPE.WINDOWS;
                } else {
                    this.ptype = PTYPE.NONE;
                }
            }
        } else if (new File("/bin/ps").exists()) {
            this.argsSimple.add("/bin/ps");
            this.argsSimple.add("-a");
            this.argsSimple.add("-o");
            if (Utilities.getOperatingSystem() == 4096) {
                this.argsSimple.add("user,pid,ppid,stime,time,command");
            } else {
                this.argsSimple.add("user,pid,ppid,stime,time,args");
            }
            this.ptype = PTYPE.STD;
        } else if (new File("/usr/bin/ps").exists()) {
            this.argsSimple.add("/usr/bin/ps");
            this.argsSimple.add("-a");
            this.argsSimple.add("-o");
            this.argsSimple.add("user,pid,ppid,stime,time,args");
            this.ptype = PTYPE.STD;
        } else {
            this.ptype = PTYPE.NONE;
        }
    }

    private void request(final ProcessListReader processListReader, final List<String> list) {
        if (!this.argsSimple.isEmpty()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        String string;
                        ProcessBuilder processBuilder = new ProcessBuilder(list);
                        processBuilder.redirectErrorStream(true);
                        Process process = processBuilder.start();
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        bufferedReader.readLine();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        while ((string = bufferedReader.readLine()) != null) {
                            arrayList.add(string);
                        }
                        processListReader.processListCallback(arrayList);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    void requestSimple(ProcessListReader processListReader) {
        this.request(processListReader, this.argsSimple);
    }

    void requestFull(ProcessListReader processListReader) {
        ArrayList<String> arrayList = new ArrayList<String>(this.argsSimple);
        if (this.ptype == PTYPE.WINDOWS) {
            arrayList.add("-W");
        } else if (this.ptype == PTYPE.STD) {
            arrayList.add("-A");
        }
        this.request(processListReader, arrayList);
    }

    protected PTYPE getPType() {
        return this.ptype;
    }

    protected boolean isStd() {
        return this.ptype == PTYPE.STD;
    }

    protected boolean isWindowsPsFound() {
        return this.ptype == PTYPE.WINDOWS;
    }

    protected List<AttachTableColumn> getColumnHeaders() {
        ArrayList<AttachTableColumn> arrayList = new ArrayList<AttachTableColumn>();
        if (this.ptype == PTYPE.STD) {
            arrayList.add(new AttachTableColumn("user", NbBundle.getMessage(ProcessList.class, (String)"HDR_USER")));
            arrayList.add(new AttachTableColumn("pid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PID")));
            arrayList.add(new AttachTableColumn("ppid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PPID")));
            arrayList.add(new AttachTableColumn("stime", NbBundle.getMessage(ProcessList.class, (String)"HDR_STIME")));
            arrayList.add(new AttachTableColumn("time", NbBundle.getMessage(ProcessList.class, (String)"HDR_TIME")));
            arrayList.add(new AttachTableColumn("args", NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS")));
        } else if (this.ptype == PTYPE.WINDOWS) {
            arrayList.add(new AttachTableColumn("uid", NbBundle.getMessage(ProcessList.class, (String)"HDR_UID")));
            arrayList.add(new AttachTableColumn("winpid", NbBundle.getMessage(ProcessList.class, (String)"HDR_WINPID")));
            arrayList.add(new AttachTableColumn("pid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PID")));
            arrayList.add(new AttachTableColumn("ppid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PPID")));
            arrayList.add(new AttachTableColumn("stime", NbBundle.getMessage(ProcessList.class, (String)"HDR_STIME")));
            arrayList.add(new AttachTableColumn("args", NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS")));
        }
        return arrayList;
    }

    protected String getArgsHeader() {
        return NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PTYPE {
        UNINITIALIZED,
        NONE,
        STD,
        WINDOWS;

    }
}

