/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.DebuggerBreakpointAnnotation;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineTranslations;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class BreakpointAnnotationProvider
implements AnnotationProvider,
DebuggerManagerListener {
    private final Map<GdbBreakpoint, Set<Annotation>> breakpointToAnnotations = new HashMap<GdbBreakpoint, Set<Annotation>>();
    private final Set<FileObject> annotatedFiles = new WeakSet();
    private Set<PropertyChangeListener> dataObjectListeners;
    private boolean attachManagerListener = true;
    private final Logger log = Logger.getLogger("gdb.breakpoint.annotations");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Line.Set set, Lookup lookup) {
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject != null) {
            DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
            if (dataObject != null) {
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("primaryFile".equals(propertyChangeEvent.getPropertyName())) {
                            DataObject dataObject = (DataObject)propertyChangeEvent.getSource();
                            FileObject fileObject = dataObject.getPrimaryFile();
                            BreakpointAnnotationProvider.this.annotate(fileObject);
                        }
                    }
                };
                dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)propertyChangeListener, (Object)dataObject));
                BreakpointAnnotationProvider breakpointAnnotationProvider = this;
                synchronized (breakpointAnnotationProvider) {
                    if (this.dataObjectListeners == null) {
                        this.dataObjectListeners = new HashSet<PropertyChangeListener>();
                    }
                    this.dataObjectListeners.add(propertyChangeListener);
                }
            }
            this.annotate(fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(FileObject fileObject) {
        Map<GdbBreakpoint, Set<Annotation>> map = this.breakpointToAnnotations;
        synchronized (map) {
            if (this.annotatedFiles.contains(fileObject)) {
                this.log.fine("BreakpointAnnotationProvider.annotate: " + fileObject.getNameExt() + " is already annotated");
                return;
            }
            Set<GdbBreakpoint> set = this.breakpointToAnnotations.keySet();
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (!BreakpointAnnotationProvider.isAnnotatable(breakpoint)) continue;
                GdbBreakpoint gdbBreakpoint = (GdbBreakpoint)breakpoint;
                if (!set.contains((Object)gdbBreakpoint)) {
                    gdbBreakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                    this.breakpointToAnnotations.put(gdbBreakpoint, (Set<Annotation>)new WeakSet());
                    if (gdbBreakpoint instanceof LineBreakpoint) {
                        LineBreakpoint lineBreakpoint = (LineBreakpoint)gdbBreakpoint;
                        LineTranslations.getTranslations().registerForLineUpdates(lineBreakpoint);
                    }
                }
                this.addAnnotationTo(gdbBreakpoint, fileObject);
            }
            this.annotatedFiles.add(fileObject);
        }
        if (this.attachManagerListener) {
            this.attachManagerListener = false;
            DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)((Object)this), (Object)DebuggerManager.getDebuggerManager()));
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            GdbBreakpoint gdbBreakpoint = (GdbBreakpoint)breakpoint;
            this.log.fine("BreakpointAnnotationProvider.breakpointAdded: " + gdbBreakpoint.getPath() + ":" + gdbBreakpoint.getLineNumber());
            gdbBreakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            RequestProcessor.getDefault().post((Runnable)new AnnotationRefresh(gdbBreakpoint, false, true));
            if (gdbBreakpoint instanceof LineBreakpoint) {
                LineBreakpoint lineBreakpoint = (LineBreakpoint)gdbBreakpoint;
                LineTranslations.getTranslations().registerForLineUpdates(lineBreakpoint);
            }
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            GdbBreakpoint gdbBreakpoint = (GdbBreakpoint)breakpoint;
            this.log.fine("BreakpointAnnotationProvider.breakpointRemoved: " + gdbBreakpoint.getPath() + ":" + gdbBreakpoint.getLineNumber());
            gdbBreakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            RequestProcessor.getDefault().post((Runnable)new AnnotationRefresh(gdbBreakpoint, true, false));
            if (gdbBreakpoint instanceof LineBreakpoint) {
                LineBreakpoint lineBreakpoint = (LineBreakpoint)gdbBreakpoint;
                LineTranslations.getTranslations().unregisterFromLineUpdates(lineBreakpoint);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (!("enabled".equals(string) || "validity".equals(string) || "condition".equals(string) || "skipCount".equals(string) || "url".equals(string) || "functionName".equals(string) || "lineNumber".equals(string) || "address".equals(string) || "refresh".equals(string))) {
            return;
        }
        GdbBreakpoint gdbBreakpoint = (GdbBreakpoint)((Object)propertyChangeEvent.getSource());
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
        boolean bl = false;
        for (Breakpoint breakpoint : breakpointArray) {
            if (gdbBreakpoint != breakpoint) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        RequestProcessor.getDefault().post((Runnable)new AnnotationRefresh(gdbBreakpoint, true, true));
    }

    private static boolean isAnnotatable(Breakpoint breakpoint) {
        return (breakpoint instanceof LineBreakpoint || breakpoint instanceof FunctionBreakpoint || breakpoint instanceof AddressBreakpoint) && !((GdbBreakpoint)breakpoint).isHidden();
    }

    private static String getAnnotationType(GdbBreakpoint gdbBreakpoint, boolean bl) {
        String string;
        boolean bl2;
        boolean bl3 = bl2 = gdbBreakpoint.getValidity() == Breakpoint.VALIDITY.INVALID;
        if (gdbBreakpoint instanceof LineBreakpoint) {
            string = gdbBreakpoint.isEnabled() ? (bl ? "CondBreakpoint" : "Breakpoint") : (bl ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        } else if (gdbBreakpoint instanceof FunctionBreakpoint) {
            string = gdbBreakpoint.isEnabled() ? "FunctionBreakpoint" : "DisabledFunctionBreakpoint";
        } else if (gdbBreakpoint instanceof AddressBreakpoint) {
            string = gdbBreakpoint.isEnabled() ? "AddressBreakpoint" : "DisabledAddressBreakpoint";
        } else {
            throw new IllegalStateException(((Object)((Object)gdbBreakpoint)).toString());
        }
        if (bl2 && gdbBreakpoint.isEnabled()) {
            string = string + "_broken";
        }
        return string;
    }

    private static int[] getAnnotationLines(GdbBreakpoint gdbBreakpoint, FileObject fileObject) {
        if (gdbBreakpoint instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)gdbBreakpoint;
            try {
                if (fileObject.getURL().equals(new URL(lineBreakpoint.getURL()))) {
                    return new int[]{lineBreakpoint.getLineNumber()};
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            return null;
        }
        if (gdbBreakpoint instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)gdbBreakpoint;
            String string = functionBreakpoint.getURL();
            if (string.length() > 0) {
                try {
                    if (fileObject.getURL().equals(new URL(string))) {
                        return new int[]{functionBreakpoint.getLineNumber()};
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
            return null;
        }
        if (gdbBreakpoint instanceof AddressBreakpoint) {
            if (fileObject != Disassembly.getFileObject()) {
                return null;
            }
            Disassembly disassembly = Disassembly.getCurrent();
            if (disassembly != null) {
                AddressBreakpoint addressBreakpoint = (AddressBreakpoint)gdbBreakpoint;
                return new int[]{disassembly.getAddressLine(addressBreakpoint.getAddress())};
            }
            return null;
        }
        throw new IllegalStateException(((Object)((Object)gdbBreakpoint)).toString());
    }

    private void addAnnotationTo(GdbBreakpoint gdbBreakpoint, FileObject fileObject) {
        DataObject dataObject;
        int[] nArray = BreakpointAnnotationProvider.getAnnotationLines(gdbBreakpoint, fileObject);
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.log.fine("BreakpointAnnotationProvider.addAnnotationTo: " + gdbBreakpoint.getPath() + ":" + gdbBreakpoint.getLineNumber());
        String string = gdbBreakpoint.getCondition();
        boolean bl = string != null && string.trim().length() > 0;
        String string2 = BreakpointAnnotationProvider.getAnnotationType(gdbBreakpoint, bl);
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return;
        }
        ArrayList<DebuggerBreakpointAnnotation> arrayList = new ArrayList<DebuggerBreakpointAnnotation>();
        for (int n : nArray) {
            try {
                Line line = lineCookie.getLineSet().getCurrent(n - 1);
                DebuggerBreakpointAnnotation debuggerBreakpointAnnotation = new DebuggerBreakpointAnnotation(string2, line, gdbBreakpoint);
                arrayList.add(debuggerBreakpointAnnotation);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (arrayList.isEmpty()) {
            return;
        }
        Object object = this.breakpointToAnnotations.get((Object)gdbBreakpoint);
        if (object == null) {
            this.breakpointToAnnotations.put(gdbBreakpoint, (Set<Annotation>)new WeakSet(arrayList));
        } else {
            object.addAll(arrayList);
            this.breakpointToAnnotations.put(gdbBreakpoint, (Set<Annotation>)object);
        }
    }

    private void removeAnnotations(GdbBreakpoint gdbBreakpoint) {
        Set<Annotation> set = this.breakpointToAnnotations.remove((Object)gdbBreakpoint);
        if (set == null) {
            return;
        }
        for (Annotation annotation : set) {
            annotation.detach();
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }

    private final class AnnotationRefresh
    implements Runnable {
        private GdbBreakpoint b;
        private boolean remove;
        private boolean add;

        public AnnotationRefresh(GdbBreakpoint gdbBreakpoint, boolean bl, boolean bl2) {
            this.b = gdbBreakpoint;
            this.remove = bl;
            this.add = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = BreakpointAnnotationProvider.this.breakpointToAnnotations;
            synchronized (map) {
                if (this.remove) {
                    BreakpointAnnotationProvider.this.removeAnnotations(this.b);
                    if (!this.add) {
                        BreakpointAnnotationProvider.this.breakpointToAnnotations.remove((Object)this.b);
                    }
                }
                if (this.add) {
                    BreakpointAnnotationProvider.this.breakpointToAnnotations.put(this.b, new WeakSet());
                    for (FileObject fileObject : BreakpointAnnotationProvider.this.annotatedFiles) {
                        BreakpointAnnotationProvider.this.addAnnotationTo(this.b, fileObject);
                    }
                }
            }
        }
    }
}

