/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.gdb.event.GdbBreakpointEvent;
import org.netbeans.modules.cnd.debugger.gdb.event.GdbBreakpointListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public abstract class GdbBreakpoint
extends Breakpoint {
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_THREAD_ID = "threadID";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PRINT_TEXT = "printText";
    public static final String PROP_BREAKPOINT_STATE = "breakpointState";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_FUNCTION_NAME = "functionName";
    public static final String PROP_URL = "url";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_SKIP_COUNT = "skipCount";
    public static final int SUSPEND_NONE = 0;
    public static final int SUSPEND_THREAD = 1;
    public static final int SUSPEND_ALL = 2;
    private int lineNumber;
    private boolean enabled = true;
    private boolean hidden = false;
    private boolean temporary = false;
    private int suspend = 2;
    private String threadID = "1";
    private String printText;
    private final Set<GdbBreakpointListener> breakpointListeners = new CopyOnWriteArraySet<GdbBreakpointListener>();
    private String condition = "";
    private int skipCount = 0;
    private String url = "";
    private String path = "";

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.setLineNumber(n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLineNumber(int n, boolean bl) {
        int n2;
        GdbBreakpoint gdbBreakpoint = this;
        synchronized (gdbBreakpoint) {
            if (n == this.lineNumber) {
                return;
            }
            n2 = this.lineNumber;
            this.lineNumber = n;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, bl ? null : Integer.valueOf(n2), n);
    }

    public void setLineNumberNoOld(int n) {
        this.setLineNumber(n, true);
    }

    protected void setValid() {
        this.setValidity(Breakpoint.VALIDITY.VALID, null);
    }

    protected void setInvalid(String string) {
        this.setValidity(Breakpoint.VALIDITY.INVALID, string);
    }

    public String getPath() {
        return this.path;
    }

    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String string) {
        GdbBreakpoint gdbBreakpoint = this;
        synchronized (gdbBreakpoint) {
            block12: {
                if (string != null && this.url != null && string.equals(this.url)) {
                    return;
                }
                if (!(string = string.replace(" ", "%20")).startsWith("file:/")) {
                    string = string.charAt(0) == '/' ? "file:" + string : "file:/" + string;
                }
                string = string.replace("\\", "/");
                try {
                    assert (string != null || !Boolean.getBoolean("gdb.assertions.enabled"));
                    FileObject fileObject = URLMapper.findFileObject((URL)new URL(string));
                    if (fileObject != null) {
                        this.path = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
                        if (Utilities.isWindows()) {
                            this.path = this.path.replace("\\", "/");
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    assert (!Boolean.getBoolean("gdb.assertions.enabled"));
                    return;
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || !Boolean.getBoolean("gdb.assertions.enabled")) break block12;
                    throw new AssertionError();
                }
            }
            String string2 = this.url;
            this.url = string;
            this.firePropertyChange(PROP_URL, string2, string);
        }
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String string) {
        String string2;
        GdbBreakpoint gdbBreakpoint = this;
        synchronized (gdbBreakpoint) {
            if (string == null) {
                string = "";
            }
            if ((string = string.trim()).equals(this.condition) || string != null && this.condition != null && this.condition.equals(string)) {
                return;
            }
            string2 = this.condition;
            this.condition = string;
        }
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public void setSkipCount(int n) {
        int n2 = this.skipCount;
        if (n != n2) {
            this.skipCount = n;
            this.firePropertyChange(PROP_SKIP_COUNT, n2, n);
        }
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int n) {
        this.setSuspend(n, "");
    }

    public void setSuspend(int n, String string) {
        if (n == this.suspend && this.threadID.equals(string)) {
            return;
        }
        if (string.length() == 0) {
            string = this.threadID;
        }
        String string2 = Integer.toString(this.suspend) + ':' + this.threadID;
        String string3 = Integer.toString(n) + ':' + string;
        this.suspend = n;
        this.threadID = string;
        this.firePropertyChange(PROP_SUSPEND, string2, string3);
    }

    public String getThreadID() {
        return this.threadID;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        if (bl == this.hidden) {
            return;
        }
        boolean bl2 = this.hidden;
        this.hidden = bl;
        this.firePropertyChange(PROP_HIDDEN, bl2, bl);
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary() {
        this.temporary = true;
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String string) {
        if (string == null || string.equals(this.printText)) {
            return;
        }
        String string2 = this.printText;
        this.printText = string;
        this.firePropertyChange(PROP_PRINT_TEXT, string2, string);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    public synchronized void addGdbBreakpointListener(GdbBreakpointListener gdbBreakpointListener) {
        this.breakpointListeners.add(gdbBreakpointListener);
    }

    public synchronized void removeGdbBreakpointListener(GdbBreakpointListener gdbBreakpointListener) {
        this.breakpointListeners.remove(gdbBreakpointListener);
    }

    public void fireGdbBreakpointChange(GdbBreakpointEvent gdbBreakpointEvent) {
        for (GdbBreakpointListener gdbBreakpointListener : this.breakpointListeners) {
            gdbBreakpointListener.breakpointReached(gdbBreakpointEvent);
        }
    }
}

