/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.WeakListeners;

public class LineBreakpoint
extends GdbBreakpoint {
    public static LineBreakpoint create(String string, int n) {
        LineBreakpointComparable lineBreakpointComparable = new LineBreakpointComparable(string);
        lineBreakpointComparable.setLineNumber(n);
        return lineBreakpointComparable;
    }

    public static LineBreakpoint create() {
        return new LineBreakpointComparable();
    }

    public String toString() {
        return "LineBreakpoint " + this.getURL() + " : " + this.getLineNumber();
    }

    private static class LineBreakpointComparable
    extends LineBreakpoint
    implements Comparable,
    FileChangeListener,
    ChangeListener {
        private FileObject fo;

        private LineBreakpointComparable() {
        }

        private LineBreakpointComparable(String string) {
            this.setURL(string);
            try {
                this.fo = URLMapper.findFileObject((URL)new URL(this.getURL()));
                if (this.fo != null) {
                    this.fo.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)this.fo));
                }
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
        }

        public int compareTo(Object object) {
            if (object instanceof LineBreakpointComparable) {
                LineBreakpointComparable lineBreakpointComparable = this;
                LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)object);
                int n = lineBreakpointComparable.getURL().compareTo(lineBreakpoint.getURL());
                if (n != 0) {
                    return n;
                }
                return lineBreakpointComparable.getLineNumber() - lineBreakpoint.getLineNumber();
            }
            return -1;
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this);
            this.fo = null;
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            try {
                this.setURL(((FileObject)fileRenameEvent.getSource()).getURL().toString());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (!(object instanceof Breakpoint.VALIDITY)) {
                throw new UnsupportedOperationException(changeEvent.toString());
            }
            this.setValidity((Breakpoint.VALIDITY)object, changeEvent.toString());
        }
    }
}

