/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.cnd.debugger.gdb.CallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class CallStackNodeModel
implements NodeModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private final GdbDebugger debugger;
    private final Session session;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public CallStackNodeModel(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        new Listener(this, this.debugger);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(CallStackNodeModel.class).getString("CTL_CallstackModel_Column_Name_Name");
        }
        if (object instanceof CallStackFrame) {
            CallStackFrame callStackFrame = (CallStackFrame)object;
            CallStackFrame callStackFrame2 = this.debugger.getCurrentCallStackFrame();
            if (callStackFrame2 != null && callStackFrame2.equals(callStackFrame)) {
                return BoldVariablesTableModelFilterFirst.toHTML(CallStackNodeModel.getCSFName(this.session, callStackFrame, false), true, false, null);
            }
            return CallStackNodeModel.getCSFName(this.session, callStackFrame, false);
        }
        if ("No current thread" == object) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"NoCurrentThread");
        }
        if ("Thread is running" == object) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"ThreadIsRunning");
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(CallStackNodeModel.class).getString("CTL_CallstackModel_Column_Name_Desc");
        }
        if (object instanceof CallStackFrame) {
            CallStackFrame callStackFrame = (CallStackFrame)object;
            return CallStackNodeModel.getCSFName(this.session, callStackFrame, true);
        }
        if ("No current thread" == object) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"NoCurrentThread");
        }
        if ("Thread is running" == object) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"ThreadIsRunning");
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return null;
        }
        if (object instanceof CallStackFrame) {
            CallStackFrame callStackFrame = this.debugger.getCurrentCallStackFrame();
            if (callStackFrame != null && callStackFrame.equals(object)) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTreeChanged() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged(null);
        }
    }

    public static String getCSFName(Session session, CallStackFrame callStackFrame, boolean bl) {
        CharSequence charSequence;
        CharSequence charSequence2;
        String string = callStackFrame.getFunctionName();
        if (string != null && !string.equals("??")) {
            charSequence2 = string;
            Collection<GdbVariable> collection = callStackFrame.getArguments();
            if (collection != null) {
                charSequence = new StringBuilder((String)charSequence2);
                ((StringBuilder)charSequence).append('(');
                Iterator<GdbVariable> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    GdbVariable gdbVariable = iterator.next();
                    ((StringBuilder)charSequence).append(gdbVariable.getName());
                    ((StringBuilder)charSequence).append('=');
                    ((StringBuilder)charSequence).append(gdbVariable.getValue());
                    if (!iterator.hasNext()) continue;
                    ((StringBuilder)charSequence).append(',');
                }
                ((StringBuilder)charSequence).append(')');
                charSequence2 = ((StringBuilder)charSequence).toString();
            }
        } else {
            charSequence2 = callStackFrame.getAddr() != null ? NbBundle.getMessage(CallStackNodeModel.class, (String)"CTL_CallstackModel_Msg_Format", (Object)callStackFrame.getAddr()) : "";
        }
        int n = callStackFrame.getLineNumber();
        if (charSequence2.length() == 0) {
            CharSequence charSequence3 = charSequence = bl ? callStackFrame.getFullname() : callStackFrame.getFileName();
            if (n < 0) {
                charSequence2 = charSequence == null ? "??" : charSequence;
            }
        } else {
            charSequence = callStackFrame.getFileName();
            if (charSequence != null && n >= 0) {
                charSequence2 = NbBundle.getMessage(CallStackNodeModel.class, (String)"FMT_StackFrame", (Object[])new Object[]{charSequence2, charSequence, String.valueOf(n)});
            }
        }
        return charSequence2;
    }

    private static class Listener
    implements PropertyChangeListener {
        private final WeakReference<CallStackNodeModel> ref;
        private final GdbDebugger debugger;

        private Listener(CallStackNodeModel callStackNodeModel, GdbDebugger gdbDebugger) {
            this.ref = new WeakReference<CallStackNodeModel>(callStackNodeModel);
            this.debugger = gdbDebugger;
            gdbDebugger.addPropertyChangeListener("currentCallStackFrame", this);
        }

        private CallStackNodeModel getModel() {
            CallStackNodeModel callStackNodeModel = (CallStackNodeModel)this.ref.get();
            if (callStackNodeModel == null) {
                this.debugger.removePropertyChangeListener("currentCallStackFrame", this);
            }
            return callStackNodeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CallStackNodeModel callStackNodeModel = this.getModel();
            if (callStackNodeModel == null) {
                return;
            }
            callStackNodeModel.fireTreeChanged();
        }
    }
}

