/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.profiles;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.cnd.actions.BuildToolsAction;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.profiles.GdbProfileXMLCodec;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.modules.cnd.ui.options.LocalToolsPanelModel;
import org.netbeans.modules.cnd.ui.options.ToolsPanelModel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class GdbProfile
implements ConfigurationAuxObject {
    public static final String GDB_PROFILE_ID = "gdbdebugger";
    public static final String PROP_GDB_COMMAND = "gdb_command";
    public static final String PROP_ARRAY_REPEAT_THRESHOLD = "array_repeat_threshold";
    private PropertyChangeSupport pcs = null;
    private boolean needSave = false;
    private String gdb_command;

    public GdbProfile() {
        this.initialize();
    }

    protected GdbProfile(PropertyChangeSupport propertyChangeSupport) {
        this.pcs = propertyChangeSupport;
        this.initialize();
    }

    public void initialize() {
        if (this.gdb_command == null) {
            this.gdb_command = GdbDebugger.isUnitTest() ? "gdb" : CppSettings.getDefault().getGdbName();
        }
    }

    public boolean shared() {
        return false;
    }

    public String getId() {
        return GDB_PROFILE_ID;
    }

    public String getGdbCommand() {
        return this.gdb_command;
    }

    public void setGdbCommand(String string) {
        int n = string.length();
        boolean bl = this.gdb_command.equals(string);
        if (string.length() > 0 && !this.gdb_command.equals(string)) {
            if (this.pcs != null) {
                this.pcs.firePropertyChange(PROP_GDB_COMMAND, this.gdb_command, string);
            }
            this.gdb_command = string;
        }
    }

    public String getGdbPath(MakeConfiguration makeConfiguration, boolean bl) {
        File file;
        String string;
        CompilerSet compilerSet;
        String string2;
        if (this.getClass().getName().contains("gdb2")) {
            return "/usr/local/bin/gdb2";
        }
        CompilerSet2Configuration compilerSet2Configuration = makeConfiguration.getCompilerSet();
        if (compilerSet2Configuration.isValid()) {
            string2 = compilerSet2Configuration.getOption();
            compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).getCompilerSet(string2);
        } else {
            string2 = compilerSet2Configuration.getOldName();
            compilerSet = CompilerSet.getCompilerSet((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment(), (String)string2, (int)makeConfiguration.getPlatformInfo().getPlatform());
            CompilerSetManager.getDefault((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).add(compilerSet);
            compilerSet2Configuration.setValid();
        }
        Tool tool = compilerSet.getTool(6);
        ExecutionEnvironment executionEnvironment = null;
        if (tool != null) {
            string = tool.getPath();
            executionEnvironment = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
            if (executionEnvironment.isLocal()) {
                file = new File(string);
                if (file.exists() && !file.isDirectory()) {
                    return string;
                }
                String string3 = Path.findCommand((String)string);
                if (string3 != null) {
                    return string3;
                }
            } else if (ServerList.isValidExecutable((ExecutionEnvironment)executionEnvironment, (String)string)) {
                return string;
            }
        }
        if (bl) {
            string = new LocalToolsPanelModel();
            string.setCRequired(false);
            string.setCppRequired(false);
            string.setFortranRequired(false);
            string.setMakeRequired(false);
            string.setGdbRequired(true);
            string.setShowRequiredBuildTools(false);
            string.setShowRequiredDebugTools(true);
            string.setCompilerSetName(null);
            string.setSelectedCompilerSetName(string2);
            string.setSelectedDevelopmentHost(executionEnvironment);
            string.setEnableDevelopmentHostChange(false);
            file = (BuildToolsAction)SystemAction.get(BuildToolsAction.class);
            file.setTitle(NbBundle.getMessage(GdbProfile.class, (String)"LBL_ResolveMissingGdb_Title"));
            if (file.initBuildTools((ToolsPanelModel)string, new ArrayList())) {
                makeConfiguration.getCompilerSet().setValue(string.getSelectedCompilerSetName());
                compilerSet = CompilerSetManager.getDefault((ExecutionEnvironment)makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).getCompilerSet(string.getSelectedCompilerSetName());
                return compilerSet.getTool(6).getPath();
            }
        }
        return null;
    }

    public int getArrayRepeatThreshold() {
        return CppSettings.getDefault().getArrayRepeatThreshold();
    }

    public void setArrayRepeatThreshold(int n) {
        CppSettings.getDefault().setArrayRepeatThreshold(n);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public XMLDecoder getXMLDecoder() {
        return new GdbProfileXMLCodec(this);
    }

    public XMLEncoder getXMLEncoder() {
        return new GdbProfileXMLCodec(this);
    }

    public boolean hasChanged() {
        return this.needSave;
    }

    public void clearChanged() {
        this.needSave = false;
    }

    public void assign(ConfigurationAuxObject configurationAuxObject) {
        assert (configurationAuxObject instanceof GdbProfile);
        GdbProfile gdbProfile = (GdbProfile)configurationAuxObject;
        this.setGdbCommand(gdbProfile.getGdbCommand());
    }

    public GdbProfile clone(Configuration configuration) {
        GdbProfile gdbProfile = new GdbProfile();
        gdbProfile.setGdbCommand(this.getGdbCommand());
        return gdbProfile;
    }

    public Sheet getSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName(NbBundle.getMessage(GdbProfile.class, (String)"LBL_GENERAL"));
        set.setShortDescription(NbBundle.getMessage(GdbProfile.class, (String)"HINT_GENERAL"));
        set.put((Node.Property)new GdbCommandNodeProp());
        set.put((Node.Property)new ArrayRepeatThresholdNodeProp());
        sheet.put(set);
        return sheet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayRepeatThresholdNodeProp
    extends PropertySupport<Integer> {
        public ArrayRepeatThresholdNodeProp() {
            super(GdbProfile.PROP_ARRAY_REPEAT_THRESHOLD, Integer.class, NbBundle.getMessage(GdbProfile.class, (String)"LBL_ArrayRepeatThreshold"), NbBundle.getMessage(GdbProfile.class, (String)"HINT_ArrayRepeatThreshold"), true, true);
        }

        public Integer getValue() {
            return GdbProfile.this.getArrayRepeatThreshold();
        }

        public void setValue(Integer n) {
            if (n != null) {
                GdbProfile.this.setArrayRepeatThreshold(n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GdbCommandNodeProp
    extends PropertySupport<String> {
        public GdbCommandNodeProp() {
            super(GdbProfile.PROP_GDB_COMMAND, String.class, NbBundle.getMessage(GdbProfile.class, (String)"LBL_GDB_COMMAND"), NbBundle.getMessage(GdbProfile.class, (String)"HINT_GDB_COMMAND"), true, false);
        }

        public String getValue() {
            return GdbProfile.this.getGdbCommand();
        }

        public void setValue(String string) {
            GdbProfile.this.setGdbCommand(string);
        }
    }
}

