/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.CndModule;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.Signal;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalTerminal
implements PropertyChangeListener {
    private final String tty;
    private final long pid;
    private File gdbHelperLog = null;
    private File gdbHelperScript = null;
    private final GdbDebugger debugger;
    private static final Logger log = Logger.getLogger("gdb.logger");
    private static final int RETRY_LIMIT = 200;

    public static String create(GdbDebugger gdbDebugger, String string, String[] stringArray) throws IOException {
        return new ExternalTerminal((GdbDebugger)gdbDebugger, (String)string, (String[])stringArray).tty;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExternalTerminal(GdbDebugger gdbDebugger, String string, String[] stringArray) throws IOException {
        Object object;
        this.debugger = gdbDebugger;
        gdbDebugger.addPropertyChangeListener(this);
        this.initGdbHelpers();
        List<String> list = this.getTermOptions(string);
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        if (Utilities.getOperatingSystem() == 4096 && (object = processBuilder.environment()).get("DISPLAY") == null) {
            String string2 = ":0.0";
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("DISPLAY=") || stringArray[i].length() < 8) continue;
                string2 = stringArray[i].substring(8);
            }
            object.put("DISPLAY", string2);
        }
        object = processBuilder.start();
        int n = 0;
        String string3 = null;
        String string4 = null;
        try {
            while (n++ < 200) {
                try {
                    int n2 = ((Process)object).exitValue();
                    throw new IllegalStateException(NbBundle.getMessage(ExternalTerminal.class, (String)"ERR_ExternalTerminalFailedMessageDetails", list, (Object)n2));
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(this.gdbHelperLog));
                    string3 = bufferedReader.readLine();
                    string4 = bufferedReader.readLine();
                    bufferedReader.close();
                    if (string4 != null) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            if (n >= 200) {
                log.warning("Retry limit reached for " + this.gdbHelperLog + ", giving up");
            }
        }
        catch (IOException iOException) {
            log.warning("Failed to read external terminal helper");
        }
        this.tty = string3;
        log.finest("ExternalTerminal: tty=" + this.tty);
        long l = 0L;
        try {
            l = Long.valueOf(string4);
        }
        catch (Exception exception) {
            log.warning("Error parsing pid: " + string4);
        }
        this.pid = l;
        log.finest("ExternalTerminal: pid=" + this.pid);
    }

    private void initGdbHelpers() {
        try {
            this.gdbHelperLog = File.createTempFile("gdb_helper_", ".log");
            this.gdbHelperScript = File.createTempFile("gdb_helper_", ".sh");
        }
        catch (IOException iOException) {
            this.gdbHelperLog = new File("/tmp/gdb_helper.log");
            this.gdbHelperScript = new File("/tmp/gdb_helper.sh");
        }
        String string = NbBundle.getMessage(ExternalTerminal.class, (String)"GdbHelperScript", (Object)this.gdbHelperLog.getAbsolutePath());
        this.gdbHelperLog.deleteOnExit();
        this.gdbHelperScript.deleteOnExit();
        try {
            FileWriter fileWriter = new FileWriter(this.gdbHelperScript);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CndModule.chmod755(Collections.singletonList(this.gdbHelperScript.getAbsolutePath()), (Logger)log);
    }

    String getTty() {
        return this.tty;
    }

    private List<String> getTermOptions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (string.contains("gnome-terminal")) {
            arrayList.add("--hide-menubar");
            arrayList.add("--disable-factory");
            arrayList.add("--command");
            arrayList.add(this.gdbHelperScript.getAbsolutePath());
        } else if (string.contains("xterm")) {
            arrayList.add("-e");
            arrayList.add(this.gdbHelperScript.getAbsolutePath());
        } else if (string.contains("konsole")) {
            arrayList.add("-e");
            arrayList.add(this.gdbHelperScript.getAbsolutePath());
        }
        return arrayList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("state")) {
            Object object = propertyChangeEvent.getNewValue();
            if (object == GdbDebugger.State.EXITED) {
                this.gdbHelperScript.delete();
                this.gdbHelperLog.delete();
                this.debugger.removePropertyChangeListener(this);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("killTerm")) {
            if (this.pid == 0L) {
                log.warning("Killing zero pid detected from log: " + this.gdbHelperLog);
            }
            this.debugger.kill(Signal.TERM, this.pid);
        }
    }
}

