/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.ui;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.modules.cnd.debugger.gdb.ui.FilteredKeymap;
import org.openide.util.RequestProcessor;

public class FilteredKeymap
implements Keymap {
    private final KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
    private final KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
    private final KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
    private final Keymap keyMap;
    private static final String KEY_MAP = "keymap";

    public FilteredKeymap(final JTextComponent jTextComponent) {
        this.keyMap = jTextComponent.getKeymap();
        jTextComponent.addPropertyChangeListener(KEY_MAP, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!(propertyChangeEvent.getNewValue() instanceof FilteredKeymap)) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class KeymapUpdater
                    implements Runnable {
                        final /* synthetic */ JTextComponent val$component;
                        final /* synthetic */ FilteredKeymap this$0;

                        KeymapUpdater() {
                            this.this$0 = filteredKeymap;
                            this.val$component = jTextComponent;
                        }

                        public void run() {
                            this.val$component.setKeymap(new FilteredKeymap(this.val$component));
                        }
                    }
                    jTextComponent.removePropertyChangeListener(FilteredKeymap.KEY_MAP, this);
                    if (EventQueue.isDispatchThread()) {
                        EventQueue.invokeLater(new KeymapUpdater(FilteredKeymap.this, jTextComponent));
                    } else {
                        RequestProcessor.getDefault().post((Runnable)new KeymapUpdater(FilteredKeymap.this, jTextComponent), 100);
                    }
                }
            }
        });
    }

    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        this.keyMap.addActionForKeyStroke(keyStroke, action);
    }

    public Action getAction(KeyStroke keyStroke) {
        if (this.enter.equals(keyStroke) || this.esc.equals(keyStroke) || this.tab.equals(keyStroke)) {
            return null;
        }
        return this.keyMap.getAction(keyStroke);
    }

    public Action[] getBoundActions() {
        return this.keyMap.getBoundActions();
    }

    public KeyStroke[] getBoundKeyStrokes() {
        return this.keyMap.getBoundKeyStrokes();
    }

    public Action getDefaultAction() {
        return this.keyMap.getDefaultAction();
    }

    public KeyStroke[] getKeyStrokesForAction(Action action) {
        return this.keyMap.getKeyStrokesForAction(action);
    }

    public String getName() {
        return this.keyMap.getName() + "_Filtered";
    }

    public Keymap getResolveParent() {
        return this.keyMap.getResolveParent();
    }

    public boolean isLocallyDefined(KeyStroke keyStroke) {
        if (this.enter.equals(keyStroke) || this.esc.equals(keyStroke) || this.tab.equals(keyStroke)) {
            return false;
        }
        return this.keyMap.isLocallyDefined(keyStroke);
    }

    public void removeBindings() {
        this.keyMap.removeBindings();
    }

    public void removeKeyStrokeBinding(KeyStroke keyStroke) {
        this.keyMap.removeKeyStrokeBinding(keyStroke);
    }

    public void setDefaultAction(Action action) {
        this.keyMap.setDefaultAction(action);
    }

    public void setResolveParent(Keymap keymap) {
        this.keyMap.setResolveParent(keymap);
    }
}

