/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.netbeans.modules.cnd.debugger.gdb.GdbContext;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.RegisterValue;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class RegistersTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static RegistersTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/cnd/debugger/gdb/resources/registers.png";
    private static final String PREFERRED_ID = "RegistersTopComponent";
    private final RegisterTableModel model = new RegisterTableModel();
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private static final Comparator<RegisterValue> REGISTER_COMPARATOR;

    private RegistersTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(RegistersTopComponent.class, (String)"CTL_RegistersTopComponent"));
        this.setToolTipText(NbBundle.getMessage(RegistersTopComponent.class, (String)"HINT_RegistersTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.jScrollPane1.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.jTable1.setDefaultRenderer(RegisterValue.class, new RegisterCellRendererForValue());
        TableColumn tableColumn = this.jTable1.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new RegisterTableCellEditor());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BorderLayout());
        this.jTable1.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add(this.jScrollPane1, "Center");
    }

    public static synchronized RegistersTopComponent getDefault() {
        if (instance == null) {
            instance = new RegistersTopComponent();
        }
        return instance;
    }

    public static synchronized RegistersTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(RegistersTopComponent.class.getName()).warning("Cannot find RegistersTopComponent component. It will not be located properly in the window system.");
            return RegistersTopComponent.getDefault();
        }
        if (topComponent instanceof RegistersTopComponent) {
            return (RegistersTopComponent)topComponent;
        }
        Logger.getLogger(RegistersTopComponent.class.getName()).warning("There seem to be multiple components with the 'RegistersTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return RegistersTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        GdbContext.getInstance().addPropertyChangeListener("Registers", this);
    }

    public void componentClosed() {
        GdbContext.getInstance().removePropertyChangeListener("Registers", this);
    }

    protected void componentShowing() {
        this.model.refresh();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.model.refresh();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static {
        REGISTER_COMPARATOR = new Comparator<RegisterValue>(){

            @Override
            public int compare(RegisterValue registerValue, RegisterValue registerValue2) {
                return registerValue.getName().compareTo(registerValue2.getName());
            }
        };
    }

    private static class RegisterCellRendererForValue
    extends DefaultTableCellRenderer.UIResource {
        private RegisterCellRendererForValue() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            RegisterValue registerValue;
            this.setEnabled(jTable == null || jTable.isEnabled());
            super.getTableCellRendererComponent(jTable, ((RegisterValue)object).getValue(), bl, bl2, n, n2);
            if (object instanceof RegisterValue && (registerValue = (RegisterValue)object).isModified()) {
                super.setFont(this.getFont().deriveFont(1));
            }
            return this;
        }
    }

    private static class RegisterTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JTextField();

        public RegisterTableCellEditor() {
            this.component.setBorder(new LineBorder(Color.black, 0));
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                // empty if block
            }
            RegisterValue registerValue = (RegisterValue)object;
            ((JTextField)this.component).setText(registerValue.getValue());
            return this.component;
        }

        public Object getCellEditorValue() {
            return ((JTextField)this.component).getText();
        }
    }

    private static class RegisterTableModel
    extends AbstractTableModel {
        private final List<RegisterValue> values = Collections.synchronizedList(new ArrayList());
        public static final int COLUMN_REGISTER = 0;
        public static final int COLUMN_VALUE = 1;
        private final String[] columnNames = new String[]{NbBundle.getMessage(RegistersTopComponent.class, (String)"LBL_REGUSAGE_REGISTER"), NbBundle.getMessage(RegistersTopComponent.class, (String)"LBL_REGUSAGE_VALUE")};
        private final Class[] types = new Class[]{String.class, RegisterValue.class};

        private RegisterTableModel() {
        }

        public Class getColumnClass(int n) {
            return this.types[n];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.values.size();
        }

        public Object getValueAt(int n, int n2) {
            RegisterValue registerValue = this.values.get(n);
            switch (n2) {
                case 0: {
                    return registerValue.getName();
                }
                case 1: {
                    return registerValue;
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            RegisterValue registerValue;
            RegisterValue registerValue2 = this.values.get(n);
            String string = (String)object;
            if (registerValue2.getValue().equals(string)) {
                return;
            }
            GdbDebugger gdbDebugger = GdbDebugger.getGdbDebugger();
            if (gdbDebugger == null) {
                return;
            }
            String string2 = gdbDebugger.updateVariable("$" + registerValue2.getName(), string);
            try {
                string2 = "0x" + Integer.toHexString(Integer.parseInt(string2));
                registerValue = new RegisterValue(registerValue2.getName(), string2, false);
                List list = (List)GdbContext.getInstance().getProperty("Registers");
                list.set(n, registerValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            registerValue = new RegisterValue(registerValue2.getName(), string2, false);
            this.values.set(n, registerValue);
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        private void refresh() {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    List list = (List)GdbContext.getInstance().getProperty("Registers");
                    List list2 = RegisterTableModel.this.values;
                    synchronized (list2) {
                        RegisterTableModel.this.values.clear();
                        if (list != null) {
                            RegisterTableModel.this.values.addAll(list);
                        }
                        Collections.sort(RegisterTableModel.this.values, REGISTER_COMPARATOR);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            RegisterTableModel.this.fireTableDataChanged();
                        }
                    });
                }
            });
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return RegistersTopComponent.getDefault();
        }
    }
}

