/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathModifierSupport;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;

public final class ClassPathModifier
extends ProjectClassPathModifierImplementation {
    public static final int ADD = 1;
    public static final int ADD_NO_HEURISTICS = 3;
    public static final int REMOVE = 2;
    private final Project project;
    private final UpdateHelper helper;
    private final PropertyEvaluator eval;
    private final ClassPathSupport cs;
    private final AntProjectHelper antHelper;
    private ReferenceHelper refHelper;
    private Callback cpModifierCallback;
    private ClassPathUiSupport.Callback cpUiSupportCallback;
    private static final Logger LOG = Logger.getLogger(ClassPathModifier.class.getName());

    public ClassPathModifier(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, ClassPathSupport.Callback callback, Callback callback2, ClassPathUiSupport.Callback callback3) {
        assert (project != null);
        assert (updateHelper != null);
        assert (propertyEvaluator != null);
        assert (referenceHelper != null);
        this.project = project;
        this.helper = updateHelper;
        this.eval = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.antHelper = updateHelper.getAntProjectHelper();
        this.cs = new ClassPathSupport(propertyEvaluator, referenceHelper, this.antHelper, updateHelper, callback);
        this.cpModifierCallback = callback2;
        this.cpUiSupportCallback = callback3;
    }

    public SourceGroup[] getExtensibleSourceGroups() {
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        assert (sources != null);
        return sources.getSourceGroups("java");
    }

    protected String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
        return new String[]{"classpath/compile", "classpath/execute"};
    }

    protected boolean removeRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        return this.removeRoots(ClassPathModifier.convertURLsToURIs((URL[])uRLArray), sourceGroup, string);
    }

    protected boolean removeRoots(URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleRoots(uRIArray, string2, this.cpModifierCallback.getElementName(string2), 2);
    }

    protected boolean addRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        return this.addRoots(ClassPathModifier.convertURLsToURIs((URL[])uRLArray), sourceGroup, string);
    }

    public boolean addRoots(URL[] uRLArray, String string) throws IOException, UnsupportedOperationException {
        return this.handleRoots(ClassPathModifier.convertURLsToURIs((URL[])uRLArray), string, this.cpModifierCallback.getElementName(string), 1);
    }

    protected boolean addRoots(URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        return this.addRoots(uRIArray, sourceGroup, string, 1);
    }

    public boolean addRoots(URI[] uRIArray, SourceGroup sourceGroup, String string, int n) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleRoots(uRIArray, string2, this.cpModifierCallback.getElementName(string2), n);
    }

    boolean handleRoots(URI[] uRIArray, String string, String string2, int n) throws IOException, UnsupportedOperationException {
        assert (uRIArray != null) : "The classPathRoots cannot be null";
        assert (string != null);
        return ClassPathModifierSupport.handleRoots(this.project, this.antHelper, this.cs, this.eval, this.cpUiSupportCallback, uRIArray, string, string2, n);
    }

    protected boolean removeAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleAntArtifacts(antArtifactArray, uRIArray, string2, this.cpModifierCallback.getElementName(string2), 2);
    }

    protected boolean addAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleAntArtifacts(antArtifactArray, uRIArray, string2, this.cpModifierCallback.getElementName(string2), 1);
    }

    boolean handleAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, String string, String string2, int n) throws IOException, UnsupportedOperationException {
        assert (antArtifactArray != null) : "Artifacts cannot be null";
        assert (uRIArray != null) : "ArtifactElements cannot be null";
        assert (antArtifactArray.length == uRIArray.length) : "Each artifact has to have corresponding artifactElement";
        assert (string != null);
        return ClassPathModifierSupport.handleAntArtifacts(this.project, this.antHelper, this.cs, this.eval, this.cpUiSupportCallback, antArtifactArray, uRIArray, string, string2, n);
    }

    protected boolean removeLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleLibraries(libraryArray, string2, this.cpModifierCallback.getElementName(string2), 2);
    }

    protected boolean addLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
        String string2 = this.cpModifierCallback.getClassPathProperty(sourceGroup, string);
        return this.handleLibraries(libraryArray, string2, this.cpModifierCallback.getElementName(string2), 1);
    }

    boolean handleLibraries(Library[] libraryArray, String string, String string2, int n) throws IOException, UnsupportedOperationException {
        return ClassPathModifierSupport.handleLibraries(this.project, this.antHelper, this.cs, this.eval, this.cpUiSupportCallback, this.refHelper, libraryArray, string, string2, n);
    }

    public ClassPathSupport getClassPathSupport() {
        return this.cs;
    }

    public static interface Callback {
        public String getClassPathProperty(SourceGroup var1, String var2);

        public String getElementName(String var1);
    }
}

