/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupportFactory;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider {
    private String buildClassesDir = "build.classes.dir";
    private static final String buildGeneratedDir = "build.generated.sources.dir";
    private String distJar = "dist.jar";
    private String buildTestClassesDir = "build.test.classes.dir";
    private String[] javacClasspath = new String[]{"javac.classpath"};
    private String[] javacTestClasspath = new String[]{"javac.test.classpath"};
    private String[] runClasspath = new String[]{"run.classpath"};
    private String[] runTestClasspath = new String[]{"run.test.classpath"};
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final ClassPath[] cache = new ClassPath[8];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();
    private PropertyChangeListener listener;

    public ClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        this.helper = antProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = sourceRoots2;
        this.listener = new PropertyChangeListener(){

            public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ClassPathProviderImpl.this.dirCache.remove(propertyChangeEvent.getPropertyName());
            }
        };
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)propertyEvaluator));
    }

    public ClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2, String string, String string2, String string3, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        this(antProjectHelper, propertyEvaluator, sourceRoots, sourceRoots2);
        this.buildClassesDir = string;
        this.distJar = string2;
        this.buildTestClassesDir = string3;
        this.javacClasspath = stringArray;
        this.javacTestClasspath = stringArray2;
        this.runClasspath = stringArray3;
        this.runTestClasspath = stringArray4;
    }

    private FileObject getDir(final String string) {
        return (FileObject)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject run() {
                ClassPathProviderImpl classPathProviderImpl = ClassPathProviderImpl.this;
                synchronized (classPathProviderImpl) {
                    String string2;
                    FileObject fileObject = (FileObject)ClassPathProviderImpl.this.dirCache.get(string);
                    if (!(fileObject != null && fileObject.isValid() || (string2 = ClassPathProviderImpl.this.evaluator.getProperty(string)) == null)) {
                        fileObject = ClassPathProviderImpl.this.helper.resolveFileObject(string2);
                        ClassPathProviderImpl.this.dirCache.put(string, fileObject);
                    }
                    return fileObject;
                }
            }
        });
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir(this.buildClassesDir);
    }

    private FileObject getBuildGeneratedDir() {
        return this.getDir(buildGeneratedDir);
    }

    private FileObject getDistJar() {
        return this.getDir(this.distJar);
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir(this.buildTestClassesDir);
    }

    private int getType(FileObject fileObject) {
        FileObject fileObject2;
        int n;
        FileObject[] fileObjectArray = this.getPrimarySrcPath();
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObject2 = fileObjectArray[n];
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return 0;
        }
        fileObjectArray = this.getTestSrcDir();
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObject2 = fileObjectArray[n];
            if (!fileObject2.equals(fileObject) && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
            return 1;
        }
        FileObject fileObject3 = this.getBuildClassesDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return 2;
        }
        fileObject3 = this.getDistJar();
        if (fileObject3 != null && fileObject3.equals(FileUtil.getArchiveFile((FileObject)fileObject))) {
            return 4;
        }
        fileObject3 = this.getBuildTestClassesDir();
        if (fileObject3 != null && (fileObject3.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject))) {
            return 3;
        }
        fileObject3 = this.getBuildGeneratedDir();
        if (fileObject3 != null && FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject)) {
            return 0;
        }
        return -1;
    }

    private ClassPath getCompileTimeClasspath(FileObject fileObject) {
        int n = this.getType(fileObject);
        return this.getCompileTimeClasspath(n);
    }

    private synchronized ClassPath getCompileTimeClasspath(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        ClassPath classPath = this.cache[2 + n];
        if (classPath == null) {
            classPath = n == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.javacClasspath)) : ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.javacTestClasspath));
            this.cache[2 + n] = classPath;
        }
        return classPath;
    }

    private ClassPath getRunTimeClasspath(FileObject fileObject) {
        int n = this.getType(fileObject);
        if (n < 0 || n > 4) {
            return null;
        }
        if (n > 1) {
            n -= 2;
        }
        return this.getRunTimeClasspath(n);
    }

    private synchronized ClassPath getRunTimeClasspath(int n) {
        int n2;
        if (n == 0 || n == 2 || n == 4) {
            n2 = 4;
        } else if (n == 1 || n == 3) {
            n2 = 5;
        } else {
            return null;
        }
        ClassPath classPath = this.cache[n2];
        if (classPath == null) {
            if (n == 0 || n == 2 || n == 4) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.runClasspath));
            } else if (n == 1 || n == 3) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])this.runTestClasspath));
            }
            this.cache[n2] = classPath;
        }
        return classPath;
    }

    private ClassPath getSourcepath(FileObject fileObject) {
        int n = this.getType(fileObject);
        return this.getSourcepath(n);
    }

    private synchronized ClassPath getSourcepath(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        ClassPath classPath = this.cache[n];
        if (classPath == null) {
            switch (n) {
                case 0: {
                    classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createSourcePathImplementation(this.sourceRoots, this.helper, this.evaluator));
                    break;
                }
                case 1: {
                    classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createSourcePathImplementation(this.testSourceRoots, this.helper, this.evaluator));
                }
            }
        }
        this.cache[n] = classPath;
        return classPath;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath classPath = this.cache[7];
        if (classPath == null) {
            this.cache[7] = classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createBootClassPathImplementation(this.evaluator));
        }
        return classPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(fileObject);
        }
        if (string.equals("classpath/execute")) {
            return this.getRunTimeClasspath(fileObject);
        }
        if (string.equals("classpath/source")) {
            return this.getSourcepath(fileObject);
        }
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(final String string) {
        return (ClassPath[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ClassPath[]>(){

            public ClassPath[] run() {
                if ("classpath/boot".equals(string)) {
                    return new ClassPath[]{ClassPathProviderImpl.this.getBootClassPath()};
                }
                if ("classpath/compile".equals(string)) {
                    ClassPath[] classPathArray = new ClassPath[]{ClassPathProviderImpl.this.getCompileTimeClasspath(0), ClassPathProviderImpl.this.getCompileTimeClasspath(1)};
                    return classPathArray;
                }
                if ("classpath/source".equals(string)) {
                    ClassPath[] classPathArray = new ClassPath[]{ClassPathProviderImpl.this.getSourcepath(0), ClassPathProviderImpl.this.getSourcepath(1)};
                    return classPathArray;
                }
                assert (false);
                return null;
            }
        });
    }

    public ClassPath getProjectSourcesClassPath(String string) {
        if ("classpath/boot".equals(string)) {
            return this.getBootClassPath();
        }
        if ("classpath/compile".equals(string)) {
            return this.getCompileTimeClasspath(0);
        }
        if ("classpath/source".equals(string)) {
            return this.getSourcepath(0);
        }
        if ("classpath/execute".equals(string)) {
            return this.getRunTimeClasspath(0);
        }
        assert (false) : "Unknown classpath type: " + string;
        return null;
    }

    public String[] getPropertyName(SourceRoots sourceRoots, String string) {
        if (sourceRoots.isTest()) {
            if ("classpath/compile".equals(string)) {
                return this.javacTestClasspath;
            }
            if ("classpath/execute".equals(string)) {
                return this.runTestClasspath;
            }
            return null;
        }
        if ("classpath/compile".equals(string)) {
            return this.javacClasspath;
        }
        if ("classpath/execute".equals(string)) {
            return this.runClasspath;
        }
        return null;
    }

    public String[] getPropertyName(SourceGroup sourceGroup, String string) {
        int n;
        FileObject fileObject = sourceGroup.getRootFolder();
        FileObject[] fileObjectArray = this.getPrimarySrcPath();
        for (n = 0; n < fileObjectArray.length; ++n) {
            if (!fileObject.equals(fileObjectArray[n])) continue;
            if ("classpath/compile".equals(string)) {
                return this.javacClasspath;
            }
            if ("classpath/execute".equals(string)) {
                return this.runClasspath;
            }
            return null;
        }
        fileObjectArray = this.getTestSrcDir();
        for (n = 0; n < fileObjectArray.length; ++n) {
            if (!fileObject.equals(fileObjectArray[n])) continue;
            if ("classpath/compile".equals(string)) {
                return this.javacTestClasspath;
            }
            if ("classpath/execute".equals(string)) {
                return this.runTestClasspath;
            }
            return null;
        }
        return null;
    }
}

