/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

final class FileBuiltQueryImpl
implements FileBuiltQueryImplementation,
PropertyChangeListener {
    private FileBuiltQueryImplementation delegate;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private File buildGeneratedDir = null;
    private final FileChangeListener buildGeneratedDirListener = new FileChangeAdapter(){

        public void fileFolderCreated(FileEvent fileEvent) {
            FileBuiltQueryImpl.this.invalidate();
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileBuiltQueryImpl.this.invalidate();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileBuiltQueryImpl.this.invalidate();
        }
    };

    FileBuiltQueryImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        assert (antProjectHelper != null);
        assert (propertyEvaluator != null);
        assert (sourceRoots != null);
        assert (sourceRoots2 != null);
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = sourceRoots2;
        this.sourceRoots.addPropertyChangeListener(this);
        this.testRoots.addPropertyChangeListener(this);
    }

    public FileBuiltQuery.Status getStatus(final FileObject fileObject) {
        return (FileBuiltQuery.Status)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileBuiltQuery.Status>(){

            public FileBuiltQuery.Status run() {
                return FileBuiltQueryImpl.this.getStatusImpl(fileObject);
            }
        });
    }

    private synchronized FileBuiltQuery.Status getStatusImpl(FileObject fileObject) {
        if (this.delegate == null) {
            this.delegate = this.createDelegate();
        }
        return this.delegate.getStatus(fileObject);
    }

    private FileBuiltQueryImplementation createDelegate() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : this.sourceRoots.getRootProperties()) {
            arrayList.add("${" + string + "}/*.java");
            arrayList2.add("${build.classes.dir}/*.class");
        }
        for (String string : this.testRoots.getRootProperties()) {
            arrayList.add("${" + string + "}/*.java");
            arrayList2.add("${build.test.classes.dir}/*.class");
        }
        String string = this.evaluator.getProperty("build.generated.sources.dir");
        if (string != null) {
            File file = this.helper.resolveFile(string);
            if (!file.equals(this.buildGeneratedDir)) {
                if (this.buildGeneratedDir != null) {
                    FileUtil.removeFileChangeListener((FileChangeListener)this.buildGeneratedDirListener, (File)this.buildGeneratedDir);
                }
                this.buildGeneratedDir = file;
                FileUtil.addFileChangeListener((FileChangeListener)this.buildGeneratedDirListener, (File)this.buildGeneratedDir);
            }
            if (this.buildGeneratedDir.isDirectory()) {
                for (File file2 : this.buildGeneratedDir.listFiles()) {
                    if (!file2.isDirectory()) continue;
                    arrayList.add(file2 + "/*.java");
                    arrayList2.add("${build.classes.dir}/*.class");
                }
            }
        }
        return this.helper.createGlobFileBuiltQuery(this.evaluator, arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SourceRoots.PROP_ROOT_PROPERTIES.equals(propertyChangeEvent.getPropertyName())) {
            this.invalidate();
        }
    }

    private synchronized void invalidate() {
        this.delegate = null;
    }
}

