/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class BreakpointCustomizeAction
extends SystemAction
implements ContextAwareAction {
    public BreakpointCustomizeAction() {
        this.setEnabled(false);
    }

    public String getName() {
        return NbBundle.getMessage(BreakpointCustomizeAction.class, (String)"CTL_customize");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public Action createContextAwareInstance(Lookup lookup) {
        Collection collection = lookup.lookupAll(BreakpointAnnotation.class);
        if (collection.size() == 1) {
            return new BreakpointAwareAction((BreakpointAnnotation)((Object)collection.iterator().next()));
        }
        return this;
    }

    private class BreakpointAwareAction
    implements Action,
    Presenter.Popup {
        private BreakpointAnnotation ann;

        public BreakpointAwareAction(BreakpointAnnotation breakpointAnnotation) {
            this.ann = breakpointAnnotation;
        }

        public JMenuItem getPopupPresenter() {
            return new Actions.MenuItem((Action)this, false);
        }

        public Object getValue(String string) {
            return BreakpointCustomizeAction.this.getValue(string);
        }

        public void putValue(String string, Object object) {
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isEnabled() {
            return this.getCustomizer(this.ann.getBreakpoint()) != null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            BreakpointCustomizeAction.this.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            BreakpointCustomizeAction.this.removePropertyChangeListener(propertyChangeListener);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.customize(this.ann.getBreakpoint());
        }

        private BeanInfo findBeanInfo(Class clazz) {
            Class<?> clazz2;
            try {
                clazz2 = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass(clazz.getName() + "BeanInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz2 = null;
            }
            if (clazz2 == null) {
                if ((clazz = clazz.getSuperclass()) != null) {
                    return this.findBeanInfo(clazz);
                }
                return null;
            }
            try {
                Constructor constructor = clazz2.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (BeanInfo)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return null;
            }
        }

        private Customizer getCustomizer(Breakpoint breakpoint) {
            BeanDescriptor beanDescriptor;
            BeanInfo beanInfo = this.findBeanInfo(breakpoint.getClass());
            if (beanInfo == null) {
                try {
                    beanInfo = Introspector.getBeanInfo(breakpoint.getClass());
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                    return null;
                }
            }
            if ((beanDescriptor = beanInfo.getBeanDescriptor()) == null) {
                return null;
            }
            Class<?> clazz = beanDescriptor.getCustomizerClass();
            if (clazz == null) {
                return null;
            }
            try {
                Customizer customizer = (Customizer)clazz.newInstance();
                customizer.setObject(breakpoint);
                return customizer;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return null;
            }
        }

        private void customize(Breakpoint breakpoint) {
            Dialog dialog;
            String string;
            Customizer customizer = this.getCustomizer(breakpoint);
            if (customizer == null) {
                return;
            }
            HelpCtx helpCtx = HelpCtx.findHelp((Object)customizer);
            if (helpCtx == null) {
                helpCtx = new HelpCtx("debug.add.breakpoint");
            }
            final Controller[] controllerArray = new Controller[]{null};
            if (customizer instanceof Controller) {
                controllerArray[0] = (Controller)((Object)customizer);
            }
            final DialogDescriptor[] dialogDescriptorArray = new DialogDescriptor[1];
            final Dialog[] dialogArray = new Dialog[1];
            ActionListener actionListener = null;
            if (controllerArray[0] != null) {
                actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (dialogDescriptorArray[0].getValue() == DialogDescriptor.OK_OPTION) {
                            boolean bl = controllerArray[0].ok();
                            if (bl) {
                                dialogArray[0].setVisible(false);
                            }
                        } else {
                            dialogArray[0].setVisible(false);
                        }
                    }
                };
            }
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)customizer, NbBundle.getMessage(BreakpointCustomizeAction.class, (String)"CTL_Breakpoint_Customizer_Title"), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, actionListener);
            if (actionListener != null) {
                dialogDescriptor.setClosingOptions(new Object[0]);
            }
            if ((string = (dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor)).getAccessibleContext().getAccessibleDescription()) == null) {
                if (customizer instanceof JComponent) {
                    string = ((JComponent)((Object)customizer)).getAccessibleContext().getAccessibleDescription();
                }
                if (string == null) {
                    string = NbBundle.getMessage(BreakpointCustomizeAction.class, (String)"ACSD_Breakpoint_Customizer", (Object)breakpoint);
                }
                dialog.getAccessibleContext().setAccessibleDescription(string);
            }
            dialog.pack();
            dialogDescriptorArray[0] = dialogDescriptor;
            dialogArray[0] = dialog;
            dialog.setVisible(true);
        }
    }
}

