/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.ui.views.VariablesViewButtons;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

public class ViewModelListener
extends DebuggerManagerAdapter {
    private String viewType;
    private JComponent view;
    private JComponent buttonsPane;
    private List models = new ArrayList(11);
    private List<? extends SessionProvider> sessionProviders;
    private Session currentSession;
    private List treeModels;
    private List treeModelFilters;
    private List treeExpansionModels;
    private List nodeModels;
    private List nodeModelFilters;
    private List tableModels;
    private List tableModelFilters;
    private List nodeActionsProviders;
    private List nodeActionsProviderFilters;
    private List columnModels;
    private List mm;
    private RequestProcessor rp;
    private List<AbstractButton> buttons;
    private JTabbedPane tabbedPane;
    private Image viewIcon;
    private SessionProvider providerToDisplay;
    private List<ViewModelListener> subListeners = new ArrayList<ViewModelListener>();
    private Preferences preferences = NbPreferences.forModule(ContextProvider.class).node("variables_view");
    private ViewPreferenceChangeListener prefListener = new ViewPreferenceChangeListener();
    private String propertiesHelpID = null;

    ViewModelListener(String string, JComponent jComponent, JComponent jComponent2, String string2, Image image) {
        this.viewType = string;
        this.view = jComponent;
        this.buttonsPane = jComponent2;
        this.propertiesHelpID = string2;
        this.viewIcon = image;
        this.setUp();
    }

    void setUp() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.preferences.addPreferenceChangeListener(this.prefListener);
        this.updateModel();
    }

    synchronized void destroy() {
        Object object;
        boolean bl;
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.preferences.removePreferenceChangeListener(this.prefListener);
        boolean bl2 = bl = this.treeModels.size() > 0 || this.nodeModels.size() > 0 || this.tableModels.size() > 0;
        if (bl && this.view.getComponentCount() > 0 && !((object = (JComponent)this.view.getComponent(0)) instanceof JTabbedPane)) {
            Models.setModelsToView((JComponent)object, null);
        }
        this.models.clear();
        this.treeModels = null;
        this.treeModelFilters = null;
        this.treeExpansionModels = null;
        this.nodeModels = null;
        this.nodeModelFilters = null;
        this.tableModels = null;
        this.tableModelFilters = null;
        this.nodeActionsProviders = null;
        this.nodeActionsProviderFilters = null;
        this.columnModels = null;
        this.mm = null;
        this.rp = null;
        this.sessionProviders = null;
        this.currentSession = null;
        this.providerToDisplay = null;
        this.buttonsPane.removeAll();
        this.buttons = null;
        this.view.removeAll();
        for (ViewModelListener viewModelListener : this.subListeners) {
            viewModelListener.destroy();
        }
        this.subListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() != null) {
            ViewModelListener viewModelListener = this;
            synchronized (viewModelListener) {
                this.providerToDisplay = null;
            }
        }
        this.updateModel();
    }

    private synchronized void updateModel() {
        Object object;
        Object object2;
        Object object3;
        AbstractCollection abstractCollection;
        Object object4;
        String string;
        DebuggerManager debuggerManager;
        DebuggerManager debuggerManager2 = DebuggerManager.getDebuggerManager();
        DebuggerEngine debuggerEngine = debuggerManager2.getCurrentEngine();
        this.sessionProviders = debuggerEngine == null ? debuggerManager2.lookup(this.viewType, SessionProvider.class) : DebuggerManager.join((ContextProvider)debuggerEngine, (ContextProvider)debuggerManager2).lookup(this.viewType, SessionProvider.class);
        if (!this.sessionProviders.contains(this.providerToDisplay)) {
            this.providerToDisplay = null;
        }
        if (debuggerEngine == null && this.providerToDisplay == null && this.sessionProviders.size() > 0) {
            this.providerToDisplay = this.sessionProviders.get(0);
        }
        if (this.providerToDisplay != null) {
            debuggerEngine = null;
            debuggerManager = debuggerManager2;
            string = this.viewType + "/" + this.providerToDisplay.getTypeID();
        } else {
            debuggerManager = debuggerEngine != null ? DebuggerManager.join((ContextProvider)debuggerEngine, (ContextProvider)debuggerManager2) : debuggerManager2;
            string = this.viewType;
        }
        this.currentSession = debuggerManager2.getCurrentSession();
        this.treeModels = debuggerManager.lookup(string, TreeModel.class);
        this.treeModelFilters = debuggerManager.lookup(string, TreeModelFilter.class);
        this.treeExpansionModels = debuggerManager.lookup(string, TreeExpansionModel.class);
        this.nodeModels = debuggerManager.lookup(string, NodeModel.class);
        this.nodeModelFilters = debuggerManager.lookup(string, NodeModelFilter.class);
        this.tableModels = debuggerManager.lookup(string, TableModel.class);
        this.tableModelFilters = debuggerManager.lookup(string, TableModelFilter.class);
        this.nodeActionsProviders = debuggerManager.lookup(string, NodeActionsProvider.class);
        this.nodeActionsProviderFilters = debuggerManager.lookup(string, NodeActionsProviderFilter.class);
        this.columnModels = debuggerManager.lookup(string, ColumnModel.class);
        this.mm = debuggerManager.lookup(string, Model.class);
        RequestProcessor requestProcessor = this.rp = debuggerEngine != null ? (RequestProcessor)debuggerEngine.lookupFirst(null, RequestProcessor.class) : null;
        if ("LocalsView".equals(this.viewType) && (VariablesViewButtons.isResultsViewNested() || VariablesViewButtons.isWatchesViewNested())) {
            object4 = new LinkedHashMap();
            abstractCollection = new HashSet();
            object3 = new HashSet();
            object2 = new HashSet();
            HashSet hashSet = new HashSet();
            object = this.createCompound("LocalsView", (Set)((Object)abstractCollection), (Set)object3, (Set)object2, hashSet);
            object4.put("LocalsView", object);
            if (VariablesViewButtons.isResultsViewNested()) {
                object4.put("ResultsView", this.createCompound("ResultsView", (Set)((Object)abstractCollection), (Set)object3, (Set)object2, hashSet));
            }
            if (VariablesViewButtons.isWatchesViewNested()) {
                object4.put("WatchesView", this.createCompound("WatchesView", (Set)((Object)abstractCollection), (Set)object3, (Set)object2, hashSet));
            }
            UnionTreeModel unionTreeModel = new UnionTreeModel((Map<String, Models.CompoundModel>)object4, (Models.CompoundModel)object);
            this.treeModels.clear();
            this.treeModels.add(unionTreeModel);
            this.treeModelFilters.clear();
            this.nodeModels.clear();
            this.nodeModels.add(unionTreeModel);
            this.nodeModelFilters.clear();
            this.tableModels.clear();
            this.tableModels.add(unionTreeModel);
            this.tableModelFilters.clear();
            this.nodeActionsProviders.clear();
            this.nodeActionsProviders.add(unionTreeModel);
            this.nodeActionsProviderFilters.clear();
        }
        object4 = debuggerManager.lookup(string, AbstractButton.class);
        this.buttons = new ArrayList<AbstractButton>();
        abstractCollection = new ArrayList();
        object3 = object4.iterator();
        while (object3.hasNext()) {
            object2 = (AbstractButton)object3.next();
            if (object2 instanceof JToggleButton) {
                this.buttons.add((AbstractButton)object2);
                continue;
            }
            abstractCollection.add(object2);
        }
        this.buttons.addAll(abstractCollection);
        this.tabbedPane = (JTabbedPane)debuggerManager.lookupFirst(string, JTabbedPane.class);
        object3 = new ModelsChangeRefresher();
        object2 = new Customizer[]{(Customizer)((Object)this.treeModels), (Customizer)((Object)this.treeModelFilters), (Customizer)((Object)this.treeExpansionModels), (Customizer)((Object)this.nodeModels), (Customizer)((Object)this.nodeModelFilters), (Customizer)((Object)this.tableModels), (Customizer)((Object)this.tableModelFilters), (Customizer)((Object)this.nodeActionsProviders), (Customizer)((Object)this.nodeActionsProviderFilters), (Customizer)((Object)this.columnModels), (Customizer)((Object)this.mm)};
        for (int i = 0; i < ((Customizer[])object2).length; ++i) {
            object = object2[i];
            if (object == null) continue;
            object.addPropertyChangeListener((PropertyChangeListener)object3);
            object.setObject("load first");
            object.setObject("unload last");
        }
        this.refreshModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshModel() {
        this.models.clear();
        if (this.treeModels == null) {
            return;
        }
        Object object = this.treeModels;
        synchronized (object) {
            this.models.add(new ArrayList(this.treeModels));
        }
        object = this.treeModelFilters;
        synchronized (object) {
            this.models.add(new ArrayList(this.treeModelFilters));
        }
        object = this.treeExpansionModels;
        synchronized (object) {
            this.models.add(new ArrayList(this.treeExpansionModels));
        }
        object = this.nodeModels;
        synchronized (object) {
            this.models.add(new ArrayList(this.nodeModels));
        }
        object = this.nodeModelFilters;
        synchronized (object) {
            this.models.add(new ArrayList(this.nodeModelFilters));
        }
        object = this.tableModels;
        synchronized (object) {
            this.models.add(new ArrayList(this.tableModels));
        }
        object = this.tableModelFilters;
        synchronized (object) {
            this.models.add(new ArrayList(this.tableModelFilters));
        }
        object = this.nodeActionsProviders;
        synchronized (object) {
            this.models.add(new ArrayList(this.nodeActionsProviders));
        }
        object = this.nodeActionsProviderFilters;
        synchronized (object) {
            this.models.add(new ArrayList(this.nodeActionsProviderFilters));
        }
        object = this.columnModels;
        synchronized (object) {
            this.models.add(new ArrayList(this.columnModels));
        }
        object = this.mm;
        synchronized (object) {
            this.models.add(new ArrayList(this.mm));
        }
        if (this.rp != null) {
            this.models.add(this.rp);
        }
        List<AbstractButton> list = this.buttons;
        synchronized (list) {
            this.buttonsPane.removeAll();
            if (this.buttons.size() == 0 && this.sessionProviders.size() == 0) {
                this.buttonsPane.setVisible(false);
                object = null;
            } else {
                Serializable serializable;
                Object object2;
                this.buttonsPane.setVisible(true);
                int n = 0;
                if (this.sessionProviders.size() > 0) {
                    object2 = this.createSessionsSwitchButton();
                    Serializable serializable2 = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0);
                    this.buttonsPane.add((Component)object2, serializable2);
                    serializable = new JSeparator(0);
                    serializable2 = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 5, 0), 0, 0);
                    this.buttonsPane.add((Component)serializable, serializable2);
                    ++n;
                }
                if (this.tabbedPane != null) {
                    object = new JPanel();
                    ((Container)object).setLayout(new GridBagLayout());
                    object2 = new GridBagConstraints(0, n, 1, 1, 0.0, 1.0, 11, 3, new Insets(5, 0, 5, 0), 0, 0);
                    this.buttonsPane.add((Component)object, object2);
                    ++n;
                } else {
                    object = null;
                    for (Serializable serializable2 : this.buttons) {
                        serializable = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0);
                        this.buttonsPane.add((Component)serializable2, serializable);
                        ++n;
                    }
                }
            }
        }
        final boolean bl = this.treeModels.size() > 0 || this.nodeModels.size() > 0 || this.tableModels.size() > 0;
        final Models.CompoundModel compoundModel = bl ? Models.createCompoundModel((List)this.models, (String)this.propertiesHelpID) : null;
        SwingUtilities.invokeLater(new Runnable((JComponent)object){
            final /* synthetic */ JComponent val$buttonsSubPane;
            {
                this.val$buttonsSubPane = jComponent;
            }

            public void run() {
                if (ViewModelListener.this.view.getComponentCount() > 0) {
                    if (ViewModelListener.this.tabbedPane == null && ViewModelListener.this.view.getComponent(0) instanceof JTabbedPane) {
                        ViewModelListener.this.view.removeAll();
                    } else if (ViewModelListener.this.tabbedPane != null) {
                        ViewModelListener.this.view.removeAll();
                    }
                }
                if (ViewModelListener.this.view.getComponentCount() == 0) {
                    if (bl) {
                        ViewModelListener.this.view.add(Models.createView((Models.CompoundModel)compoundModel));
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    } else if (ViewModelListener.this.tabbedPane != null) {
                        int n = ViewModelListener.this.tabbedPane.getTabCount();
                        for (int i = 0; i < n; ++i) {
                            Component component = ViewModelListener.this.tabbedPane.getComponentAt(i);
                            if (component instanceof JPanel) {
                                component = (Component)((JPanel)component).getClientProperty(JLabel.class.getName());
                            }
                            if (!(component instanceof JLabel)) continue;
                            String string = ((JLabel)component).getText();
                            if (ViewModelListener.this.providerToDisplay != null) {
                                string = ViewModelListener.this.providerToDisplay.getTypeID() + "/" + string;
                            }
                            JPanel jPanel = new JPanel(new BorderLayout());
                            ViewModelListener.this.subListeners.add(new ViewModelListener(ViewModelListener.this.viewType + "/" + string, jPanel, this.val$buttonsSubPane, ViewModelListener.this.propertiesHelpID, ViewModelListener.this.viewIcon));
                            ViewModelListener.this.tabbedPane.setComponentAt(i, jPanel);
                            jPanel.putClientProperty(JLabel.class.getName(), component);
                        }
                        ViewModelListener.this.view.add(ViewModelListener.this.tabbedPane);
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    }
                } else if (ViewModelListener.this.tabbedPane == null) {
                    if (!bl) {
                        ViewModelListener.this.view.removeAll();
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    } else {
                        JComponent jComponent = (JComponent)ViewModelListener.this.view.getComponent(0);
                        Models.setModelsToView((JComponent)jComponent, (Models.CompoundModel)compoundModel);
                    }
                }
            }
        });
    }

    private JButton createSessionsSwitchButton() {
        final JButton jButton = new JButton(new ImageIcon(this.viewIcon));
        jButton.setToolTipText(NbBundle.getMessage(ViewModelListener.class, (String)"Tooltip_SelectSrc"));
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jButton) {
                    Object object;
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    if (ViewModelListener.this.currentSession != null) {
                        object = new JMenuItem(ViewModelListener.this.currentSession.getName());
                        ((JComponent)object).putClientProperty("SESSION", ViewModelListener.this.currentSession);
                        ((AbstractButton)object).addActionListener(this);
                        jPopupMenu.add((JMenuItem)object);
                    }
                    for (SessionProvider sessionProvider : ViewModelListener.this.sessionProviders) {
                        JMenuItem jMenuItem = new JMenuItem(sessionProvider.getSessionName());
                        jMenuItem.putClientProperty("SESSION", sessionProvider);
                        jMenuItem.addActionListener(this);
                        jPopupMenu.add(jMenuItem);
                    }
                    object = jButton.getMousePosition();
                    if (object == null) {
                        object = new Point(jButton.getWidth(), jButton.getHeight());
                    }
                    jPopupMenu.show(jButton, ((Point)object).x, ((Point)object).y);
                } else {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    Object object = jMenuItem.getClientProperty("SESSION");
                    ViewModelListener viewModelListener = ViewModelListener.this;
                    synchronized (viewModelListener) {
                        if (object instanceof Session) {
                            ViewModelListener.this.providerToDisplay = null;
                        } else {
                            ViewModelListener.this.providerToDisplay = (SessionProvider)object;
                        }
                    }
                    ViewModelListener.this.updateModel();
                }
            }
        });
        return jButton;
    }

    private Models.CompoundModel createCompound(String string, Set set, Set set2, Set set3, Set set4) {
        String string2;
        DebuggerManager debuggerManager;
        DebuggerManager debuggerManager2 = DebuggerManager.getDebuggerManager();
        DebuggerEngine debuggerEngine = debuggerManager2.getCurrentEngine();
        List list = debuggerEngine == null ? debuggerManager2.lookup(string, SessionProvider.class) : DebuggerManager.join((ContextProvider)debuggerEngine, (ContextProvider)debuggerManager2).lookup(string, SessionProvider.class);
        if (!list.contains(this.providerToDisplay)) {
            this.providerToDisplay = null;
        }
        if (debuggerEngine == null && this.providerToDisplay == null && list.size() > 0) {
            this.providerToDisplay = (SessionProvider)list.get(0);
        }
        if (this.providerToDisplay != null) {
            debuggerEngine = null;
            debuggerManager = debuggerManager2;
            string2 = string + "/" + this.providerToDisplay.getTypeID();
        } else {
            debuggerManager = debuggerEngine != null ? DebuggerManager.join((ContextProvider)debuggerEngine, (ContextProvider)debuggerManager2) : debuggerManager2;
            string2 = string;
        }
        List list2 = debuggerManager.lookup(string2, TreeModel.class);
        List list3 = debuggerManager.lookup(string2, TreeModelFilter.class);
        List list4 = debuggerManager.lookup(string2, TreeExpansionModel.class);
        List list5 = debuggerManager.lookup(string2, NodeModel.class);
        List list6 = debuggerManager.lookup(string2, NodeModelFilter.class);
        List list7 = debuggerManager.lookup(string2, TableModel.class);
        List list8 = debuggerManager.lookup(string2, TableModelFilter.class);
        List list9 = debuggerManager.lookup(string2, NodeActionsProvider.class);
        List list10 = debuggerManager.lookup(string2, NodeActionsProviderFilter.class);
        list3 = this.excludeKnownFilters(list3, set);
        list6 = this.excludeKnownFilters(list6, set2);
        list8 = this.excludeKnownFilters(list8, set3);
        list10 = this.excludeKnownFilters(list10, set4);
        ArrayList<List> arrayList = new ArrayList<List>(11);
        arrayList.add(list2);
        arrayList.add(list3);
        arrayList.add(list4);
        arrayList.add(list5);
        arrayList.add(list6);
        arrayList.add(list7);
        arrayList.add(list8);
        arrayList.add(list9);
        arrayList.add(list10);
        arrayList.add(Collections.EMPTY_LIST);
        arrayList.add(Collections.EMPTY_LIST);
        Models.CompoundModel compoundModel = Models.createCompoundModel(arrayList);
        return compoundModel;
    }

    private List excludeKnownFilters(List list, Set set) {
        ArrayList arrayList = new ArrayList();
        for (Object e : list) {
            if (set.contains(e)) continue;
            arrayList.add(e);
            set.add(e);
        }
        return arrayList;
    }

    private class ViewPreferenceChangeListener
    implements PreferenceChangeListener {
        private ViewPreferenceChangeListener() {
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            if ("show_watches".equals(string) || "show_evaluator_result".equals(string)) {
                ViewModelListener.this.updateModel();
            }
        }
    }

    private class ModelsChangeRefresher
    implements PropertyChangeListener,
    Runnable {
        private RequestProcessor.Task task;

        private ModelsChangeRefresher() {
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.task == null) {
                this.task = new RequestProcessor(ModelsChangeRefresher.class.getName(), 1).create((Runnable)this);
            }
            this.task.schedule(1);
        }

        public void run() {
            ViewModelListener.this.refreshModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnionTreeModel
    implements TreeModel,
    ExtendedNodeModel,
    NodeActionsProvider,
    TableModel,
    TreeExpansionModel,
    ModelListener {
        private Collection<Models.CompoundModel> compoundModels;
        private Map<String, Models.CompoundModel> compoundModelsByViewName;
        private List<Models.CompoundModel> orderedModels;
        private final Collection<ModelListener> modelListeners = new HashSet<ModelListener>();

        UnionTreeModel(Map<String, Models.CompoundModel> map, Models.CompoundModel compoundModel) {
            this.compoundModelsByViewName = map;
            this.compoundModels = map.values();
            this.orderedModels = new ArrayList<Models.CompoundModel>(this.compoundModels);
            this.orderedModels.remove(compoundModel);
            this.orderedModels.add(compoundModel);
        }

        public Object getRoot() {
            return "Root";
        }

        public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
            if (object == "Root") {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Models.CompoundModel objectArray3 : this.orderedModels) {
                    try {
                        Object[] unknownTypeException = objectArray3.getChildren(object, 0, objectArray3.getChildrenCount(object));
                        for (int i = 0; i < unknownTypeException.length; ++i) {
                            if ("HistoryNode".equals(unknownTypeException[i].getClass().getSimpleName())) continue;
                            arrayList.add(unknownTypeException[i]);
                        }
                    }
                    catch (UnknownTypeException unknownTypeException) {
                    }
                }
                Object[] objectArray = new Object[arrayList.size()];
                arrayList.toArray(objectArray);
                if (n2 > objectArray.length) {
                    n2 = objectArray.length;
                }
                if (n <= n2 && (n > 0 || n2 < objectArray.length)) {
                    Object[] unknownTypeException = new Object[n2 - n];
                    System.arraycopy(objectArray, n, unknownTypeException, 0, unknownTypeException.length);
                    return unknownTypeException;
                }
                return objectArray;
            }
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    return compoundModel.getChildren(object, n, n2);
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public boolean isLeaf(Object object) throws UnknownTypeException {
            boolean bl = false;
            boolean bl2 = false;
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    bl |= compoundModel.isLeaf(object);
                    bl2 = true;
                }
                catch (UnknownTypeException unknownTypeException) {}
            }
            if (!bl2) {
                throw new UnknownTypeException(object);
            }
            return bl;
        }

        public int getChildrenCount(Object object) throws UnknownTypeException {
            if (object == "Root") {
                int n = 0;
                for (Models.CompoundModel compoundModel : this.compoundModels) {
                    int n2 = compoundModel.getChildrenCount(object);
                    if (n2 == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    n += n2;
                }
                return n;
            }
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    return compoundModel.getChildrenCount(object);
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addModelListener(ModelListener modelListener) {
            Collection<ModelListener> collection = this.modelListeners;
            synchronized (collection) {
                if (this.modelListeners.size() == 0) {
                    for (Models.CompoundModel compoundModel : this.compoundModels) {
                        compoundModel.addModelListener(modelListener);
                    }
                }
                this.modelListeners.add(modelListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeModelListener(ModelListener modelListener) {
            Collection<ModelListener> collection = this.modelListeners;
            synchronized (collection) {
                this.modelListeners.remove(modelListener);
                if (this.modelListeners.size() == 0) {
                    for (Models.CompoundModel compoundModel : this.compoundModels) {
                        compoundModel.addModelListener(modelListener);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(ModelEvent modelEvent) {
            ArrayList<ModelListener> arrayList;
            ModelEvent modelEvent2 = this.translateEvent(modelEvent, this);
            Object object = this.modelListeners;
            synchronized (object) {
                arrayList = new ArrayList<ModelListener>(this.modelListeners);
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                ((ModelListener)object.next()).modelChanged(modelEvent2);
            }
        }

        private ModelEvent translateEvent(ModelEvent modelEvent, Object object) {
            Object object2 = modelEvent instanceof ModelEvent.NodeChanged ? new ModelEvent.NodeChanged(object, ((ModelEvent.NodeChanged)modelEvent).getNode(), ((ModelEvent.NodeChanged)modelEvent).getChange()) : (modelEvent instanceof ModelEvent.TableValueChanged ? new ModelEvent.TableValueChanged(object, ((ModelEvent.TableValueChanged)modelEvent).getNode(), ((ModelEvent.TableValueChanged)modelEvent).getColumnID()) : (modelEvent instanceof ModelEvent.TreeChanged ? new ModelEvent.TreeChanged(object) : modelEvent));
            return object2;
        }

        public boolean canRename(Object object) throws UnknownTypeException {
            boolean bl = false;
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    bl |= compoundModel.canRename(object);
                }
                catch (UnknownTypeException unknownTypeException) {}
            }
            return bl;
        }

        public boolean canCopy(Object object) throws UnknownTypeException {
            boolean bl = false;
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    bl |= compoundModel.canCopy(object);
                }
                catch (UnknownTypeException unknownTypeException) {}
            }
            return bl;
        }

        public boolean canCut(Object object) throws UnknownTypeException {
            boolean bl = false;
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    bl |= compoundModel.canCut(object);
                }
                catch (UnknownTypeException unknownTypeException) {}
            }
            return bl;
        }

        public Transferable clipboardCopy(Object object) throws IOException, UnknownTypeException {
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    return compoundModel.clipboardCopy(object);
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public Transferable clipboardCut(Object object) throws IOException, UnknownTypeException {
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    return compoundModel.clipboardCut(object);
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public PasteType[] getPasteTypes(Object object, Transferable transferable) throws UnknownTypeException {
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    return compoundModel.getPasteTypes(object, transferable);
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public void setName(Object object, String string) throws UnknownTypeException {
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    compoundModel.setName(object, string);
                    return;
                }
                catch (UnknownTypeException unknownTypeException) {
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    return compoundModel.getIconBaseWithExtension(object);
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public String getDisplayName(Object object) throws UnknownTypeException {
            String string = null;
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    string = compoundModel.getDisplayName(object);
                    if (string == null || string.trim().length() <= 0) continue;
                    return string;
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            if (string == null) {
                throw new UnknownTypeException(object);
            }
            return string;
        }

        public String getIconBase(Object object) throws UnknownTypeException {
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    return compoundModel.getIconBase(object);
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public String getShortDescription(Object object) throws UnknownTypeException {
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    return compoundModel.getShortDescription(object);
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public void performDefaultAction(Object object) throws UnknownTypeException {
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    compoundModel.performDefaultAction(object);
                    return;
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public Action[] getActions(Object object) throws UnknownTypeException {
            boolean bl = false;
            ArrayList<Action> arrayList = new ArrayList<Action>();
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    Action[] actionArray = compoundModel.getActions(object);
                    for (int i = 0; i < actionArray.length; ++i) {
                        arrayList.add(actionArray[i]);
                    }
                    bl = true;
                }
                catch (UnknownTypeException unknownTypeException) {}
            }
            if (!bl) {
                throw new UnknownTypeException(object);
            }
            Action[] actionArray = new Action[arrayList.size()];
            arrayList.toArray(actionArray);
            return actionArray;
        }

        private String adjustColumn(String string, String string2) {
            if ("WatchesView".equals(string)) {
                if ("LocalsType".equals(string2)) {
                    string2 = "WatchType";
                } else if ("LocalsValue".equals(string2)) {
                    string2 = "WatchValue";
                } else if ("LocalsToString".equals(string2)) {
                    string2 = "WatchToString";
                }
            }
            return string2;
        }

        public Object getValueAt(Object object, String string) throws UnknownTypeException {
            for (String string2 : this.compoundModelsByViewName.keySet()) {
                Models.CompoundModel compoundModel = this.compoundModelsByViewName.get(string2);
                String string3 = this.adjustColumn(string2, string);
                try {
                    return compoundModel.getValueAt(object, string3);
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
            for (String string2 : this.compoundModelsByViewName.keySet()) {
                Models.CompoundModel compoundModel = this.compoundModelsByViewName.get(string2);
                String string3 = this.adjustColumn(string2, string);
                try {
                    return compoundModel.isReadOnly(object, string3);
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
            for (String string2 : this.compoundModelsByViewName.keySet()) {
                Models.CompoundModel compoundModel = this.compoundModelsByViewName.get(string2);
                String string3 = this.adjustColumn(string2, string);
                try {
                    compoundModel.setValueAt(object, string3, object2);
                    return;
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public boolean isExpanded(Object object) throws UnknownTypeException {
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                try {
                    return compoundModel.isExpanded(object);
                }
                catch (UnknownTypeException unknownTypeException) {
                }
            }
            throw new UnknownTypeException(object);
        }

        public void nodeExpanded(Object object) {
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                compoundModel.nodeExpanded(object);
            }
        }

        public void nodeCollapsed(Object object) {
            for (Models.CompoundModel compoundModel : this.compoundModels) {
                compoundModel.nodeCollapsed(object);
            }
        }
    }
}

