/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Controller;

public abstract class BreakpointType {
    public abstract String getCategoryDisplayName();

    public String getTypeDisplayName() {
        return null;
    }

    public abstract JComponent getCustomizer();

    public Controller getController() {
        return null;
    }

    public abstract boolean isDefault();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContextAware
    extends BreakpointType
    implements ContextAwareService<BreakpointType> {
        private String serviceName;
        private String displayName;
        private ContextProvider context;
        private BreakpointType delegate;

        private ContextAware(String string, String string2) {
            this.serviceName = string;
            this.displayName = string2;
        }

        private ContextAware(String string, String string2, ContextProvider contextProvider) {
            this.serviceName = string;
            this.displayName = string2;
            this.context = contextProvider;
        }

        private synchronized BreakpointType getDelegate() {
            if (this.delegate == null) {
                this.delegate = (BreakpointType)ContextAwareSupport.createInstance((String)this.serviceName, (ContextProvider)this.context);
            }
            return this.delegate;
        }

        public BreakpointType forContext(ContextProvider contextProvider) {
            if (contextProvider == this.context) {
                return this;
            }
            return new ContextAware(this.serviceName, this.displayName, contextProvider);
        }

        @Override
        public String getTypeDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return this.getDelegate().getTypeDisplayName();
        }

        @Override
        public JComponent getCustomizer() {
            return this.getDelegate().getCustomizer();
        }

        @Override
        public String getCategoryDisplayName() {
            return this.getDelegate().getCategoryDisplayName();
        }

        @Override
        public boolean isDefault() {
            return this.getDelegate().isDefault();
        }

        static ContextAwareService createService(Map map) throws ClassNotFoundException {
            String string = (String)map.get("serviceName");
            String string2 = (String)map.get("displayName");
            return new ContextAware(string, string2);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String displayName();

        public String path() default "";

        public int position() default 0x7FFFFFFF;
    }
}

