/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.server.RemoteServerSetup;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.setup.HostSetupProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RemoteServerRecord
implements ServerRecord {
    public static final String PROP_STATE_CHANGED = "stateChanged";
    private final ExecutionEnvironment executionEnvironment;
    private final boolean editable;
    private boolean deleted;
    private State state;
    private final Object stateLock;
    private String reason;
    private String displayName;
    private RemoteSyncFactory syncFactory;
    private static final Logger log = Logger.getLogger("cnd.remote.logger");

    RemoteServerRecord(ExecutionEnvironment executionEnvironment, String string, RemoteSyncFactory remoteSyncFactory, boolean bl) {
        CndUtils.assertTrue((executionEnvironment != null ? 1 : 0) != 0);
        CndUtils.assertTrue((remoteSyncFactory != null ? 1 : 0) != 0);
        this.executionEnvironment = executionEnvironment;
        this.syncFactory = remoteSyncFactory;
        this.stateLock = new String("RemoteServerRecord state lock for " + this.toString());
        this.reason = null;
        this.deleted = false;
        this.displayName = this.escape(string);
        if (executionEnvironment.isLocal()) {
            this.editable = false;
            this.state = State.ONLINE;
        } else {
            this.editable = true;
            this.state = bl ? State.UNINITIALIZED : State.OFFLINE;
        }
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public String toString() {
        return this.executionEnvironment.toString();
    }

    public synchronized void validate(boolean bl) {
        Object object;
        if (this.isOnline()) {
            return;
        }
        log.fine("RSR.validate2: Validating " + this.toString());
        if (bl) {
            object = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RemoteServerRecord.class, (String)"PBAR_ConnectingTo", (Object)this.getDisplayName()));
            object.start();
            this.init(null);
            object.finish();
        }
        object = this.isOnline() ? NbBundle.getMessage(RemoteServerRecord.class, (String)"Validation_OK", (Object)this.getDisplayName()) : NbBundle.getMessage(RemoteServerRecord.class, (String)"Validation_ERR", (Object)this.getDisplayName(), (Object)this.getStateAsText(), (Object)this.getReason());
        StatusDisplayer.getDefault().setStatusText((String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(PropertyChangeSupport propertyChangeSupport) {
        assert (!SwingUtilities.isEventDispatchThread()) : "RemoteServer initialization must be done out of EDT";
        State state = this.state;
        this.state = State.INITIALIZING;
        RemoteServerSetup remoteServerSetup = new RemoteServerSetup(this.getExecutionEnvironment());
        if (remoteServerSetup.needsSetupOrUpdate()) {
            remoteServerSetup.setup();
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (remoteServerSetup.isCancelled()) {
                this.state = State.CANCELLED;
            } else if (remoteServerSetup.isFailed()) {
                this.state = State.OFFLINE;
                this.reason = remoteServerSetup.getReason();
            } else {
                RemotePathMap.getRemotePathMapInstance(this.getExecutionEnvironment()).init();
                this.state = State.ONLINE;
            }
        }
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(PROP_STATE_CHANGED, (Object)state, (Object)this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetOfflineState() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.INITIALIZING && this.state != State.ONLINE) {
                this.state = State.UNINITIALIZED;
                return true;
            }
        }
        return false;
    }

    public String getStateAsText() {
        return NbBundle.getMessage(RemoteServerRecord.class, (String)this.state.toString());
    }

    public boolean isOnline() {
        return this.state == State.ONLINE;
    }

    public boolean isOffline() {
        return this.state == State.OFFLINE;
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isRemote() {
        return this.executionEnvironment.isRemote();
    }

    public String getDisplayName() {
        return this.displayName != null && this.displayName.length() > 0 ? this.displayName : this.executionEnvironment.getDisplayName();
    }

    String getRawDisplayName() {
        return this.displayName;
    }

    public String getServerDisplayName() {
        if (this.displayName == null || this.displayName.length() == 0) {
            if (this.executionEnvironment.isLocal()) {
                return "localhost";
            }
            return this.executionEnvironment.getHost();
        }
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = this.escape(string);
    }

    private String escape(String string) {
        if (string != null) {
            string = string.replace('|', '_');
            string = string.replace(',', '_');
        }
        return string;
    }

    public String getServerName() {
        return this.executionEnvironment.getHost();
    }

    public String getUserName() {
        return this.executionEnvironment.getUser();
    }

    public String getReason() {
        return this.reason == null ? "" : this.reason;
    }

    public RemoteSyncFactory getSyncFactory() {
        return this.syncFactory;
    }

    public void setSyncFactory(RemoteSyncFactory remoteSyncFactory) {
        this.syncFactory = remoteSyncFactory;
    }

    void setState(State state) {
        this.state = state;
    }

    public boolean isSetUp() {
        Collection collection = Lookup.getDefault().lookupAll(HostSetupProvider.class);
        for (HostSetupProvider hostSetupProvider : collection) {
            if (!hostSetupProvider.canCheckSetup(this.executionEnvironment)) continue;
            return hostSetupProvider.isSetUp(this.executionEnvironment);
        }
        return true;
    }

    public boolean setUp() {
        Collection collection = Lookup.getDefault().lookupAll(HostSetupProvider.class);
        for (HostSetupProvider hostSetupProvider : collection) {
            if (!hostSetupProvider.canCheckSetup(this.executionEnvironment)) continue;
            return hostSetupProvider.setUp(this.executionEnvironment);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNINITIALIZED,
        INITIALIZING,
        ONLINE,
        OFFLINE,
        CANCELLED;

    }
}

