/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCommandSupport
extends RemoteConnectionSupport {
    private BufferedReader in;
    private StringWriter out;
    private final String cmd;
    private final Map<String, String> env;
    private final String[] args;
    private boolean interrupted = false;

    public static int run(ExecutionEnvironment executionEnvironment, String string) {
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(executionEnvironment, string);
        return remoteCommandSupport.run();
    }

    public static int run(ExecutionEnvironment executionEnvironment, String string, String ... stringArray) {
        RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(executionEnvironment, string, null, stringArray);
        return remoteCommandSupport.run();
    }

    public RemoteCommandSupport(ExecutionEnvironment executionEnvironment, String string, Map<String, String> map, String ... stringArray) {
        super(executionEnvironment);
        this.cmd = string;
        this.env = map;
        this.args = stringArray;
    }

    public RemoteCommandSupport(ExecutionEnvironment executionEnvironment, String string, Map<String, String> map) {
        super(executionEnvironment);
        this.cmd = string;
        this.env = map;
        this.args = null;
    }

    public RemoteCommandSupport(ExecutionEnvironment executionEnvironment, String string) {
        this(executionEnvironment, string, null);
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        if (!this.isFailedOrCancelled()) {
            Object object;
            log.fine("RemoteCommandSupport<Init>: Running [" + this.cmd + "] on " + this.executionEnvironment);
            if (SwingUtilities.isEventDispatchThread()) {
                object = "Running remote command in EDT: " + this.cmd;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, (String)object, new Exception((String)object));
                } else {
                    log.warning((String)object);
                }
            }
            try {
                String string;
                object = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
                if (this.args == null) {
                    object.setCommandLine(this.cmd);
                } else {
                    object.setExecutable(this.cmd);
                    object.setArguments(this.args);
                }
                object.addEnvironmentVariables(this.env);
                NativeProcess nativeProcess = object.call();
                InputStream inputStream = nativeProcess.getInputStream();
                if (inputStream == null) {
                    throw new IOException("process (" + nativeProcess.getClass().getName() + ") returned null input stream");
                }
                this.in = new BufferedReader(new InputStreamReader(inputStream));
                this.out = new StringWriter();
                while ((string = this.in.readLine()) != null) {
                    if (string == null) continue;
                    this.out.write(string + '\n');
                    this.out.flush();
                }
                int n = nativeProcess.waitFor();
                log.fine("RemoteCommandSupport: " + this.cmd + " on " + this.executionEnvironment + " finished; rc=" + n);
                if (n != 0 && log.isLoggable(Level.FINEST)) {
                    String string2;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(nativeProcess.getErrorStream()));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        log.finest("RemoteCommandSupport ERROR: " + string2);
                    }
                }
                this.setExitStatus(n);
            }
            catch (InterruptedException interruptedException) {
                this.interrupted = true;
                log.log(Level.FINEST, "Interrupted", interruptedException);
            }
            catch (InterruptedIOException interruptedIOException) {
                this.interrupted = true;
                log.log(Level.FINEST, "Interrupted", interruptedIOException);
            }
            catch (IOException iOException) {
                log.warning("IO failure during running " + this.cmd);
            }
            finally {
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }
        return this.getExitStatus();
    }

    public String toString() {
        return this.getOutput();
    }

    public String getOutput() {
        if (this.out != null) {
            return this.out.toString();
        }
        return "";
    }
}

