/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Exceptions;

public class RemoteCopySupport
extends RemoteConnectionSupport {
    private static final Logger LOG = Logger.getLogger("cnd.remote.logger");

    public RemoteCopySupport(ExecutionEnvironment executionEnvironment) {
        super(executionEnvironment);
    }

    public static boolean copyFrom(ExecutionEnvironment executionEnvironment, String string, String string2) {
        RemoteCopySupport remoteCopySupport = new RemoteCopySupport(executionEnvironment);
        return remoteCopySupport.copyFrom(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFrom(String string, String string2) {
        FileOutputStream fileOutputStream = null;
        try {
            String string3 = null;
            if (new File(string2).isDirectory()) {
                string3 = string2 + File.separator;
            }
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
            nativeProcessBuilder.setExecutable("scp");
            nativeProcessBuilder.setArguments(new String[]{"-f", string});
            NativeProcess nativeProcess = nativeProcessBuilder.call();
            OutputStream outputStream = nativeProcess.getOutputStream();
            InputStream inputStream = nativeProcess.getInputStream();
            byte[] byArray = new byte[1024];
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
            while (true) {
                long l = System.currentTimeMillis();
                int n = RemoteCopySupport.checkAck(inputStream);
                if (n != 67) break;
                inputStream.read(byArray, 0, 5);
                long l2 = 0L;
                while (inputStream.read(byArray, 0, 1) >= 0 && byArray[0] != 32) {
                    l2 = l2 * 10L + (long)(byArray[0] - 48);
                }
                String string4 = null;
                int n2 = 0;
                while (true) {
                    inputStream.read(byArray, n2, 1);
                    if (byArray[n2] == 10) break;
                    ++n2;
                }
                string4 = new String(byArray, 0, n2);
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
                fileOutputStream = new FileOutputStream(string3 == null ? string2 : string3 + string4);
                do {
                    n2 = (long)byArray.length < l2 ? byArray.length : (int)l2;
                    if ((n2 = inputStream.read(byArray, 0, n2)) < 0) break;
                    fileOutputStream.write(byArray, 0, n2);
                } while ((l2 -= (long)n2) != 0L);
                fileOutputStream.close();
                fileOutputStream = null;
                if (RemoteCopySupport.checkAck(inputStream) != 0) {
                    boolean bl = false;
                    return bl;
                }
                byArray[0] = 0;
                outputStream.write(byArray, 0, 1);
                outputStream.flush();
                LOG.finest("Copying: filesize=" + l2 + "b, file=" + string4 + " took " + (System.currentTimeMillis() - l) + " ms");
            }
            this.setExitStatus(nativeProcess.waitFor());
        }
        catch (InterruptedIOException interruptedIOException) {
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return this.getExitStatus() == 0;
    }

    public static boolean copyTo(ExecutionEnvironment executionEnvironment, String string, String string2) {
        RemoteCopySupport remoteCopySupport = new RemoteCopySupport(executionEnvironment);
        return remoteCopySupport.copyTo(string, string2);
    }

    public boolean copyTo(String string, String string2) {
        Future future = CommonTasksSupport.uploadFile((String)string, (ExecutionEnvironment)this.executionEnvironment, (String)string2, (int)509, null);
        try {
            Integer n = (Integer)future.get();
            if (n != null) {
                return n == 0;
            }
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        return false;
    }

    private static int checkAck(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == 0) {
            return n;
        }
        if (n == -1) {
            return n;
        }
        if (n == 1 || n == 2) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                n2 = inputStream.read();
                stringBuffer.append((char)n2);
            } while (n2 != 10);
            if (n == 1) {
                LOG.warning("Error: Invalid value during reading remote string: " + stringBuffer.toString());
            }
            if (n == 2) {
                LOG.warning("Fatal error: Invalid value during reading remote string: " + stringBuffer.toString());
            }
        }
        return n;
    }
}

