/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteNativeExecutionSupport
extends RemoteConnectionSupport {
    private static String displayString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteNativeExecutionSupport(ExecutionEnvironment executionEnvironment, File file, String string, String string2, Map<String, String> map, PrintWriter printWriter, Reader reader) {
        super(executionEnvironment);
        log.fine("RNES<Init>: Running [" + string + "] on " + this.executionEnvironment);
        try {
            int n;
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
            nativeProcessBuilder.setExecutable(string);
            nativeProcessBuilder.addEnvironmentVariables(map);
            if (string2 != null) {
                nativeProcessBuilder.setArguments(Utilities.parseParameters((String)string2));
            }
            nativeProcessBuilder.redirectError();
            if (map == null || !map.containsKey("DISPLAY")) {
                nativeProcessBuilder.setX11Forwarding(true);
            }
            String string3 = null;
            if (file != null) {
                string3 = RemotePathMap.getPathMap(this.executionEnvironment).getRemotePath(file.getAbsolutePath(), true);
                if (log.isLoggable(Level.FINEST) && string3.contains(" ")) {
                    log.finest("A PATH WITH A SPACE\n");
                }
                nativeProcessBuilder = nativeProcessBuilder.setWorkingDirectory(string3);
            }
            NativeProcess nativeProcess = nativeProcessBuilder.call();
            InputStream inputStream = nativeProcess.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            if (reader != null) {
                InputReaderThread inputReaderThread = new InputReaderThread(nativeProcess.getOutputStream(), new ReaderInputStream(reader));
                inputReaderThread.start();
            }
            while ((n = ((Reader)inputStreamReader).read()) != -1) {
                if (n == 10) {
                    printWriter.append('\n');
                    continue;
                }
                printWriter.append((char)n);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int n2 = nativeProcess.waitFor();
            if (n2 != 0 && log.isLoggable(Level.FINEST)) {
                Object object;
                Object object2;
                log.finest("RNES: " + string + " on " + this.executionEnvironment + " in " + string3 + " finished; rc=" + n2);
                if (map == null) {
                    log.finest("RNES: env == null");
                } else {
                    object2 = map.entrySet().iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        log.finest("\tRNES: " + (String)object.getKey() + "=" + (String)object.getValue());
                    }
                }
                object = new BufferedReader(new InputStreamReader(nativeProcess.getErrorStream()));
                while ((object2 = ((BufferedReader)object).readLine()) != null) {
                    log.finest("RNES ERROR: " + (String)object2);
                }
            }
            this.setExitStatus(n2);
            printWriter.flush();
            inputStream.close();
            ((Reader)inputStreamReader).close();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, iOException.getMessage(), iOException);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, exception.getMessage(), exception);
        }
        finally {
            log.finest("RNES return value: " + this.getExitStatus());
        }
    }

    private static String getDisplayString() {
        if (displayString == null) {
            try {
                String string = (String)PlatformInfo.getDefault((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).getEnv().get("DISPLAY");
                if (string == null) {
                    string = ":.0";
                }
                displayString = "DISPLAY=" + InetAddress.getLocalHost().getHostAddress() + string;
            }
            catch (UnknownHostException unknownHostException) {
                displayString = "";
            }
        }
        return displayString;
    }

    private static final class ReaderInputStream
    extends InputStream {
        private final Reader reader;

        public ReaderInputStream(Reader reader) {
            this.reader = reader;
        }

        public int read() throws IOException {
            int n = this.reader.read();
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = this.read();
            if (n3 == -1) {
                return -1;
            }
            byArray[n] = (byte)n3;
            return 1;
        }
    }

    private static final class InputReaderThread
    extends Thread {
        private InputStream in;
        private OutputStream pout;

        public InputReaderThread(OutputStream outputStream, InputStream inputStream) {
            this.pout = outputStream;
            this.in = inputStream;
            this.setName("inputReaderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int n;
                while ((n = this.in.read()) != -1) {
                    this.pout.write((char)n);
                    this.pout.flush();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.pout.flush();
                    this.pout.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

