/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.support.RemoteCopySupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemIncludesUtils {
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    private static final Map<ExecutionEnvironment, Collection<WeakReference<Loader>>> loaders = new LinkedHashMap<ExecutionEnvironment, Collection<WeakReference<Loader>>>();
    private static final Object loadersLock = new Object();
    private static final String tempDir = System.getProperty("java.io.tmpdir");

    public static Runnable createLoader(ExecutionEnvironment executionEnvironment, List<CompilerSet> list) {
        Loader loader = new Loader(executionEnvironment, list);
        SystemIncludesUtils.addLoader(executionEnvironment, loader);
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLoader(ExecutionEnvironment executionEnvironment, Loader loader) {
        Object object = loadersLock;
        synchronized (object) {
            Collection<WeakReference<Loader>> collection = loaders.get(executionEnvironment);
            if (collection == null) {
                collection = new ArrayList<WeakReference<Loader>>();
                loaders.put(executionEnvironment, collection);
            }
            collection.add(new WeakReference<Loader>(loader));
        }
    }

    public static void cancel(Collection<ExecutionEnvironment> collection) {
        for (ExecutionEnvironment executionEnvironment : collection) {
            SystemIncludesUtils.cancel(executionEnvironment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancel(ExecutionEnvironment executionEnvironment) {
        Collection<WeakReference<Loader>> collection;
        log.fine("Cancelling loaders for " + executionEnvironment);
        Iterator<WeakReference<Loader>> iterator = loadersLock;
        synchronized (iterator) {
            collection = loaders.get(executionEnvironment);
            loaders.remove(executionEnvironment);
        }
        if (collection != null) {
            for (WeakReference<Loader> weakReference : collection) {
                Loader loader = (Loader)weakReference.get();
                if (loader == null) continue;
                log.fine("Cancelling loader " + loader + " for " + executionEnvironment);
                loader.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doLoad(ExecutionEnvironment executionEnvironment, String string, Collection<String> collection, ProgressHandle progressHandle, AtomicBoolean atomicBoolean) {
        File file = new File(string);
        File file2 = new File(file.getParent(), file.getName() + ".download");
        if (file.exists()) {
            return true;
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file2.isDirectory()) {
            return false;
        }
        if (atomicBoolean.get()) {
            return false;
        }
        boolean bl = false;
        try {
            bl = SystemIncludesUtils.load(file2.getAbsolutePath(), executionEnvironment, collection, progressHandle, atomicBoolean);
            log.fine("SystemIncludesUtils.doLoad for " + file2 + " finished " + bl);
            if (bl) {
                log.fine("SystemIncludesUtils.doLoad renaming " + file2 + " to " + file);
                file2.renameTo(file);
            }
        }
        finally {
            if (!bl && file.exists()) {
                log.fine("SystemIncludesUtils.doLoad removing " + file + " due to faile");
                file.delete();
            }
        }
        return true;
    }

    private static boolean load(String string, ExecutionEnvironment executionEnvironment, Collection<String> collection, ProgressHandle progressHandle, AtomicBoolean atomicBoolean) {
        progressHandle.switchToDeterminate(3 * collection.size());
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        for (String string2 : collection) {
            String string3;
            if (atomicBoolean.get()) {
                bl = false;
                break;
            }
            log.fine("SystemIncludesUtils.load loading " + string2);
            String string4 = "cnd" + string2.replaceAll("(/|\\\\)", "-") + ".zip";
            String string5 = "/tmp/" + executionEnvironment.getUser() + '-' + string4;
            try {
                File file = File.createTempFile(string4, ".zip", new File(tempDir));
                string3 = file.getAbsolutePath();
            }
            catch (IOException iOException) {
                string3 = tempDir + File.separator + string4;
            }
            progressHandle.progress(SystemIncludesUtils.getMessage("SIU_Archiving") + " " + string2, n++);
            RemoteCommandSupport remoteCommandSupport = new RemoteCommandSupport(executionEnvironment, "zip -r -q " + string5 + " " + string2);
            remoteCommandSupport.run();
            if (!atomicBoolean.get()) {
                progressHandle.progress(SystemIncludesUtils.getMessage("SIU_Downloading") + " " + string2, n++);
                RemoteCopySupport remoteCopySupport = new RemoteCopySupport(executionEnvironment);
                remoteCopySupport.copyFrom(string5, string3);
            }
            remoteCommandSupport = new RemoteCommandSupport(executionEnvironment, "rm " + string5);
            remoteCommandSupport.run();
            if (atomicBoolean.get()) {
                bl = false;
                break;
            }
            progressHandle.progress(SystemIncludesUtils.getMessage("SIU_Preparing") + " " + string2, n++);
            SystemIncludesUtils.unzip(string, string3);
            arrayList.add(string3);
            log.fine("SystemIncludesUtils.load loading done for " + string2);
        }
        for (String string2 : arrayList) {
            new File(string2).delete();
        }
        return bl;
    }

    private static void unzip(String string, String string2) {
        long l = System.currentTimeMillis();
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdir();
            }
            assert (file.isDirectory());
            ZipFile zipFile = new ZipFile(string2);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                File file2 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                SystemIncludesUtils.copyInputStream(zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(file2.getAbsolutePath())));
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            log.warning("unzipping " + string2 + " to " + string + " failed");
            log.warning(iOException.getMessage());
            return;
        }
        log.fine("unzipping " + string2 + " to " + string + " took " + (System.currentTimeMillis() - l) + " ms");
    }

    private static final void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(SystemIncludesUtils.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Loader
    implements Runnable {
        private final ExecutionEnvironment execEnv;
        private final List<CompilerSet> csList;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private Thread thread;

        public Loader(ExecutionEnvironment executionEnvironment, List<CompilerSet> list) {
            this.execEnv = executionEnvironment;
            this.csList = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            this.cancelled.set(true);
            Loader loader = this;
            synchronized (loader) {
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.cancelled.get()) {
                return;
            }
            Loader loader = this;
            synchronized (loader) {
                this.thread = Thread.currentThread();
            }
            try {
                this.load();
            }
            finally {
                loader = this;
                synchronized (loader) {
                    this.thread = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load() {
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)(SystemIncludesUtils.getMessage("SIU_ProgressTitle") + " " + this.execEnv.getHost()));
            progressHandle.start();
            log.fine("SystemIncludesUtils.load for " + this.execEnv);
            String string = null;
            try {
                HashSet<String> hashSet = new HashSet<String>();
                for (CompilerSet compilerSet : this.csList) {
                    for (Tool tool : compilerSet.getTools()) {
                        if (!(tool instanceof BasicCompiler)) continue;
                        BasicCompiler basicCompiler = (BasicCompiler)tool;
                        string = basicCompiler.getIncludeFilePathPrefix();
                        for (String string2 : basicCompiler.getSystemIncludeDirectories()) {
                            String string3 = string2;
                            if (string3.length() < string.length()) {
                                log.warning("CompilerSet " + basicCompiler.getDisplayName() + " has returned invalid include path: " + string3);
                                continue;
                            }
                            hashSet.add(string3.substring(string.length()));
                        }
                    }
                }
                if (string != null) {
                    SystemIncludesUtils.doLoad(this.execEnv, string, hashSet, progressHandle, this.cancelled);
                }
            }
            finally {
                progressHandle.finish();
            }
        }
    }
}

