/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.BaseSyncWorker;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.NbBundle;

class ScpSyncWorker
extends BaseSyncWorker
implements RemoteSyncWorker {
    private Logger logger = Logger.getLogger("cnd.remote.logger");
    private FileFilter sharabilityFilter = new SharabilityFilter();
    private int plainFilesCount;
    private int dirCount;
    private long totalSize;

    public ScpSyncWorker(File file, ExecutionEnvironment executionEnvironment, PrintWriter printWriter, PrintWriter printWriter2) {
        super(file, executionEnvironment, printWriter, printWriter2);
    }

    protected String getRemoteSyncRoot() {
        String string = System.getProperty("cnd.remote.sync.root." + this.executionEnvironment.getHost());
        if (string != null) {
            return string;
        }
        string = System.getProperty("cnd.remote.sync.root");
        if (string != null) {
            return string;
        }
        String string2 = RemoteUtil.getHomeDirectory(this.executionEnvironment);
        return string2 == null ? null : string2 + "/.netbeans/remote";
    }

    public boolean synchronize() {
        boolean bl;
        block13: {
            String string = this.getRemoteSyncRoot();
            if (string == null) {
                if (this.err != null) {
                    this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Cant_find_sync_root", (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                }
                return false;
            }
            String string2 = string + '/' + this.localDir.getName();
            bl = false;
            try {
                boolean bl2;
                try {
                    bl2 = RemotePathMap.isTheSame(this.executionEnvironment, string2, this.localDir);
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.executionEnvironment.getHost() + ":" + string2 + " and " + this.localDir.getAbsolutePath() + (bl2 ? " are same - skipping" : " arent same - copying"));
                }
                if (!bl2) {
                    if (this.out != null) {
                        this.out.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Copying", (Object)string2, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                    }
                    this.synchronizeImpl(string2);
                }
                RemotePathMap remotePathMap = RemotePathMap.getRemotePathMapInstance(this.executionEnvironment);
                remotePathMap.addMapping(this.localDir.getParentFile().getAbsolutePath(), string);
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                this.logger.log(Level.FINEST, null, interruptedException);
            }
            catch (InterruptedIOException interruptedIOException) {
                this.logger.log(Level.FINEST, null, interruptedIOException);
            }
            catch (ExecutionException executionException) {
                this.logger.log(Level.FINE, null, executionException);
                if (this.err != null) {
                    this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)string2, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)executionException.getLocalizedMessage()));
                }
            }
            catch (IOException iOException) {
                this.logger.log(Level.FINE, null, iOException);
                if (this.err == null) break block13;
                this.err.printf("%s asdasd \n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)string2, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)iOException.getLocalizedMessage()));
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void synchronizeImpl(String string) throws InterruptedException, ExecutionException, IOException {
        this.dirCount = 0;
        this.plainFilesCount = 0;
        this.totalSize = 0L;
        long l = 0L;
        if (this.logger.isLoggable(Level.FINE)) {
            System.out.printf("Uploading %s ...\n", this.localDir.getAbsolutePath());
            l = System.currentTimeMillis();
        }
        boolean bl = false;
        CommonTasksSupport.mkDir((ExecutionEnvironment)this.executionEnvironment, (String)string, (Writer)this.err);
        ++this.dirCount;
        File[] fileArray = this.localDir.listFiles(this.sharabilityFilter);
        if (fileArray == null) {
            throw new IOException("Failed to get children of " + this.localDir);
        }
        for (File file : fileArray) {
            this.synchronizeImpl(file, string);
        }
        bl = true;
        if (this.logger.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis() - l;
            long l2 = this.totalSize * 1000L / l;
            String string2 = l2 < 8192L ? l2 + " b/s" : l2 / 1024L + " Kb/s";
            String string3 = this.totalSize < 1024L ? this.totalSize + " bytes" : this.totalSize / 1024L + " K";
            System.out.printf("Uploading %s in %d files in %d directories to %s took %d ms. %s. Avg. speed: %s\n", string3, this.plainFilesCount, this.dirCount, this.executionEnvironment, l, bl ? "OK" : "FAILURE", string2);
        }
    }

    private void synchronizeImpl(File file, String string) throws InterruptedException, ExecutionException, IOException {
        if (file.isDirectory()) {
            string = string + "/" + file.getName();
            Future future = CommonTasksSupport.mkDir((ExecutionEnvironment)this.executionEnvironment, (String)string, (Writer)this.err);
            ++this.dirCount;
            int n = (Integer)future.get();
            if (n != 0) {
                throw new IOException("creating directory " + string + " on " + this.executionEnvironment + " finished with error code " + n);
            }
            for (File file2 : file.listFiles(this.sharabilityFilter)) {
                this.synchronizeImpl(file2, string);
            }
        } else {
            if (file.length() == 0L) {
                return;
            }
            String string2 = file.getAbsolutePath();
            String string3 = string + '/' + file.getName();
            Future future = CommonTasksSupport.uploadFile((String)string2, (ExecutionEnvironment)this.executionEnvironment, (String)string3, (int)511, (Writer)this.err);
            int n = (Integer)future.get();
            ++this.plainFilesCount;
            this.totalSize += file.length();
            this.logger.finest("SCP: uploading " + string2 + " to " + string3 + " rc=" + n);
            if (n != 0) {
                throw new IOException("uploading " + string2 + " to " + string3 + " finished with error code " + n);
            }
        }
    }

    public boolean cancel() {
        return false;
    }
}

