/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.sync.SyncUtils;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HostPropertiesDialog
extends JPanel {
    private final ServerRecord serverRecord;
    private JComboBox cbSync;
    private JLabel lblHost;
    private JLabel lblName;
    private JLabel lblPort;
    private JLabel lblSync;
    private JLabel lblUser;
    private JTextField tfHost;
    private JTextField tfName;
    private JTextField tfPort;
    private JTextField tfUser;

    public static boolean invokeMe(RemoteServerRecord remoteServerRecord) {
        HostPropertiesDialog hostPropertiesDialog = new HostPropertiesDialog(remoteServerRecord);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)hostPropertiesDialog, NbBundle.getMessage(HostPropertiesDialog.class, (String)"TITLE_HostProperties"), true, 2, DialogDescriptor.OK_OPTION, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            RemoteSyncFactory remoteSyncFactory;
            String string = hostPropertiesDialog.tfName.getText();
            boolean bl = false;
            if (!string.equals(remoteServerRecord.getDisplayName())) {
                remoteServerRecord.setDisplayName(string);
                bl = true;
            }
            if (!(remoteSyncFactory = (RemoteSyncFactory)hostPropertiesDialog.cbSync.getSelectedItem()).equals(remoteServerRecord.getSyncFactory())) {
                remoteServerRecord.setSyncFactory(remoteSyncFactory);
                bl = true;
            }
            if (bl) {
                RemoteServerList.storePreferences(remoteServerRecord);
                return true;
            }
        }
        return false;
    }

    private HostPropertiesDialog(ServerRecord serverRecord) {
        this.serverRecord = serverRecord;
        this.initComponents();
        this.tfHost.setBackground(this.getBackground());
        this.tfPort.setBackground(this.getBackground());
        this.tfUser.setBackground(this.getBackground());
        this.tfName.setText(serverRecord.getDisplayName());
        this.tfHost.setText(serverRecord.getServerName());
        this.tfUser.setText(serverRecord.getUserName());
        this.tfPort.setText("" + serverRecord.getExecutionEnvironment().getSSHPort());
        SyncUtils.arrangeComboBox(this.cbSync, serverRecord.getExecutionEnvironment());
        this.cbSync.setSelectedItem(serverRecord.getSyncFactory());
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                HostPropertiesDialog.this.tfName.requestFocus();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private void initComponents() {
        this.lblHost = new JLabel();
        this.tfHost = new JTextField();
        this.lblPort = new JLabel();
        this.tfPort = new JTextField();
        this.lblUser = new JLabel();
        this.tfUser = new JTextField();
        this.lblName = new JLabel();
        this.tfName = new JTextField();
        this.lblSync = new JLabel();
        this.cbSync = new JComboBox();
        this.setFocusCycleRoot(true);
        this.lblHost.setLabelFor(this.tfHost);
        Mnemonics.setLocalizedText((JLabel)this.lblHost, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblHost.text"));
        this.tfHost.setEditable(false);
        this.tfHost.setText(NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.tfHost.text"));
        this.lblPort.setLabelFor(this.tfPort);
        Mnemonics.setLocalizedText((JLabel)this.lblPort, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblPort.text"));
        this.tfPort.setEditable(false);
        this.tfPort.setText(NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.tfPort.text"));
        this.lblUser.setLabelFor(this.tfUser);
        Mnemonics.setLocalizedText((JLabel)this.lblUser, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblUser.text"));
        this.tfUser.setEditable(false);
        this.tfUser.setText(NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.tfUser.text"));
        this.lblName.setLabelFor(this.tfName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblName.text"));
        this.tfName.setText(NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.tfName.text"));
        this.lblSync.setLabelFor(this.cbSync);
        Mnemonics.setLocalizedText((JLabel)this.lblSync, (String)NbBundle.getMessage(HostPropertiesDialog.class, (String)"HostPropertiesDialog.lblSync.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblName).add((Component)this.lblUser).add((Component)this.lblHost)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.tfHost, -1, 236, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.lblPort).addPreferredGap(0).add((Component)this.tfPort, -2, 54, -2)).add((Component)this.tfUser, -1, 347, Short.MAX_VALUE).add((Component)this.tfName, -1, 347, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblSync).add(18, 18, 18).add((Component)this.cbSync, 0, 289, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblHost).add((Component)this.tfHost, -2, -1, -2).add((Component)this.tfPort, -2, -1, -2).add((Component)this.lblPort)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblUser).add((Component)this.tfUser, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.tfName, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblSync).add((Component)this.cbSync, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

