/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mozilla.nb.javascript.CompilerEnvirons;
import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.Decompiler;
import org.mozilla.nb.javascript.ErrorReporter;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.IRFactory;
import org.mozilla.nb.javascript.Kit;
import org.mozilla.nb.javascript.Node;
import org.mozilla.nb.javascript.ObjArray;
import org.mozilla.nb.javascript.ScriptOrFnNode;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Token;
import org.mozilla.nb.javascript.TokenStream;

public class Parser {
    private static final String GENERATED_IDENTIFIER = "__UNKNOWN__";
    public static final int CLEAR_TI_MASK = 65535;
    public static final int TI_AFTER_EOL = 65536;
    public static final int TI_CHECK_LABEL = 131072;
    CompilerEnvirons compilerEnv;
    private ErrorReporter errorReporter;
    private String sourceURI;
    boolean calledByCompileFunction;
    private TokenStream ts;
    private int peekedTokenStart;
    private int peekedTokenEnd;
    private int matchedTokenStart;
    private int matchedTokenEnd;
    private int matchedToken;
    private boolean jsonMode;
    private int currentFlaggedToken;
    private int syntaxErrorCount;
    private IRFactory nf;
    private int nestingOfFunction;
    private Decompiler decompiler;
    private String encodedSource;
    ScriptOrFnNode currentScriptOrFn;
    Node.Scope currentScope;
    private int nestingOfWith;
    private Map<String, Node> labelSet;
    private ObjArray loopSet;
    private ObjArray loopAndSwitchSet;
    private int endFlags;

    public void setJsonMode(boolean bl) {
        this.jsonMode = bl;
    }

    public int getCurrentLineNumber() {
        return this.ts.getLineno();
    }

    public Parser(CompilerEnvirons compilerEnvirons, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnvirons;
        this.errorReporter = errorReporter;
    }

    protected Decompiler createDecompiler(CompilerEnvirons compilerEnvirons) {
        return new NoOpDecompiler();
    }

    void addStrictWarning(String string, String string2, Object object) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(string, string2, object);
        }
    }

    void addWarning(String string, String string2, Object object) {
        String string3 = ScriptRuntime.getMessage1(string, string2);
        if (this.compilerEnv.reportWarningAsError()) {
            ++this.syntaxErrorCount;
            this.errorReporter.error(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset(), string, object);
        } else {
            this.errorReporter.warning(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset(), string, object);
        }
    }

    void addError(String string) {
        ++this.syntaxErrorCount;
        String string2 = ScriptRuntime.getMessage0(string);
        this.errorReporter.error(string2, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset(), string, null);
    }

    void addError(String string, String string2, Object object) {
        ++this.syntaxErrorCount;
        String string3 = ScriptRuntime.getMessage1(string, string2);
        this.errorReporter.error(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset(), string, object);
    }

    RuntimeException reportError(String string) {
        this.addError(string);
        throw new ParserException();
    }

    private int peekToken() throws IOException {
        int n = this.currentFlaggedToken;
        if (n == 0) {
            this.peekedTokenStart = this.ts.getBufferOffset();
            n = this.ts.getToken();
            if (n == 1) {
                do {
                    this.peekedTokenStart = this.ts.getBufferOffset();
                } while ((n = this.ts.getToken()) == 1);
                n |= 0x10000;
            }
            this.currentFlaggedToken = n;
            this.peekedTokenStart += this.ts.seenSpaces();
            this.peekedTokenEnd = this.ts.getBufferOffset();
        }
        return n & 0xFFFF;
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private void consumeToken() {
        this.matchedToken = this.currentFlaggedToken;
        this.matchedTokenStart = this.peekedTokenStart;
        this.matchedTokenEnd = this.peekedTokenEnd;
        this.currentFlaggedToken = 0;
    }

    private int nextToken() throws IOException {
        int n = this.peekToken();
        this.consumeToken();
        return n;
    }

    private int nextFlaggedToken() throws IOException {
        this.peekToken();
        int n = this.currentFlaggedToken;
        this.consumeToken();
        return n;
    }

    private boolean matchToken(int n) throws IOException {
        int n2 = this.peekToken();
        if (n2 != n) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private int peekTokenOrEOL() throws IOException {
        int n = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            n = 1;
        }
        return n;
    }

    private void setCheckForLabel() {
        if ((this.currentFlaggedToken & 0xFFFF) != 39) {
            throw Kit.codeBug();
        }
        this.currentFlaggedToken |= 0x20000;
    }

    private void mustMatchToken(int n, String string) throws IOException, ParserException {
        if (!this.matchToken(n)) {
            this.reportError(string);
        }
    }

    private void mustHaveXML() {
        if (!this.compilerEnv.isXmlAvailable()) {
            this.reportError("msg.XML.not.available");
        }
    }

    public String getEncodedSource() {
        return this.encodedSource;
    }

    public boolean eof() {
        return this.ts.eof();
    }

    boolean insideFunction() {
        return this.nestingOfFunction != 0;
    }

    void pushScope(Node node) {
        Node.Scope scope = (Node.Scope)node;
        if (scope.getParentScope() != null) {
            throw Kit.codeBug();
        }
        scope.setParent(this.currentScope);
        this.currentScope = scope;
    }

    void popScope() {
        this.currentScope = this.currentScope.getParentScope();
    }

    private Node enterLoop(Node node, boolean bl) {
        Node node2 = this.nf.createLoopNode(node, this.ts.getLineno());
        int n = this.getStartOffset();
        node2.setSourceBounds(n, n);
        if (this.loopSet == null) {
            this.loopSet = new ObjArray();
            if (this.loopAndSwitchSet == null) {
                this.loopAndSwitchSet = new ObjArray();
            }
        }
        this.loopSet.push(node2);
        this.loopAndSwitchSet.push(node2);
        if (bl) {
            this.pushScope(node2);
        }
        return node2;
    }

    private void exitLoop(boolean bl) {
        this.loopSet.pop();
        this.loopAndSwitchSet.pop();
        if (bl) {
            this.popScope();
        }
    }

    private Node enterSwitch(Node node, int n) {
        Node node2 = this.nf.createSwitch(node, n);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ObjArray();
        }
        this.loopAndSwitchSet.push(node2);
        return node2;
    }

    private void exitSwitch() {
        Node node = (Node)this.loopAndSwitchSet.pop();
        this.setSourceOffsets(node, node.getSourceStart());
    }

    public ScriptOrFnNode parse(String string, String string2, int n) {
        this.sourceURI = string2;
        this.ts = new TokenStream(this, null, string, n);
        try {
            this.setJsonMode(false);
            return this.parse();
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public ScriptOrFnNode parse(Reader reader, String string, int n) throws IOException {
        this.sourceURI = string;
        this.ts = new TokenStream(this, reader, null, n);
        return this.parse();
    }

    private ScriptOrFnNode parse() throws IOException {
        int n;
        this.decompiler = this.createDecompiler(this.compilerEnv);
        this.nf = new IRFactory(this);
        this.currentScriptOrFn = this.nf.createScript();
        this.currentScope = this.currentScriptOrFn;
        int n2 = this.decompiler.getCurrentOffset();
        int n3 = this.ts.getBufferOffset();
        this.encodedSource = null;
        this.decompiler.addToken(135);
        this.currentFlaggedToken = 0;
        this.syntaxErrorCount = 0;
        int n4 = this.ts.getLineno();
        Node node = this.nf.createLeaf(128);
        try {
            while ((n = this.peekToken()) > 0) {
                Node node2;
                block8: {
                    if (n == 108) {
                        int n5 = this.peekedTokenStart;
                        this.consumeToken();
                        try {
                            node2 = this.function(this.calledByCompileFunction ? 2 : 1);
                            this.setSourceOffsets(node2, n5);
                            break block8;
                        }
                        catch (ParserException parserException) {
                            break;
                        }
                    }
                    node2 = this.statement();
                }
                this.nf.addChildToBack(node, node2);
            }
        }
        catch (StackOverflowError stackOverflowError) {
            String string = ScriptRuntime.getMessage0("msg.too.deep.parser.recursion");
            throw Context.reportRuntimeError(string, this.sourceURI, this.ts.getLineno(), null, 0);
        }
        if (this.syntaxErrorCount != 0) {
            String string = String.valueOf(this.syntaxErrorCount);
            string = ScriptRuntime.getMessage1("msg.got.syntax.errors", string);
            return null;
        }
        this.currentScriptOrFn.setSourceName(this.sourceURI);
        this.currentScriptOrFn.setBaseLineno(n4);
        this.currentScriptOrFn.setEndLineno(this.ts.getLineno());
        n = this.decompiler.getCurrentOffset();
        this.currentScriptOrFn.setEncodedSourceBounds(n2, n);
        int n6 = this.getEndOffset();
        this.currentScriptOrFn.setSourceBounds(n3, n6);
        this.nf.initScript(this.currentScriptOrFn, node);
        if (this.compilerEnv.isGeneratingSource()) {
            this.encodedSource = this.decompiler.getEncodedSource();
        }
        this.decompiler = null;
        return this.currentScriptOrFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node parseFunctionBody() throws IOException {
        Node node;
        int n;
        block10: {
            ++this.nestingOfFunction;
            n = this.getStartOffset();
            node = this.nf.createBlock(this.ts.getLineno());
            try {
                while (true) {
                    Node node2;
                    int n2 = this.peekToken();
                    switch (n2) {
                        case -1: 
                        case 0: 
                        case 85: {
                            break block10;
                        }
                        case 108: {
                            this.consumeToken();
                            node2 = this.function(1);
                            break;
                        }
                        default: {
                            node2 = this.statement();
                        }
                    }
                    this.nf.addChildToBack(node, node2);
                }
            }
            catch (ParserException parserException) {
            }
            finally {
                --this.nestingOfFunction;
            }
        }
        node.setSourceBounds(n, this.getEndOffset());
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node function(int n) throws IOException, ParserException {
        int n2;
        Node node;
        int n3;
        String string;
        int n4;
        int n5 = n;
        int n6 = this.ts.getLineno();
        int n7 = this.decompiler.markFunctionStart(n);
        int n8 = n4 = this.getStartOffset();
        Node node2 = null;
        Node node3 = null;
        if (this.matchToken(39)) {
            string = this.ts.getString();
            node2 = Node.newString(164, string);
            this.setSourceOffsets(node2, this.getStartOffset());
            this.decompiler.addName(string);
            if (!this.matchToken(86)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    Node node4 = this.nf.createName(string);
                    string = "";
                    node3 = this.memberExprTail(false, node4);
                }
                if ((n3 = this.peekToken()) != 86 && GENERATED_IDENTIFIER.equals(string) && this.matchToken(39)) {
                    string = this.ts.getString();
                    node2 = Node.newString(164, string);
                    this.setSourceOffsets(node2, this.getStartOffset());
                }
                this.mustMatchToken(86, "msg.no.paren.parms");
            }
        } else if (this.matchToken(86)) {
            string = "";
        } else {
            string = "";
            if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                node3 = this.memberExpr(false);
            }
            this.mustMatchToken(86, "msg.no.paren.parms");
        }
        if (node3 != null) {
            n5 = 2;
        }
        if (n5 != 2 && string.length() > 0) {
            this.defineSymbol(108, false, string, node2);
        }
        n3 = this.insideFunction();
        FunctionNode functionNode = this.nf.createFunction(string);
        if (node2 != null) {
            functionNode.addChildToFront(node2);
        }
        if (n3 != 0 || this.nestingOfWith > 0) {
            functionNode.itsIgnoreDynamicScope = true;
        }
        int n9 = this.currentScriptOrFn.addFunction(functionNode);
        ScriptOrFnNode scriptOrFnNode = this.currentScriptOrFn;
        this.currentScriptOrFn = functionNode;
        Node.Scope scope = this.currentScope;
        this.currentScope = functionNode;
        int n10 = this.nestingOfWith;
        this.nestingOfWith = 0;
        Map<String, Node> map = this.labelSet;
        this.labelSet = null;
        ObjArray objArray = this.loopSet;
        this.loopSet = null;
        ObjArray objArray2 = this.loopAndSwitchSet;
        this.loopAndSwitchSet = null;
        int n11 = this.endFlags;
        this.endFlags = 0;
        Node node5 = null;
        try {
            this.decompiler.addToken(86);
            if (!this.matchToken(87)) {
                boolean bl = true;
                do {
                    String string2;
                    if (!bl) {
                        this.decompiler.addToken(88);
                    }
                    bl = false;
                    int n12 = this.peekToken();
                    if (n12 == 82 || n12 == 84) {
                        if (node5 == null) {
                            node5 = new Node(88);
                        }
                        string2 = this.currentScriptOrFn.getNextTempName();
                        this.defineSymbol(86, false, string2, null);
                        node5.addChildToBack(this.nf.createDestructuringAssignment(121, this.primaryExpr(), this.nf.createName(string2)));
                        continue;
                    }
                    this.mustMatchToken(39, "msg.no.parm");
                    string2 = this.ts.getString();
                    Node node6 = Node.newString(163, string2);
                    this.setSourceOffsets(node6, this.getStartOffset());
                    functionNode.addChildToBack(node6);
                    this.defineSymbol(86, false, string2, node6);
                    this.decompiler.addName(string2);
                    while (this.peekToken() == 39 && GENERATED_IDENTIFIER.equals(this.ts.getString())) {
                        this.consumeToken();
                    }
                } while (this.matchToken(88));
                this.mustMatchToken(87, "msg.no.paren.after.parms");
            }
            this.decompiler.addToken(87);
            this.mustMatchToken(84, "msg.no.brace.body");
            this.decompiler.addEOL(84);
            node = this.parseFunctionBody();
            if (node5 != null) {
                node.addChildToFront(new Node(132, node5, this.ts.getLineno()));
            }
            this.mustMatchToken(85, "msg.no.brace.after.body");
            if (this.compilerEnv.isStrictMode() && !node.hasConsistentReturnUsage()) {
                String string3 = string.length() > 0 ? "msg.no.return.value" : "msg.anon.no.return.value";
                this.addStrictWarning(string3, string, functionNode);
            }
            if (n5 == 2 && string.length() > 0 && this.currentScope.getSymbol(string) == null) {
                this.defineSymbol(108, false, string, node2);
            }
            this.decompiler.addToken(85);
            n2 = this.decompiler.markFunctionEnd(n7);
            n8 = this.getEndOffset();
            if (n != 2) {
                this.decompiler.addToken(1);
            }
        }
        finally {
            this.endFlags = n11;
            this.loopAndSwitchSet = objArray2;
            this.loopSet = objArray;
            this.labelSet = map;
            this.nestingOfWith = n10;
            this.currentScriptOrFn = scriptOrFnNode;
            this.currentScope = scope;
        }
        functionNode.setEncodedSourceBounds(n7, n2);
        functionNode.setSourceName(this.sourceURI);
        functionNode.setBaseLineno(n6);
        functionNode.setEndLineno(this.ts.getLineno());
        functionNode.setSourceBounds(n4, n8);
        Node node7 = this.nf.initFunction(functionNode, n9, node, n5);
        if (node3 != null) {
            node7 = this.nf.createAssignment(89, node3, node7);
            if (n != 2) {
                node7 = this.nf.createExprStatementNoReturn(node7, n6);
            }
        }
        node7.setSourceBounds(functionNode.getSourceStart(), functionNode.getSourceEnd());
        return node7;
    }

    private Node statements(Node node) throws IOException {
        int n;
        Node node2;
        int n2 = this.getStartOffset();
        Node node3 = node2 = node != null ? node : this.nf.createBlock(this.ts.getLineno());
        while ((n = this.peekToken()) > 0 && n != 85) {
            this.nf.addChildToBack(node2, this.statement());
        }
        node2.setSourceBounds(n2, this.peekedTokenEnd);
        return node2;
    }

    private Node condition() throws IOException, ParserException {
        this.mustMatchToken(86, "msg.no.paren.cond");
        this.decompiler.addToken(86);
        this.peekToken();
        int n = this.peekedTokenStart;
        Node node = this.expr(false);
        int n2 = this.getEndOffset();
        node.setSourceBounds(n, n2);
        this.mustMatchToken(87, "msg.no.paren.after.cond");
        this.decompiler.addToken(87);
        if (node.getProp(19) == null && (node.getType() == 8 || node.getType() == 35 || node.getType() == 37)) {
            this.addStrictWarning("msg.equal.as.assign", "", node);
        }
        return node;
    }

    private Node matchJumpLabelName() throws IOException, ParserException {
        Node node = null;
        int n = this.peekTokenOrEOL();
        if (n == 39) {
            this.consumeToken();
            String string = this.ts.getString();
            this.decompiler.addName(string);
            if (this.labelSet != null) {
                node = this.labelSet.get(string);
            }
            if (node == null) {
                this.reportError("msg.undef.label");
            }
        }
        return node;
    }

    private Node statement() throws IOException {
        int n = this.getStartOffset();
        try {
            Node node = this.statementHelper(null);
            if (node != null) {
                if (this.compilerEnv.isStrictMode() && !node.hasSideEffects()) {
                    this.addStrictWarning("msg.no.side.effects", "", node);
                }
                return node;
            }
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        int n2 = this.ts.getLineno();
        block5: while (true) {
            int n3 = this.peekTokenOrEOL();
            this.consumeToken();
            switch (n3) {
                case -1: 
                case 0: 
                case 1: 
                case 81: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return this.setSourceOffsets(this.nf.createExprStatement(this.nf.createName("error"), n2), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Node statementHelper(Node var1_1) throws IOException, ParserException {
        var2_2 = null;
        var3_3 = this.peekToken();
        var4_4 = this.peekedTokenStart;
        switch (var3_3) {
            case 111: {
                this.consumeToken();
                this.decompiler.addToken(111);
                var5_5 = this.ts.getLineno();
                var6_14 = this.condition();
                this.decompiler.addEOL(84);
                var7_25 = this.statement();
                var8_34 = null;
                if (this.matchToken(112)) {
                    this.decompiler.addToken(85);
                    this.decompiler.addToken(112);
                    this.decompiler.addEOL(84);
                    var8_34 = this.statement();
                }
                this.decompiler.addEOL(85);
                var2_2 = this.nf.createIf(var6_14, var7_25, var8_34, var5_5);
                var2_2.setSourceBounds(var4_4, this.getEndOffset());
                return var2_2;
            }
            case 113: {
                this.consumeToken();
                this.decompiler.addToken(113);
                var5_6 = this.ts.getLineno();
                this.mustMatchToken(86, "msg.no.paren.switch");
                this.decompiler.addToken(86);
                var2_2 = this.enterSwitch(this.expr(false), var5_6);
                try {
                    this.mustMatchToken(87, "msg.no.paren.after.switch");
                    this.decompiler.addToken(87);
                    this.mustMatchToken(84, "msg.no.brace.switch");
                    this.decompiler.addEOL(84);
                    var6_15 = 0;
                    block51: while (true) {
                        var3_3 = this.nextToken();
                        var8_35 = this.peekedTokenStart;
                        switch (var3_3) {
                            case 85: {
                                break block51;
                            }
                            case 114: {
                                this.decompiler.addToken(114);
                                var7_26 = this.expr(false);
                                this.mustMatchToken(102, "msg.no.colon.case");
                                this.decompiler.addEOL(102);
                                break;
                            }
                            case 115: {
                                if (var6_15 != 0) {
                                    this.reportError("msg.double.switch.default");
                                }
                                this.decompiler.addToken(115);
                                var6_15 = 1;
                                var7_26 = null;
                                this.mustMatchToken(102, "msg.no.colon.case");
                                this.decompiler.addEOL(102);
                                break;
                            }
                            default: {
                                this.reportError("msg.bad.switch");
                                break block51;
                            }
                        }
                        var9_39 = this.nf.createLeaf(128);
                        var10_44 = this.getStartOffset();
                        var2_2.setSourceBounds(var10_44, var10_44);
                        while ((var3_3 = this.peekToken()) != 85 && var3_3 != 114 && var3_3 != 115 && var3_3 != 0) {
                            this.nf.addChildToBack(var9_39, this.statement());
                        }
                        this.nf.addSwitchCase(var2_2, var7_26, var9_39, var8_35);
                    }
                    this.decompiler.addEOL(85);
                    this.nf.closeSwitch(var2_2);
                }
                finally {
                    this.exitSwitch();
                }
                var6_15 = this.matchedTokenEnd;
                var2_2.setSourceBounds(var4_4, var6_15);
                return var2_2;
            }
            case 116: {
                this.consumeToken();
                this.decompiler.addToken(116);
                var5_7 = this.enterLoop(var1_1, true);
                try {
                    var6_16 = this.condition();
                    this.decompiler.addEOL(84);
                    var7_27 = this.statement();
                    this.decompiler.addEOL(85);
                    var2_2 = this.nf.createWhile(var5_7, var6_16, var7_27);
                    this.setSourceOffsets(var2_2, var4_4);
                }
                finally {
                    this.exitLoop(true);
                }
                return var2_2;
            }
            case 117: {
                this.consumeToken();
                this.decompiler.addToken(117);
                this.decompiler.addEOL(84);
                var5_8 = this.enterLoop(var1_1, true);
                try {
                    var6_17 = this.statement();
                    this.decompiler.addToken(85);
                    this.mustMatchToken(116, "msg.no.while.do");
                    this.decompiler.addToken(116);
                    var7_28 = this.condition();
                    var2_2 = this.nf.createDoWhile(var5_8, var6_17, var7_28);
                }
                finally {
                    this.exitLoop(true);
                }
                this.matchToken(81);
                this.decompiler.addEOL(81);
                this.setSourceOffsets(var2_2, var4_4);
                return var2_2;
            }
            case 118: {
                this.consumeToken();
                var5_9 = false;
                this.decompiler.addToken(118);
                var6_18 = this.enterLoop(var1_1, true);
                try {
                    var9_40 = null;
                    var11_49 = -1;
                    if (this.matchToken(39)) {
                        this.decompiler.addName(this.ts.getString());
                        if (this.ts.getString().equals("each")) {
                            var5_9 = true;
                        } else {
                            this.reportError("msg.no.paren.for");
                        }
                    }
                    this.mustMatchToken(86, "msg.no.paren.for");
                    this.decompiler.addToken(86);
                    var12_53 = this.getStartOffset();
                    var3_3 = this.peekToken();
                    if (var3_3 == 81) {
                        var7_29 = this.nf.createLeaf(127);
                        var13_57 = this.getStartOffset();
                        var7_29.setSourceBounds(var13_57, var13_57);
                    } else if (var3_3 == 121 || var3_3 == 152) {
                        this.consumeToken();
                        this.decompiler.addToken(var3_3);
                        var7_29 = this.variables(true, var3_3);
                        var13_57 = this.getEndOffset();
                        var7_29.setSourceBounds(var12_53, var13_57);
                        var11_49 = var3_3;
                    } else {
                        var7_29 = this.expr(true);
                    }
                    if (this.matchToken(52)) {
                        this.decompiler.addToken(52);
                        var8_36 = this.expr(false);
                    } else {
                        this.mustMatchToken(81, "msg.no.semi.for");
                        this.decompiler.addToken(81);
                        if (this.peekToken() == 81) {
                            var8_36 = this.nf.createLeaf(127);
                            var13_57 = this.getStartOffset();
                            var8_36.setSourceBounds(var13_57, var13_57);
                        } else {
                            var8_36 = this.expr(false);
                        }
                        this.mustMatchToken(81, "msg.no.semi.for.cond");
                        this.decompiler.addToken(81);
                        if (this.peekToken() == 87) {
                            var9_40 = this.nf.createLeaf(127);
                            var13_57 = this.getStartOffset();
                            var9_40.setSourceBounds(var13_57, var13_57);
                        } else {
                            var9_40 = this.expr(false);
                        }
                    }
                    this.mustMatchToken(87, "msg.no.paren.for.ctrl");
                    this.decompiler.addToken(87);
                    this.decompiler.addEOL(84);
                    var10_45 = this.statement();
                    this.decompiler.addEOL(85);
                    var2_2 = var9_40 == null ? this.nf.createForIn(var11_49, var6_18, var7_29, var8_36, var10_45, var5_9) : this.nf.createFor(var6_18, var7_29, var8_36, var9_40, var10_45);
                }
                finally {
                    this.exitLoop(true);
                }
                this.setSourceOffsets(var2_2, var4_4);
                return var2_2;
            }
            case 80: {
                this.consumeToken();
                var4_4 = this.getStartOffset();
                var5_10 = this.ts.getLineno();
                var7_30 = null;
                var8_37 = null;
                this.decompiler.addToken(80);
                if (this.peekToken() != 84) {
                    this.reportError("msg.no.brace.try");
                }
                this.decompiler.addEOL(84);
                var6_19 = this.statement();
                this.decompiler.addEOL(85);
                var7_30 = this.nf.createLeaf(128);
                var9_41 = false;
                var10_46 = this.peekToken();
                if (var10_46 == 123) {
                    while (this.matchToken(123)) {
                        if (var9_41) {
                            this.reportError("msg.catch.unreachable");
                        }
                        var11_50 = this.getStartOffset();
                        this.decompiler.addToken(123);
                        this.mustMatchToken(86, "msg.no.paren.catch");
                        this.decompiler.addToken(86);
                        this.mustMatchToken(39, "msg.bad.catchcond");
                        var12_54 = this.getStartOffset();
                        var13_58 = this.matchedTokenEnd;
                        var14_60 = this.ts.getString();
                        this.decompiler.addName(var14_60);
                        var15_61 = null;
                        if (this.matchToken(111)) {
                            this.decompiler.addToken(111);
                            var15_61 = this.expr(false);
                        } else {
                            var9_41 = true;
                        }
                        this.mustMatchToken(87, "msg.bad.catchcond");
                        this.decompiler.addToken(87);
                        this.mustMatchToken(84, "msg.no.brace.catchblock");
                        this.decompiler.addEOL(84);
                        var7_30.setSourceBounds(var4_4, this.getEndOffset());
                        if (var15_61 == null) {
                            var15_61 = new Node(127);
                            var15_61.setSourceBounds(var13_58, var13_58);
                        }
                        var16_62 = this.nf.createCatch(var14_60, var15_61, this.statements(null), this.ts.getLineno());
                        this.setSourceOffsets(var16_62, var11_50);
                        this.peekToken();
                        var16_62.setSourceBounds(var11_50, this.peekedTokenEnd);
                        var7_30.setSourceBounds(var4_4, this.peekedTokenEnd);
                        this.nf.addChildToBack(var7_30, var16_62);
                        var17_63 = var7_30.getLastChild().getFirstChild();
                        var17_63.setSourceBounds(var12_54, var13_58);
                        this.mustMatchToken(85, "msg.no.brace.after.body");
                        this.decompiler.addEOL(85);
                    }
                } else if (var10_46 != 124) {
                    this.mustMatchToken(124, "msg.try.no.catchfinally");
                }
                if (this.matchToken(124)) {
                    var11_50 = this.getStartOffset();
                    this.decompiler.addToken(124);
                    this.decompiler.addEOL(84);
                    var8_37 = this.statement();
                    var12_55 = new Node(124, var8_37);
                    var12_55.setSourceBounds(var11_50, this.getEndOffset());
                    var8_37 = var12_55;
                    this.decompiler.addEOL(85);
                }
                var2_2 = this.nf.createTryCatchFinally(var6_19, var7_30, var8_37, var5_10);
                var2_2.setSourceBounds(var4_4, this.getEndOffset());
                return var2_2;
            }
            case 50: {
                this.consumeToken();
                if (this.peekTokenOrEOL() == 1) {
                    this.reportError("msg.bad.throw.eol");
                }
                var5_11 = this.ts.getLineno();
                this.decompiler.addToken(50);
                var2_2 = this.nf.createThrow(this.expr(false), var5_11);
                var2_2.setSourceBounds(var4_4, this.getEndOffset());
                break;
            }
            case 119: {
                this.consumeToken();
                var5_11 = this.ts.getLineno();
                this.decompiler.addToken(119);
                var6_20 = this.matchJumpLabelName();
                if (var6_20 == null) {
                    if (this.loopAndSwitchSet == null || this.loopAndSwitchSet.size() == 0) {
                        this.reportError("msg.bad.break");
                        return null;
                    }
                    var6_20 = (Node)this.loopAndSwitchSet.peek();
                }
                var2_2 = this.nf.createBreak(var6_20, var5_11);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
            case 120: {
                this.consumeToken();
                var5_11 = this.ts.getLineno();
                this.decompiler.addToken(120);
                var7_31 = this.matchJumpLabelName();
                if (var7_31 == null) {
                    if (this.loopSet == null || this.loopSet.size() == 0) {
                        this.reportError("msg.continue.outside");
                        return null;
                    }
                    var6_21 = (Node)this.loopSet.peek();
                } else {
                    var6_21 = this.nf.getLabelLoop(var7_31);
                    if (var6_21 == null) {
                        this.reportError("msg.continue.nonloop");
                        return null;
                    }
                }
                var2_2 = this.nf.createContinue(var6_21, var5_11);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
            case 122: {
                this.consumeToken();
                this.decompiler.addToken(122);
                var5_12 = this.ts.getLineno();
                this.mustMatchToken(86, "msg.no.paren.with");
                this.decompiler.addToken(86);
                var6_22 = this.expr(false);
                this.mustMatchToken(87, "msg.no.paren.after.with");
                this.decompiler.addToken(87);
                this.decompiler.addEOL(84);
                ++this.nestingOfWith;
                try {
                    var7_32 = this.statement();
                }
                finally {
                    --this.nestingOfWith;
                }
                this.decompiler.addEOL(85);
                var2_2 = this.nf.createWith(var6_22, var7_32, var5_12);
                this.setSourceOffsets(var2_2, var4_4);
                return var2_2;
            }
            case 121: 
            case 153: {
                this.consumeToken();
                this.decompiler.addToken(var3_3);
                var2_2 = this.variables(false, var3_3);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
            case 152: {
                this.consumeToken();
                this.decompiler.addToken(152);
                if (this.peekToken() == 86) {
                    return this.let(true);
                }
                var2_2 = this.variables(false, var3_3);
                if (this.peekToken() == 81) break;
                return var2_2;
            }
            case 4: 
            case 72: {
                var2_2 = this.returnOrYield(var3_3, false);
                break;
            }
            case 159: {
                this.consumeToken();
                this.decompiler.addToken(159);
                var2_2 = this.nf.createDebugger(this.ts.getLineno());
                break;
            }
            case 84: {
                this.consumeToken();
                if (var1_1 != null) {
                    this.decompiler.addToken(84);
                }
                var5_13 = this.nf.createScopeNode(128, this.ts.getLineno());
                this.pushScope(var5_13);
                try {
                    this.statements(var5_13);
                    this.mustMatchToken(85, "msg.no.brace.block");
                    if (var1_1 != null) {
                        this.decompiler.addEOL(85);
                    }
                    var6_23 = var5_13;
                    return var6_23;
                }
                finally {
                    this.popScope();
                }
            }
            case -1: 
            case 81: {
                this.consumeToken();
                var2_2 = this.nf.createLeaf(127);
                var6_24 = this.getStartOffset();
                var2_2.setSourceBounds(var6_24, var6_24);
                return var2_2;
            }
            case 108: {
                this.consumeToken();
                var2_2 = this.function(3);
                this.setSourceOffsets(var2_2, var4_4);
                return var2_2;
            }
            case 115: {
                this.consumeToken();
                this.mustHaveXML();
                this.decompiler.addToken(115);
                var7_33 = this.ts.getLineno();
                if (!this.matchToken(39) || !this.ts.getString().equals("xml")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" xml");
                if (!this.matchToken(39) || !this.ts.getString().equals("namespace")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" namespace");
                if (!this.matchToken(89)) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addToken(89);
                var8_38 = this.expr(false);
                var2_2 = this.nf.createDefaultNamespace(var8_38, var7_33);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
            case 39: {
                var9_42 = this.ts.getLineno();
                var10_47 = this.ts.getString();
                this.setCheckForLabel();
                var2_2 = this.expr(false);
                if (var2_2.getType() != 129) ** GOTO lbl434
                if (this.peekToken() != 102) {
                    Kit.codeBug();
                }
                this.consumeToken();
                this.decompiler.addName(var10_47);
                this.decompiler.addEOL(102);
                if (this.labelSet == null) {
                    this.labelSet = new HashMap<String, Node>();
                } else if (this.labelSet.containsKey(var10_47)) {
                    this.reportError("msg.dup.label");
                }
                if (var1_1 == null) {
                    var11_51 = true;
                    var1_1 = var2_2;
                } else {
                    var11_51 = false;
                }
                this.labelSet.put(var10_47, var1_1);
                try {
                    var2_2 = this.statementHelper(var1_1);
                }
                finally {
                    this.labelSet.remove(var10_47);
                }
                if (var11_51) {
                    var2_2 = this.nf.createLabeledStatement(var1_1, var2_2);
                }
                this.setSourceOffsets(var2_2, var4_4);
                return var2_2;
lbl434:
                // 1 sources

                var2_2 = this.nf.createExprStatement(var2_2, var9_42);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
            default: {
                var9_43 = this.ts.getLineno();
                var2_2 = this.expr(false);
                var2_2 = this.nf.createExprStatement(var2_2, var9_43);
                this.setSourceOffsets(var2_2, var4_4);
                break;
            }
        }
        var5_11 = this.peekFlaggedToken();
        switch (var5_11 & 65535) {
            case 81: {
                this.consumeToken();
                break;
            }
            case -1: 
            case 0: 
            case 85: {
                break;
            }
            default: {
                if ((var5_11 & 65536) != 0) break;
                this.reportError("msg.no.semi.stmt");
            }
        }
        this.decompiler.addEOL(81);
        this.setSourceOffsets(var2_2, var4_4);
        return var2_2;
    }

    private static final boolean nowAllSet(int n, int n2, int n3) {
        return (n & n3) != n3 && (n2 & n3) == n3;
    }

    private Node returnOrYield(int n, boolean bl) throws IOException, ParserException {
        int n2;
        Node node;
        Node node2;
        if (!this.insideFunction()) {
            this.reportError(n == 4 ? "msg.bad.return" : "msg.bad.yield");
        }
        this.consumeToken();
        int n3 = this.getStartOffset();
        this.decompiler.addToken(n);
        int n4 = this.ts.getLineno();
        switch (this.peekTokenOrEOL()) {
            case -1: 
            case 0: 
            case 1: 
            case 72: 
            case 81: 
            case 83: 
            case 85: 
            case 87: {
                node2 = null;
                break;
            }
            default: {
                node2 = this.expr(false);
            }
        }
        int n5 = this.endFlags;
        if (n == 4) {
            this.endFlags = node2 == null ? (this.endFlags |= 2) : (this.endFlags |= 4);
            node = this.nf.createReturn(node2, n4);
            if (Parser.nowAllSet(n5, this.endFlags, 6)) {
                this.addStrictWarning("msg.return.inconsistent", "", node);
            }
        } else {
            this.endFlags |= 8;
            node = this.nf.createYield(node2, n4);
            n2 = this.matchedTokenEnd;
            node.setSourceBounds(n3, n2);
            if (!bl) {
                node = new Node(132, node, n4);
            }
        }
        if (Parser.nowAllSet(n5, this.endFlags, 12)) {
            String string = ((FunctionNode)this.currentScriptOrFn).getFunctionName();
            if (string.length() == 0) {
                this.addError("msg.anon.generator.returns", "", node);
            } else {
                this.addError("msg.generator.returns", string, node);
            }
        }
        n2 = this.matchedTokenEnd;
        node.setSourceBounds(n3, n2);
        return node;
    }

    private Node variables(boolean bl, int n) throws IOException, ParserException {
        int n2 = this.getStartOffset();
        Node node = this.nf.createVariables(n, this.ts.getLineno());
        boolean bl2 = true;
        do {
            Node node2 = null;
            String string = null;
            int n3 = this.peekToken();
            int n4 = this.peekedTokenStart;
            int n5 = this.peekedTokenEnd;
            Node node3 = null;
            if (n3 == 82 || n3 == 84) {
                node2 = this.primaryExpr();
            } else {
                this.mustMatchToken(39, "msg.bad.var");
                string = this.ts.getString();
                if (!bl2) {
                    this.decompiler.addToken(88);
                }
                bl2 = false;
                this.decompiler.addName(string);
                node3 = this.nf.createName(string);
                this.defineSymbol(n, bl, string, node3);
            }
            Node node4 = null;
            if (this.matchToken(89)) {
                this.decompiler.addToken(89);
                node4 = this.assignExpr(bl);
            }
            if (node2 != null) {
                if (node4 == null) {
                    if (!bl) {
                        this.reportError("msg.destruct.assign.no.init");
                    }
                    this.nf.addChildToBack(node, node2);
                    continue;
                }
                this.nf.addChildToBack(node, this.nf.createDestructuringAssignment(n, node2, node4));
                continue;
            }
            node3.setSourceBounds(n4, n5);
            if (node4 != null) {
                this.nf.addChildToBack(node3, node4);
            }
            this.nf.addChildToBack(node, node3);
        } while (this.matchToken(88));
        node.setSourceBounds(n2, this.getEndOffset());
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node let(boolean bl) throws IOException, ParserException {
        this.mustMatchToken(86, "msg.no.paren.after.let");
        this.decompiler.addToken(86);
        Node node = this.nf.createScopeNode(152, this.ts.getLineno());
        this.pushScope(node);
        try {
            Node node2 = this.variables(false, 152);
            this.nf.addChildToBack(node, node2);
            this.mustMatchToken(87, "msg.no.paren.let");
            this.decompiler.addToken(87);
            if (bl && this.peekToken() == 84) {
                this.consumeToken();
                this.decompiler.addEOL(84);
                this.nf.addChildToBack(node, this.statements(null));
                this.mustMatchToken(85, "msg.no.curly.let");
                this.decompiler.addToken(85);
            } else {
                node.setType(157);
                this.nf.addChildToBack(node, this.expr(false));
                if (bl) {
                    node = this.nf.createExprStatement(node, this.ts.getLineno());
                }
            }
        }
        finally {
            this.popScope();
        }
        return node;
    }

    void defineSymbol(int n, boolean bl, String string, Node node) {
        Node.Scope scope = this.currentScope.getDefiningScope(string);
        Node.Symbol symbol = scope != null ? scope.getSymbol(string) : null;
        boolean bl2 = false;
        if (symbol != null && (symbol.declType == 153 || n == 153)) {
            bl2 = true;
        } else {
            switch (n) {
                case 152: {
                    if (symbol != null && scope == this.currentScope) {
                        bl2 = symbol.declType == 152;
                    }
                    int n2 = this.currentScope.getType();
                    if (!(bl || n2 != 131 && n2 != 111)) {
                        this.addError("msg.let.decl.not.in.block");
                    }
                    this.currentScope.putSymbol(string, new Node.Symbol(n, string));
                    break;
                }
                case 108: 
                case 121: 
                case 153: {
                    if (symbol != null) {
                        if (symbol.declType == 121) {
                            this.addStrictWarning("msg.var.redecl", string, node);
                            break;
                        }
                        if (symbol.declType != 86) break;
                        this.addStrictWarning("msg.var.hides.arg", string, node);
                        break;
                    }
                    this.currentScriptOrFn.putSymbol(string, new Node.Symbol(n, string));
                    break;
                }
                case 86: {
                    if (symbol != null) {
                        this.addWarning("msg.dup.parms", string, node);
                    }
                    this.currentScriptOrFn.putSymbol(string, new Node.Symbol(n, string));
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
        }
        if (bl2) {
            this.addError(symbol.declType == 153 ? "msg.const.redecl" : (symbol.declType == 152 ? "msg.let.redecl" : (symbol.declType == 121 ? "msg.var.redecl" : (symbol.declType == 108 ? "msg.fn.redecl" : "msg.parm.redecl"))), string, node);
        }
    }

    private Node expr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.assignExpr(bl);
        while (this.matchToken(88)) {
            this.decompiler.addToken(88);
            if (this.compilerEnv.isStrictMode() && !node.hasSideEffects()) {
                this.addStrictWarning("msg.no.side.effects", "", node);
            }
            if (this.peekToken() == 72) {
                this.reportError("msg.yield.parenthesized");
            }
            node = this.nf.createBinary(88, node, this.assignExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node assignExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        int n2 = this.peekToken();
        if (n2 == 72) {
            this.consumeToken();
            return this.returnOrYield(n2, true);
        }
        Node node = this.condExpr(bl);
        n2 = this.peekToken();
        if (n2 == 39 && GENERATED_IDENTIFIER.equals(this.ts.getString())) {
            while ((this.currentFlaggedToken & 0x10000) == 0 && this.peekToken() == 39 && GENERATED_IDENTIFIER.equals(this.ts.getString())) {
                this.consumeToken();
            }
            n2 = this.peekToken();
        }
        if (89 <= n2 && n2 <= 100) {
            this.consumeToken();
            this.decompiler.addToken(n2);
            node = this.nf.createAssignment(n2, node, this.assignExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node condExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.orExpr(bl);
        if (this.matchToken(101)) {
            this.decompiler.addToken(101);
            Node node2 = this.assignExpr(false);
            this.mustMatchToken(102, "msg.no.colon.cond");
            this.decompiler.addToken(102);
            Node node3 = this.assignExpr(bl);
            return this.nf.createCondExpr(node, node2, node3);
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node orExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.andExpr(bl);
        if (this.matchToken(103)) {
            this.decompiler.addToken(103);
            node = this.nf.createBinary(103, node, this.orExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node andExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.bitOrExpr(bl);
        if (this.matchToken(104)) {
            this.decompiler.addToken(104);
            node = this.nf.createBinary(104, node, this.andExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node bitOrExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.bitXorExpr(bl);
        while (this.matchToken(9)) {
            this.decompiler.addToken(9);
            node = this.nf.createBinary(9, node, this.bitXorExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node bitXorExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.bitAndExpr(bl);
        while (this.matchToken(10)) {
            this.decompiler.addToken(10);
            node = this.nf.createBinary(10, node, this.bitAndExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node bitAndExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.eqExpr(bl);
        while (this.matchToken(11)) {
            this.decompiler.addToken(11);
            node = this.nf.createBinary(11, node, this.eqExpr(bl));
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node eqExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.relExpr(bl);
        block9: while (true) {
            int n2 = this.peekToken();
            switch (n2) {
                case 12: 
                case 13: 
                case 46: 
                case 47: {
                    this.consumeToken();
                    int n3 = n2;
                    int n4 = n2;
                    if (this.compilerEnv.getLanguageVersion() == 120) {
                        switch (n2) {
                            case 12: {
                                n4 = 46;
                                break;
                            }
                            case 13: {
                                n4 = 47;
                                break;
                            }
                            case 46: {
                                n3 = 12;
                                break;
                            }
                            case 47: {
                                n3 = 13;
                            }
                        }
                    }
                    this.decompiler.addToken(n3);
                    node = this.nf.createBinary(n4, node, this.relExpr(bl));
                    continue block9;
                }
            }
            break;
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node relExpr(boolean bl) throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.shiftExpr();
        block4: while (true) {
            int n2 = this.peekToken();
            switch (n2) {
                case 52: {
                    if (bl) break block4;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 53: {
                    this.consumeToken();
                    this.decompiler.addToken(n2);
                    node = this.nf.createBinary(n2, node, this.shiftExpr());
                    continue block4;
                }
            }
            break;
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node shiftExpr() throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.addExpr();
        block3: while (true) {
            int n2 = this.peekToken();
            switch (n2) {
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    this.decompiler.addToken(n2);
                    node = this.nf.createBinary(n2, node, this.addExpr());
                    continue block3;
                }
            }
            break;
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node addExpr() throws IOException, ParserException {
        int n;
        int n2 = this.getStartOffset();
        Node node = this.mulExpr();
        while ((n = this.peekToken()) == 21 || n == 22) {
            this.consumeToken();
            this.decompiler.addToken(n);
            node = this.nf.createBinary(n, node, this.mulExpr());
        }
        this.setSourceOffsets(node, n2);
        return node;
    }

    private Node mulExpr() throws IOException, ParserException {
        int n = this.getStartOffset();
        Node node = this.unaryExpr();
        block3: while (true) {
            int n2 = this.peekToken();
            switch (n2) {
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    this.decompiler.addToken(n2);
                    node = this.nf.createBinary(n2, node, this.unaryExpr());
                    continue block3;
                }
            }
            break;
        }
        this.setSourceOffsets(node, n);
        return node;
    }

    private Node unaryExpr() throws IOException, ParserException {
        int n = this.peekToken();
        int n2 = this.getStartOffset();
        switch (n) {
            case 26: 
            case 27: 
            case 32: 
            case 125: {
                this.consumeToken();
                this.decompiler.addToken(n);
                return this.setSourceOffsets(this.nf.createUnary(n, this.unaryExpr()), n2);
            }
            case 21: {
                this.consumeToken();
                this.decompiler.addToken(28);
                return this.setSourceOffsets(this.nf.createUnary(28, this.unaryExpr()), n2);
            }
            case 22: {
                this.consumeToken();
                this.decompiler.addToken(29);
                return this.setSourceOffsets(this.nf.createUnary(29, this.unaryExpr()), n2);
            }
            case 105: 
            case 106: {
                this.consumeToken();
                this.decompiler.addToken(n);
                return this.setSourceOffsets(this.nf.createIncDec(n, false, this.memberExpr(true)), n2);
            }
            case 31: {
                this.consumeToken();
                this.decompiler.addToken(31);
                return this.setSourceOffsets(this.nf.createUnary(31, this.unaryExpr()), n2);
            }
            case -1: {
                this.consumeToken();
                break;
            }
            case 14: {
                if (this.compilerEnv.isXmlAvailable()) {
                    this.consumeToken();
                    Node node = this.xmlInitializer();
                    return this.setSourceOffsets(this.memberExprTail(true, node), n2);
                }
            }
            default: {
                Node node = this.memberExpr(true);
                n = this.peekTokenOrEOL();
                if (n == 105 || n == 106) {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    return this.setSourceOffsets(this.nf.createIncDec(n, true, node), n2);
                }
                this.setSourceOffsets(node, n2);
                return node;
            }
        }
        return this.nf.createName("err");
    }

    Node setSourceOffsets(Node node, int n) {
        if (node.getSourceEnd() != 0) {
            return node;
        }
        int n2 = this.matchedTokenEnd;
        node.setSourceBounds(n, n2);
        return node;
    }

    static Node setSourceOffsets(Node node, int n, int n2) {
        node.setSourceBounds(n, n2);
        return node;
    }

    int getStartOffset() {
        return this.matchedTokenStart;
    }

    int getEndOffset() {
        return this.matchedTokenEnd;
    }

    private Node xmlInitializer() throws IOException {
        int n = this.getStartOffset();
        int n2 = this.ts.getFirstXMLToken();
        if (n2 != 144 && n2 != 147) {
            this.reportError("msg.syntax");
            return null;
        }
        Node node = this.nf.createLeaf(174);
        Node node2 = null;
        String string = this.ts.getString();
        node2 = null;
        while (true) {
            switch (n2) {
                case 144: {
                    Node node3;
                    Node node4;
                    string = this.ts.getString();
                    int n3 = this.ts.getBufferOffset();
                    n = n3 - string.length();
                    this.decompiler.addName(string);
                    this.mustMatchToken(84, "msg.syntax");
                    this.decompiler.addToken(84);
                    if (this.peekToken() == 85) {
                        node4 = this.nf.createString("");
                        node4.setSourceBounds(n, n);
                    } else {
                        node4 = this.expr(false);
                    }
                    this.mustMatchToken(85, "msg.syntax");
                    this.decompiler.addToken(85);
                    if (node2 == null) {
                        node2 = this.nf.createString(string);
                        node2.setSourceBounds(n, n3);
                    } else {
                        node3 = this.nf.createString(string);
                        node3.setSourceBounds(n, n3);
                        node2 = this.nf.createBinary(21, node2, node3);
                        node2.setSourceBounds(node2.getSourceStart(), n3);
                    }
                    node4 = this.nf.createUnary(75, node4);
                    node2 = this.nf.createBinary(21, node2, node4);
                    node2.setSourceBounds(node2.getSourceStart(), node4.getSourceEnd());
                    break;
                }
                case 147: {
                    Node node3;
                    string = this.ts.getString();
                    this.decompiler.addName(string);
                    int n3 = this.ts.getBufferOffset();
                    n = n3 - string.length();
                    if (node2 == null) {
                        node2 = this.nf.createString(string);
                        node2.setSourceBounds(n, n3);
                    } else {
                        node3 = this.nf.createString(string);
                        node3.setSourceBounds(n, n3);
                        node2 = this.nf.createBinary(21, node2, node3);
                    }
                    this.nf.addChildToBack(node, node2);
                    node.setSourceBounds(node.getSourceStart(), n3);
                    this.matchedTokenEnd = n3;
                    return node;
                }
                default: {
                    this.reportError("msg.syntax");
                    return null;
                }
            }
            n2 = this.ts.getNextXMLToken();
        }
    }

    private void argumentList(Node node) throws IOException, ParserException {
        int n = this.getStartOffset();
        boolean bl = this.matchToken(87);
        if (!bl) {
            boolean bl2 = true;
            boolean bl3 = false;
            do {
                int n2;
                if (!bl2) {
                    this.decompiler.addToken(88);
                }
                bl2 = false;
                if (this.peekToken() == 72) {
                    this.reportError("msg.yield.parenthesized");
                }
                if (bl3 && (n2 = this.peekToken()) == 87) break;
                Node node2 = this.assignExpr(false);
                int n3 = this.peekToken();
                while (n3 == 39 || n3 == 41) {
                    if (n3 == 39 && GENERATED_IDENTIFIER.equals(this.ts.getString())) {
                        bl3 = true;
                        this.nextToken();
                    } else {
                        if (n3 != 41 || this.ts.getString().indexOf(GENERATED_IDENTIFIER) == -1) break;
                        bl3 = true;
                        this.nextToken();
                    }
                    n3 = this.peekToken();
                }
                if ((n3 = this.peekToken()) != 88 && n3 != 87 && node2.getType() == 39 && GENERATED_IDENTIFIER.equals(node2.getString())) {
                    node2 = this.assignExpr(false);
                }
                this.nf.addChildToBack(node, node2);
            } while (this.matchToken(88));
            this.mustMatchToken(87, "msg.no.paren.arg");
        }
        this.setSourceOffsets(node, n);
        this.decompiler.addToken(87);
    }

    private Node memberExpr(boolean bl) throws IOException, ParserException {
        Node node;
        int n = this.peekToken();
        int n2 = this.getStartOffset();
        if (n == 30) {
            this.consumeToken();
            this.decompiler.addToken(30);
            n2 = this.getStartOffset();
            node = this.nf.createCallOrNew(30, this.memberExpr(false));
            node.setSourceBounds(n2, node.getSourceEnd());
            if (this.matchToken(86)) {
                this.decompiler.addToken(86);
                this.argumentList(node);
            }
            if ((n = this.peekToken()) == 84) {
                this.nf.addChildToBack(node, this.primaryExpr());
            }
        } else {
            node = this.primaryExpr();
        }
        this.setSourceOffsets(node, n2);
        return this.memberExprTail(bl, node);
    }

    private Node memberExprTail(boolean bl, Node node) throws IOException, ParserException {
        assert (node.getSourceStart() <= this.getStartOffset()) : node.getSourceStart() + "," + this.getStartOffset();
        int n = node.getSourceStart();
        block12: while (true) {
            int n2 = this.peekToken();
            block0 : switch (n2) {
                case 107: 
                case 142: {
                    String string;
                    this.consumeToken();
                    this.decompiler.addToken(n2);
                    int n3 = 0;
                    if (n2 == 142) {
                        this.mustHaveXML();
                        n3 = 4;
                    }
                    if (!this.compilerEnv.isXmlAvailable()) {
                        this.mustMatchToken(39, "msg.no.name.after.dot");
                        string = this.ts.getString();
                        this.decompiler.addName(string);
                        node = this.nf.createPropertyGet(node, null, string, n3);
                        break;
                    }
                    n2 = this.nextToken();
                    switch (n2) {
                        case 50: {
                            this.decompiler.addName("throw");
                            node = this.propertyName(node, "throw", n3);
                            this.setSourceOffsets(node.getLastChild(), this.getStartOffset());
                            break block0;
                        }
                        case 39: {
                            string = this.ts.getString();
                            this.decompiler.addName(string);
                            node = this.propertyName(node, string, n3);
                            this.setSourceOffsets(node.getLastChild(), this.getStartOffset());
                            break block0;
                        }
                        case 23: {
                            this.decompiler.addName("*");
                            node = this.propertyName(node, "*", n3);
                            break block0;
                        }
                        case 146: {
                            this.decompiler.addToken(146);
                            node = this.attributeAccess(node, n3);
                            break block0;
                        }
                    }
                    String string2 = ScriptRuntime.getMessage0("msg.no.name.after.dot");
                    this.errorReporter.error(string2, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.getStartOffset(), "msg.no.name.after.dot", null);
                    node = this.propertyName(node, "@", n3);
                    Node node2 = node.getFirstChild().getNext();
                    if (node2 != null) {
                        node2.setType(172);
                    }
                    this.setSourceOffsets(node.getLastChild(), this.getStartOffset());
                    break;
                }
                case 145: {
                    this.consumeToken();
                    this.mustHaveXML();
                    this.decompiler.addToken(145);
                    node = this.nf.createDotQuery(node, this.expr(false), this.ts.getLineno());
                    this.mustMatchToken(87, "msg.no.paren");
                    this.decompiler.addToken(87);
                    break;
                }
                case 82: {
                    this.consumeToken();
                    this.decompiler.addToken(82);
                    node = this.nf.createElementGet(node, null, this.expr(false), 0);
                    this.mustMatchToken(83, "msg.no.bracket.index");
                    this.decompiler.addToken(83);
                    break;
                }
                case 86: {
                    if (!bl) break block12;
                    this.consumeToken();
                    this.decompiler.addToken(86);
                    node = this.nf.createCallOrNew(38, node);
                    this.argumentList(node);
                    break;
                }
                default: {
                    break block12;
                }
            }
        }
        node.setSourceBounds(n, this.getEndOffset());
        return node;
    }

    private Node attributeAccess(Node node, int n) throws IOException {
        int n2 = this.getStartOffset();
        n |= 2;
        int n3 = this.nextToken();
        switch (n3) {
            case 39: {
                String string = this.ts.getString();
                this.decompiler.addName(string);
                node = this.propertyName(node, string, n);
                break;
            }
            case 23: {
                this.decompiler.addName("*");
                node = this.propertyName(node, "*", n);
                break;
            }
            case 82: {
                this.decompiler.addToken(82);
                node = this.nf.createElementGet(node, null, this.expr(false), n);
                this.mustMatchToken(83, "msg.no.bracket.index");
                this.decompiler.addToken(83);
                break;
            }
            default: {
                this.reportError("msg.no.name.after.xmlAttr");
                node = this.nf.createPropertyGet(node, null, "?", n);
            }
        }
        this.setSourceOffsets(node, n2);
        return node;
    }

    private Node propertyName(Node node, String string, int n) throws IOException, ParserException {
        int n2;
        int n3 = this.matchedTokenStart;
        if (GENERATED_IDENTIFIER.equals(string) && (n2 = this.peekToken()) == 39) {
            this.nextToken();
            string = this.ts.getString();
        }
        String string2 = null;
        if (this.matchToken(143)) {
            this.decompiler.addToken(143);
            string2 = string;
            int n4 = this.nextToken();
            switch (n4) {
                case 39: {
                    string = this.ts.getString();
                    this.decompiler.addName(string);
                    break;
                }
                case 23: {
                    this.decompiler.addName("*");
                    string = "*";
                    break;
                }
                case 82: {
                    this.decompiler.addToken(82);
                    node = this.nf.createElementGet(node, string2, this.expr(false), n);
                    this.mustMatchToken(83, "msg.no.bracket.index");
                    this.decompiler.addToken(83);
                    this.setSourceOffsets(node, n3);
                    return node;
                }
                default: {
                    this.reportError("msg.no.name.after.coloncolon");
                    string = "?";
                }
            }
        }
        node = this.nf.createPropertyGet(node, string2, string, n);
        this.setSourceOffsets(node, n3);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node arrayComprehension(String string, Node node) throws IOException, ParserException {
        Node node2;
        Node node3;
        Node node4;
        Node node5;
        String string2;
        int n = this.matchedTokenStart;
        if (this.nextToken() != 118) {
            throw Kit.codeBug();
        }
        this.decompiler.addName(" ");
        this.decompiler.addToken(118);
        boolean bl = false;
        if (this.matchToken(39)) {
            this.decompiler.addName(this.ts.getString());
            if (this.ts.getString().equals("each")) {
                bl = true;
            } else {
                this.reportError("msg.no.paren.for");
            }
        }
        this.mustMatchToken(86, "msg.no.paren.for");
        this.decompiler.addToken(86);
        int n2 = this.peekToken();
        if (n2 == 82 || n2 == 84) {
            string2 = this.currentScriptOrFn.getNextTempName();
            this.defineSymbol(86, false, string2, null);
            node5 = this.nf.createName(string2);
            node5.setSourceBounds(n, n);
            node = this.nf.createBinary(88, this.nf.createAssignment(89, this.primaryExpr(), node5), node);
        } else if (n2 == 39) {
            this.consumeToken();
            string2 = this.ts.getString();
            this.decompiler.addName(string2);
        } else {
            this.reportError("msg.bad.var");
            return this.nf.createNumber(0.0);
        }
        node5 = this.nf.createName(string2);
        if (n2 == 39) {
            node5.setSourceBounds(this.getStartOffset(), this.getEndOffset());
        } else {
            node5.setSourceBounds(n, n);
        }
        this.defineSymbol(152, false, string2, node5);
        this.mustMatchToken(52, "msg.in.after.for.name");
        this.decompiler.addToken(52);
        Node node6 = this.expr(false);
        this.mustMatchToken(87, "msg.no.paren.for.ctrl");
        this.decompiler.addToken(87);
        n2 = this.peekToken();
        if (n2 == 118) {
            node4 = this.arrayComprehension(string, node);
        } else {
            node3 = this.nf.createCallOrNew(38, this.nf.createPropertyGet(this.nf.createName(string), null, "push", 0));
            node3.addChildToBack(node);
            node4 = new Node(132, node3, this.ts.getLineno());
            node3.setSourceBounds(n, n);
            node4.setSourceBounds(n, n);
            if (n2 == 111) {
                this.consumeToken();
                this.decompiler.addToken(111);
                int n3 = this.ts.getLineno();
                node2 = this.condition();
                node4 = this.nf.createIf(node2, node4, null, n3);
            }
            this.mustMatchToken(83, "msg.no.bracket.arg");
            this.decompiler.addToken(83);
        }
        node3 = this.enterLoop(null, true);
        try {
            Node node7 = this.nf.createForIn(152, node3, node5, node6, node4, bl);
            this.setSourceOffsets(node7, n);
            node2 = node7;
            return node2;
        }
        finally {
            this.exitLoop(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node primaryExpr() throws IOException, ParserException {
        int n = this.nextFlaggedToken();
        int n2 = n & 0xFFFF;
        int n3 = this.matchedTokenStart;
        switch (n2) {
            case 108: {
                Node node = this.function(2);
                if (this.jsonMode) {
                    this.addError("msg.json.error", Token.fullName(n2), node);
                }
                return node;
            }
            case 82: {
                ObjArray objArray = new ObjArray();
                int n4 = 0;
                int n5 = 0;
                this.decompiler.addToken(82);
                boolean bl = true;
                Node node = null;
                while (true) {
                    if ((n2 = this.peekToken()) == 88) {
                        this.consumeToken();
                        this.decompiler.addToken(88);
                        if (!bl) {
                            bl = true;
                            continue;
                        }
                        objArray.add(null);
                        ++n4;
                        continue;
                    }
                    if (n2 == 83) break;
                    if (n4 == 0 && objArray.size() == 1 && n2 == 118) {
                        Node node2 = this.nf.createScopeNode(156, this.ts.getLineno());
                        String string = this.currentScriptOrFn.getNextTempName();
                        this.pushScope(node2);
                        try {
                            this.defineSymbol(152, false, string, null);
                            Node node3 = (Node)objArray.get(0);
                            Node node4 = this.nf.createBlock(this.ts.getLineno());
                            int n6 = this.peekedTokenStart;
                            Node node5 = new Node(132, this.nf.createAssignment(89, Parser.setSourceOffsets(this.nf.createName(string), n6, n6), this.nf.createCallOrNew(30, Parser.setSourceOffsets(this.nf.createName("Array"), n6, n6))), this.ts.getLineno());
                            node5.setSourceBounds(n6, n6);
                            node4.setSourceBounds(n6, n6);
                            node4.addChildToBack(node5);
                            node4.addChildToBack(this.arrayComprehension(string, node3));
                            node2.addChildToBack(node4);
                            node2.addChildToBack(Parser.setSourceOffsets(this.nf.createName(string), n6, n6));
                            Node node6 = node2;
                            return node6;
                        }
                        finally {
                            this.popScope();
                        }
                    }
                    if (!bl) {
                        this.reportError("msg.no.bracket.arg");
                    }
                    node = this.assignExpr(false);
                    objArray.add(node);
                    bl = false;
                }
                this.consumeToken();
                this.decompiler.addToken(83);
                n5 = objArray.size() + (bl ? 1 : 0);
                return this.setSourceOffsets(this.nf.createArrayLiteral(objArray, n4, n5), n3);
            }
            case 84: {
                Object object;
                ObjArray objArray = new ObjArray();
                ArrayList<Node.LabelledNode> arrayList = new ArrayList<Node.LabelledNode>();
                this.decompiler.addToken(84);
                if (!this.matchToken(85)) {
                    boolean bl = true;
                    block29: do {
                        int n7 = this.getStartOffset();
                        if (!bl) {
                            this.decompiler.addToken(88);
                        } else {
                            bl = false;
                        }
                        n2 = this.peekToken();
                        switch (n2) {
                            case 39: {
                                if (this.jsonMode) {
                                    this.addError("msg.json.error", Token.fullName(n2), null);
                                }
                            }
                            case 41: {
                                this.consumeToken();
                                String string = this.ts.getString();
                                if (n2 == 39) {
                                    if (string.equals("get") && this.peekToken() == 39) {
                                        this.decompiler.addToken(150);
                                        this.consumeToken();
                                        string = this.ts.getString();
                                        this.decompiler.addName(string);
                                        object = ScriptRuntime.getIndexObject(string);
                                        if (this.getterSetterProperty(objArray, object, true)) continue block29;
                                        break block29;
                                    }
                                    if (string.equals("set") && this.peekToken() == 39) {
                                        this.decompiler.addToken(151);
                                        this.consumeToken();
                                        string = this.ts.getString();
                                        this.decompiler.addName(string);
                                        object = ScriptRuntime.getIndexObject(string);
                                        if (this.getterSetterProperty(objArray, object, false)) continue block29;
                                        break block29;
                                    }
                                    this.decompiler.addName(string);
                                } else {
                                    this.decompiler.addString(string);
                                }
                                int n8 = this.matchedTokenStart;
                                object = ScriptRuntime.getIndexObject(string);
                                this.plainProperty(objArray, object);
                                if (objArray.size() <= 0) continue block29;
                                Node node = (Node)objArray.get(objArray.size() - 1);
                                Node.LabelledNode labelledNode = new Node.LabelledNode(string, node);
                                labelledNode.setSourceBounds(n8, n8 + string.length());
                                arrayList.add(labelledNode);
                                break;
                            }
                            case 40: {
                                this.consumeToken();
                                int n9 = this.matchedTokenStart;
                                int n8 = this.matchedTokenEnd;
                                double d = this.ts.getNumber();
                                this.decompiler.addNumber(d);
                                object = ScriptRuntime.getIndexObject(d);
                                this.plainProperty(objArray, object);
                                if (objArray.size() <= 0) continue block29;
                                Object object2 = (Node)objArray.get(objArray.size() - 1);
                                String string = Double.toString(d);
                                if (string.endsWith(".0")) {
                                    string = string.substring(0, string.length() - 2);
                                }
                                Node.LabelledNode labelledNode = new Node.LabelledNode(string, (Node)object2);
                                labelledNode.setSourceBounds(n9, n8);
                                arrayList.add(labelledNode);
                                break;
                            }
                            case 85: {
                                if (!this.compilerEnv.isStrictMode()) break block29;
                                Object object2 = ScriptRuntime.getMessage0("msg.trailing.comma");
                                this.errorReporter.warning((String)object2, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), n7, "msg.trailing.comma", n7);
                                break block29;
                            }
                            default: {
                                this.reportError("msg.bad.prop");
                                break block29;
                            }
                        }
                    } while (this.matchToken(88));
                    this.mustMatchToken(85, "msg.no.brace.prop");
                }
                this.decompiler.addToken(85);
                Node node = this.nf.createObjectLiteral(objArray);
                if (node.hasChildren()) {
                    object = node.getFirstChild();
                    Iterator iterator = arrayList.iterator();
                    do {
                        node.addChildBefore((Node)iterator.next(), (Node)object);
                    } while ((object = ((Node)object).getNext()) != null);
                }
                node.setSourceBounds(n3, this.getEndOffset());
                return node;
            }
            case 152: {
                this.decompiler.addToken(152);
                return this.let(false);
            }
            case 86: {
                if (this.jsonMode) {
                    this.addError("msg.json.error", Token.fullName(n2), null);
                }
                this.decompiler.addToken(86);
                Node node = this.expr(false);
                node.putProp(19, Boolean.TRUE);
                this.decompiler.addToken(87);
                this.mustMatchToken(87, "msg.no.paren");
                this.setSourceOffsets(node, n3);
                return node;
            }
            case 146: {
                this.mustHaveXML();
                this.decompiler.addToken(146);
                Node node = this.attributeAccess(null, 0);
                this.setSourceOffsets(node, n3);
                return node;
            }
            case 39: {
                String string;
                if (this.jsonMode) {
                    this.addError("msg.json.error", Token.fullName(n2), null);
                }
                if (GENERATED_IDENTIFIER.equals(string = this.ts.getString())) {
                    int n10 = this.peekToken();
                    boolean bl = false;
                    switch (n10) {
                        case 24: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 82: 
                        case 84: 
                        case 86: 
                        case 99: 
                        case 108: 
                        case 146: {
                            bl = true;
                        }
                    }
                    if (bl) {
                        Node node = this.primaryExpr();
                        this.setSourceOffsets(node, n3);
                        return node;
                    }
                }
                if ((n & 0x20000) != 0 && this.peekToken() == 102) {
                    return this.nf.createLabel(this.ts.getLineno());
                }
                this.decompiler.addName(string);
                Node node = this.compilerEnv.isXmlAvailable() ? this.propertyName(null, string, 0) : this.nf.createName(string);
                this.setSourceOffsets(node, n3);
                return node;
            }
            case 40: {
                double d = this.ts.getNumber();
                this.decompiler.addNumber(d);
                return this.setSourceOffsets(this.nf.createNumber(d), n3);
            }
            case 41: {
                String string = this.ts.getString();
                this.decompiler.addString(string);
                return this.setSourceOffsets(this.nf.createString(string), n3);
            }
            case 24: 
            case 99: {
                this.ts.readRegExp(n2);
                String string = this.ts.regExpFlags;
                this.ts.regExpFlags = null;
                String string2 = this.ts.getString();
                this.decompiler.addRegexp(string2, string);
                int n11 = this.currentScriptOrFn.addRegexp(string2, string);
                Node node = this.nf.createRegExp(n11);
                int n12 = this.matchedTokenEnd + string2.length() + string.length() + 1;
                node.setSourceBounds(n3, n12);
                this.matchedTokenEnd = n12;
                return node;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.decompiler.addToken(n2);
                return this.setSourceOffsets(this.nf.createLeaf(n2), n3);
            }
            case 126: {
                this.reportError("msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                this.reportError("msg.unexpected.eof");
                break;
            }
            default: {
                this.reportError("msg.syntax");
            }
        }
        return null;
    }

    private void plainProperty(ObjArray objArray, Object object) throws IOException {
        this.mustMatchToken(102, "msg.no.colon.prop");
        this.decompiler.addToken(66);
        objArray.add(object);
        objArray.add(this.assignExpr(false));
    }

    private boolean getterSetterProperty(ObjArray objArray, Object object, boolean bl) throws IOException {
        Node node = this.function(2);
        if (node.getType() != 108) {
            this.reportError("msg.bad.prop");
            return false;
        }
        int n = node.getExistingIntProp(1);
        FunctionNode functionNode = this.currentScriptOrFn.getFunctionNode(n);
        if (functionNode.getFunctionName().length() != 0) {
            this.reportError("msg.bad.prop");
            return false;
        }
        objArray.add(object);
        if (bl) {
            objArray.add(this.nf.createUnary(150, node));
        } else {
            objArray.add(this.nf.createUnary(151, node));
        }
        return true;
    }

    public TokenStream getTokenStream() {
        return this.ts;
    }

    public void setTokenStream(TokenStream tokenStream) {
        this.ts = tokenStream;
    }

    public FunctionNode parseFunction(String string, String string2, int n) {
        this.sourceURI = string2;
        this.ts = new TokenStream(this, null, string, n);
        this.setJsonMode(false);
        this.decompiler = this.createDecompiler(this.compilerEnv);
        this.nf = new IRFactory(this);
        this.currentScriptOrFn = this.nf.createScript();
        this.currentScope = this.currentScriptOrFn;
        this.encodedSource = null;
        this.currentFlaggedToken = 0;
        this.syntaxErrorCount = 0;
        try {
            int n2 = this.peekToken();
            if (n2 <= 0) {
                return null;
            }
            if (n2 == 108) {
                int n3 = this.peekedTokenStart;
                this.consumeToken();
                try {
                    Node node = this.function(this.calledByCompileFunction ? 2 : 1);
                    this.setSourceOffsets(node, n3);
                    return this.syntaxErrorCount == 0 ? (FunctionNode)node : null;
                }
                catch (ParserException parserException) {
                    return null;
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
        return null;
    }

    public ScriptOrFnNode parseJson(String string, String string2, int n) {
        this.sourceURI = string2;
        this.ts = new TokenStream(this, null, string, n);
        try {
            this.setJsonMode(true);
            return this.parseJson();
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    private ScriptOrFnNode parseJson() throws IOException {
        int n;
        assert (this.jsonMode);
        this.decompiler = this.createDecompiler(this.compilerEnv);
        this.nf = new IRFactory(this);
        this.currentScriptOrFn = this.nf.createScript();
        int n2 = this.decompiler.getCurrentOffset();
        int n3 = this.ts.getBufferOffset();
        this.encodedSource = null;
        this.decompiler.addToken(135);
        this.currentFlaggedToken = 0;
        this.syntaxErrorCount = 0;
        int n4 = this.ts.getLineno();
        Node node = this.nf.createLeaf(128);
        try {
            Object object;
            this.mustMatchToken(84, "msg.json.expectedlc");
            n = this.getStartOffset();
            ObjArray objArray = new ObjArray();
            ArrayList<Node.LabelledNode> arrayList = new ArrayList<Node.LabelledNode>();
            this.decompiler.addToken(84);
            if (!this.matchToken(85)) {
                boolean bl = true;
                block7: do {
                    if (!bl) {
                        this.decompiler.addToken(88);
                    } else {
                        bl = false;
                    }
                    int n5 = this.peekToken();
                    switch (n5) {
                        case 39: 
                        case 41: {
                            this.consumeToken();
                            String string = this.ts.getString();
                            if (n5 == 39) {
                                if (string.equals("get") && this.peekToken() == 39) {
                                    this.decompiler.addToken(150);
                                    this.consumeToken();
                                    string = this.ts.getString();
                                    this.decompiler.addName(string);
                                    object = ScriptRuntime.getIndexObject(string);
                                    if (this.getterSetterProperty(objArray, object, true)) continue block7;
                                    break block7;
                                }
                                if (string.equals("set") && this.peekToken() == 39) {
                                    this.decompiler.addToken(151);
                                    this.consumeToken();
                                    string = this.ts.getString();
                                    this.decompiler.addName(string);
                                    object = ScriptRuntime.getIndexObject(string);
                                    if (this.getterSetterProperty(objArray, object, false)) continue block7;
                                    break block7;
                                }
                                this.decompiler.addName(string);
                            } else {
                                this.decompiler.addString(string);
                            }
                            int n6 = this.matchedTokenStart;
                            object = ScriptRuntime.getIndexObject(string);
                            this.plainProperty(objArray, object);
                            if (objArray.size() <= 0) continue block7;
                            Node node2 = (Node)objArray.get(objArray.size() - 1);
                            Node.LabelledNode labelledNode = new Node.LabelledNode(string, node2);
                            labelledNode.setSourceBounds(n6, n6 + string.length());
                            arrayList.add(labelledNode);
                            break;
                        }
                        case 40: {
                            this.consumeToken();
                            int n7 = this.matchedTokenStart;
                            int n6 = this.matchedTokenEnd;
                            double d = this.ts.getNumber();
                            this.decompiler.addNumber(d);
                            object = ScriptRuntime.getIndexObject(d);
                            this.plainProperty(objArray, object);
                            if (objArray.size() <= 0) continue block7;
                            Node node3 = (Node)objArray.get(objArray.size() - 1);
                            String string = Double.toString(d);
                            if (string.endsWith(".0")) {
                                string = string.substring(0, string.length() - 2);
                            }
                            Node.LabelledNode labelledNode = new Node.LabelledNode(string, node3);
                            labelledNode.setSourceBounds(n7, n6);
                            arrayList.add(labelledNode);
                            break;
                        }
                        case 85: {
                            break block7;
                        }
                        default: {
                            this.reportError("msg.bad.prop");
                            break block7;
                        }
                    }
                } while (this.matchToken(88));
                this.mustMatchToken(85, "msg.no.brace.prop");
            }
            this.decompiler.addToken(85);
            Node node4 = this.nf.createObjectLiteral(objArray);
            if (node4.hasChildren()) {
                object = node4.getFirstChild();
                Iterator iterator = arrayList.iterator();
                do {
                    node4.addChildBefore((Node)iterator.next(), (Node)object);
                } while ((object = ((Node)object).getNext()) != null);
            }
            node4.setSourceBounds(n, this.getEndOffset());
            node.addChildToBack(node4);
        }
        catch (StackOverflowError stackOverflowError) {
            String string = ScriptRuntime.getMessage0("msg.too.deep.parser.recursion");
            throw Context.reportRuntimeError(string, this.sourceURI, this.ts.getLineno(), null, 0);
        }
        if (this.syntaxErrorCount != 0) {
            String string = String.valueOf(this.syntaxErrorCount);
            string = ScriptRuntime.getMessage1("msg.got.syntax.errors", string);
            return null;
        }
        this.currentScriptOrFn.setSourceName(this.sourceURI);
        this.currentScriptOrFn.setBaseLineno(n4);
        this.currentScriptOrFn.setEndLineno(this.ts.getLineno());
        n = this.decompiler.getCurrentOffset();
        this.currentScriptOrFn.setEncodedSourceBounds(n2, n);
        int n8 = this.getEndOffset();
        this.currentScriptOrFn.setSourceBounds(n3, n8);
        this.nf.initScript(this.currentScriptOrFn, node);
        if (this.compilerEnv.isGeneratingSource()) {
            this.encodedSource = this.decompiler.getEncodedSource();
        }
        this.decompiler = null;
        return this.currentScriptOrFn;
    }

    private class NoOpDecompiler
    extends Decompiler {
        private NoOpDecompiler() {
        }

        String getEncodedSource() {
            return null;
        }

        int getCurrentOffset() {
            return 0;
        }

        int markFunctionStart(int n) {
            return 0;
        }

        int markFunctionEnd(int n) {
            return 0;
        }

        void addToken(int n) {
        }

        void addEOL(int n) {
        }

        void addName(String string) {
        }

        void addString(String string) {
        }

        void addRegexp(String string, String string2) {
        }

        void addNumber(double d) {
        }
    }

    private static class ParserException
    extends RuntimeException {
        static final long serialVersionUID = 5882582646773765630L;

        private ParserException() {
        }
    }
}

