/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.language;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.profiler.oql.language.OQLTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OQLLexer
implements Lexer<OQLTokenId> {
    private static final String TOKEN_FROM = "FROM";
    private static final String TOKEN_INSTANCEOF = "INSTANCEOF";
    private static final String TOKEN_SELECT = "SELECT";
    private static final String TOKEN_WHERE = "WHERE";
    private LexerInput input;
    private TokenFactory<OQLTokenId> tokenFactory;
    private State state = State.INIT;
    private final Pattern classPattern = Pattern.compile("(\\[*)[a-z]+(?:[a-z 0-9]*)(?:[\\. \\$][a-z 0-9]+)*(\\[\\])*", 2);
    private final Pattern classIdPattern = Pattern.compile("(0X)?([0-9 a-f A-F]+)");

    OQLLexer(LexerRestartInfo<OQLTokenId> lexerRestartInfo) {
        this.input = lexerRestartInfo.input();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        if (lexerRestartInfo.state() != null) {
            this.state = (State)((Object)lexerRestartInfo.state());
        }
    }

    public Token<OQLTokenId> nextToken() {
        Object object;
        int n;
        block27: while ((n = this.input.read()) != -1) {
            switch (this.state) {
                case INIT: {
                    object = ((Object)this.input.readText()).toString().toUpperCase();
                    if (Character.isWhitespace(n)) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.WHITESPACE);
                    }
                    this.input.backup(this.input.readLength());
                    if (TOKEN_SELECT.startsWith(((String)object).trim())) {
                        this.state = State.IN_SELECT;
                        break;
                    }
                    this.state = State.PLAIN_JS;
                    break;
                }
                case IN_SELECT: {
                    object = ((Object)this.input.readText()).toString().toUpperCase();
                    Object object2 = ((String)object).trim();
                    if (Character.isWhitespace(n)) {
                        if (((String)object2).length() == 0) {
                            return this.tokenFactory.createToken((TokenId)OQLTokenId.WHITESPACE);
                        }
                        if (TOKEN_SELECT.equals(object2)) {
                            this.state = State.JSBLOCK;
                            this.input.backup(1);
                            return this.tokenFactory.createToken((TokenId)OQLTokenId.KEYWORD);
                        }
                        this.state = State.ERROR;
                        this.input.backup(this.input.readLength());
                        break;
                    }
                    if (TOKEN_SELECT.startsWith((String)object2)) break;
                    this.input.backup(this.input.readLength());
                    this.state = State.PLAIN_JS;
                    break;
                }
                case IN_FROM: {
                    if (!Character.isWhitespace(n)) break;
                    object = ((Object)this.input.readText()).toString().toUpperCase();
                    if (((String)object).trim().length() == 0) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.WHITESPACE);
                    }
                    if (TOKEN_FROM.equals(((String)object).trim())) {
                        this.input.backup(1);
                        this.state = State.FROM;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.KEYWORD, ((String)object).trim().length(), PartType.COMPLETE);
                    }
                    this.state = State.ERROR;
                    this.input.backup(this.input.readLength());
                    break;
                }
                case FROM: {
                    object = ((Object)this.input.readText()).toString().toUpperCase();
                    if (TOKEN_INSTANCEOF.startsWith(((String)object).trim())) {
                        this.state = State.FROM_INSTANCEOF;
                        this.input.backup(this.input.readLength());
                        break;
                    }
                    this.state = State.IN_CLASSNAME;
                    break;
                }
                case FROM_INSTANCEOF: {
                    object = ((Object)this.input.readText()).toString().toUpperCase();
                    Object object2 = ((String)object).trim();
                    if (!TOKEN_INSTANCEOF.startsWith((String)object2)) {
                        this.state = State.IN_CLASSNAME;
                        this.input.backup(this.input.readLength());
                    }
                    if (!Character.isWhitespace(n)) break;
                    if (((String)object2).length() == 0) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.WHITESPACE);
                    }
                    if (TOKEN_INSTANCEOF.equals(object2)) {
                        this.state = State.IN_CLASSNAME;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.KEYWORD);
                    }
                    this.state = State.ERROR;
                    this.input.backup(this.input.readLength());
                    break;
                }
                case JSBLOCK: {
                    Object object2;
                    if (Character.isWhitespace(n)) {
                        object = ((Object)this.input.readText()).toString().toUpperCase();
                        object2 = ((String)object).trim();
                        if (((String)object2).endsWith(TOKEN_FROM)) {
                            this.state = State.IN_FROM;
                            if (this.input.readLength() > 5) {
                                this.input.backup(5);
                                return this.tokenFactory.createToken((TokenId)OQLTokenId.JSBLOCK);
                            }
                            this.state = State.ERROR;
                            this.input.backup(this.input.readLength());
                            break;
                        }
                        if (!TOKEN_SELECT.equals(object2) && !TOKEN_INSTANCEOF.equals(object2) && !TOKEN_WHERE.equals(object2)) continue block27;
                        this.state = State.ERROR;
                        this.input.backup(this.input.readLength());
                        break;
                    }
                    if (n != 40 && n != 41 && n != 91 && n != 93 && n != 123 && n != 125 && n != 46 && n != 44) break;
                    this.state = State.JSBLOCK1;
                    this.input.backup(1);
                    if (this.input.readLength() <= 0) break;
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.JSBLOCK);
                }
                case JSBLOCK1: {
                    if (n == 40 || n == 41 || n == 91 || n == 93 || n == 123 || n == 125) {
                        this.state = State.JSBLOCK;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.BRACE);
                    }
                    if (n == 46) {
                        this.state = State.JSBLOCK;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.DOT);
                    }
                    if (n != 44) break;
                    this.state = State.JSBLOCK;
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.COMMA);
                }
                case IN_CLASSNAME: {
                    if (!Character.isWhitespace(n)) break;
                    object = ((Object)this.input.readText()).toString().toUpperCase();
                    Object object2 = this.classIdPattern.matcher(((String)object).trim());
                    if (((Matcher)object2).matches()) {
                        this.state = State.CLASS_ALIAS;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.CLAZZ);
                    }
                    Matcher matcher = this.classPattern.matcher(((String)object).trim());
                    if (!matcher.matches()) continue block27;
                    if ((OQLLexer.isEmpty(matcher.group(1)) ? 0 : 1) + (OQLLexer.isEmpty(matcher.group(2)) ? 0 : 1) > 1) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.CLAZZ_E);
                    }
                    this.state = State.CLASS_ALIAS;
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.CLAZZ);
                }
                case CLASS_ALIAS: {
                    object = ((Object)this.input.readText()).toString().toUpperCase();
                    if (TOKEN_SELECT.equals(object) || TOKEN_FROM.equals(object) || TOKEN_INSTANCEOF.equals(object) || TOKEN_WHERE.equals(object)) {
                        this.state = State.ERROR;
                        this.input.backup(this.input.readLength());
                        break;
                    }
                    if (Character.isWhitespace(n)) {
                        if (((String)object).trim().length() == 0) {
                            return this.tokenFactory.createToken((TokenId)OQLTokenId.WHITESPACE);
                        }
                        this.state = State.IN_WHERE;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.IDENTIFIER);
                    }
                    if (Character.isLetter(n)) break;
                    this.state = State.ERROR;
                    this.input.backup(1);
                    break;
                }
                case IN_WHERE: {
                    object = ((Object)this.input.readText()).toString().toUpperCase();
                    Object object2 = ((String)object).trim();
                    if (!TOKEN_WHERE.startsWith((String)object2)) {
                        this.state = State.ERROR;
                        this.input.backup(this.input.readLength());
                    }
                    if (!Character.isWhitespace(n)) break;
                    if (((String)object2).length() == 0) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.WHITESPACE);
                    }
                    if (TOKEN_WHERE.equals(object2)) {
                        this.state = State.JSBLOCK;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.KEYWORD);
                    }
                    this.state = State.ERROR;
                    this.input.backup(this.input.readLength());
                    break;
                }
                case PLAIN_JS: {
                    break;
                }
                case ERROR: {
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.ERROR);
                }
            }
        }
        if (this.input.readLength() == 0) {
            return null;
        }
        switch (this.state) {
            case INIT: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.UNKNOWN);
            }
            case IN_SELECT: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.KEYWORD, this.input.readLength(), PartType.START);
            }
            case JSBLOCK: {
                String string = ((Object)this.input.readText()).toString().trim().toUpperCase();
                if (string.endsWith(TOKEN_FROM)) {
                    this.state = State.IN_FROM;
                    if (this.input.readLength() > 5) {
                        this.input.backup(5);
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.JSBLOCK);
                    }
                    this.state = State.ERROR;
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.ERROR);
                }
                return this.tokenFactory.createToken((TokenId)OQLTokenId.JSBLOCK, this.input.readLength(), PartType.START);
            }
            case PLAIN_JS: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.JSBLOCK);
            }
            case IN_FROM: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.KEYWORD, this.input.readLength(), PartType.START);
            }
            case FROM: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.UNKNOWN);
            }
            case FROM_INSTANCEOF: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.KEYWORD, this.input.readLength(), PartType.START);
            }
            case IN_CLASSNAME: {
                String string = ((Object)this.input.readText()).toString().trim().toUpperCase();
                object = this.classPattern.matcher(string);
                if (((Matcher)object).matches()) {
                    if ((OQLLexer.isEmpty(((Matcher)object).group(1)) ? 0 : 1) + (OQLLexer.isEmpty(((Matcher)object).group(2)) ? 0 : 1) > 1) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.ERROR);
                    }
                    this.state = State.CLASS_ALIAS;
                    this.input.backup(1);
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.CLAZZ);
                }
                return this.tokenFactory.createToken((TokenId)OQLTokenId.CLAZZ_E);
            }
            case CLASS_ALIAS: {
                String string = ((Object)this.input.readText()).toString().toUpperCase();
                if (TOKEN_SELECT.equals(string) || TOKEN_FROM.equals(string) || TOKEN_INSTANCEOF.equals(string) || TOKEN_WHERE.equals(string)) {
                    this.state = State.ERROR;
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.ERROR);
                }
                return this.tokenFactory.createToken((TokenId)OQLTokenId.IDENTIFIER);
            }
            case IN_WHERE: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.KEYWORD, this.input.readLength(), PartType.START);
            }
            case ERROR: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.ERROR);
            }
        }
        return this.tokenFactory.createToken((TokenId)OQLTokenId.UNKNOWN);
    }

    private static final boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public Object state() {
        return this.state;
    }

    public void release() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INIT,
        IN_SELECT,
        IN_FROM,
        IN_WHERE,
        IN_CLASSNAME,
        IN_CLASSID,
        PLAIN_JS,
        FROM,
        FROM_INSTANCEOF,
        CLASS_ALIAS,
        JSBLOCK,
        JSBLOCK1,
        ERROR;

    }
}

