/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paths {
    protected static final Context.Key<Paths> pathsKey = new Context.Key();
    private Log log;
    private Options options;
    private Lint lint;
    private static boolean NON_BATCH_MODE = System.getProperty("nonBatchMode") != null;
    private static Map<File, PathEntry> pathExistanceCache = new ConcurrentHashMap<File, PathEntry>();
    private static Map<File, List<File>> manifestEntries = new ConcurrentHashMap<File, List<File>>();
    private static Map<File, Boolean> isDirectory = new ConcurrentHashMap<File, Boolean>();
    private static Lock lock = new ReentrantLock();
    private boolean warn;
    private Map<JavaFileManager.Location, Path> pathsForLocation;
    private boolean inited = false;
    private File bootClassPathRtJar = null;
    private Path sourceSearchPath;
    private Path classSearchPath;
    private Path otherSearchPath;

    public static Paths instance(Context context) {
        Paths paths = context.get(pathsKey);
        if (paths == null) {
            paths = new Paths(context);
        }
        return paths;
    }

    public static void clearPathExistanceCache() {
        pathExistanceCache.clear();
    }

    protected Paths(Context context) {
        context.put(pathsKey, this);
        this.pathsForLocation = new HashMap<JavaFileManager.Location, Path>(16);
        this.setContext(context);
    }

    void setContext(Context context) {
        this.log = Log.instance(context);
        this.options = Options.instance(context);
        this.lint = Lint.instance(context);
    }

    Path getPathForLocation(JavaFileManager.Location location) {
        Path path = this.pathsForLocation.get(location);
        if (path == null) {
            this.setPathForLocation(location, null);
        }
        return this.pathsForLocation.get(location);
    }

    void setPathForLocation(JavaFileManager.Location location, Iterable<? extends File> iterable) {
        Path path;
        if (iterable == null) {
            path = location == StandardLocation.CLASS_PATH ? this.computeUserClassPath() : (location == StandardLocation.PLATFORM_CLASS_PATH ? this.computeBootClassPath() : (location == StandardLocation.ANNOTATION_PROCESSOR_PATH ? this.computeAnnotationProcessorPath() : (location == StandardLocation.SOURCE_PATH ? this.computeSourcePath() : null)));
        } else {
            path = new Path();
            for (File file : iterable) {
                path.addFile(file, this.warn);
            }
        }
        this.pathsForLocation.put(location, path);
    }

    protected void lazy() {
        if (!this.inited) {
            this.warn = this.lint.isEnabled(Lint.LintCategory.PATH);
            this.pathsForLocation.put(StandardLocation.PLATFORM_CLASS_PATH, this.computeBootClassPath());
            this.pathsForLocation.put(StandardLocation.CLASS_PATH, this.computeUserClassPath());
            this.pathsForLocation.put(StandardLocation.SOURCE_PATH, this.computeSourcePath());
            this.inited = true;
        }
    }

    public Collection<File> bootClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.getPathForLocation(StandardLocation.PLATFORM_CLASS_PATH));
    }

    public Collection<File> userClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.getPathForLocation(StandardLocation.CLASS_PATH));
    }

    public Collection<File> sourcePath() {
        this.lazy();
        Path path = this.getPathForLocation(StandardLocation.SOURCE_PATH);
        return path == null || path.size() == 0 ? null : Collections.unmodifiableCollection(path);
    }

    boolean isBootClassPathRtJar(File file) {
        return file.equals(this.bootClassPathRtJar);
    }

    private Path computeBootClassPath() {
        this.bootClassPathRtJar = null;
        Path path = new Path();
        path.addFiles(this.options.get(OptionName.XBOOTCLASSPATH_PREPEND));
        String string = this.options.get(OptionName.ENDORSEDDIRS);
        if (string != null) {
            path.addDirectories(string);
        } else {
            path.addDirectories(System.getProperty("java.endorsed.dirs"), false);
        }
        string = this.options.get(OptionName.BOOTCLASSPATH);
        if (string != null) {
            path.addFiles(string);
        } else {
            String string2 = System.getProperty("sun.boot.class.path");
            path.addFiles(string2, false);
            File file = new File("rt.jar");
            for (String string3 : new PathIterator(string2, null)) {
                File file2 = new File(string3);
                if (!new File(file2.getName()).equals(file)) continue;
                this.bootClassPathRtJar = file2;
            }
        }
        path.addFiles(this.options.get(OptionName.XBOOTCLASSPATH_APPEND));
        string = this.options.get(OptionName.EXTDIRS);
        if (string != null) {
            path.addDirectories(string);
        } else {
            path.addDirectories(System.getProperty("java.ext.dirs"), false);
        }
        return path;
    }

    private Path computeUserClassPath() {
        String string = this.options.get(OptionName.CLASSPATH);
        if (string == null) {
            string = System.getProperty("env.class.path");
        }
        if (string == null && System.getProperty("application.home") == null) {
            string = System.getProperty("java.class.path");
        }
        if (string == null) {
            string = ".";
        }
        return new Path().expandJarClassPaths(true).emptyPathDefault(".").addFiles(string);
    }

    private Path computeSourcePath() {
        String string = this.options.get(OptionName.SOURCEPATH);
        if (string == null) {
            return null;
        }
        return new Path().addFiles(string);
    }

    private Path computeAnnotationProcessorPath() {
        String string = this.options.get(OptionName.PROCESSORPATH);
        if (string == null) {
            return null;
        }
        return new Path().addFiles(string);
    }

    public Collection<File> sourceSearchPath() {
        if (this.sourceSearchPath == null) {
            this.lazy();
            Path path = this.getPathForLocation(StandardLocation.SOURCE_PATH);
            Path path2 = this.getPathForLocation(StandardLocation.CLASS_PATH);
            this.sourceSearchPath = path != null ? path : path2;
        }
        return Collections.unmodifiableCollection(this.sourceSearchPath);
    }

    public Collection<File> classSearchPath() {
        if (this.classSearchPath == null) {
            this.lazy();
            Path path = this.getPathForLocation(StandardLocation.PLATFORM_CLASS_PATH);
            Path path2 = this.getPathForLocation(StandardLocation.CLASS_PATH);
            this.classSearchPath = new Path();
            this.classSearchPath.addAll(path);
            this.classSearchPath.addAll(path2);
        }
        return Collections.unmodifiableCollection(this.classSearchPath);
    }

    Collection<File> otherSearchPath() {
        if (this.otherSearchPath == null) {
            this.lazy();
            Path path = this.getPathForLocation(StandardLocation.CLASS_PATH);
            Path path2 = this.getPathForLocation(StandardLocation.SOURCE_PATH);
            if (path2 == null) {
                this.otherSearchPath = path;
            } else {
                this.otherSearchPath = new Path();
                this.otherSearchPath.addAll(path);
                this.otherSearchPath.addAll(path2);
            }
        }
        return Collections.unmodifiableCollection(this.otherSearchPath);
    }

    private static boolean isArchive(File file) {
        String string = file.getName().toLowerCase();
        boolean bl = false;
        if (!NON_BATCH_MODE) {
            Boolean bl2 = isDirectory.get(file);
            if (bl2 == null) {
                bl = file.isFile();
                isDirectory.put(file, bl);
            } else {
                bl = bl2;
            }
        } else {
            bl = file.isFile();
        }
        return bl && (string.endsWith(".jar") || string.endsWith(".zip"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Path
    extends LinkedHashSet<File> {
        private static final long serialVersionUID = 0L;
        private boolean expandJarClassPaths = false;
        private Set<File> canonicalValues = new HashSet<File>();
        private String emptyPathDefault = null;

        public Path expandJarClassPaths(boolean bl) {
            this.expandJarClassPaths = bl;
            return this;
        }

        public Path emptyPathDefault(String string) {
            this.emptyPathDefault = string;
            return this;
        }

        public Path addDirectories(String string, boolean bl) {
            if (string != null) {
                for (String string2 : new PathIterator(string)) {
                    this.addDirectory(string2, bl);
                }
            }
            return this;
        }

        public Path addDirectories(String string) {
            return this.addDirectories(string, Paths.this.warn);
        }

        private void addDirectory(String string, boolean bl) {
            if (!new File(string).isDirectory()) {
                if (bl) {
                    Paths.this.log.warning("dir.path.element.not.found", string);
                }
                return;
            }
            File[] fileArray = new File(string).listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file : fileArray) {
                if (!Paths.isArchive(file)) continue;
                this.addFile(file, bl);
            }
        }

        public Path addFiles(String string, boolean bl) {
            if (string != null) {
                for (String string2 : new PathIterator(string, this.emptyPathDefault)) {
                    this.addFile(string2, bl);
                }
            }
            return this;
        }

        public Path addFiles(String string) {
            return this.addFiles(string, Paths.this.warn);
        }

        public Path addFile(String string, boolean bl) {
            this.addFile(new File(string), bl);
            return this;
        }

        public void addFile(File file, boolean bl) {
            boolean bl2 = false;
            PathEntry pathEntry = null;
            if (!NON_BATCH_MODE) {
                pathEntry = (PathEntry)pathExistanceCache.get(file);
                if (pathEntry != null) {
                    bl2 = true;
                } else {
                    pathEntry = new PathEntry();
                }
            } else {
                pathEntry = new PathEntry();
            }
            try {
                if (!bl2) {
                    pathEntry.cannonicalPath = file.getCanonicalFile();
                } else {
                    File file2 = pathEntry.cannonicalPath;
                }
            }
            catch (IOException iOException) {
                File file3;
                pathEntry.cannonicalPath = file3 = file;
            }
            if (this.contains(file) || this.canonicalValues.contains(pathEntry.cannonicalPath)) {
                return;
            }
            if (!bl2) {
                pathEntry.exists = file.exists();
                pathEntry.isFile = file.isFile();
                if (!NON_BATCH_MODE) {
                    pathExistanceCache.put(file, pathEntry);
                }
            }
            if (!pathEntry.exists) {
                if (bl) {
                    Paths.this.log.warning("path.element.not.found", file);
                }
            } else if (pathEntry.isFile && !Paths.isArchive(file)) {
                try {
                    ZipFile zipFile = new ZipFile(file);
                    zipFile.close();
                    if (bl) {
                        Paths.this.log.warning("unexpected.archive.file", file);
                    }
                }
                catch (IOException iOException) {
                    if (bl) {
                        Paths.this.log.warning("invalid.archive.file", file);
                    }
                    return;
                }
            }
            super.add(file);
            this.canonicalValues.add(pathEntry.cannonicalPath);
            if (this.expandJarClassPaths && file.exists() && file.isFile()) {
                this.addJarClassPath(file, bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addJarClassPath(File file, boolean bl) {
            try {
                JarFile jarFile;
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                Attributes attributes;
                                ArrayList<File> arrayList = (ArrayList<File>)manifestEntries.get(file);
                                if (!NON_BATCH_MODE) {
                                    lock.lock();
                                    try {
                                        if (arrayList != null) {
                                            Iterator iterator = arrayList.iterator();
                                            while (true) {
                                                if (!iterator.hasNext()) {
                                                    Object var7_9 = null;
                                                    lock.unlock();
                                                    return;
                                                }
                                                File file2 = (File)iterator.next();
                                                this.addFile(file2, bl);
                                            }
                                        }
                                        attributes = null;
                                        lock.unlock();
                                    }
                                    catch (Throwable throwable) {
                                        Object var7_11 = null;
                                        lock.unlock();
                                        throw throwable;
                                    }
                                }
                                if (!NON_BATCH_MODE) {
                                    arrayList = new ArrayList<File>();
                                    manifestEntries.put(file, arrayList);
                                }
                                String string = file.getParent();
                                jarFile = new JarFile(file);
                                try {
                                    Manifest manifest = jarFile.getManifest();
                                    if (manifest == null) {
                                        Object var15_14 = null;
                                        break block17;
                                    }
                                    attributes = manifest.getMainAttributes();
                                    if (attributes == null) {
                                        break block18;
                                    }
                                    String string2 = attributes.getValue(Attributes.Name.CLASS_PATH);
                                    if (string2 == null) {
                                        break block19;
                                    }
                                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                                    while (stringTokenizer.hasMoreTokens()) {
                                        Object var13_23;
                                        String string3 = stringTokenizer.nextToken();
                                        File file3 = string == null ? new File(string3) : new File(string, string3);
                                        this.addFile(file3, bl);
                                        if (NON_BATCH_MODE) continue;
                                        lock.lock();
                                        try {
                                            arrayList.add(file3);
                                            var13_23 = null;
                                            lock.unlock();
                                        }
                                        catch (Throwable throwable) {
                                            var13_23 = null;
                                            lock.unlock();
                                            throw throwable;
                                        }
                                    }
                                    break block20;
                                }
                                catch (Throwable throwable) {
                                    Object var15_18 = null;
                                    jarFile.close();
                                    throw throwable;
                                }
                            }
                            jarFile.close();
                            return;
                        }
                        Object var15_15 = null;
                        jarFile.close();
                        return;
                    }
                    Object var15_16 = null;
                    jarFile.close();
                    return;
                }
                Object var15_17 = null;
                jarFile.close();
                return;
            }
            catch (IOException iOException) {
                Paths.this.log.error("error.reading.file", file, iOException.getLocalizedMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathIterator
    implements Iterable<String> {
        private int pos = 0;
        private final String path;
        private final String emptyPathDefault;

        public PathIterator(String string, String string2) {
            this.path = string;
            this.emptyPathDefault = string2;
        }

        public PathIterator(String string) {
            this(string, null);
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return PathIterator.this.pos <= PathIterator.this.path.length();
                }

                @Override
                public String next() {
                    int n = PathIterator.this.pos;
                    int n2 = PathIterator.this.path.indexOf(File.pathSeparator, n);
                    if (n2 == -1) {
                        n2 = PathIterator.this.path.length();
                    }
                    PathIterator.this.pos = n2 + 1;
                    if (n == n2 && PathIterator.this.emptyPathDefault != null) {
                        return PathIterator.this.emptyPathDefault;
                    }
                    return PathIterator.this.path.substring(n, n2);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class PathEntry {
        boolean exists = false;
        boolean isFile = false;
        File cannonicalPath = null;

        PathEntry() {
        }
    }
}

