/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.jruby.util.ByteList;
import org.jvyamlb.PositioningComposerImpl;
import org.jvyamlb.PositioningParser;
import org.jvyamlb.PositioningParserImpl;
import org.jvyamlb.PositioningScanner;
import org.jvyamlb.PositioningScannerImpl;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.exceptions.PositionedParserException;
import org.jvyamlb.nodes.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.netbeans.modules.languages.yaml.YamlTokenId;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.util.NbBundle;

public class YamlParser
extends Parser {
    private static final Logger LOGGER = Logger.getLogger(YamlParser.class.getName());
    private static final int MAX_LENGTH = 524288;
    private YamlParserResult lastResult;

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void cancel() {
    }

    public Parser.Result getResult(Task task) throws ParseException {
        assert (this.lastResult != null) : "getResult() called prior parse()";
        return this.lastResult;
    }

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    private boolean isTooLarge(String string) {
        return string.length() > 524288;
    }

    private YamlParserResult resultForTooLargeFile(Snapshot snapshot) {
        YamlParserResult yamlParserResult = new YamlParserResult(Collections.<Node>emptyList(), this, snapshot, false, null, null);
        DefaultError defaultError = new DefaultError(null, NbBundle.getMessage(YamlParser.class, (String)"TooLarge"), null, snapshot.getSource().getFileObject(), 0, 0, Severity.WARNING);
        yamlParserResult.addError((Error)defaultError);
        return yamlParserResult;
    }

    YamlParserResult parse(String string, Snapshot snapshot) {
        try {
            Node node;
            Object object;
            ByteArrayOutputStream byteArrayOutputStream;
            if (this.isTooLarge(string)) {
                return this.resultForTooLargeFile(snapshot);
            }
            ByteList byteList = null;
            int[] nArray = null;
            int[] nArray2 = null;
            byte[] byArray = string.getBytes("UTF-8");
            if (byArray.length == string.length()) {
                byteList = new ByteList(byArray);
            } else {
                int n;
                byteArrayOutputStream = new ByteArrayOutputStream(2 * string.length());
                object = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
                nArray2 = new int[string.length()];
                int n2 = 0;
                int n3 = string.length();
                for (n = 0; n < n3; ++n) {
                    ((OutputStreamWriter)object).write(string.charAt(n));
                    ((OutputStreamWriter)object).flush();
                    nArray2[n] = n2;
                    n2 = byteArrayOutputStream.size();
                }
                if (n2 > 0) {
                    nArray = new int[n2];
                    n3 = nArray2.length;
                    for (n = 0; n < n3; ++n) {
                        nArray[nArray2[n]] = n;
                    }
                    n = 0;
                    int n4 = nArray.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        int n5 = nArray[n3];
                        if (n5 == 0) {
                            nArray[n3] = n;
                            continue;
                        }
                        n = n5;
                    }
                } else {
                    nArray = new int[]{};
                }
                byteList = new ByteList(byteArrayOutputStream.toByteArray());
            }
            byteArrayOutputStream = new PositioningComposerImpl((PositioningParser)new PositioningParserImpl((PositioningScanner)new PositioningScannerImpl(byteList)), (Resolver)new ResolverImpl());
            object = new ArrayList();
            Iterator iterator = byteArrayOutputStream.eachNode();
            while (iterator.hasNext() && (node = (Node)iterator.next()) != null) {
                object.add(node);
            }
            return new YamlParserResult((List<Node>)object, this, snapshot, true, nArray, nArray2);
        }
        catch (Exception exception) {
            Object object;
            int n = 0;
            if (exception instanceof PositionedParserException) {
                object = (PositionedParserException)exception;
                n = object.getPosition().offset;
            }
            object = new YamlParserResult(Collections.<Node>emptyList(), this, snapshot, false, null, null);
            String string2 = exception.getMessage();
            if (string2 != null && string2.length() > 0) {
                if (string2.startsWith("ScannerException null ")) {
                    string2 = string2.substring(22);
                } else if (string2.startsWith("ParserException ")) {
                    string2 = string2.substring(16);
                }
                char c = string2.charAt(0);
                char c2 = Character.toUpperCase(c);
                if (c != c2) {
                    string2 = c2 + string2.substring(1);
                }
                DefaultError defaultError = new DefaultError(null, string2, null, snapshot.getSource().getFileObject(), n, n, Severity.ERROR);
                ((YamlParserResult)((Object)object)).addError((Error)defaultError);
            }
            return object;
        }
    }

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent sourceModificationEvent) throws ParseException {
        String string = YamlParser.asString(snapshot.getText());
        if (this.isTooLarge(string)) {
            LOGGER.log(Level.FINE, "Skipping {0}, too large to parse (length: {1})", new Object[]{snapshot.getSource().getFileObject(), string.length()});
            this.lastResult = this.resultForTooLargeFile(snapshot);
            return;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, YamlTokenId.language());
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            int n = 0;
            tokenSequence.move(n);
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                TokenId tokenId = token.id();
                if (tokenId == YamlTokenId.RUBY_EXPR) {
                    String string2 = "__";
                    stringBuilder.append(string2);
                    int n2 = token.length() - string2.length();
                    for (int i = 0; i < n2; ++i) {
                        stringBuilder.append(' ');
                    }
                    continue;
                }
                if (tokenId == YamlTokenId.RUBY || tokenId == YamlTokenId.RUBYCOMMENT || tokenId == YamlTokenId.DELIMITER) {
                    for (int i = 0; i < token.length(); ++i) {
                        stringBuilder.append(' ');
                    }
                    continue;
                }
                stringBuilder.append(((Object)token.text()).toString());
            }
            string = stringBuilder.toString();
            this.lastResult = this.parse(string, snapshot);
        }
        catch (Exception exception) {
            this.lastResult = new YamlParserResult(Collections.<Node>emptyList(), this, snapshot, false, null, null);
        }
    }
}

