/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jvyamlb.Position;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.PositionedScalarNode;
import org.jvyamlb.nodes.PositionedSequenceNode;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlSemanticAnalyzer
extends SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        YamlParserResult yamlParserResult = (YamlParserResult)result;
        if (yamlParserResult == null || yamlParserResult.getRootNodes().size() == 0) {
            this.semanticHighlights = Collections.emptyMap();
            return;
        }
        List<Node> list = yamlParserResult.getRootNodes();
        HashMap<OffsetRange, Set<ColoringAttributes>> hashMap = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        IdentityHashMap<Object, Boolean> identityHashMap = new IdentityHashMap<Object, Boolean>(100);
        for (Node node : list) {
            this.addHighlights(yamlParserResult, node, hashMap, identityHashMap, 0);
        }
        this.semanticHighlights = hashMap;
    }

    private void addHighlights(YamlParserResult yamlParserResult, Node node, Map<OffsetRange, Set<ColoringAttributes>> map, IdentityHashMap<Object, Boolean> identityHashMap, int n) {
        block14: {
            Object object;
            block13: {
                if (n > 10 || node == null) {
                    return;
                }
                object = node.getValue();
                if (identityHashMap.containsKey(object)) {
                    return;
                }
                identityHashMap.put(object, Boolean.TRUE);
                if (!(object instanceof Map)) break block13;
                Map map2 = (Map)object;
                Set set = map2.entrySet();
                for (Map.Entry entry : set) {
                    Object object2;
                    List list;
                    Object object3;
                    PositionedSequenceNode positionedSequenceNode;
                    Object k = entry.getKey();
                    if (k instanceof PositionedSequenceNode) {
                        Object object42;
                        positionedSequenceNode = (PositionedSequenceNode)k;
                        object3 = positionedSequenceNode.getValue();
                        assert (object3 instanceof List);
                        list = (List)object3;
                        for (Object object42 : list) {
                            if (object42 == node) {
                                return;
                            }
                            this.addHighlights(yamlParserResult, (Node)object42, map, identityHashMap, n + 1);
                        }
                        object2 = entry.getValue();
                        if (!(object2 instanceof PositionedSequenceNode)) continue;
                        positionedSequenceNode = (PositionedSequenceNode)object2;
                        object3 = positionedSequenceNode.getValue();
                        assert (object3 instanceof List);
                        list = (List)object3;
                        object42 = list.iterator();
                        while (object42.hasNext()) {
                            Node node2 = (Node)object42.next();
                            if (node2 == node) {
                                return;
                            }
                            this.addHighlights(yamlParserResult, node2, map, identityHashMap, n + 1);
                        }
                        continue;
                    }
                    assert (k instanceof PositionedScalarNode);
                    positionedSequenceNode = (PositionedScalarNode)k;
                    object3 = positionedSequenceNode.getRange();
                    list = yamlParserResult.getAstRange((Position.Range)object3);
                    map.put((OffsetRange)list, ColoringAttributes.METHOD_SET);
                    object2 = (Node)entry.getValue();
                    this.addHighlights(yamlParserResult, (Node)object2, map, identityHashMap, n + 1);
                }
                break block14;
            }
            if (!(object instanceof List)) break block14;
            List list = (List)object;
            for (Node node3 : list) {
                if (node3 == node) {
                    return;
                }
                this.addHighlights(yamlParserResult, node3, map, identityHashMap, n + 1);
            }
        }
    }
}

