/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RDocAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(RDocAnalyzer.class.getName());
    static final String PARAM_HINT_ARG = "#:arg:";
    static final String PARAM_HINT_RETURN = "#:return:=>";
    private static final List<TypeCommentAnalyzer> RAW_TYPE_COMMENT_ANALYZERS = RDocAnalyzer.initRawTypeCommentAnalyzers();
    private static final List<TypeCommentAnalyzer> TYPE_COMMENT_ANALYZERS = RDocAnalyzer.initTypeCommentAnalyzers();
    private final RubyType type = new RubyType();

    private RDocAnalyzer() {
    }

    private static List<TypeCommentAnalyzer> initRawTypeCommentAnalyzers() {
        ArrayList<TypeCommentAnalyzer> arrayList = new ArrayList<TypeCommentAnalyzer>();
        arrayList.add(new HashAnalyzer());
        arrayList.add(new ArrayAnalyzer());
        return arrayList;
    }

    private static List<TypeCommentAnalyzer> initTypeCommentAnalyzers() {
        ArrayList<TypeCommentAnalyzer> arrayList = new ArrayList<TypeCommentAnalyzer>();
        arrayList.add(new ClassNameAnalyzer());
        arrayList.add(new CustomClassNameAnalyzer());
        arrayList.add(new NumericAnalyzer());
        arrayList.add(new TrueFalseAnalyzer());
        arrayList.add(new StringAnalyzer());
        return arrayList;
    }

    static RubyType collectTypesFromComment(List<? extends String> list) {
        String string;
        String string2;
        RDocAnalyzer rDocAnalyzer = new RDocAnalyzer();
        Iterator<? extends String> iterator = list.iterator();
        while (iterator.hasNext() && (string2 = (string = iterator.next()).trim()).startsWith("#  ")) {
            rDocAnalyzer.parseTypeFromLine(string2);
        }
        return rDocAnalyzer.type;
    }

    private void parseTypeFromLine(String string) {
        String[] stringArray;
        int n = string.indexOf(" #=> ");
        if (n == -1) {
            n = string.indexOf(" -> ");
        }
        if (n == -1) {
            n = string.indexOf(" => ");
        }
        if (n == -1) {
            return;
        }
        String string2 = string.substring(n + 4).trim();
        if (string2.length() == 0) {
            return;
        }
        boolean bl = false;
        for (String string3 : stringArray = string2.split(" or ")) {
            String[] stringArray2 = RAW_TYPE_COMMENT_ANALYZERS.iterator();
            while (stringArray2.hasNext()) {
                String[] stringArray3 = stringArray2.next();
                String string4 = stringArray3.getType(string3);
                if (string4 == null) continue;
                this.type.add(string4);
                bl = true;
                return;
            }
            for (String string5 : stringArray2 = string3.split(",")) {
                if ((string5 = string5.trim()).length() <= 0) continue;
                bl = this.addRealTypeForCommentType(string5);
            }
            if (bl) continue;
            LOGGER.log(Level.FINE, "Could not resolve type for {0}", string);
        }
    }

    private boolean addRealTypeForCommentType(String string) {
        boolean bl = false;
        for (TypeCommentAnalyzer typeCommentAnalyzer : TYPE_COMMENT_ANALYZERS) {
            String string2 = typeCommentAnalyzer.getType(string);
            if (string2 == null) continue;
            this.type.add(string2);
            bl = true;
            break;
        }
        return bl;
    }

    static void collectTypeAssertions(ContextKnowledge contextKnowledge) {
        Source source;
        List<String> list;
        if (!contextKnowledge.hasDocument()) {
            return;
        }
        Node node = contextKnowledge.getRoot();
        if (node instanceof MethodDefNode && (list = AstUtilities.gatherDocumentation((source = Source.create((Document)contextKnowledge.getDocument())).createSnapshot(), node)) != null && list.size() > 0) {
            for (String string : list) {
                char c;
                int n;
                if (!string.startsWith(PARAM_HINT_ARG)) continue;
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = null;
                int n2 = string.length();
                for (n = PARAM_HINT_ARG.length(); n < n2; ++n) {
                    c = string.charAt(n);
                    if (c == ' ') continue;
                    if (c == '=') break;
                    stringBuilder.append(c);
                }
                if (n == n2 || string.charAt(n) != '=') continue;
                ++n;
                if (stringBuilder.length() <= 0) continue;
                string2 = stringBuilder.toString();
                stringBuilder.setLength(0);
                if (n == n2 || string.charAt(n) != '>') continue;
                ++n;
                while (n < n2) {
                    c = string.charAt(n);
                    if (c != ' ') {
                        if (!Character.isJavaIdentifierPart(c)) break;
                        stringBuilder.append(c);
                    }
                    ++n;
                }
                if (stringBuilder.length() <= 0) continue;
                String string3 = stringBuilder.toString();
                contextKnowledge.maybePutTypeForSymbol(string2, string3, true);
            }
        }
    }

    static List<String> getStandardNameVariants(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(9);
        arrayList.add(string);
        arrayList.add("a_" + string);
        arrayList.add("an_" + string);
        String string2 = RubyUtils.camelToUnderlinedName(string);
        arrayList.add(string2);
        arrayList.add("a_" + string2);
        arrayList.add("an_" + string2);
        String string3 = RubyUtils.underlinedNameToCamel(string);
        arrayList.add(string3);
        arrayList.add("a" + string3);
        arrayList.add("an" + string3);
        return arrayList;
    }

    private static String validName(String string) {
        if (RubyUtils.isValidConstantName(string)) {
            return string;
        }
        return null;
    }

    static String resolveType(String string) {
        if ("".equals(string.trim()) || !Character.isLetter(string.charAt(0))) {
            return null;
        }
        if (string.startsWith("an_")) {
            return RDocAnalyzer.validName(RubyUtils.underlinedNameToCamel(string.substring(3)));
        }
        if (string.startsWith("a_")) {
            return RDocAnalyzer.validName(RubyUtils.underlinedNameToCamel(string.substring(2)));
        }
        if (string.startsWith("an") && string.length() > 2 && Character.isUpperCase(string.charAt(2))) {
            return RDocAnalyzer.validName(string.substring(2));
        }
        if (string.startsWith("a") && string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
            return RDocAnalyzer.validName(string.substring(1));
        }
        if (Character.isUpperCase(string.charAt(0))) {
            return RDocAnalyzer.validName(string);
        }
        return RDocAnalyzer.validName(RubyUtils.underlinedNameToCamel(string));
    }

    private static final class HashAnalyzer
    extends TypeCommentAnalyzer {
        private HashAnalyzer() {
        }

        protected String doGetType(String string) {
            String string2 = string.trim();
            if (string2.startsWith("{") && string2.endsWith("}")) {
                return "Hash";
            }
            return null;
        }
    }

    private static final class ArrayAnalyzer
    extends TypeCommentAnalyzer {
        private ArrayAnalyzer() {
        }

        protected String doGetType(String string) {
            String string2 = string.trim();
            if (string2.startsWith("[") && string2.endsWith("]")) {
                return "Array";
            }
            return null;
        }
    }

    private static final class TrueFalseAnalyzer
    extends TypeCommentAnalyzer {
        private static final String[] TRUE_TYPES = new String[]{"true"};
        private static final String[] FALSE_TYPES = new String[]{"false"};

        private TrueFalseAnalyzer() {
        }

        protected String doGetType(String string) {
            for (String string2 : TRUE_TYPES) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return "TrueClass";
            }
            for (String string2 : FALSE_TYPES) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return "FalseClass";
            }
            return null;
        }
    }

    private static final class StringAnalyzer
    extends TypeCommentAnalyzer {
        private StringAnalyzer() {
        }

        protected String doGetType(String string) {
            return string.startsWith("\"") && string.endsWith("\"") ? "String" : null;
        }
    }

    private static final class NumericAnalyzer
    extends TypeCommentAnalyzer {
        private NumericAnalyzer() {
        }

        protected String doGetType(String string) {
            if (this.isFixnum(string)) {
                return "Fixnum";
            }
            if (this.isFloat(string)) {
                return "Float";
            }
            return null;
        }

        private boolean isFixnum(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                if (string.startsWith("+") && string.length() > 1) {
                    return this.isFixnum(string.substring(1));
                }
                return false;
            }
        }

        private boolean isFloat(String string) {
            try {
                Float.parseFloat(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    private static final class CustomClassNameAnalyzer
    extends TypeCommentAnalyzer {
        private static final String[] EXCEPTIONS = new String[]{"Self", "Key", "Value", "Detail", "Result"};

        private CustomClassNameAnalyzer() {
        }

        protected String doGetType(String string) {
            String string2 = RDocAnalyzer.resolveType(string);
            for (String string3 : EXCEPTIONS) {
                if (!string3.equals(string2)) continue;
                return null;
            }
            return string2;
        }
    }

    private static final class ClassNameAnalyzer
    extends TypeCommentAnalyzer {
        private static final Map<String, String> COMMENT_TYPE_TO_REAL_TYPE = new HashMap<String, String>();

        private ClassNameAnalyzer() {
        }

        private static void putType(String string, String string2) {
            for (String string3 : RDocAnalyzer.getStandardNameVariants(string)) {
                COMMENT_TYPE_TO_REAL_TYPE.put(string3, string2);
            }
        }

        protected String doGetType(String string) {
            return COMMENT_TYPE_TO_REAL_TYPE.get(string);
        }

        static {
            COMMENT_TYPE_TO_REAL_TYPE.put("!obj", "FalseClass");
            ClassNameAnalyzer.putType("abs_file_name", "String");
            ClassNameAnalyzer.putType("class", "Class");
            ClassNameAnalyzer.putType("super_class", "Class");
            ClassNameAnalyzer.putType("klass", "Class");
            ClassNameAnalyzer.putType("dir", "Dir");
            ClassNameAnalyzer.putType("dir_name", "String");
            ClassNameAnalyzer.putType("fixnum", "Fixnum");
            ClassNameAnalyzer.putType("hash", "Hash");
            ClassNameAnalyzer.putType("hsh", "Hash");
            ClassNameAnalyzer.putType("array", "Array");
            ClassNameAnalyzer.putType("sub_array", "Array");
            ClassNameAnalyzer.putType("ary", "Array");
            ClassNameAnalyzer.putType("object", "Object");
            ClassNameAnalyzer.putType("enum", "Enumeration");
            ClassNameAnalyzer.putType("enumerat", "Enumeration");
            ClassNameAnalyzer.putType("enumerator", "Enumeration");
            ClassNameAnalyzer.putType("enumeration", "Enumeration");
            ClassNameAnalyzer.putType("io", "IO");
            ClassNameAnalyzer.putType("ios", "IO");
            ClassNameAnalyzer.putType("proc", "Proc");
            ClassNameAnalyzer.putType("str", "String");
            ClassNameAnalyzer.putType("base_name", "String");
            ClassNameAnalyzer.putType("big", "Bignum");
            ClassNameAnalyzer.putType("bignum", "Bignum");
            ClassNameAnalyzer.putType("boolean", "TrueClass");
            ClassNameAnalyzer.putType("bool", "TrueClass");
            ClassNameAnalyzer.putType("buffer", "String");
            ClassNameAnalyzer.putType("binding", "Binding");
            ClassNameAnalyzer.putType("exception", "Exception");
            ClassNameAnalyzer.putType("no_method_error", "NoMethodError");
            COMMENT_TYPE_TO_REAL_TYPE.put("false", "FalseClass");
            ClassNameAnalyzer.putType("file", "File");
            ClassNameAnalyzer.putType("fixnum", "Fixnum");
            ClassNameAnalyzer.putType("float", "Float");
            ClassNameAnalyzer.putType("flt", "Float");
            COMMENT_TYPE_TO_REAL_TYPE.put(":foo", "Symbol");
            ClassNameAnalyzer.putType("integer", "Integer");
            ClassNameAnalyzer.putType("int", "Integer");
            ClassNameAnalyzer.putType("matchdata", "MatchData");
            ClassNameAnalyzer.putType("method", "Method");
            ClassNameAnalyzer.putType("mod", "Module");
            ClassNameAnalyzer.putType("name_error", "NameError");
            ClassNameAnalyzer.putType("new_method", "UnboundMethod");
            ClassNameAnalyzer.putType("new_regexp", "Regexp");
            ClassNameAnalyzer.putType("new_str", "String");
            ClassNameAnalyzer.putType("new_time", "Time");
            ClassNameAnalyzer.putType("nil", "NilClass");
            ClassNameAnalyzer.putType("number", "Numeric");
            ClassNameAnalyzer.putType("numeric", "Numeric");
            ClassNameAnalyzer.putType("numeric_result", "Numeric");
            ClassNameAnalyzer.putType("num", "Numeric");
            ClassNameAnalyzer.putType("obj", "Object");
            ClassNameAnalyzer.putType("other_big", "Bignum");
            ClassNameAnalyzer.putType("outbuf", "String");
            ClassNameAnalyzer.putType("prc", "Proc");
            ClassNameAnalyzer.putType("range", "Range");
            ClassNameAnalyzer.putType("regexp", "Regexp");
            ClassNameAnalyzer.putType("rng", "Range");
            COMMENT_TYPE_TO_REAL_TYPE.put("stat", "File::Stat");
            ClassNameAnalyzer.putType("string", "String");
            ClassNameAnalyzer.putType("str", "String");
            ClassNameAnalyzer.putType("system_exit", "SystemExit");
            ClassNameAnalyzer.putType("struct", "Struct");
            ClassNameAnalyzer.putType("struct_tms", "Struct::Tms");
            ClassNameAnalyzer.putType("symbol", "Symbol");
            ClassNameAnalyzer.putType("sym", "Symbol");
            ClassNameAnalyzer.putType("thgrp", "ThreadGroup");
            ClassNameAnalyzer.putType("thread", "Thread");
            ClassNameAnalyzer.putType("thr", "Thread");
            ClassNameAnalyzer.putType("time", "Time");
            COMMENT_TYPE_TO_REAL_TYPE.put("class_or_module", "Class");
            COMMENT_TYPE_TO_REAL_TYPE.put("e", "Enumeration");
            COMMENT_TYPE_TO_REAL_TYPE.put("old_seed", "Numeric");
            COMMENT_TYPE_TO_REAL_TYPE.put("old_seed", "Numeric");
            COMMENT_TYPE_TO_REAL_TYPE.put("true", "TrueClass");
            COMMENT_TYPE_TO_REAL_TYPE.put("false", "FalseClass");
            COMMENT_TYPE_TO_REAL_TYPE.put("path", "String");
            COMMENT_TYPE_TO_REAL_TYPE.put("$_", "String");
            ClassNameAnalyzer.putType("unbound_method", "UnboundMethod");
        }
    }

    private static abstract class TypeCommentAnalyzer {
        private TypeCommentAnalyzer() {
        }

        final String getType(String string) {
            String string2 = this.doGetType(string);
            if (string2 != null && LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Resolved type [" + string2 + "] for comment: [" + string + "]. " + "Analyzer: [" + this.getClass().getSimpleName() + "].");
            }
            return string2;
        }

        protected abstract String doGetType(String var1);
    }
}

