/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.List;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.RubyBaseCompleter;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.RubyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RubyKeywordCompleter
extends RubyBaseCompleter {
    private static final String[] RUBY_DOLLAR_VARIABLES = new String[]{"$!", "The exception information message set by 'raise'.", "$@", "Array of backtrace of the last exception thrown.", "$&", "The string matched by the last successful pattern match in this scope.", "$`", "The string to the left  of the last successful match.", "$'", "The string to the right of the last successful match.", "$+", "The last bracket matched by the last successful match.", "$n", "The Nth group of the last successful regexp match.", "$~", "The information about the last match in the current scope.", "$=", "The flag for case insensitive, nil by default.", "$/", "The input record separator, newline by default.", "$\\", "The output record separator for the print and IO#write. Default is nil.", "$,", "The output field separator for the print and Array#join.", "$;", "The default separator for String#split.", "$.", "The current input line number of the last file that was read.", "$<", "The virtual concatenation file of the files given on command line.", "$>", "The default output for print, printf. $stdout by default.", "$_", "The last input line of string by gets or readline.", "$0", "Contains the name of the script being executed. May be assignable.", "$*", "Command line arguments given for the script sans args.", "$$", "The process number of the Ruby running this script.", "$?", "The status of the last executed child process.", "$:", "Load path for scripts and binary modules by load or require.", "$\"", "The array contains the module names loaded by require.", "$DEBUG", "The status of the -d switch.", "$FILENAME", "Current input file from $&lt;. Same as $&lt;.filename.", "$LOAD_PATH", "The alias to the $:.", "$stderr", "The current standard error output.", "$stdin", "The current standard input.", "$stdout", "The current standard output.", "$VERBOSE", "The verbose flag, which is set by the -v switch.", "$-0", "The alias to $/.", "$-a", "True if option -a (\"autosplit\" mode) is set. Read-only variable.", "$-d", "The alias to $DEBUG.", "$-F", "The alias to $;.", "$-i", "If in-place-edit mode is set, this variable holds the extension, otherwise nil.", "$-I", "The alias to $:.", "$-l", "True if option -l is set (\"line-ending processing\" is on). Read-only variable.", "$-p", "True if option -p is set (\"loop\" mode is on). Read-only variable.", "$-v", "The alias to $VERBOSE.", "$-w", "True if option -w is set."};
    private final boolean isSymbol;

    static boolean complete(List<? super CompletionProposal> list, CompletionRequest completionRequest, int n, boolean bl, boolean bl2) {
        RubyKeywordCompleter rubyKeywordCompleter = new RubyKeywordCompleter(list, completionRequest, n, bl, bl2);
        return rubyKeywordCompleter.complete();
    }

    private RubyKeywordCompleter(List<? super CompletionProposal> list, CompletionRequest completionRequest, int n, boolean bl, boolean bl2) {
        super(list, completionRequest, n, bl);
        this.isSymbol = bl2;
    }

    private boolean complete() {
        RubyCompletionItem.KeywordItem keywordItem;
        String string = this.request.prefix;
        if (string.equals("$")) {
            int n = RUBY_DOLLAR_VARIABLES.length;
            for (int i = 0; i < n; i += 2) {
                String string2 = RUBY_DOLLAR_VARIABLES[i];
                String string3 = RUBY_DOLLAR_VARIABLES[i + 1];
                keywordItem = new RubyCompletionItem.KeywordItem(string2, string3, this.anchor, this.request);
                if (this.isSymbol) {
                    keywordItem.setSymbol(true);
                }
                this.propose((CompletionProposal)keywordItem);
            }
        }
        for (String string3 : RubyUtils.RUBY_PREDEF_VAR) {
            if (!RubyCodeCompleter.startsWith(string3, string, this.caseSensitive)) continue;
            keywordItem = new RubyCompletionItem.KeywordItem(string3, null, this.anchor, this.request);
            if (this.isSymbol) {
                keywordItem.setSymbol(true);
            }
            this.propose((CompletionProposal)keywordItem);
        }
        for (String string3 : RubyUtils.RUBY_KEYWORDS) {
            if (!RubyCodeCompleter.startsWith(string3, string, this.caseSensitive)) continue;
            keywordItem = new RubyCompletionItem.KeywordItem(string3, null, this.anchor, this.request);
            if (this.isSymbol) {
                keywordItem.setSymbol(true);
            }
            this.propose((CompletionProposal)keywordItem);
        }
        return false;
    }
}

