/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.FindersHelper;
import org.netbeans.modules.ruby.RDocAnalyzer;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.options.TypeInferenceSettings;

final class RubyMethodTypeInferencer {
    private static final String[] COMPARISON_OPERATORS = new String[]{"==", "==="};
    private static final String[] RECEIVER_METHODS = new String[]{"new", "clone", "dup", "freeze"};
    private static final Map<String, RubyType> METHOD_TYPES = new HashMap<String, RubyType>(16);
    private final boolean fast;
    private Node callNodeToInfer;
    private ContextKnowledge knowledge;

    private RubyMethodTypeInferencer(Node node, ContextKnowledge contextKnowledge, boolean bl) {
        assert (AstUtilities.isCall(node)) : "Must be a call node";
        this.callNodeToInfer = node;
        this.knowledge = contextKnowledge;
        this.fast = bl;
    }

    static RubyType inferTypeFor(Node node, ContextKnowledge contextKnowledge, boolean bl) {
        return new RubyMethodTypeInferencer(node, contextKnowledge, bl).inferType();
    }

    static RubyType fastCheckType(String string) {
        if (string.endsWith("?") || RubyMethodTypeInferencer.isTrueFalseCall(string)) {
            return RubyType.BOOLEAN;
        }
        return METHOD_TYPES.get(string);
    }

    private static boolean isTrueFalseCall(String string) {
        for (String string2 : COMPARISON_OPERATORS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean returnsReceiver(String string) {
        for (String string2 : RECEIVER_METHODS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    RubyIndex getIndex() {
        return this.knowledge == null ? null : this.knowledge.getIndex();
    }

    private RubyType inferType() {
        Object object;
        String string = AstUtilities.getName(this.callNodeToInfer);
        Node node = null;
        switch (this.callNodeToInfer.getNodeType()) {
            case CALLNODE: {
                node = ((CallNode)this.callNodeToInfer).getReceiverNode();
                break;
            }
            case FCALLNODE: {
                break;
            }
            case VCALLNODE: {
                node = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal node passed: " + this.callNodeToInfer);
            }
        }
        RubyType rubyType = RubyMethodTypeInferencer.fastCheckType(string);
        if (rubyType != null) {
            return rubyType;
        }
        if (node == null) {
            return RubyType.createUnknown();
        }
        RubyType rubyType2 = this.getReceiverType(node);
        if (RubyMethodTypeInferencer.returnsReceiver(string)) {
            return rubyType2;
        }
        if (FindersHelper.isFinderMethod(string) && rubyType2.isSingleton() && this.getIndex() != null && (object = this.getIndex().getSuperclass(rubyType2.first())) != null && "ActiveRecord::Base".equals(((IndexedElement)object).getFqn())) {
            return FindersHelper.pickFinderType((CallNode)this.callNodeToInfer, string, rubyType2);
        }
        if (!TypeInferenceSettings.getDefault().getMethodTypeInference() || this.fast) {
            return RubyType.createUnknown();
        }
        object = new RubyType();
        RubyIndex rubyIndex = this.getIndex();
        if (rubyIndex != null) {
            Set<IndexedMethod> set = rubyIndex.getInheritedMethods(rubyType2, string, QuerySupport.Kind.EXACT);
            for (IndexedMethod indexedMethod : set) {
                List<String> list;
                IndexedElement indexedElement;
                RubyType rubyType3 = indexedMethod.getType();
                if (!rubyType3.isKnown() && indexedMethod.getMethodType() != IndexedMethod.MethodType.DYNAMIC_FINDER && TypeInferenceSettings.getDefault().getRdocTypeInference() && (indexedElement = RubyCodeCompleter.findDocumentationEntry(null, indexedMethod)) != null && (list = RubyCodeCompleter.getComments(null, indexedElement)) != null) {
                    rubyType3 = RDocAnalyzer.collectTypesFromComment(list);
                }
                ((RubyType)object).append(rubyType3);
            }
            rubyIndex.logMostTimeConsuming();
        }
        return object;
    }

    private RubyType getReceiverType(Node node) {
        String string;
        RubyType rubyType = RubyTypeInferencer.normal(this.knowledge).inferType(node);
        if (!rubyType.isKnown() && node instanceof INameNode && RubyUtils.isValidConstantName(string = ((INameNode)node).getName())) {
            rubyType = RubyType.create(((INameNode)node).getName());
        }
        return rubyType;
    }

    static {
        METHOD_TYPES.put("<=>", RubyType.INTEGER);
        METHOD_TYPES.put("to_s", RubyType.STRING);
        METHOD_TYPES.put("to_str", RubyType.STRING);
        METHOD_TYPES.put("to_string", RubyType.STRING);
        METHOD_TYPES.put("to_sym", RubyType.SYMBOL);
        METHOD_TYPES.put("to_symbol", RubyType.SYMBOL);
        METHOD_TYPES.put("to_a", RubyType.ARRAY);
        METHOD_TYPES.put("to_ary", RubyType.ARRAY);
        METHOD_TYPES.put("to_array", RubyType.ARRAY);
        METHOD_TYPES.put("to_i", RubyType.INTEGER);
        METHOD_TYPES.put("to_f", RubyType.FLOAT);
    }
}

