/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.RubyBaseCompleter;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.elements.CommentElement;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RubyStringCompleter
extends RubyBaseCompleter {
    private static final String[] RUBY_PERCENT_WORDS = new String[]{"%q", "String (single-quoting rules)", "%Q", "String (double-quoting rules)", "%r", "Regular Expression", "%x", "Commands", "%W", "String Array (double quoting rules)", "%w", "String Array (single quoting rules)", "%s", "Symbol"};
    private static final String[] RUBY_REGEXP_WORDS = new String[]{"^", "Start of line", "$", "End of line", "\\A", "Beginning of string", "\\z", "End of string", "\\Z", "End of string (except \\n)", "\\w", "Letter or digit; same as [0-9A-Za-z]", "\\W", "Neither letter or digit", "\\s", "Space character; same as [ \\t\\n\\r\\f]", "\\S", "Non-space character", "\\d", "Digit character; same as [0-9]", "\\D", "Non-digit character", "\\b", "Backspace (0x08) (only if in a range specification)", "\\b", "Word boundary (if not in a range specification)", "\\B", "Non-word boundary", "*", "Zero or more repetitions of the preceding", "+", "One or more repetitions of the preceding", "{m,n}", "At least m and at most n repetitions of the preceding", "?", "At most one repetition of the preceding; same as {0,1}", "|", "Either preceding or next expression may match", "()", "Grouping", "[:alnum:]", "Alphanumeric character class", "[:alpha:]", "Uppercase or lowercase letter", "[:blank:]", "Blank and tab", "[:cntrl:]", "Control characters (at least 0x00-0x1f,0x7f)", "[:digit:]", "Digit", "[:graph:]", "Printable character excluding space", "[:lower:]", "Lowecase letter", "[:print:]", "Any printable letter (including space)", "[:punct:]", "Printable character excluding space and alphanumeric", "[:space:]", "Whitespace (same as \\s)", "[:upper:]", "Uppercase letter", "[:xdigit:]", "Hex digit (0-9, a-f, A-F)"};
    private static final String[] RUBY_STRING_PAIRS = new String[]{"(", "(delimiters)", "{", "{delimiters}", "[", "[delimiters]", "x", "<i>x</i>delimiters<i>x</i>"};
    private static final String[] RUBY_QUOTED_STRING_ESCAPES = new String[]{"\\a", "Bell/alert (0x07)", "\\b", "Backspace (0x08)", "\\x", "\\x<i>nn</i>: Hex <i>nn</i>", "\\e", "Escape (0x1b)", "\\c", "Control-<i>x</i>", "\\C-", "Control-<i>x</i>", "\\f", "Formfeed (0x0c)", "\\n", "Newline (0x0a)", "\\M-", "\\M-<i>x</i>: Meta-<i>x</i>", "\\r", "Return (0x0d)", "\\M-\\C-", "Meta-control-<i>x</i>", "\\s", "Space (0x20)", "\\", "\\nnn Octal <i>nnn</i>", "\\t", "Tab (0x09)", "#{", "#{expr}: Value of expr", "\\v", "Vertical tab (0x0b)"};

    static boolean complete(List<? super CompletionProposal> list, CompletionRequest completionRequest, int n, boolean bl) {
        RubyStringCompleter rubyStringCompleter = new RubyStringCompleter(list, completionRequest, n, bl);
        return rubyStringCompleter.complete();
    }

    private RubyStringCompleter(List<? super CompletionProposal> list, CompletionRequest completionRequest, int n, boolean bl) {
        super(list, completionRequest, n, bl);
    }

    private boolean complete() {
        String string = this.request.prefix;
        int n = this.request.lexOffset;
        TokenHierarchy<Document> tokenHierarchy = this.request.th;
        TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence(tokenHierarchy, n);
        if (this.getIndex() != null && tokenSequence != null) {
            Token token;
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return false;
            }
            if (tokenSequence.offset() == n) {
                tokenSequence.movePrevious();
            }
            if ((token = tokenSequence.token()) != null) {
                int n2;
                TokenId tokenId = token.id();
                if (tokenId == RubyTokenId.LINE_COMMENT || tokenId == RubyTokenId.DOCUMENTATION) {
                    BaseDocument baseDocument;
                    OffsetRange offsetRange;
                    if (this.request.queryType == CodeCompletionHandler.QueryType.DOCUMENTATION && (offsetRange = LexUtilities.getCommentBlock(baseDocument = this.request.doc, n)) != OffsetRange.NONE) {
                        try {
                            String string2 = baseDocument.getText(offsetRange.getStart(), offsetRange.getLength());
                            if (string2.startsWith("=begin\n") && string2.endsWith("=end")) {
                                string2 = string2.substring("=begin\n".length(), string2.length() - "=end".length());
                            }
                            CommentElement commentElement = new CommentElement(string2);
                            RubyCompletionItem.ClassItem classItem = new RubyCompletionItem.ClassItem(commentElement, this.anchor, this.request);
                            this.propose((CompletionProposal)classItem);
                            return true;
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                    return true;
                }
                if (tokenId == RubyTokenId.EMBEDDED_RUBY) {
                    tokenSequence = tokenSequence.embedded();
                    assert (tokenSequence != null);
                    tokenSequence.move(n);
                    if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                        return false;
                    }
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                String string3 = ((Object)token.text()).toString();
                if ((tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN || tokenId == RubyTokenId.ERROR && string3.equals("%")) && (n2 = tokenSequence.offset()) == n - 1 && string3.length() > 0 && string3.charAt(0) == '%' && this.completePercentWords()) {
                    return true;
                }
                if ((tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN || tokenId == RubyTokenId.REGEXP_BEGIN) && token.length() == 3 && n == tokenSequence.offset() + 2 && Character.isLetter(string3.charAt(1))) {
                    this.completeStringBegins();
                    return true;
                }
                while (tokenId == RubyTokenId.ERROR || tokenId == RubyTokenId.STRING_LITERAL || tokenId == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.REGEXP_LITERAL || tokenId == RubyTokenId.EMBEDDED_RUBY) {
                    if (tokenId == RubyTokenId.QUOTED_STRING_LITERAL) {
                        bl2 = true;
                    }
                    if (!tokenSequence.movePrevious()) {
                        return false;
                    }
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
                if (tokenId == RubyTokenId.STRING_BEGIN) {
                    bl = true;
                } else if (tokenId == RubyTokenId.QUOTED_STRING_BEGIN) {
                    bl = true;
                    bl2 = true;
                } else if (tokenId == RubyTokenId.REGEXP_BEGIN) {
                    bl3 = true;
                }
                if (bl3) {
                    if (this.completeRegexps()) {
                        this.request.completionResult.setFilterable(false);
                        return true;
                    }
                } else if (bl) {
                    while (tokenSequence.movePrevious()) {
                        String string4;
                        token = tokenSequence.token();
                        if (token.id() == RubyTokenId.WHITESPACE || token.id() == RubyTokenId.LPAREN || token.id() == RubyTokenId.STRING_LITERAL || token.id() == RubyTokenId.QUOTED_STRING_LITERAL || token.id() == RubyTokenId.STRING_BEGIN || token.id() == RubyTokenId.QUOTED_STRING_BEGIN) continue;
                        if (token.id() != RubyTokenId.IDENTIFIER || !(string4 = ((Object)token.text()).toString()).equals("require") && !string4.equals("load")) break;
                        Set<String[]> set = this.getIndex().getRequires(string, this.caseSensitive ? QuerySupport.Kind.PREFIX : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                        for (String[] stringArray : set) {
                            assert (stringArray.length == 2);
                            RubyCompletionItem.KeywordItem keywordItem = new RubyCompletionItem.KeywordItem(stringArray[0], stringArray[1], this.anchor, this.request);
                            this.propose((CompletionProposal)keywordItem);
                        }
                        return true;
                    }
                    if (bl && bl2) {
                        int n3 = RUBY_QUOTED_STRING_ESCAPES.length;
                        for (int i = 0; i < n3; i += 2) {
                            String string5 = RUBY_QUOTED_STRING_ESCAPES[i];
                            String string6 = RUBY_QUOTED_STRING_ESCAPES[i + 1];
                            if (!string5.startsWith(string)) continue;
                            RubyCompletionItem.KeywordItem keywordItem = new RubyCompletionItem.KeywordItem(string5, string6, this.anchor, this.request);
                            this.propose((CompletionProposal)keywordItem);
                        }
                        return true;
                    }
                    if (bl) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean completePercentWords() {
        String string = this.request.prefix;
        int n = RUBY_PERCENT_WORDS.length;
        for (int i = 0; i < n; i += 2) {
            String string2 = RUBY_PERCENT_WORDS[i];
            String string3 = RUBY_PERCENT_WORDS[i + 1];
            if (!RubyCodeCompleter.startsWith(string2, string, this.caseSensitive)) continue;
            RubyCompletionItem.KeywordItem keywordItem = new RubyCompletionItem.KeywordItem(string2, string3, this.anchor, this.request);
            this.propose((CompletionProposal)keywordItem);
        }
        return true;
    }

    private boolean completeRegexps() {
        String string = this.request.prefix;
        int n = RUBY_REGEXP_WORDS.length;
        for (int i = 0; i < n; i += 2) {
            String string2 = RUBY_REGEXP_WORDS[i];
            String string3 = RUBY_REGEXP_WORDS[i + 1];
            if (!RubyCodeCompleter.startsWith(string2, string, this.caseSensitive)) continue;
            RubyCompletionItem.KeywordItem keywordItem = new RubyCompletionItem.KeywordItem(string2, string3, this.anchor, this.request);
            this.propose((CompletionProposal)keywordItem);
        }
        return true;
    }

    private boolean completeStringBegins() {
        int n = RUBY_STRING_PAIRS.length;
        for (int i = 0; i < n; i += 2) {
            String string = RUBY_STRING_PAIRS[i];
            String string2 = RUBY_STRING_PAIRS[i + 1];
            RubyCompletionItem.KeywordItem keywordItem = new RubyCompletionItem.KeywordItem(string, string2, this.anchor, this.request);
            this.propose((CompletionProposal)keywordItem);
        }
        return true;
    }
}

